/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.PlaybackParams;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import com.google.vr.sdk.widgets.video.deps.ac;
import com.google.vr.sdk.widgets.video.deps.ad;
import com.google.vr.sdk.widgets.video.deps.af;
import com.google.vr.sdk.widgets.video.deps.ag;
import com.google.vr.sdk.widgets.video.deps.ah;
import com.google.vr.sdk.widgets.video.deps.aj;
import com.google.vr.sdk.widgets.video.deps.al;
import com.google.vr.sdk.widgets.video.deps.am;
import com.google.vr.sdk.widgets.video.deps.ao;
import com.google.vr.sdk.widgets.video.deps.ay;
import com.google.vr.sdk.widgets.video.deps.bn;
import com.google.vr.sdk.widgets.video.deps.bz;
import com.google.vr.sdk.widgets.video.deps.cd;
import com.google.vr.sdk.widgets.video.deps.ch;
import com.google.vr.sdk.widgets.video.deps.f;
import com.google.vr.sdk.widgets.video.deps.g;
import com.google.vr.sdk.widgets.video.deps.gp;
import com.google.vr.sdk.widgets.video.deps.gt;
import com.google.vr.sdk.widgets.video.deps.h;
import com.google.vr.sdk.widgets.video.deps.if;
import com.google.vr.sdk.widgets.video.deps.iw;
import com.google.vr.sdk.widgets.video.deps.l;
import com.google.vr.sdk.widgets.video.deps.li;
import com.google.vr.sdk.widgets.video.deps.lr;
import com.google.vr.sdk.widgets.video.deps.nh;
import com.google.vr.sdk.widgets.video.deps.ni;
import com.google.vr.sdk.widgets.video.deps.nn;
import com.google.vr.sdk.widgets.video.deps.o;
import com.google.vr.sdk.widgets.video.deps.oq;
import com.google.vr.sdk.widgets.video.deps.ps;
import com.google.vr.sdk.widgets.video.deps.qa;
import com.google.vr.sdk.widgets.video.deps.qc;
import com.google.vr.sdk.widgets.video.deps.qd;
import com.google.vr.sdk.widgets.video.deps.ql;
import com.google.vr.sdk.widgets.video.deps.u;
import com.google.vr.sdk.widgets.video.deps.v;
import com.google.vr.sdk.widgets.video.deps.x;
import com.google.vr.sdk.widgets.video.deps.y;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;

@TargetApi(value=16)
public class ae
implements g,
v.a,
v.d,
v.e {
    private static final String TAG = "SimpleExoPlayer";
    protected final y[] renderers;
    private final h player;
    private final Handler eventHandler;
    private final a componentListener;
    private final CopyOnWriteArraySet<qc> videoListeners;
    private final CopyOnWriteArraySet<am> audioListeners;
    private final CopyOnWriteArraySet<lr> textOutputs;
    private final CopyOnWriteArraySet<gt> metadataOutputs;
    private final CopyOnWriteArraySet<qd> videoDebugListeners;
    private final CopyOnWriteArraySet<ao> audioDebugListeners;
    private final nn bandwidthMeter;
    private final ag analyticsCollector;
    private final al audioFocusManager;
    private l videoFormat;
    private l audioFormat;
    private Surface surface;
    private boolean ownsSurface;
    private int videoScalingMode;
    private SurfaceHolder surfaceHolder;
    private TextureView textureView;
    private int surfaceWidth;
    private int surfaceHeight;
    private bn videoDecoderCounters;
    private bn audioDecoderCounters;
    private int audioSessionId;
    private aj audioAttributes;
    private float audioVolume;
    private if mediaSource;
    private List<li> currentCues;
    private qa videoFrameMetadataListener;
    private ql cameraMotionListener;

    protected ae(Context context, ac ac2, ni ni2, o o2, nn nn2, @Nullable cd<ch> cd2, Looper looper) {
        this(context, ac2, ni2, o2, cd2, nn2, new ag.a(), looper);
    }

    protected ae(Context context, ac ac2, ni ni2, o o2, @Nullable cd<ch> cd2, nn nn2, ag.a a2, Looper looper) {
        this(context, ac2, ni2, o2, cd2, nn2, a2, oq.a, looper);
    }

    protected ae(Context context, ac ac2, ni ni2, o o2, @Nullable cd<ch> cd2, nn nn2, ag.a a2, oq oq2, Looper looper) {
        this.bandwidthMeter = nn2;
        this.componentListener = new a();
        this.videoListeners = new CopyOnWriteArraySet();
        this.audioListeners = new CopyOnWriteArraySet();
        this.textOutputs = new CopyOnWriteArraySet();
        this.metadataOutputs = new CopyOnWriteArraySet();
        this.videoDebugListeners = new CopyOnWriteArraySet();
        this.audioDebugListeners = new CopyOnWriteArraySet();
        this.eventHandler = new Handler(looper);
        this.renderers = ac2.createRenderers(this.eventHandler, this.componentListener, this.componentListener, this.componentListener, this.componentListener, cd2);
        this.audioVolume = 1.0f;
        this.audioSessionId = 0;
        this.audioAttributes = aj.a;
        this.videoScalingMode = 1;
        this.currentCues = Collections.emptyList();
        this.player = new h(this.renderers, ni2, o2, nn2, oq2, looper);
        this.analyticsCollector = a2.a(this.player, oq2);
        this.addListener(this.analyticsCollector);
        this.videoDebugListeners.add(this.analyticsCollector);
        this.videoListeners.add(this.analyticsCollector);
        this.audioDebugListeners.add(this.analyticsCollector);
        this.audioListeners.add(this.analyticsCollector);
        this.addMetadataOutput(this.analyticsCollector);
        nn2.a(this.eventHandler, this.analyticsCollector);
        if (cd2 instanceof bz) {
            ((bz)cd2).a(this.eventHandler, this.analyticsCollector);
        }
        this.audioFocusManager = new al(context, this.componentListener);
    }

    public v.a getAudioComponent() {
        return this;
    }

    public v.e getVideoComponent() {
        return this;
    }

    public v.d getTextComponent() {
        return this;
    }

    public void setVideoScalingMode(int n2) {
        this.videoScalingMode = n2;
        for (y y2 : this.renderers) {
            if (y2.getTrackType() != 2) continue;
            this.player.a(y2).a(4).a((Object)n2).i();
        }
    }

    public int getVideoScalingMode() {
        return this.videoScalingMode;
    }

    public void clearVideoSurface() {
        this.setVideoSurface(null);
    }

    public void clearVideoSurface(Surface surface) {
        if (surface != null && surface == this.surface) {
            this.setVideoSurface(null);
        }
    }

    public void setVideoSurface(Surface surface) {
        this.removeSurfaceCallbacks();
        this.setVideoSurfaceInternal(surface, false);
        int n2 = surface == null ? 0 : -1;
        this.maybeNotifySurfaceSizeChanged(n2, n2);
    }

    public void setVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.removeSurfaceCallbacks();
        this.surfaceHolder = surfaceHolder;
        if (surfaceHolder == null) {
            this.setVideoSurfaceInternal(null, false);
            this.maybeNotifySurfaceSizeChanged(0, 0);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
            Surface surface = surfaceHolder.getSurface();
            if (surface != null && surface.isValid()) {
                this.setVideoSurfaceInternal(surface, false);
                Rect rect = surfaceHolder.getSurfaceFrame();
                this.maybeNotifySurfaceSizeChanged(rect.width(), rect.height());
            } else {
                this.setVideoSurfaceInternal(null, false);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            }
        }
    }

    public void clearVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        if (surfaceHolder != null && surfaceHolder == this.surfaceHolder) {
            this.setVideoSurfaceHolder(null);
        }
    }

    public void setVideoSurfaceView(SurfaceView surfaceView) {
        this.setVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    public void clearVideoSurfaceView(SurfaceView surfaceView) {
        this.clearVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    public void setVideoTextureView(TextureView textureView) {
        this.removeSurfaceCallbacks();
        this.textureView = textureView;
        if (textureView == null) {
            this.setVideoSurfaceInternal(null, true);
            this.maybeNotifySurfaceSizeChanged(0, 0);
        } else {
            SurfaceTexture surfaceTexture;
            if (textureView.getSurfaceTextureListener() != null) {
                Log.w((String)TAG, (String)"Replacing existing SurfaceTextureListener.");
            }
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.componentListener);
            SurfaceTexture surfaceTexture2 = surfaceTexture = textureView.isAvailable() ? textureView.getSurfaceTexture() : null;
            if (surfaceTexture == null) {
                this.setVideoSurfaceInternal(null, true);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            } else {
                this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
                this.maybeNotifySurfaceSizeChanged(textureView.getWidth(), textureView.getHeight());
            }
        }
    }

    public void clearVideoTextureView(TextureView textureView) {
        if (textureView != null && textureView == this.textureView) {
            this.setVideoTextureView(null);
        }
    }

    public void addAudioListener(am am2) {
        this.audioListeners.add(am2);
    }

    public void removeAudioListener(am am2) {
        this.audioListeners.remove(am2);
    }

    public void setAudioAttributes(aj aj2) {
        this.setAudioAttributes(aj2, false);
    }

    public void setAudioAttributes(aj aj2, boolean bl2) {
        if (!ps.a(this.audioAttributes, (Object)aj2)) {
            this.audioAttributes = aj2;
            for (y y2 : this.renderers) {
                if (y2.getTrackType() != 1) continue;
                this.player.a(y2).a(3).a(aj2).i();
            }
            for (am am2 : this.audioListeners) {
                am2.a(aj2);
            }
        }
        int n2 = this.audioFocusManager.a(bl2 ? aj2 : null, this.getPlayWhenReady(), this.getPlaybackState());
        this.updatePlayWhenReady(this.getPlayWhenReady(), n2);
    }

    public aj getAudioAttributes() {
        return this.audioAttributes;
    }

    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public void setAuxEffectInfo(ay ay2) {
        for (y y2 : this.renderers) {
            if (y2.getTrackType() != 1) continue;
            this.player.a(y2).a(5).a(ay2).i();
        }
    }

    public void clearAuxEffectInfo() {
        this.setAuxEffectInfo(new ay(0, 0.0f));
    }

    public void setVolume(float f2) {
        if (this.audioVolume == (f2 = ps.a(f2, 0.0f, 1.0f))) {
            return;
        }
        this.audioVolume = f2;
        this.sendVolumeToRenderers();
        for (am am2 : this.audioListeners) {
            am2.a(f2);
        }
    }

    public float getVolume() {
        return this.audioVolume;
    }

    @Deprecated
    public void setAudioStreamType(int n2) {
        int n3 = ps.f(n2);
        int n4 = ps.g(n2);
        aj aj2 = new aj.a().b(n3).a(n4).a();
        this.setAudioAttributes(aj2);
    }

    @Deprecated
    public int getAudioStreamType() {
        return ps.h(this.audioAttributes.d);
    }

    public ag getAnalyticsCollector() {
        return this.analyticsCollector;
    }

    public void addAnalyticsListener(ah ah2) {
        this.analyticsCollector.a(ah2);
    }

    public void removeAnalyticsListener(ah ah2) {
        this.analyticsCollector.b(ah2);
    }

    @Deprecated
    @TargetApi(value=23)
    public void setPlaybackParams(@Nullable PlaybackParams playbackParams) {
        u u2;
        if (playbackParams != null) {
            playbackParams.allowDefaults();
            u2 = new u(playbackParams.getSpeed(), playbackParams.getPitch());
        } else {
            u2 = null;
        }
        this.setPlaybackParameters(u2);
    }

    public l getVideoFormat() {
        return this.videoFormat;
    }

    public l getAudioFormat() {
        return this.audioFormat;
    }

    public bn getVideoDecoderCounters() {
        return this.videoDecoderCounters;
    }

    public bn getAudioDecoderCounters() {
        return this.audioDecoderCounters;
    }

    public void addVideoListener(qc qc2) {
        this.videoListeners.add(qc2);
    }

    public void removeVideoListener(qc qc2) {
        this.videoListeners.remove(qc2);
    }

    public void setVideoFrameMetadataListener(qa qa2) {
        this.videoFrameMetadataListener = qa2;
        for (y y2 : this.renderers) {
            if (y2.getTrackType() != 2) continue;
            this.player.a(y2).a(6).a(qa2).i();
        }
    }

    public void clearVideoFrameMetadataListener(qa qa2) {
        if (this.videoFrameMetadataListener != qa2) {
            return;
        }
        for (y y2 : this.renderers) {
            if (y2.getTrackType() != 2) continue;
            this.player.a(y2).a(6).a(null).i();
        }
    }

    public void setCameraMotionListener(ql ql2) {
        this.cameraMotionListener = ql2;
        for (y y2 : this.renderers) {
            if (y2.getTrackType() != 5) continue;
            this.player.a(y2).a(7).a(ql2).i();
        }
    }

    public void clearCameraMotionListener(ql ql2) {
        if (this.cameraMotionListener != ql2) {
            return;
        }
        for (y y2 : this.renderers) {
            if (y2.getTrackType() != 5) continue;
            this.player.a(y2).a(7).a(null).i();
        }
    }

    @Deprecated
    public void setVideoListener(b b2) {
        this.videoListeners.clear();
        if (b2 != null) {
            this.addVideoListener(b2);
        }
    }

    @Deprecated
    public void clearVideoListener(b b2) {
        this.removeVideoListener(b2);
    }

    public void addTextOutput(lr lr2) {
        if (!this.currentCues.isEmpty()) {
            lr2.a(this.currentCues);
        }
        this.textOutputs.add(lr2);
    }

    public void removeTextOutput(lr lr2) {
        this.textOutputs.remove(lr2);
    }

    @Deprecated
    public void setTextOutput(lr lr2) {
        this.textOutputs.clear();
        if (lr2 != null) {
            this.addTextOutput(lr2);
        }
    }

    @Deprecated
    public void clearTextOutput(lr lr2) {
        this.removeTextOutput(lr2);
    }

    public void addMetadataOutput(gt gt2) {
        this.metadataOutputs.add(gt2);
    }

    public void removeMetadataOutput(gt gt2) {
        this.metadataOutputs.remove(gt2);
    }

    @Deprecated
    public void setMetadataOutput(gt gt2) {
        this.metadataOutputs.retainAll(Collections.singleton(this.analyticsCollector));
        if (gt2 != null) {
            this.addMetadataOutput(gt2);
        }
    }

    @Deprecated
    public void clearMetadataOutput(gt gt2) {
        this.removeMetadataOutput(gt2);
    }

    @Deprecated
    public void setVideoDebugListener(qd qd2) {
        this.videoDebugListeners.retainAll(Collections.singleton(this.analyticsCollector));
        if (qd2 != null) {
            this.addVideoDebugListener(qd2);
        }
    }

    @Deprecated
    public void addVideoDebugListener(qd qd2) {
        this.videoDebugListeners.add(qd2);
    }

    @Deprecated
    public void removeVideoDebugListener(qd qd2) {
        this.videoDebugListeners.remove(qd2);
    }

    @Deprecated
    public void setAudioDebugListener(ao ao2) {
        this.audioDebugListeners.retainAll(Collections.singleton(this.analyticsCollector));
        if (ao2 != null) {
            this.addAudioDebugListener(ao2);
        }
    }

    @Deprecated
    public void addAudioDebugListener(ao ao2) {
        this.audioDebugListeners.add(ao2);
    }

    @Deprecated
    public void removeAudioDebugListener(ao ao2) {
        this.audioDebugListeners.remove(ao2);
    }

    public Looper getPlaybackLooper() {
        return this.player.a();
    }

    public Looper getApplicationLooper() {
        return this.player.b();
    }

    @Override
    public void addListener(v.c c2) {
        this.player.addListener(c2);
    }

    public void removeListener(v.c c2) {
        this.player.a(c2);
    }

    public int getPlaybackState() {
        return this.player.c();
    }

    public f getPlaybackError() {
        return this.player.d();
    }

    public void retry() {
        if (this.mediaSource != null && (this.getPlaybackError() != null || this.getPlaybackState() == 1)) {
            this.prepare(this.mediaSource, false, false);
        }
    }

    public void prepare(if if_) {
        this.prepare(if_, true, true);
    }

    public void prepare(if if_, boolean bl2, boolean bl3) {
        if (this.mediaSource != null) {
            this.mediaSource.a(this.analyticsCollector);
            this.analyticsCollector.b();
        }
        this.mediaSource = if_;
        if_.a(this.eventHandler, this.analyticsCollector);
        int n2 = this.audioFocusManager.a(this.getPlayWhenReady());
        this.updatePlayWhenReady(this.getPlayWhenReady(), n2);
        this.player.a(if_, bl2, bl3);
    }

    @Override
    public void setPlayWhenReady(boolean bl2) {
        int n2 = this.audioFocusManager.a(bl2, this.getPlaybackState());
        this.updatePlayWhenReady(bl2, n2);
    }

    public boolean getPlayWhenReady() {
        return this.player.e();
    }

    public int getRepeatMode() {
        return this.player.f();
    }

    public void setRepeatMode(int n2) {
        this.player.a(n2);
    }

    public void setShuffleModeEnabled(boolean bl2) {
        this.player.a(bl2);
    }

    public boolean getShuffleModeEnabled() {
        return this.player.g();
    }

    public boolean isLoading() {
        return this.player.h();
    }

    public void seekToDefaultPosition() {
        this.analyticsCollector.a();
        this.player.i();
    }

    public void seekToDefaultPosition(int n2) {
        this.analyticsCollector.a();
        this.player.b(n2);
    }

    @Override
    public void seekTo(long l2) {
        this.analyticsCollector.a();
        this.player.seekTo(l2);
    }

    public void seekTo(int n2, long l2) {
        this.analyticsCollector.a();
        this.player.a(n2, l2);
    }

    public void setPlaybackParameters(@Nullable u u2) {
        this.player.a(u2);
    }

    public u getPlaybackParameters() {
        return this.player.j();
    }

    public void setSeekParameters(@Nullable ad ad2) {
        this.player.a(ad2);
    }

    public ad getSeekParameters() {
        return this.player.k();
    }

    @Nullable
    public Object getCurrentTag() {
        return this.player.l();
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    public void stop(boolean bl2) {
        this.player.b(bl2);
        if (this.mediaSource != null) {
            this.mediaSource.a(this.analyticsCollector);
            this.analyticsCollector.b();
            if (bl2) {
                this.mediaSource = null;
            }
        }
        this.audioFocusManager.b();
        this.currentCues = Collections.emptyList();
    }

    @Override
    public void release() {
        this.audioFocusManager.b();
        this.player.release();
        this.removeSurfaceCallbacks();
        if (this.surface != null) {
            if (this.ownsSurface) {
                this.surface.release();
            }
            this.surface = null;
        }
        if (this.mediaSource != null) {
            this.mediaSource.a(this.analyticsCollector);
            this.mediaSource = null;
        }
        this.bandwidthMeter.a(this.analyticsCollector);
        this.currentCues = Collections.emptyList();
    }

    @Deprecated
    public void sendMessages(g.a ... aArray) {
        this.player.a(aArray);
    }

    public x createMessage(x.b b2) {
        return this.player.a(b2);
    }

    @Deprecated
    public void blockingSendMessages(g.a ... aArray) {
        this.player.b(aArray);
    }

    public int getRendererCount() {
        return this.player.w();
    }

    public int getRendererType(int n2) {
        return this.player.c(n2);
    }

    public iw getCurrentTrackGroups() {
        return this.player.x();
    }

    public nh getCurrentTrackSelections() {
        return this.player.y();
    }

    @Override
    public af getCurrentTimeline() {
        return this.player.getCurrentTimeline();
    }

    public Object getCurrentManifest() {
        return this.player.z();
    }

    public int getCurrentPeriodIndex() {
        return this.player.m();
    }

    @Override
    public int getCurrentWindowIndex() {
        return this.player.getCurrentWindowIndex();
    }

    public int getNextWindowIndex() {
        return this.player.n();
    }

    public int getPreviousWindowIndex() {
        return this.player.o();
    }

    @Override
    public long getDuration() {
        return this.player.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.player.getCurrentPosition();
    }

    public long getBufferedPosition() {
        return this.player.p();
    }

    public int getBufferedPercentage() {
        return this.player.q();
    }

    @Override
    public long getTotalBufferedDuration() {
        return this.player.getTotalBufferedDuration();
    }

    public boolean isCurrentWindowDynamic() {
        return this.player.r();
    }

    public boolean isCurrentWindowSeekable() {
        return this.player.s();
    }

    public boolean isPlayingAd() {
        return this.player.t();
    }

    @Override
    public int getCurrentAdGroupIndex() {
        return this.player.getCurrentAdGroupIndex();
    }

    @Override
    public int getCurrentAdIndexInAdGroup() {
        return this.player.getCurrentAdIndexInAdGroup();
    }

    public long getContentDuration() {
        return this.player.u();
    }

    @Override
    public long getContentPosition() {
        return this.player.getContentPosition();
    }

    public long getContentBufferedPosition() {
        return this.player.v();
    }

    private void removeSurfaceCallbacks() {
        if (this.textureView != null) {
            if (this.textureView.getSurfaceTextureListener() != this.componentListener) {
                Log.w((String)TAG, (String)"SurfaceTextureListener already unset or replaced.");
            } else {
                this.textureView.setSurfaceTextureListener(null);
            }
            this.textureView = null;
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this.componentListener);
            this.surfaceHolder = null;
        }
    }

    private void setVideoSurfaceInternal(Surface surface, boolean bl2) {
        ArrayList<x> arrayList = new ArrayList<x>();
        for (y y2 : this.renderers) {
            if (y2.getTrackType() != 2) continue;
            arrayList.add(this.player.a(y2).a(1).a(surface).i());
        }
        if (this.surface != null && this.surface != surface) {
            try {
                for (x x2 : arrayList) {
                    x2.k();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (this.ownsSurface) {
                this.surface.release();
            }
        }
        this.surface = surface;
        this.ownsSurface = bl2;
    }

    private void maybeNotifySurfaceSizeChanged(int n2, int n3) {
        if (n2 != this.surfaceWidth || n3 != this.surfaceHeight) {
            this.surfaceWidth = n2;
            this.surfaceHeight = n3;
            for (qc qc2 : this.videoListeners) {
                qc2.a(n2, n3);
            }
        }
    }

    private void sendVolumeToRenderers() {
        float f2 = this.audioVolume * this.audioFocusManager.a();
        for (y y2 : this.renderers) {
            if (y2.getTrackType() != 1) continue;
            this.player.a(y2).a(2).a(Float.valueOf(f2)).i();
        }
    }

    private void updatePlayWhenReady(boolean bl2, int n2) {
        this.player.a(bl2 && n2 != -1, n2 != 1);
    }

    private final class a
    implements SurfaceHolder.Callback,
    TextureView.SurfaceTextureListener,
    al.b,
    ao,
    gt,
    lr,
    qd {
        private a() {
        }

        @Override
        public void a(bn bn2) {
            ae.this.videoDecoderCounters = bn2;
            for (qd qd2 : ae.this.videoDebugListeners) {
                qd2.a(bn2);
            }
        }

        @Override
        public void a(String string, long l2, long l3) {
            for (qd qd2 : ae.this.videoDebugListeners) {
                qd2.a(string, l2, l3);
            }
        }

        @Override
        public void a(l l2) {
            ae.this.videoFormat = l2;
            for (qd qd2 : ae.this.videoDebugListeners) {
                qd2.a(l2);
            }
        }

        @Override
        public void a(int n2, long l2) {
            for (qd qd2 : ae.this.videoDebugListeners) {
                qd2.a(n2, l2);
            }
        }

        @Override
        public void a(int n2, int n3, int n4, float f2) {
            for (Object object : ae.this.videoListeners) {
                if (ae.this.videoDebugListeners.contains(object)) continue;
                object.a(n2, n3, n4, f2);
            }
            for (Object object : ae.this.videoDebugListeners) {
                object.a(n2, n3, n4, f2);
            }
        }

        @Override
        public void a(Surface surface) {
            if (ae.this.surface == surface) {
                for (Object object : ae.this.videoListeners) {
                    object.c();
                }
            }
            for (Object object : ae.this.videoDebugListeners) {
                object.a(surface);
            }
        }

        @Override
        public void b(bn bn2) {
            for (qd qd2 : ae.this.videoDebugListeners) {
                qd2.b(bn2);
            }
            ae.this.videoFormat = null;
            ae.this.videoDecoderCounters = null;
        }

        @Override
        public void c(bn bn2) {
            ae.this.audioDecoderCounters = bn2;
            for (ao ao2 : ae.this.audioDebugListeners) {
                ao2.c(bn2);
            }
        }

        @Override
        public void a(int n2) {
            if (ae.this.audioSessionId == n2) {
                return;
            }
            ae.this.audioSessionId = n2;
            for (Object object : ae.this.audioListeners) {
                if (ae.this.audioDebugListeners.contains(object)) continue;
                object.a(n2);
            }
            for (Object object : ae.this.audioDebugListeners) {
                object.a(n2);
            }
        }

        @Override
        public void b(String string, long l2, long l3) {
            for (ao ao2 : ae.this.audioDebugListeners) {
                ao2.b(string, l2, l3);
            }
        }

        @Override
        public void b(l l2) {
            ae.this.audioFormat = l2;
            for (ao ao2 : ae.this.audioDebugListeners) {
                ao2.b(l2);
            }
        }

        @Override
        public void a(int n2, long l2, long l3) {
            for (ao ao2 : ae.this.audioDebugListeners) {
                ao2.a(n2, l2, l3);
            }
        }

        @Override
        public void d(bn bn2) {
            for (ao ao2 : ae.this.audioDebugListeners) {
                ao2.d(bn2);
            }
            ae.this.audioFormat = null;
            ae.this.audioDecoderCounters = null;
            ae.this.audioSessionId = 0;
        }

        @Override
        public void a(List<li> list) {
            ae.this.currentCues = list;
            for (lr lr2 : ae.this.textOutputs) {
                lr2.a(list);
            }
        }

        @Override
        public void a(gp gp2) {
            for (gt gt2 : ae.this.metadataOutputs) {
                gt2.a(gp2);
            }
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            ae.this.setVideoSurfaceInternal(surfaceHolder.getSurface(), false);
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
            ae.this.maybeNotifySurfaceSizeChanged(n3, n4);
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            ae.this.setVideoSurfaceInternal(null, false);
            ae.this.maybeNotifySurfaceSizeChanged(0, 0);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
            ae.this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
            ae.this.maybeNotifySurfaceSizeChanged(n2, n3);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
            ae.this.maybeNotifySurfaceSizeChanged(n2, n3);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            ae.this.setVideoSurfaceInternal(null, true);
            ae.this.maybeNotifySurfaceSizeChanged(0, 0);
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        @Override
        public void a(float f2) {
            ae.this.sendVolumeToRenderers();
        }

        @Override
        public void b(int n2) {
            ae.this.updatePlayWhenReady(ae.this.getPlayWhenReady(), n2);
        }
    }

    @Deprecated
    public static interface b
    extends qc {
    }
}

