/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import com.google.vr.sdk.widgets.video.deps.bd;
import com.google.vr.sdk.widgets.video.deps.bo;
import com.google.vr.sdk.widgets.video.deps.bq;
import com.google.vr.sdk.widgets.video.deps.bu;
import com.google.vr.sdk.widgets.video.deps.f;
import com.google.vr.sdk.widgets.video.deps.ff;
import com.google.vr.sdk.widgets.video.deps.fg;
import com.google.vr.sdk.widgets.video.deps.fh;
import com.google.vr.sdk.widgets.video.deps.fi;
import com.google.vr.sdk.widgets.video.deps.fj;
import com.google.vr.sdk.widgets.video.deps.k;
import com.google.vr.sdk.widgets.video.deps.mx;
import com.google.vr.sdk.widgets.video.deps.nj;
import com.google.vr.sdk.widgets.video.deps.nu;
import com.google.vr.sdk.widgets.video.deps.nw;
import com.google.vr.sdk.widgets.video.deps.oa;
import com.google.vr.sdk.widgets.video.deps.od;
import com.google.vr.sdk.widgets.video.deps.of;
import java.nio.ByteBuffer;
import java.util.List;

@TargetApi(value=16)
public class oc
extends fg {
    private static final String TAG = "MediaCodecVideoRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private static final int[] STANDARD_LONG_EDGE_VIDEO_PX = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private static final int MAX_PENDING_OUTPUT_STREAM_OFFSET_COUNT = 10;
    private final Context context;
    private final od frameReleaseTimeHelper;
    private final of.a eventDispatcher;
    private final long allowedJoiningTimeMs;
    private final int maxDroppedFramesToNotify;
    private final boolean deviceNeedsAutoFrcWorkaround;
    private final long[] pendingOutputStreamOffsetsUs;
    private final long[] pendingOutputStreamSwitchTimesUs;
    private a codecMaxValues;
    private boolean codecNeedsSetOutputSurfaceWorkaround;
    private Surface surface;
    private Surface dummySurface;
    private int scalingMode;
    private boolean renderedFirstFrame;
    private long initialPositionUs;
    private long joiningDeadlineMs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int buffersInCodecCount;
    private long lastRenderTimeUs;
    private int pendingRotationDegrees;
    private float pendingPixelWidthHeightRatio;
    private int currentWidth;
    private int currentHeight;
    private int currentUnappliedRotationDegrees;
    private float currentPixelWidthHeightRatio;
    private int reportedWidth;
    private int reportedHeight;
    private int reportedUnappliedRotationDegrees;
    private float reportedPixelWidthHeightRatio;
    private boolean tunneling;
    private int tunnelingAudioSessionId;
    b tunnelingOnFrameRenderedListener;
    private long lastInputTimeUs;
    private long outputStreamOffsetUs;
    private int pendingOutputStreamOffsetCount;

    public oc(Context context, fh fh2) {
        this(context, fh2, 0L);
    }

    public oc(Context context, fh fh2, long l2) {
        this(context, fh2, l2, null, null, -1);
    }

    public oc(Context context, fh fh2, long l2, @Nullable Handler handler, @Nullable of of2, int n2) {
        this(context, fh2, l2, null, false, handler, of2, n2);
    }

    public oc(Context context, fh fh2, long l2, @Nullable bq<bu> bq2, boolean bl2, @Nullable Handler handler, @Nullable of of2, int n2) {
        super(2, fh2, bq2, bl2);
        this.allowedJoiningTimeMs = l2;
        this.maxDroppedFramesToNotify = n2;
        this.context = context.getApplicationContext();
        this.frameReleaseTimeHelper = new od(this.context);
        this.eventDispatcher = new of.a(handler, of2);
        this.deviceNeedsAutoFrcWorkaround = oc.deviceNeedsAutoFrcWorkaround();
        this.pendingOutputStreamOffsetsUs = new long[10];
        this.pendingOutputStreamSwitchTimesUs = new long[10];
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.lastInputTimeUs = -9223372036854775807L;
        this.joiningDeadlineMs = -9223372036854775807L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.scalingMode = 1;
        this.clearReportedVideoSize();
    }

    @Override
    protected int supportsFormat(fh fh2, bq<bu> bq2, k k2) throws fi.b {
        int n2;
        int n3;
        List<ff> list;
        String string = k2.g;
        if (!nj.b(string)) {
            return 0;
        }
        boolean bl2 = false;
        bo bo2 = k2.j;
        if (bo2 != null) {
            for (int i2 = 0; i2 < bo2.b; ++i2) {
                bl2 |= bo2.a((int)i2).d;
            }
        }
        if ((list = fh2.a(k2, bl2)).isEmpty()) {
            return bl2 && !fh2.a(k2, false).isEmpty() ? 2 : 1;
        }
        if (!oc.supportsFormatDrm(bq2, bo2)) {
            return 2;
        }
        ff ff2 = list.get(0);
        boolean bl3 = ff2.b(k2.d);
        if (bl3 && k2.l > 0 && k2.m > 0) {
            if (nw.a >= 21) {
                bl3 = ff2.a(k2.l, k2.m, k2.n);
            } else {
                boolean bl4 = bl3 = k2.l * k2.m <= fi.b();
                if (!bl3) {
                    n3 = k2.l;
                    n2 = k2.m;
                    String string2 = nw.e;
                    Log.d((String)TAG, (String)new StringBuilder(56 + String.valueOf(string2).length()).append("FalseCheck [legacyFrameSize, ").append(n3).append("x").append(n2).append("] [").append(string2).append("]").toString());
                }
            }
        }
        n3 = ff2.d ? 16 : 8;
        n2 = ff2.e ? 32 : 0;
        int n4 = bl3 ? 4 : 3;
        return n3 | n2 | n4;
    }

    @Override
    protected void onEnabled(boolean bl2) throws f {
        super.onEnabled(bl2);
        this.tunnelingAudioSessionId = this.getConfiguration().b;
        this.tunneling = this.tunnelingAudioSessionId != 0;
        this.eventDispatcher.a(this.decoderCounters);
        this.frameReleaseTimeHelper.a();
    }

    @Override
    protected void onStreamChanged(k[] kArray, long l2) throws f {
        if (this.outputStreamOffsetUs == -9223372036854775807L) {
            this.outputStreamOffsetUs = l2;
        } else {
            if (this.pendingOutputStreamOffsetCount == this.pendingOutputStreamOffsetsUs.length) {
                long l3 = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
                Log.w((String)TAG, (String)new StringBuilder(65).append("Too many stream changes, so dropping offset: ").append(l3).toString());
            } else {
                ++this.pendingOutputStreamOffsetCount;
            }
            this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1] = l2;
            this.pendingOutputStreamSwitchTimesUs[this.pendingOutputStreamOffsetCount - 1] = this.lastInputTimeUs;
        }
        super.onStreamChanged(kArray, l2);
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) throws f {
        super.onPositionReset(l2, bl2);
        this.clearRenderedFirstFrame();
        this.initialPositionUs = -9223372036854775807L;
        this.consecutiveDroppedFrameCount = 0;
        this.lastInputTimeUs = -9223372036854775807L;
        if (this.pendingOutputStreamOffsetCount != 0) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
            this.pendingOutputStreamOffsetCount = 0;
        }
        if (bl2) {
            this.setJoiningDeadlineMs();
        } else {
            this.joiningDeadlineMs = -9223372036854775807L;
        }
    }

    @Override
    public boolean isReady() {
        if (super.isReady() && (this.renderedFirstFrame || this.dummySurface != null && this.surface == this.dummySurface || this.getCodec() == null || this.tunneling)) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
        this.lastRenderTimeUs = SystemClock.elapsedRealtime() * 1000L;
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineMs = -9223372036854775807L;
        this.maybeNotifyDroppedFrames();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.lastInputTimeUs = -9223372036854775807L;
        this.pendingOutputStreamOffsetCount = 0;
        this.clearReportedVideoSize();
        this.clearRenderedFirstFrame();
        this.frameReleaseTimeHelper.b();
        this.tunnelingOnFrameRenderedListener = null;
        this.tunneling = false;
        try {
            super.onDisabled();
        }
        finally {
            this.decoderCounters.a();
            this.eventDispatcher.b(this.decoderCounters);
        }
    }

    @Override
    public void handleMessage(int n2, Object object) throws f {
        if (n2 == 1) {
            this.setSurface((Surface)object);
        } else if (n2 == 4) {
            this.scalingMode = (Integer)object;
            MediaCodec mediaCodec = this.getCodec();
            if (mediaCodec != null) {
                mediaCodec.setVideoScalingMode(this.scalingMode);
            }
        } else {
            super.handleMessage(n2, object);
        }
    }

    private void setSurface(Surface surface) throws f {
        if (surface == null) {
            if (this.dummySurface != null) {
                surface = this.dummySurface;
            } else {
                ff ff2 = this.getCodecInfo();
                if (ff2 != null && this.shouldUseDummySurface(ff2)) {
                    surface = this.dummySurface = oa.a(this.context, ff2.f);
                }
            }
        }
        if (this.surface != surface) {
            this.surface = surface;
            int n2 = this.getState();
            if (n2 == 1 || n2 == 2) {
                MediaCodec mediaCodec = this.getCodec();
                if (nw.a >= 23 && mediaCodec != null && surface != null && !this.codecNeedsSetOutputSurfaceWorkaround) {
                    oc.setOutputSurfaceV23(mediaCodec, surface);
                } else {
                    this.releaseCodec();
                    this.maybeInitCodec();
                }
            }
            if (surface != null && surface != this.dummySurface) {
                this.maybeRenotifyVideoSizeChanged();
                this.clearRenderedFirstFrame();
                if (n2 == 2) {
                    this.setJoiningDeadlineMs();
                }
            } else {
                this.clearReportedVideoSize();
                this.clearRenderedFirstFrame();
            }
        } else if (surface != null && surface != this.dummySurface) {
            this.maybeRenotifyVideoSizeChanged();
            this.maybeRenotifyRenderedFirstFrame();
        }
    }

    @Override
    protected boolean shouldInitCodec(ff ff2) {
        return this.surface != null || this.shouldUseDummySurface(ff2);
    }

    @Override
    protected void configureCodec(ff ff2, MediaCodec mediaCodec, k k2, MediaCrypto mediaCrypto) throws fi.b {
        this.codecMaxValues = this.getCodecMaxValues(ff2, k2, this.getStreamFormats());
        MediaFormat mediaFormat = this.getMediaFormat(k2, this.codecMaxValues, this.deviceNeedsAutoFrcWorkaround, this.tunnelingAudioSessionId);
        if (this.surface == null) {
            mx.b(this.shouldUseDummySurface(ff2));
            if (this.dummySurface == null) {
                this.dummySurface = oa.a(this.context, ff2.f);
            }
            this.surface = this.dummySurface;
        }
        mediaCodec.configure(mediaFormat, this.surface, mediaCrypto, 0);
        if (nw.a >= 23 && this.tunneling) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    @Override
    protected int canKeepCodec(MediaCodec mediaCodec, ff ff2, k k2, k k3) {
        if (oc.areAdaptationCompatible(ff2.d, k2, k3) && k3.l <= this.codecMaxValues.a && k3.m <= this.codecMaxValues.b && oc.getMaxInputSize(ff2, k3) <= this.codecMaxValues.c) {
            return k2.b(k3) ? 1 : 3;
        }
        return 0;
    }

    @Override
    @CallSuper
    protected void releaseCodec() {
        try {
            super.releaseCodec();
        }
        finally {
            this.buffersInCodecCount = 0;
            if (this.dummySurface != null) {
                if (this.surface == this.dummySurface) {
                    this.surface = null;
                }
                this.dummySurface.release();
                this.dummySurface = null;
            }
        }
    }

    @Override
    @CallSuper
    protected void flushCodec() throws f {
        super.flushCodec();
        this.buffersInCodecCount = 0;
    }

    @Override
    protected void onCodecInitialized(String string, long l2, long l3) {
        this.eventDispatcher.a(string, l2, l3);
        this.codecNeedsSetOutputSurfaceWorkaround = this.codecNeedsSetOutputSurfaceWorkaround(string);
    }

    @Override
    protected void onInputFormatChanged(k k2) throws f {
        super.onInputFormatChanged(k2);
        this.eventDispatcher.a(k2);
        this.pendingPixelWidthHeightRatio = k2.p;
        this.pendingRotationDegrees = k2.o;
    }

    @Override
    @CallSuper
    protected void onQueueInputBuffer(bd bd2) {
        ++this.buffersInCodecCount;
        this.lastInputTimeUs = Math.max(bd2.c, this.lastInputTimeUs);
        if (nw.a < 23 && this.tunneling) {
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    @Override
    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        boolean bl2 = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
        this.currentWidth = bl2 ? mediaFormat.getInteger(KEY_CROP_RIGHT) - mediaFormat.getInteger(KEY_CROP_LEFT) + 1 : mediaFormat.getInteger("width");
        this.currentHeight = bl2 ? mediaFormat.getInteger(KEY_CROP_BOTTOM) - mediaFormat.getInteger(KEY_CROP_TOP) + 1 : mediaFormat.getInteger("height");
        this.currentPixelWidthHeightRatio = this.pendingPixelWidthHeightRatio;
        if (nw.a >= 21) {
            if (this.pendingRotationDegrees == 90 || this.pendingRotationDegrees == 270) {
                int n2 = this.currentWidth;
                this.currentWidth = this.currentHeight;
                this.currentHeight = n2;
                this.currentPixelWidthHeightRatio = 1.0f / this.currentPixelWidthHeightRatio;
            }
        } else {
            this.currentUnappliedRotationDegrees = this.pendingRotationDegrees;
        }
        mediaCodec.setVideoScalingMode(this.scalingMode);
    }

    @Override
    protected boolean processOutputBuffer(long l2, long l3, MediaCodec mediaCodec, ByteBuffer byteBuffer, int n2, int n3, long l4, boolean bl2) throws f {
        boolean bl3;
        if (this.initialPositionUs == -9223372036854775807L) {
            this.initialPositionUs = l2;
        }
        long l5 = l4 - this.outputStreamOffsetUs;
        if (bl2) {
            this.skipOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        long l6 = l4 - l2;
        if (this.surface == this.dummySurface) {
            if (oc.isBufferLate(l6)) {
                this.skipOutputBuffer(mediaCodec, n2, l5);
                return true;
            }
            return false;
        }
        long l7 = SystemClock.elapsedRealtime() * 1000L;
        boolean bl4 = bl3 = this.getState() == 2;
        if (!this.renderedFirstFrame || bl3 && this.shouldForceRenderOutputBuffer(l6, l7 - this.lastRenderTimeUs)) {
            if (nw.a >= 21) {
                this.renderOutputBufferV21(mediaCodec, n2, l5, System.nanoTime());
            } else {
                this.renderOutputBuffer(mediaCodec, n2, l5);
            }
            return true;
        }
        if (!bl3 || l2 == this.initialPositionUs) {
            return false;
        }
        long l8 = l7 - l3;
        l6 -= l8;
        long l9 = System.nanoTime();
        long l10 = l9 + l6 * 1000L;
        long l11 = this.frameReleaseTimeHelper.a(l4, l10);
        l6 = (l11 - l9) / 1000L;
        if (this.shouldDropBuffersToKeyframe(l6, l3) && this.maybeDropBuffersToKeyframe(mediaCodec, n2, l5, l2)) {
            return false;
        }
        if (this.shouldDropOutputBuffer(l6, l3)) {
            this.dropOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        if (nw.a >= 21) {
            if (l6 < 50000L) {
                this.renderOutputBufferV21(mediaCodec, n2, l5, l11);
                return true;
            }
        } else if (l6 < 30000L) {
            if (l6 > 11000L) {
                try {
                    Thread.sleep((l6 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            this.renderOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        return false;
    }

    @Override
    @CallSuper
    protected void onProcessedOutputBuffer(long l2) {
        --this.buffersInCodecCount;
        while (this.pendingOutputStreamOffsetCount != 0 && l2 >= this.pendingOutputStreamSwitchTimesUs[0]) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[0];
            --this.pendingOutputStreamOffsetCount;
            System.arraycopy(this.pendingOutputStreamOffsetsUs, 1, this.pendingOutputStreamOffsetsUs, 0, this.pendingOutputStreamOffsetCount);
            System.arraycopy(this.pendingOutputStreamSwitchTimesUs, 1, this.pendingOutputStreamSwitchTimesUs, 0, this.pendingOutputStreamOffsetCount);
        }
    }

    protected boolean shouldDropOutputBuffer(long l2, long l3) {
        return oc.isBufferLate(l2);
    }

    protected boolean shouldDropBuffersToKeyframe(long l2, long l3) {
        return oc.isBufferVeryLate(l2);
    }

    protected boolean shouldForceRenderOutputBuffer(long l2, long l3) {
        return oc.isBufferLate(l2) && l3 > 100000L;
    }

    protected void skipOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        nu.a("skipVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        nu.a();
        ++this.decoderCounters.f;
    }

    protected void dropOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        nu.a("dropVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        nu.a();
        this.updateDroppedBufferCounters(1);
    }

    protected boolean maybeDropBuffersToKeyframe(MediaCodec mediaCodec, int n2, long l2, long l3) throws f {
        int n3 = this.skipSource(l3);
        if (n3 == 0) {
            return false;
        }
        ++this.decoderCounters.i;
        this.updateDroppedBufferCounters(this.buffersInCodecCount + n3);
        this.flushCodec();
        return true;
    }

    protected void updateDroppedBufferCounters(int n2) {
        this.decoderCounters.g += n2;
        this.droppedFrames += n2;
        this.consecutiveDroppedFrameCount += n2;
        this.decoderCounters.h = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.h);
        if (this.droppedFrames >= this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    protected void renderOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        this.maybeNotifyVideoSizeChanged();
        nu.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, true);
        nu.a();
        this.lastRenderTimeUs = SystemClock.elapsedRealtime() * 1000L;
        ++this.decoderCounters.e;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    @TargetApi(value=21)
    protected void renderOutputBufferV21(MediaCodec mediaCodec, int n2, long l2, long l3) {
        this.maybeNotifyVideoSizeChanged();
        nu.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, l3);
        nu.a();
        this.lastRenderTimeUs = SystemClock.elapsedRealtime() * 1000L;
        ++this.decoderCounters.e;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    private boolean shouldUseDummySurface(ff ff2) {
        return nw.a >= 23 && !this.tunneling && !this.codecNeedsSetOutputSurfaceWorkaround(ff2.a) && (!ff2.f || oa.a(this.context));
    }

    private void setJoiningDeadlineMs() {
        this.joiningDeadlineMs = this.allowedJoiningTimeMs > 0L ? SystemClock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    private void clearRenderedFirstFrame() {
        MediaCodec mediaCodec;
        this.renderedFirstFrame = false;
        if (nw.a >= 23 && this.tunneling && (mediaCodec = this.getCodec()) != null) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    void maybeNotifyRenderedFirstFrame() {
        if (!this.renderedFirstFrame) {
            this.renderedFirstFrame = true;
            this.eventDispatcher.a(this.surface);
        }
    }

    private void maybeRenotifyRenderedFirstFrame() {
        if (this.renderedFirstFrame) {
            this.eventDispatcher.a(this.surface);
        }
    }

    private void clearReportedVideoSize() {
        this.reportedWidth = -1;
        this.reportedHeight = -1;
        this.reportedPixelWidthHeightRatio = -1.0f;
        this.reportedUnappliedRotationDegrees = -1;
    }

    private void maybeNotifyVideoSizeChanged() {
        if (!(this.currentWidth == -1 && this.currentHeight == -1 || this.reportedWidth == this.currentWidth && this.reportedHeight == this.currentHeight && this.reportedUnappliedRotationDegrees == this.currentUnappliedRotationDegrees && this.reportedPixelWidthHeightRatio == this.currentPixelWidthHeightRatio)) {
            this.eventDispatcher.a(this.currentWidth, this.currentHeight, this.currentUnappliedRotationDegrees, this.currentPixelWidthHeightRatio);
            this.reportedWidth = this.currentWidth;
            this.reportedHeight = this.currentHeight;
            this.reportedUnappliedRotationDegrees = this.currentUnappliedRotationDegrees;
            this.reportedPixelWidthHeightRatio = this.currentPixelWidthHeightRatio;
        }
    }

    private void maybeRenotifyVideoSizeChanged() {
        if (this.reportedWidth != -1 || this.reportedHeight != -1) {
            this.eventDispatcher.a(this.reportedWidth, this.reportedHeight, this.reportedUnappliedRotationDegrees, this.reportedPixelWidthHeightRatio);
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long l2 = SystemClock.elapsedRealtime();
            long l3 = l2 - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.a(this.droppedFrames, l3);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = l2;
        }
    }

    private static boolean isBufferLate(long l2) {
        return l2 < -30000L;
    }

    private static boolean isBufferVeryLate(long l2) {
        return l2 < -500000L;
    }

    @TargetApi(value=23)
    private static void setOutputSurfaceV23(MediaCodec mediaCodec, Surface surface) {
        mediaCodec.setOutputSurface(surface);
    }

    @TargetApi(value=21)
    private static void configureTunnelingV21(MediaFormat mediaFormat, int n2) {
        mediaFormat.setFeatureEnabled("tunneled-playback", true);
        mediaFormat.setInteger("audio-session-id", n2);
    }

    @SuppressLint(value={"InlinedApi"})
    protected MediaFormat getMediaFormat(k k2, a a2, boolean bl2, int n2) {
        MediaFormat mediaFormat = new MediaFormat();
        mediaFormat.setString("mime", k2.g);
        mediaFormat.setInteger("width", k2.l);
        mediaFormat.setInteger("height", k2.m);
        fj.a(mediaFormat, k2.i);
        fj.a(mediaFormat, "frame-rate", k2.n);
        fj.a(mediaFormat, "rotation-degrees", k2.o);
        fj.a(mediaFormat, k2.s);
        mediaFormat.setInteger("max-width", a2.a);
        mediaFormat.setInteger("max-height", a2.b);
        fj.a(mediaFormat, "max-input-size", a2.c);
        if (nw.a >= 23) {
            mediaFormat.setInteger("priority", 0);
        }
        if (bl2) {
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (n2 != 0) {
            oc.configureTunnelingV21(mediaFormat, n2);
        }
        return mediaFormat;
    }

    protected a getCodecMaxValues(ff ff2, k k2, k[] kArray) throws fi.b {
        int n2 = k2.l;
        int n3 = k2.m;
        int n4 = oc.getMaxInputSize(ff2, k2);
        if (kArray.length == 1) {
            return new a(n2, n3, n4);
        }
        boolean bl2 = false;
        for (k k3 : kArray) {
            if (!oc.areAdaptationCompatible(ff2.d, k2, k3)) continue;
            bl2 |= k3.l == -1 || k3.m == -1;
            n2 = Math.max(n2, k3.l);
            n3 = Math.max(n3, k3.m);
            n4 = Math.max(n4, oc.getMaxInputSize(ff2, k3));
        }
        if (bl2) {
            int n5 = n2;
            int n6 = n3;
            Log.w((String)TAG, (String)new StringBuilder(66).append("Resolutions unknown. Codec max resolution: ").append(n5).append("x").append(n6).toString());
            Point point = oc.getCodecMaxSize(ff2, k2);
            if (point != null) {
                n2 = Math.max(n2, point.x);
                n3 = Math.max(n3, point.y);
                n4 = Math.max(n4, oc.getMaxInputSize(ff2, k2.g, n2, n3));
                n6 = n2;
                int n7 = n3;
                Log.w((String)TAG, (String)new StringBuilder(57).append("Codec max resolution adjusted to: ").append(n6).append("x").append(n7).toString());
            }
        }
        return new a(n2, n3, n4);
    }

    private static Point getCodecMaxSize(ff ff2, k k2) throws fi.b {
        boolean bl2 = k2.m > k2.l;
        int n2 = bl2 ? k2.m : k2.l;
        int n3 = bl2 ? k2.l : k2.m;
        float f2 = (float)n3 / (float)n2;
        for (int n4 : STANDARD_LONG_EDGE_VIDEO_PX) {
            int n5 = (int)((float)n4 * f2);
            if (n4 <= n2 || n5 <= n3) {
                return null;
            }
            if (nw.a >= 21) {
                Point point = ff2.a(bl2 ? n5 : n4, bl2 ? n4 : n5);
                float f3 = k2.n;
                if (!ff2.a(point.x, point.y, f3)) continue;
                return point;
            }
            if ((n4 = nw.a(n4, 16) * 16) * (n5 = nw.a(n5, 16) * 16) > fi.b()) continue;
            return new Point(bl2 ? n5 : n4, bl2 ? n4 : n5);
        }
        return null;
    }

    private static int getMaxInputSize(ff ff2, k k2) {
        if (k2.h != -1) {
            int n2 = 0;
            int n3 = k2.i.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 += k2.i.get(i2).length;
            }
            return k2.h + n2;
        }
        return oc.getMaxInputSize(ff2, k2.g, k2.l, k2.m);
    }

    private static int getMaxInputSize(ff ff2, String string, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == -1 || n3 == -1) {
            return -1;
        }
        switch (string) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(nw.d) || "Amazon".equals(nw.c) && ("KFSOWI".equals(nw.d) || "AFTS".equals(nw.d) && ff2.f)) {
                    return -1;
                }
                n5 = nw.a(n2, 16) * nw.a(n3, 16) * 16 * 16;
                n4 = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                n5 = n2 * n3;
                n4 = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return n5 * 3 / (2 * n4);
    }

    private static boolean areAdaptationCompatible(boolean bl2, k k2, k k3) {
        return k2.g.equals(k3.g) && k2.o == k3.o && (bl2 || k2.l == k3.l && k2.m == k3.m) && nw.a(k2.s, (Object)k3.s);
    }

    private static boolean deviceNeedsAutoFrcWorkaround() {
        return nw.a <= 22 && "foster".equals(nw.b) && "NVIDIA".equals(nw.c);
    }

    protected boolean codecNeedsSetOutputSurfaceWorkaround(String string) {
        if (string.startsWith("OMX.google")) {
            return false;
        }
        return "deb".equals(nw.b) || "flo".equals(nw.b) || "mido".equals(nw.b) || "santoni".equals(nw.b) || "ZB500KL".equals(nw.d) || "tcl_eu".equals(nw.b) || "SVP-DTV15".equals(nw.b) || "BRAVIA_ATV2".equals(nw.b) || "F3311".equals(nw.b) || "M5c".equals(nw.b) || "QM16XE_U".equals(nw.b) || "A7010a48".equals(nw.b) || "woods_f".equals(nw.d) || "watson".equals(nw.b) || "ALE-L21".equals(nw.d) || "CAM-L21".equals(nw.d) || "HUAWEI VNS-L21".equals(nw.d) || "AFTN".equals(nw.d) || nw.b.startsWith("panell_");
    }

    @TargetApi(value=23)
    private final class b
    implements MediaCodec.OnFrameRenderedListener {
        private b(MediaCodec mediaCodec) {
            mediaCodec.setOnFrameRenderedListener((MediaCodec.OnFrameRenderedListener)this, new Handler());
        }

        public void onFrameRendered(@NonNull MediaCodec mediaCodec, long l2, long l3) {
            if (this != oc.this.tunnelingOnFrameRenderedListener) {
                return;
            }
            oc.this.maybeNotifyRenderedFirstFrame();
        }
    }

    protected static final class a {
        public final int a;
        public final int b;
        public final int c;

        public a(int n2, int n3, int n4) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
        }
    }
}

