/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.CheckResult;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.vr.sdk.widgets.video.deps.bc;
import com.google.vr.sdk.widgets.video.deps.bd;
import com.google.vr.sdk.widgets.video.deps.bp;
import com.google.vr.sdk.widgets.video.deps.bq;
import com.google.vr.sdk.widgets.video.deps.bu;
import com.google.vr.sdk.widgets.video.deps.f;
import com.google.vr.sdk.widgets.video.deps.ff;
import com.google.vr.sdk.widgets.video.deps.fh;
import com.google.vr.sdk.widgets.video.deps.fi;
import com.google.vr.sdk.widgets.video.deps.k;
import com.google.vr.sdk.widgets.video.deps.l;
import com.google.vr.sdk.widgets.video.deps.mx;
import com.google.vr.sdk.widgets.video.deps.nk;
import com.google.vr.sdk.widgets.video.deps.nu;
import com.google.vr.sdk.widgets.video.deps.nw;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=16)
public abstract class fg
extends com.google.vr.sdk.widgets.video.deps.a {
    private static final String TAG = "MediaCodecRenderer";
    private static final long MAX_CODEC_HOTSWAP_TIME_MS = 1000L;
    protected static final int KEEP_CODEC_RESULT_NO = 0;
    protected static final int KEEP_CODEC_RESULT_YES_WITHOUT_RECONFIGURATION = 1;
    protected static final int KEEP_CODEC_RESULT_YES_WITH_RECONFIGURATION = 3;
    private static final int RECONFIGURATION_STATE_NONE = 0;
    private static final int RECONFIGURATION_STATE_WRITE_PENDING = 1;
    private static final int RECONFIGURATION_STATE_QUEUE_PENDING = 2;
    private static final int REINITIALIZATION_STATE_NONE = 0;
    private static final int REINITIALIZATION_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int REINITIALIZATION_STATE_WAIT_END_OF_STREAM = 2;
    private static final int ADAPTATION_WORKAROUND_MODE_NEVER = 0;
    private static final int ADAPTATION_WORKAROUND_MODE_SAME_RESOLUTION = 1;
    private static final int ADAPTATION_WORKAROUND_MODE_ALWAYS = 2;
    private static final byte[] ADAPTATION_WORKAROUND_BUFFER = nw.i("0000016742C00BDA259000000168CE0F13200000016588840DCE7118A0002FBF1C31C3275D78");
    private static final int ADAPTATION_WORKAROUND_SLICE_WIDTH_HEIGHT = 32;
    private final fh mediaCodecSelector;
    @Nullable
    private final bq<bu> drmSessionManager;
    private final boolean playClearSamplesWithoutKeys;
    private final bd buffer;
    private final bd flagsOnlyBuffer;
    private final l formatHolder;
    private final List<Long> decodeOnlyPresentationTimestamps;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private k format;
    private bp<bu> drmSession;
    private bp<bu> pendingDrmSession;
    private MediaCodec codec;
    @Nullable
    private ArrayDeque<ff> availableCodecInfos;
    @Nullable
    private a preferredDecoderInitializationException;
    @Nullable
    private ff codecInfo;
    private int codecAdaptationWorkaroundMode;
    private boolean codecNeedsDiscardToSpsWorkaround;
    private boolean codecNeedsFlushWorkaround;
    private boolean codecNeedsEosPropagationWorkaround;
    private boolean codecNeedsEosFlushWorkaround;
    private boolean codecNeedsEosOutputExceptionWorkaround;
    private boolean codecNeedsMonoChannelCountWorkaround;
    private boolean codecNeedsAdaptationWorkaroundBuffer;
    private boolean shouldSkipAdaptationWorkaroundOutputBuffer;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private long codecHotswapDeadlineMs;
    private int inputIndex;
    private int outputIndex;
    private ByteBuffer outputBuffer;
    private boolean shouldSkipOutputBuffer;
    private boolean codecReconfigured;
    private int codecReconfigurationState;
    private int codecReinitializationState;
    private boolean codecReceivedBuffers;
    private boolean codecReceivedEos;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private boolean waitingForKeys;
    private boolean waitingForFirstSyncFrame;
    protected bc decoderCounters;

    public fg(int n2, fh fh2, @Nullable bq<bu> bq2, boolean bl2) {
        super(n2);
        mx.b(nw.a >= 16);
        this.mediaCodecSelector = mx.a(fh2);
        this.drmSessionManager = bq2;
        this.playClearSamplesWithoutKeys = bl2;
        this.buffer = new bd(0);
        this.flagsOnlyBuffer = bd.e();
        this.formatHolder = new l();
        this.decodeOnlyPresentationTimestamps = new ArrayList<Long>();
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
    }

    @Override
    public final int supportsMixedMimeTypeAdaptation() {
        return 8;
    }

    @Override
    public final int supportsFormat(k k2) throws f {
        try {
            return this.supportsFormat(this.mediaCodecSelector, this.drmSessionManager, k2);
        }
        catch (fi.b b2) {
            throw f.a(b2, this.getIndex());
        }
    }

    protected abstract int supportsFormat(fh var1, bq<bu> var2, k var3) throws fi.b;

    protected List<ff> getDecoderInfos(fh fh2, k k2, boolean bl2) throws fi.b {
        return fh2.a(k2, bl2);
    }

    protected abstract void configureCodec(ff var1, MediaCodec var2, k var3, MediaCrypto var4) throws fi.b;

    protected final void maybeInitCodec() throws f {
        Object object;
        if (this.codec != null || this.format == null) {
            return;
        }
        this.drmSession = this.pendingDrmSession;
        String string = this.format.g;
        MediaCrypto mediaCrypto = null;
        boolean bl2 = false;
        if (this.drmSession != null) {
            object = this.drmSession.g();
            if (object == null) {
                bp.a a2 = this.drmSession.f();
                if (a2 == null) {
                    return;
                }
            } else {
                mediaCrypto = ((bu)object).a();
                bl2 = ((bu)object).a(string);
            }
            if (this.deviceNeedsDrmKeysToConfigureCodecWorkaround()) {
                int n2 = this.drmSession.e();
                if (n2 == 1) {
                    throw f.a(this.drmSession.f(), this.getIndex());
                }
                if (n2 != 4) {
                    return;
                }
            }
        }
        try {
            if (!this.initCodecWithFallback(mediaCrypto, bl2)) {
                return;
            }
        }
        catch (a a3) {
            throw f.a(a3, this.getIndex());
        }
        object = this.codecInfo.a;
        this.codecAdaptationWorkaroundMode = this.codecAdaptationWorkaroundMode((String)object);
        this.codecNeedsDiscardToSpsWorkaround = fg.codecNeedsDiscardToSpsWorkaround((String)object, this.format);
        this.codecNeedsFlushWorkaround = fg.codecNeedsFlushWorkaround((String)object);
        this.codecNeedsEosPropagationWorkaround = fg.codecNeedsEosPropagationWorkaround(this.codecInfo);
        this.codecNeedsEosFlushWorkaround = fg.codecNeedsEosFlushWorkaround((String)object);
        this.codecNeedsEosOutputExceptionWorkaround = fg.codecNeedsEosOutputExceptionWorkaround((String)object);
        this.codecNeedsMonoChannelCountWorkaround = fg.codecNeedsMonoChannelCountWorkaround((String)object, this.format);
        this.codecHotswapDeadlineMs = this.getState() == 2 ? SystemClock.elapsedRealtime() + 1000L : -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForFirstSyncFrame = true;
        ++this.decoderCounters.a;
    }

    protected boolean shouldInitCodec(ff ff2) {
        return true;
    }

    protected final MediaCodec getCodec() {
        return this.codec;
    }

    protected final ff getCodecInfo() {
        return this.codecInfo;
    }

    @Override
    protected void onEnabled(boolean bl2) throws f {
        this.decoderCounters = new bc();
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) throws f {
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        if (this.codec != null) {
            this.flushCodec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDisabled() {
        this.format = null;
        this.availableCodecInfos = null;
        try {
            this.releaseCodec();
        }
        finally {
            try {
                if (this.drmSession != null) {
                    this.drmSessionManager.a(this.drmSession);
                }
            }
            finally {
                try {
                    if (this.pendingDrmSession != null && this.pendingDrmSession != this.drmSession) {
                        this.drmSessionManager.a(this.pendingDrmSession);
                    }
                }
                finally {
                    this.drmSession = null;
                    this.pendingDrmSession = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseCodec() {
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForKeys = false;
        this.shouldSkipOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.resetCodecBuffers();
        this.codecInfo = null;
        this.codecReconfigured = false;
        this.codecReceivedBuffers = false;
        this.codecNeedsDiscardToSpsWorkaround = false;
        this.codecNeedsFlushWorkaround = false;
        this.codecAdaptationWorkaroundMode = 0;
        this.codecNeedsEosPropagationWorkaround = false;
        this.codecNeedsEosFlushWorkaround = false;
        this.codecNeedsMonoChannelCountWorkaround = false;
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        this.codecReceivedEos = false;
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
        if (this.codec != null) {
            ++this.decoderCounters.b;
            try {
                this.codec.stop();
            }
            finally {
                try {
                    this.codec.release();
                }
                finally {
                    this.codec = null;
                    if (this.drmSession != null && this.pendingDrmSession != this.drmSession) {
                        try {
                            this.drmSessionManager.a(this.drmSession);
                        }
                        finally {
                            this.drmSession = null;
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void onStarted() {
    }

    @Override
    protected void onStopped() {
    }

    @Override
    public void render(long l2, long l3) throws f {
        int n2;
        if (this.outputStreamEnded) {
            this.renderToEndOfStream();
            return;
        }
        if (this.format == null) {
            this.flagsOnlyBuffer.a();
            n2 = this.readSource(this.formatHolder, this.flagsOnlyBuffer, true);
            if (n2 == -5) {
                this.onInputFormatChanged(this.formatHolder.a);
            } else {
                if (n2 == -4) {
                    mx.b(this.flagsOnlyBuffer.c());
                    this.inputStreamEnded = true;
                    this.processEndOfStream();
                    return;
                }
                return;
            }
        }
        this.maybeInitCodec();
        if (this.codec != null) {
            nu.a("drainAndFeed");
            while (this.drainOutputBuffer(l2, l3)) {
            }
            while (this.feedInputBuffer()) {
            }
            nu.a();
        } else {
            this.decoderCounters.d += this.skipSource(l2);
            this.flagsOnlyBuffer.a();
            n2 = this.readSource(this.formatHolder, this.flagsOnlyBuffer, false);
            if (n2 == -5) {
                this.onInputFormatChanged(this.formatHolder.a);
            } else if (n2 == -4) {
                mx.b(this.flagsOnlyBuffer.c());
                this.inputStreamEnded = true;
                this.processEndOfStream();
            }
        }
        this.decoderCounters.a();
    }

    protected void flushCodec() throws f {
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForFirstSyncFrame = true;
        this.waitingForKeys = false;
        this.shouldSkipOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        if (this.codecNeedsFlushWorkaround || this.codecNeedsEosFlushWorkaround && this.codecReceivedEos) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else if (this.codecReinitializationState != 0) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.codec.flush();
            this.codecReceivedBuffers = false;
        }
        if (this.codecReconfigured && this.format != null) {
            this.codecReconfigurationState = 1;
        }
    }

    private boolean initCodecWithFallback(MediaCrypto mediaCrypto, boolean bl2) throws a {
        if (this.availableCodecInfos == null) {
            try {
                this.availableCodecInfos = new ArrayDeque<ff>(this.getAvailableCodecInfos(bl2));
                this.preferredDecoderInitializationException = null;
            }
            catch (fi.b b2) {
                throw new a(this.format, (Throwable)b2, bl2, -49998);
            }
        }
        if (this.availableCodecInfos.isEmpty()) {
            throw new a(this.format, null, bl2, -49999);
        }
        ff ff2;
        while (this.shouldInitCodec(ff2 = this.availableCodecInfos.peekFirst())) {
            try {
                this.initCodec(ff2, mediaCrypto);
                return true;
            }
            catch (Exception exception) {
                Object object = String.valueOf(ff2);
                Log.w((String)TAG, (String)new StringBuilder(30 + String.valueOf(object).length()).append("Failed to initialize decoder: ").append((String)object).toString(), (Throwable)exception);
                this.availableCodecInfos.removeFirst();
                object = new a(this.format, (Throwable)exception, bl2, ff2.a);
                this.preferredDecoderInitializationException = this.preferredDecoderInitializationException == null ? object : this.preferredDecoderInitializationException.a((a)object);
                if (!this.availableCodecInfos.isEmpty()) continue;
                throw this.preferredDecoderInitializationException;
            }
            break;
        }
        return false;
    }

    private List<ff> getAvailableCodecInfos(boolean bl2) throws fi.b {
        List<ff> list = this.getDecoderInfos(this.mediaCodecSelector, this.format, bl2);
        if (list.isEmpty() && bl2 && !(list = this.getDecoderInfos(this.mediaCodecSelector, this.format, false)).isEmpty()) {
            String string = this.format.g;
            String string2 = String.valueOf(list);
            Log.w((String)TAG, (String)new StringBuilder(99 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Drm session requires secure decoder for ").append(string).append(", but no secure decoder available. Trying to proceed with ").append(string2).append(".").toString());
        }
        return list;
    }

    private void initCodec(ff ff2, MediaCrypto mediaCrypto) throws Exception {
        long l2;
        long l3;
        MediaCodec mediaCodec = null;
        String string = ff2.a;
        try {
            l3 = SystemClock.elapsedRealtime();
            String string2 = String.valueOf(string);
            nu.a(string2.length() != 0 ? "createCodec:".concat(string2) : new String("createCodec:"));
            mediaCodec = MediaCodec.createByCodecName((String)string);
            nu.a();
            nu.a("configureCodec");
            this.configureCodec(ff2, mediaCodec, this.format, mediaCrypto);
            nu.a();
            nu.a("startCodec");
            mediaCodec.start();
            nu.a();
            l2 = SystemClock.elapsedRealtime();
            this.getCodecBuffers(mediaCodec);
        }
        catch (Exception exception) {
            if (mediaCodec != null) {
                this.resetCodecBuffers();
                mediaCodec.release();
            }
            throw exception;
        }
        this.codec = mediaCodec;
        this.codecInfo = ff2;
        long l4 = l2 - l3;
        this.onCodecInitialized(string, l2, l4);
    }

    private void getCodecBuffers(MediaCodec mediaCodec) {
        if (nw.a < 21) {
            this.inputBuffers = mediaCodec.getInputBuffers();
            this.outputBuffers = mediaCodec.getOutputBuffers();
        }
    }

    private void resetCodecBuffers() {
        if (nw.a < 21) {
            this.inputBuffers = null;
            this.outputBuffers = null;
        }
    }

    private ByteBuffer getInputBuffer(int n2) {
        if (nw.a >= 21) {
            return this.codec.getInputBuffer(n2);
        }
        return this.inputBuffers[n2];
    }

    private ByteBuffer getOutputBuffer(int n2) {
        if (nw.a >= 21) {
            return this.codec.getOutputBuffer(n2);
        }
        return this.outputBuffers[n2];
    }

    private boolean hasOutputBuffer() {
        return this.outputIndex >= 0;
    }

    private void resetInputBuffer() {
        this.inputIndex = -1;
        this.buffer.b = null;
    }

    private void resetOutputBuffer() {
        this.outputIndex = -1;
        this.outputBuffer = null;
    }

    private boolean feedInputBuffer() throws f {
        int n2;
        int n3;
        if (this.codec == null || this.codecReinitializationState == 2 || this.inputStreamEnded) {
            return false;
        }
        if (this.inputIndex < 0) {
            this.inputIndex = this.codec.dequeueInputBuffer(0L);
            if (this.inputIndex < 0) {
                return false;
            }
            this.buffer.b = this.getInputBuffer(this.inputIndex);
            this.buffer.a();
        }
        if (this.codecReinitializationState == 1) {
            if (!this.codecNeedsEosPropagationWorkaround) {
                this.codecReceivedEos = true;
                this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                this.resetInputBuffer();
            }
            this.codecReinitializationState = 2;
            return false;
        }
        if (this.codecNeedsAdaptationWorkaroundBuffer) {
            this.codecNeedsAdaptationWorkaroundBuffer = false;
            this.buffer.b.put(ADAPTATION_WORKAROUND_BUFFER);
            this.codec.queueInputBuffer(this.inputIndex, 0, ADAPTATION_WORKAROUND_BUFFER.length, 0L, 0);
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            return true;
        }
        int n4 = 0;
        if (this.waitingForKeys) {
            n3 = -4;
        } else {
            if (this.codecReconfigurationState == 1) {
                for (n2 = 0; n2 < this.format.i.size(); n2 += 1) {
                    byte[] byArray = this.format.i.get(n2);
                    this.buffer.b.put(byArray);
                }
                this.codecReconfigurationState = 2;
            }
            n4 = this.buffer.b.position();
            n3 = this.readSource(this.formatHolder, this.buffer, false);
        }
        if (n3 == -3) {
            return false;
        }
        if (n3 == -5) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.a();
                this.codecReconfigurationState = 1;
            }
            this.onInputFormatChanged(this.formatHolder.a);
            return true;
        }
        if (this.buffer.c()) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.a();
                this.codecReconfigurationState = 1;
            }
            this.inputStreamEnded = true;
            if (!this.codecReceivedBuffers) {
                this.processEndOfStream();
                return false;
            }
            try {
                if (!this.codecNeedsEosPropagationWorkaround) {
                    this.codecReceivedEos = true;
                    this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                    this.resetInputBuffer();
                }
            }
            catch (MediaCodec.CryptoException cryptoException) {
                throw f.a((Exception)((Object)cryptoException), this.getIndex());
            }
            return false;
        }
        if (this.waitingForFirstSyncFrame && !this.buffer.d()) {
            this.buffer.a();
            if (this.codecReconfigurationState == 2) {
                this.codecReconfigurationState = 1;
            }
            return true;
        }
        this.waitingForFirstSyncFrame = false;
        n2 = this.buffer.g() ? 1 : 0;
        this.waitingForKeys = this.shouldWaitForKeys(n2 != 0);
        if (this.waitingForKeys) {
            return false;
        }
        if (this.codecNeedsDiscardToSpsWorkaround && !n2) {
            nk.a(this.buffer.b);
            if (this.buffer.b.position() == 0) {
                return true;
            }
            this.codecNeedsDiscardToSpsWorkaround = false;
        }
        try {
            long l2 = this.buffer.c;
            if (this.buffer.b_()) {
                this.decodeOnlyPresentationTimestamps.add(l2);
            }
            this.buffer.h();
            this.onQueueInputBuffer(this.buffer);
            if (n2) {
                MediaCodec.CryptoInfo cryptoInfo = fg.getFrameworkCryptoInfo(this.buffer, n4);
                this.codec.queueSecureInputBuffer(this.inputIndex, 0, cryptoInfo, l2, 0);
            } else {
                this.codec.queueInputBuffer(this.inputIndex, 0, this.buffer.b.limit(), l2, 0);
            }
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            this.codecReconfigurationState = 0;
            ++this.decoderCounters.c;
        }
        catch (MediaCodec.CryptoException cryptoException) {
            throw f.a((Exception)((Object)cryptoException), this.getIndex());
        }
        return true;
    }

    private boolean shouldWaitForKeys(boolean bl2) throws f {
        if (this.drmSession == null || !bl2 && this.playClearSamplesWithoutKeys) {
            return false;
        }
        int n2 = this.drmSession.e();
        if (n2 == 1) {
            throw f.a(this.drmSession.f(), this.getIndex());
        }
        return n2 != 4;
    }

    protected void onCodecInitialized(String string, long l2, long l3) {
    }

    protected void onInputFormatChanged(k k2) throws f {
        boolean bl2;
        k k3 = this.format;
        this.format = k2;
        boolean bl3 = bl2 = !nw.a(this.format.j, (Object)(k3 == null ? null : k3.j));
        if (bl2) {
            if (this.format.j != null) {
                if (this.drmSessionManager == null) {
                    throw f.a(new IllegalStateException("Media requires a DrmSessionManager"), this.getIndex());
                }
                this.pendingDrmSession = this.drmSessionManager.a(Looper.myLooper(), this.format.j);
                if (this.pendingDrmSession == this.drmSession) {
                    this.drmSessionManager.a(this.pendingDrmSession);
                }
            } else {
                this.pendingDrmSession = null;
            }
        }
        boolean bl4 = false;
        if (this.pendingDrmSession == this.drmSession && this.codec != null) {
            switch (this.canKeepCodec(this.codec, this.codecInfo, k3, this.format)) {
                case 0: {
                    break;
                }
                case 1: {
                    bl4 = true;
                    break;
                }
                case 3: {
                    bl4 = true;
                    this.codecReconfigured = true;
                    this.codecReconfigurationState = 1;
                    this.codecNeedsAdaptationWorkaroundBuffer = this.codecAdaptationWorkaroundMode == 2 || this.codecAdaptationWorkaroundMode == 1 && this.format.l == k3.l && this.format.m == k3.m;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (!bl4) {
            this.availableCodecInfos = null;
            if (this.codecReceivedBuffers) {
                this.codecReinitializationState = 1;
            } else {
                this.releaseCodec();
                this.maybeInitCodec();
            }
        }
    }

    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) throws f {
    }

    protected void onQueueInputBuffer(bd bd2) {
    }

    protected void onProcessedOutputBuffer(long l2) {
    }

    protected int canKeepCodec(MediaCodec mediaCodec, ff ff2, k k2, k k3) {
        return 0;
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return this.format != null && !this.waitingForKeys && (this.isSourceReady() || this.hasOutputBuffer() || this.codecHotswapDeadlineMs != -9223372036854775807L && SystemClock.elapsedRealtime() < this.codecHotswapDeadlineMs);
    }

    protected long getDequeueOutputBufferTimeoutUs() {
        return 0L;
    }

    private boolean drainOutputBuffer(long l2, long l3) throws f {
        int n2;
        if (!this.hasOutputBuffer()) {
            if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
                try {
                    n2 = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
                }
                catch (IllegalStateException illegalStateException) {
                    this.processEndOfStream();
                    if (this.outputStreamEnded) {
                        this.releaseCodec();
                    }
                    return false;
                }
            } else {
                n2 = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
            }
            if (n2 >= 0) {
                if (this.shouldSkipAdaptationWorkaroundOutputBuffer) {
                    this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
                    this.codec.releaseOutputBuffer(n2, false);
                    return true;
                }
                if (this.outputBufferInfo.size == 0 && (this.outputBufferInfo.flags & 4) != 0) {
                    this.processEndOfStream();
                    return false;
                }
                this.outputIndex = n2;
                this.outputBuffer = this.getOutputBuffer(n2);
                if (this.outputBuffer != null) {
                    this.outputBuffer.position(this.outputBufferInfo.offset);
                    this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
                }
                this.shouldSkipOutputBuffer = this.shouldSkipOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            } else {
                if (n2 == -2) {
                    this.processOutputFormat();
                    return true;
                }
                if (n2 == -3) {
                    this.processOutputBuffersChanged();
                    return true;
                }
                if (this.codecNeedsEosPropagationWorkaround && (this.inputStreamEnded || this.codecReinitializationState == 2)) {
                    this.processEndOfStream();
                }
                return false;
            }
        }
        if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
            try {
                n2 = this.processOutputBuffer(l2, l3, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer) ? 1 : 0;
            }
            catch (IllegalStateException illegalStateException) {
                this.processEndOfStream();
                if (this.outputStreamEnded) {
                    this.releaseCodec();
                }
                return false;
            }
        } else {
            n2 = this.processOutputBuffer(l2, l3, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer) ? 1 : 0;
        }
        if (n2 != 0) {
            this.onProcessedOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            boolean bl2 = (this.outputBufferInfo.flags & 4) != 0;
            this.resetOutputBuffer();
            if (!bl2) {
                return true;
            }
            this.processEndOfStream();
        }
        return false;
    }

    private void processOutputFormat() throws f {
        MediaFormat mediaFormat = this.codec.getOutputFormat();
        if (this.codecAdaptationWorkaroundMode != 0 && mediaFormat.getInteger("width") == 32 && mediaFormat.getInteger("height") == 32) {
            this.shouldSkipAdaptationWorkaroundOutputBuffer = true;
            return;
        }
        if (this.codecNeedsMonoChannelCountWorkaround) {
            mediaFormat.setInteger("channel-count", 1);
        }
        this.onOutputFormatChanged(this.codec, mediaFormat);
    }

    private void processOutputBuffersChanged() {
        if (nw.a < 21) {
            this.outputBuffers = this.codec.getOutputBuffers();
        }
    }

    protected abstract boolean processOutputBuffer(long var1, long var3, MediaCodec var5, ByteBuffer var6, int var7, int var8, long var9, boolean var11) throws f;

    protected void renderToEndOfStream() throws f {
    }

    private void processEndOfStream() throws f {
        if (this.codecReinitializationState == 2) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.outputStreamEnded = true;
            this.renderToEndOfStream();
        }
    }

    private boolean shouldSkipOutputBuffer(long l2) {
        int n2 = this.decodeOnlyPresentationTimestamps.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.decodeOnlyPresentationTimestamps.get(i2) != l2) continue;
            this.decodeOnlyPresentationTimestamps.remove(i2);
            return true;
        }
        return false;
    }

    private static MediaCodec.CryptoInfo getFrameworkCryptoInfo(bd bd2, int n2) {
        MediaCodec.CryptoInfo cryptoInfo = bd2.a.a();
        if (n2 == 0) {
            return cryptoInfo;
        }
        if (cryptoInfo.numBytesOfClearData == null) {
            cryptoInfo.numBytesOfClearData = new int[1];
        }
        cryptoInfo.numBytesOfClearData[0] = cryptoInfo.numBytesOfClearData[0] + n2;
        return cryptoInfo;
    }

    private boolean deviceNeedsDrmKeysToConfigureCodecWorkaround() {
        return "Amazon".equals(nw.c) && ("AFTM".equals(nw.d) || "AFTB".equals(nw.d));
    }

    private static boolean codecNeedsFlushWorkaround(String string) {
        return nw.a < 18 || nw.a == 18 && ("OMX.SEC.avc.dec".equals(string) || "OMX.SEC.avc.dec.secure".equals(string)) || nw.a == 19 && nw.d.startsWith("SM-G800") && ("OMX.Exynos.avc.dec".equals(string) || "OMX.Exynos.avc.dec.secure".equals(string));
    }

    private int codecAdaptationWorkaroundMode(String string) {
        if (nw.a <= 25 && "OMX.Exynos.avc.dec.secure".equals(string) && (nw.d.startsWith("SM-T585") || nw.d.startsWith("SM-A510") || nw.d.startsWith("SM-A520") || nw.d.startsWith("SM-J700"))) {
            return 2;
        }
        if (nw.a < 24 && ("OMX.Nvidia.h264.decode".equals(string) || "OMX.Nvidia.h264.decode.secure".equals(string)) && ("flounder".equals(nw.b) || "flounder_lte".equals(nw.b) || "grouper".equals(nw.b) || "tilapia".equals(nw.b))) {
            return 1;
        }
        return 0;
    }

    private static boolean codecNeedsDiscardToSpsWorkaround(String string, k k2) {
        return nw.a < 21 && k2.i.isEmpty() && "OMX.MTK.VIDEO.DECODER.AVC".equals(string);
    }

    private static boolean codecNeedsEosPropagationWorkaround(ff ff2) {
        String string = ff2.a;
        return nw.a <= 17 && ("OMX.rk.video_decoder.avc".equals(string) || "OMX.allwinner.video.decoder.avc".equals(string)) || "Amazon".equals(nw.c) && "AFTS".equals(nw.d) && ff2.f;
    }

    private static boolean codecNeedsEosFlushWorkaround(String string) {
        return nw.a <= 23 && "OMX.google.vorbis.decoder".equals(string) || nw.a <= 19 && "hb2000".equals(nw.b) && ("OMX.amlogic.avc.decoder.awesome".equals(string) || "OMX.amlogic.avc.decoder.awesome.secure".equals(string));
    }

    private static boolean codecNeedsEosOutputExceptionWorkaround(String string) {
        return nw.a == 21 && "OMX.google.aac.decoder".equals(string);
    }

    private static boolean codecNeedsMonoChannelCountWorkaround(String string, k k2) {
        return nw.a <= 18 && k2.t == 1 && "OMX.MTK.AUDIO.DECODER.MP3".equals(string);
    }

    public static class a
    extends Exception {
        public final String a;
        public final boolean b;
        public final String c;
        public final String d;
        @Nullable
        public final a e;

        public a(k k2, Throwable throwable, boolean bl2, int n2) {
            String string = String.valueOf(k2);
            this(new StringBuilder(36 + String.valueOf(string).length()).append("Decoder init failed: [").append(n2).append("], ").append(string).toString(), throwable, k2.g, bl2, null, com.google.vr.sdk.widgets.video.deps.fg$a.a(n2), null);
        }

        public a(k k2, Throwable throwable, boolean bl2, String string) {
            String string2 = String.valueOf(k2);
            this(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Decoder init failed: ").append(string).append(", ").append(string2).toString(), throwable, k2.g, bl2, string, nw.a >= 21 ? com.google.vr.sdk.widgets.video.deps.fg$a.a(throwable) : null, null);
        }

        private a(String string, Throwable throwable, String string2, boolean bl2, @Nullable String string3, @Nullable String string4, @Nullable a a2) {
            super(string, throwable);
            this.a = string2;
            this.b = bl2;
            this.c = string3;
            this.d = string4;
            this.e = a2;
        }

        @CheckResult
        private a a(a a2) {
            return new a(this.getMessage(), this.getCause(), this.a, this.b, this.c, this.d, a2);
        }

        @TargetApi(value=21)
        private static String a(Throwable throwable) {
            if (throwable instanceof MediaCodec.CodecException) {
                return ((MediaCodec.CodecException)throwable).getDiagnosticInfo();
            }
            return null;
        }

        private static String a(int n2) {
            String string = n2 < 0 ? "neg_" : "";
            int n3 = Math.abs(n2);
            return new StringBuilder(64 + String.valueOf(string).length()).append("com.google.android.exoplayer.MediaCodecTrackRenderer_").append(string).append(n3).toString();
        }
    }
}

