/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.PlaybackParams;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import com.google.vr.sdk.widgets.video.deps.aa;
import com.google.vr.sdk.widgets.video.deps.ab;
import com.google.vr.sdk.widgets.video.deps.ad;
import com.google.vr.sdk.widgets.video.deps.ae;
import com.google.vr.sdk.widgets.video.deps.af;
import com.google.vr.sdk.widgets.video.deps.ah;
import com.google.vr.sdk.widgets.video.deps.aj;
import com.google.vr.sdk.widgets.video.deps.al;
import com.google.vr.sdk.widgets.video.deps.bc;
import com.google.vr.sdk.widgets.video.deps.bm;
import com.google.vr.sdk.widgets.video.deps.bq;
import com.google.vr.sdk.widgets.video.deps.bu;
import com.google.vr.sdk.widgets.video.deps.f;
import com.google.vr.sdk.widgets.video.deps.fk;
import com.google.vr.sdk.widgets.video.deps.fp;
import com.google.vr.sdk.widgets.video.deps.g;
import com.google.vr.sdk.widgets.video.deps.gy;
import com.google.vr.sdk.widgets.video.deps.h;
import com.google.vr.sdk.widgets.video.deps.hp;
import com.google.vr.sdk.widgets.video.deps.jx;
import com.google.vr.sdk.widgets.video.deps.k;
import com.google.vr.sdk.widgets.video.deps.kg;
import com.google.vr.sdk.widgets.video.deps.lt;
import com.google.vr.sdk.widgets.video.deps.lu;
import com.google.vr.sdk.widgets.video.deps.my;
import com.google.vr.sdk.widgets.video.deps.n;
import com.google.vr.sdk.widgets.video.deps.nw;
import com.google.vr.sdk.widgets.video.deps.oe;
import com.google.vr.sdk.widgets.video.deps.of;
import com.google.vr.sdk.widgets.video.deps.t;
import com.google.vr.sdk.widgets.video.deps.u;
import com.google.vr.sdk.widgets.video.deps.w;
import com.google.vr.sdk.widgets.video.deps.x;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;

@TargetApi(value=16)
public class ac
implements g,
u.a,
u.d,
u.e {
    private static final String TAG = "SimpleExoPlayer";
    protected final x[] renderers;
    private final g player;
    private final Handler eventHandler;
    private final a componentListener = new a();
    private final CopyOnWriteArraySet<oe> videoListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<aj> audioListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<kg> textOutputs = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<fp> metadataOutputs = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<of> videoDebugListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<al> audioDebugListeners = new CopyOnWriteArraySet();
    private final ae analyticsCollector;
    private k videoFormat;
    private k audioFormat;
    private Surface surface;
    private boolean ownsSurface;
    private int videoScalingMode;
    private SurfaceHolder surfaceHolder;
    private TextureView textureView;
    private int surfaceWidth;
    private int surfaceHeight;
    private bc videoDecoderCounters;
    private bc audioDecoderCounters;
    private int audioSessionId;
    private ah audioAttributes;
    private float audioVolume;
    private gy mediaSource;
    private List<jx> currentCues;

    @Deprecated
    protected ac(aa aa2, lu lu2, n n2, @Nullable bq<bu> bq2) {
        this(aa2, lu2, n2, bq2, nw.a());
    }

    protected ac(aa aa2, lu lu2, n n2, @Nullable bq<bu> bq2, Looper looper) {
        this(aa2, lu2, n2, bq2, new ae.a(), looper);
    }

    protected ac(aa aa2, lu lu2, n n2, @Nullable bq<bu> bq2, ae.a a2, Looper looper) {
        this(aa2, lu2, n2, bq2, a2, my.a, looper);
    }

    protected ac(aa aa2, lu lu2, n n2, @Nullable bq<bu> bq2, ae.a a2, my my2, Looper looper) {
        this.eventHandler = new Handler(looper);
        this.renderers = aa2.createRenderers(this.eventHandler, this.componentListener, this.componentListener, this.componentListener, this.componentListener, bq2);
        this.audioVolume = 1.0f;
        this.audioSessionId = 0;
        this.audioAttributes = ah.a;
        this.videoScalingMode = 1;
        this.currentCues = Collections.emptyList();
        this.player = this.createExoPlayerImpl(this.renderers, lu2, n2, my2, looper);
        this.analyticsCollector = a2.a(this.player, my2);
        this.addListener(this.analyticsCollector);
        this.videoDebugListeners.add(this.analyticsCollector);
        this.videoListeners.add(this.analyticsCollector);
        this.audioDebugListeners.add(this.analyticsCollector);
        this.audioListeners.add(this.analyticsCollector);
        this.addMetadataOutput(this.analyticsCollector);
        if (bq2 instanceof bm) {
            ((bm)bq2).a(this.eventHandler, this.analyticsCollector);
        }
    }

    public u.a getAudioComponent() {
        return this;
    }

    public u.e getVideoComponent() {
        return this;
    }

    public u.d getTextComponent() {
        return this;
    }

    public void setVideoScalingMode(int n2) {
        this.videoScalingMode = n2;
        for (x x2 : this.renderers) {
            if (x2.getTrackType() != 2) continue;
            this.player.createMessage(x2).a(4).a((Object)n2).i();
        }
    }

    public int getVideoScalingMode() {
        return this.videoScalingMode;
    }

    public void clearVideoSurface() {
        this.setVideoSurface(null);
    }

    public void setVideoSurface(Surface surface) {
        this.removeSurfaceCallbacks();
        this.setVideoSurfaceInternal(surface, false);
        int n2 = surface == null ? 0 : -1;
        this.maybeNotifySurfaceSizeChanged(n2, n2);
    }

    public void clearVideoSurface(Surface surface) {
        if (surface != null && surface == this.surface) {
            this.setVideoSurface(null);
        }
    }

    public void setVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.removeSurfaceCallbacks();
        this.surfaceHolder = surfaceHolder;
        if (surfaceHolder == null) {
            this.setVideoSurfaceInternal(null, false);
            this.maybeNotifySurfaceSizeChanged(0, 0);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
            Surface surface = surfaceHolder.getSurface();
            if (surface != null && surface.isValid()) {
                this.setVideoSurfaceInternal(surface, false);
                Rect rect = surfaceHolder.getSurfaceFrame();
                this.maybeNotifySurfaceSizeChanged(rect.width(), rect.height());
            } else {
                this.setVideoSurfaceInternal(null, false);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            }
        }
    }

    public void clearVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        if (surfaceHolder != null && surfaceHolder == this.surfaceHolder) {
            this.setVideoSurfaceHolder(null);
        }
    }

    public void setVideoSurfaceView(SurfaceView surfaceView) {
        this.setVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    public void clearVideoSurfaceView(SurfaceView surfaceView) {
        this.clearVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    public void setVideoTextureView(TextureView textureView) {
        this.removeSurfaceCallbacks();
        this.textureView = textureView;
        if (textureView == null) {
            this.setVideoSurfaceInternal(null, true);
            this.maybeNotifySurfaceSizeChanged(0, 0);
        } else {
            SurfaceTexture surfaceTexture;
            if (textureView.getSurfaceTextureListener() != null) {
                Log.w((String)TAG, (String)"Replacing existing SurfaceTextureListener.");
            }
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.componentListener);
            SurfaceTexture surfaceTexture2 = surfaceTexture = textureView.isAvailable() ? textureView.getSurfaceTexture() : null;
            if (surfaceTexture == null) {
                this.setVideoSurfaceInternal(null, true);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            } else {
                this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
                this.maybeNotifySurfaceSizeChanged(textureView.getWidth(), textureView.getHeight());
            }
        }
    }

    public void clearVideoTextureView(TextureView textureView) {
        if (textureView != null && textureView == this.textureView) {
            this.setVideoTextureView(null);
        }
    }

    public void addAudioListener(aj aj2) {
        this.audioListeners.add(aj2);
    }

    public void removeAudioListener(aj aj2) {
        this.audioListeners.remove(aj2);
    }

    public void setAudioAttributes(ah ah2) {
        if (nw.a(this.audioAttributes, (Object)ah2)) {
            return;
        }
        this.audioAttributes = ah2;
        for (x x2 : this.renderers) {
            if (x2.getTrackType() != 1) continue;
            this.player.createMessage(x2).a(3).a(ah2).i();
        }
        for (aj aj2 : this.audioListeners) {
            aj2.a(ah2);
        }
    }

    public ah getAudioAttributes() {
        return this.audioAttributes;
    }

    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public void setVolume(float f2) {
        if (this.audioVolume == (f2 = nw.a(f2, 0.0f, 1.0f))) {
            return;
        }
        this.audioVolume = f2;
        for (x x2 : this.renderers) {
            if (x2.getTrackType() != 1) continue;
            this.player.createMessage(x2).a(2).a(Float.valueOf(f2)).i();
        }
        for (aj aj2 : this.audioListeners) {
            aj2.a(f2);
        }
    }

    public float getVolume() {
        return this.audioVolume;
    }

    @Deprecated
    public void setAudioStreamType(int n2) {
        int n3 = nw.e(n2);
        int n4 = nw.f(n2);
        ah ah2 = new ah.a().b(n3).a(n4).a();
        this.setAudioAttributes(ah2);
    }

    @Deprecated
    public int getAudioStreamType() {
        return nw.g(this.audioAttributes.d);
    }

    public ae getAnalyticsCollector() {
        return this.analyticsCollector;
    }

    public void addAnalyticsListener(af af2) {
        this.analyticsCollector.a(af2);
    }

    public void removeAnalyticsListener(af af2) {
        this.analyticsCollector.b(af2);
    }

    @Deprecated
    @TargetApi(value=23)
    public void setPlaybackParams(@Nullable PlaybackParams playbackParams) {
        t t2;
        if (playbackParams != null) {
            playbackParams.allowDefaults();
            t2 = new t(playbackParams.getSpeed(), playbackParams.getPitch());
        } else {
            t2 = null;
        }
        this.setPlaybackParameters(t2);
    }

    public k getVideoFormat() {
        return this.videoFormat;
    }

    public k getAudioFormat() {
        return this.audioFormat;
    }

    public bc getVideoDecoderCounters() {
        return this.videoDecoderCounters;
    }

    public bc getAudioDecoderCounters() {
        return this.audioDecoderCounters;
    }

    public void addVideoListener(oe oe2) {
        this.videoListeners.add(oe2);
    }

    public void removeVideoListener(oe oe2) {
        this.videoListeners.remove(oe2);
    }

    @Deprecated
    public void setVideoListener(b b2) {
        this.videoListeners.clear();
        if (b2 != null) {
            this.addVideoListener(b2);
        }
    }

    @Deprecated
    public void clearVideoListener(b b2) {
        this.removeVideoListener(b2);
    }

    public void addTextOutput(kg kg2) {
        if (!this.currentCues.isEmpty()) {
            kg2.a(this.currentCues);
        }
        this.textOutputs.add(kg2);
    }

    public void removeTextOutput(kg kg2) {
        this.textOutputs.remove(kg2);
    }

    @Deprecated
    public void setTextOutput(kg kg2) {
        this.textOutputs.clear();
        if (kg2 != null) {
            this.addTextOutput(kg2);
        }
    }

    @Deprecated
    public void clearTextOutput(kg kg2) {
        this.removeTextOutput(kg2);
    }

    public void addMetadataOutput(fp fp2) {
        this.metadataOutputs.add(fp2);
    }

    public void removeMetadataOutput(fp fp2) {
        this.metadataOutputs.remove(fp2);
    }

    @Deprecated
    public void setMetadataOutput(fp fp2) {
        this.metadataOutputs.retainAll(Collections.singleton(this.analyticsCollector));
        if (fp2 != null) {
            this.addMetadataOutput(fp2);
        }
    }

    @Deprecated
    public void clearMetadataOutput(fp fp2) {
        this.removeMetadataOutput(fp2);
    }

    @Deprecated
    public void setVideoDebugListener(of of2) {
        this.videoDebugListeners.retainAll(Collections.singleton(this.analyticsCollector));
        if (of2 != null) {
            this.addVideoDebugListener(of2);
        }
    }

    @Deprecated
    public void addVideoDebugListener(of of2) {
        this.videoDebugListeners.add(of2);
    }

    @Deprecated
    public void removeVideoDebugListener(of of2) {
        this.videoDebugListeners.remove(of2);
    }

    @Deprecated
    public void setAudioDebugListener(al al2) {
        this.audioDebugListeners.retainAll(Collections.singleton(this.analyticsCollector));
        if (al2 != null) {
            this.addAudioDebugListener(al2);
        }
    }

    @Deprecated
    public void addAudioDebugListener(al al2) {
        this.audioDebugListeners.add(al2);
    }

    @Deprecated
    public void removeAudioDebugListener(al al2) {
        this.audioDebugListeners.remove(al2);
    }

    @Override
    public Looper getPlaybackLooper() {
        return this.player.getPlaybackLooper();
    }

    @Override
    public Looper getApplicationLooper() {
        return this.player.getApplicationLooper();
    }

    @Override
    public void addListener(u.c c2) {
        this.player.addListener(c2);
    }

    @Override
    public void removeListener(u.c c2) {
        this.player.removeListener(c2);
    }

    @Override
    public int getPlaybackState() {
        return this.player.getPlaybackState();
    }

    @Override
    public f getPlaybackError() {
        return this.player.getPlaybackError();
    }

    public void prepare(gy gy2) {
        this.prepare(gy2, true, true);
    }

    @Override
    public void prepare(gy gy2, boolean bl2, boolean bl3) {
        if (this.mediaSource != gy2) {
            if (this.mediaSource != null) {
                this.mediaSource.a(this.analyticsCollector);
                this.analyticsCollector.b();
            }
            gy2.a(this.eventHandler, this.analyticsCollector);
            this.mediaSource = gy2;
        }
        this.player.prepare(gy2, bl2, bl3);
    }

    @Override
    public void setPlayWhenReady(boolean bl2) {
        this.player.setPlayWhenReady(bl2);
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.player.getPlayWhenReady();
    }

    @Override
    public int getRepeatMode() {
        return this.player.getRepeatMode();
    }

    @Override
    public void setRepeatMode(int n2) {
        this.player.setRepeatMode(n2);
    }

    @Override
    public void setShuffleModeEnabled(boolean bl2) {
        this.player.setShuffleModeEnabled(bl2);
    }

    @Override
    public boolean getShuffleModeEnabled() {
        return this.player.getShuffleModeEnabled();
    }

    @Override
    public boolean isLoading() {
        return this.player.isLoading();
    }

    @Override
    public void seekToDefaultPosition() {
        this.analyticsCollector.a();
        this.player.seekToDefaultPosition();
    }

    @Override
    public void seekToDefaultPosition(int n2) {
        this.analyticsCollector.a();
        this.player.seekToDefaultPosition(n2);
    }

    @Override
    public void seekTo(long l2) {
        this.analyticsCollector.a();
        this.player.seekTo(l2);
    }

    @Override
    public void seekTo(int n2, long l2) {
        this.analyticsCollector.a();
        this.player.seekTo(n2, l2);
    }

    @Override
    public void setPlaybackParameters(@Nullable t t2) {
        this.player.setPlaybackParameters(t2);
    }

    @Override
    public t getPlaybackParameters() {
        return this.player.getPlaybackParameters();
    }

    @Override
    public void setSeekParameters(@Nullable ab ab2) {
        this.player.setSeekParameters(ab2);
    }

    @Override
    public ab getSeekParameters() {
        return this.player.getSeekParameters();
    }

    @Override
    @Nullable
    public Object getCurrentTag() {
        return this.player.getCurrentTag();
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    @Override
    public void stop(boolean bl2) {
        this.player.stop(bl2);
        if (this.mediaSource != null) {
            this.mediaSource.a(this.analyticsCollector);
            this.mediaSource = null;
            this.analyticsCollector.b();
        }
        this.currentCues = Collections.emptyList();
    }

    @Override
    public void release() {
        this.player.release();
        this.removeSurfaceCallbacks();
        if (this.surface != null) {
            if (this.ownsSurface) {
                this.surface.release();
            }
            this.surface = null;
        }
        if (this.mediaSource != null) {
            this.mediaSource.a(this.analyticsCollector);
        }
        this.currentCues = Collections.emptyList();
    }

    @Override
    public void sendMessages(g.a ... aArray) {
        this.player.sendMessages(aArray);
    }

    @Override
    public w createMessage(w.b b2) {
        return this.player.createMessage(b2);
    }

    @Override
    public void blockingSendMessages(g.a ... aArray) {
        this.player.blockingSendMessages(aArray);
    }

    @Override
    public int getRendererCount() {
        return this.player.getRendererCount();
    }

    @Override
    public int getRendererType(int n2) {
        return this.player.getRendererType(n2);
    }

    @Override
    public hp getCurrentTrackGroups() {
        return this.player.getCurrentTrackGroups();
    }

    @Override
    public lt getCurrentTrackSelections() {
        return this.player.getCurrentTrackSelections();
    }

    @Override
    public ad getCurrentTimeline() {
        return this.player.getCurrentTimeline();
    }

    @Override
    public Object getCurrentManifest() {
        return this.player.getCurrentManifest();
    }

    @Override
    public int getCurrentPeriodIndex() {
        return this.player.getCurrentPeriodIndex();
    }

    @Override
    public int getCurrentWindowIndex() {
        return this.player.getCurrentWindowIndex();
    }

    @Override
    public int getNextWindowIndex() {
        return this.player.getNextWindowIndex();
    }

    @Override
    public int getPreviousWindowIndex() {
        return this.player.getPreviousWindowIndex();
    }

    @Override
    public long getDuration() {
        return this.player.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.player.getCurrentPosition();
    }

    @Override
    public long getBufferedPosition() {
        return this.player.getBufferedPosition();
    }

    @Override
    public int getBufferedPercentage() {
        return this.player.getBufferedPercentage();
    }

    @Override
    public long getTotalBufferedDuration() {
        return this.player.getTotalBufferedDuration();
    }

    @Override
    public boolean isCurrentWindowDynamic() {
        return this.player.isCurrentWindowDynamic();
    }

    @Override
    public boolean isCurrentWindowSeekable() {
        return this.player.isCurrentWindowSeekable();
    }

    @Override
    public boolean isPlayingAd() {
        return this.player.isPlayingAd();
    }

    @Override
    public int getCurrentAdGroupIndex() {
        return this.player.getCurrentAdGroupIndex();
    }

    @Override
    public int getCurrentAdIndexInAdGroup() {
        return this.player.getCurrentAdIndexInAdGroup();
    }

    @Override
    public long getContentPosition() {
        return this.player.getContentPosition();
    }

    @Override
    public long getContentBufferedPosition() {
        return this.player.getContentBufferedPosition();
    }

    protected g createExoPlayerImpl(x[] xArray, lu lu2, n n2, my my2, Looper looper) {
        return new h(xArray, lu2, n2, my2, looper);
    }

    private void removeSurfaceCallbacks() {
        if (this.textureView != null) {
            if (this.textureView.getSurfaceTextureListener() != this.componentListener) {
                Log.w((String)TAG, (String)"SurfaceTextureListener already unset or replaced.");
            } else {
                this.textureView.setSurfaceTextureListener(null);
            }
            this.textureView = null;
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this.componentListener);
            this.surfaceHolder = null;
        }
    }

    private void setVideoSurfaceInternal(Surface surface, boolean bl2) {
        ArrayList<w> arrayList = new ArrayList<w>();
        for (x x2 : this.renderers) {
            if (x2.getTrackType() != 2) continue;
            arrayList.add(this.player.createMessage(x2).a(1).a(surface).i());
        }
        if (this.surface != null && this.surface != surface) {
            try {
                for (w w2 : arrayList) {
                    w2.k();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (this.ownsSurface) {
                this.surface.release();
            }
        }
        this.surface = surface;
        this.ownsSurface = bl2;
    }

    private void maybeNotifySurfaceSizeChanged(int n2, int n3) {
        if (n2 != this.surfaceWidth || n3 != this.surfaceHeight) {
            this.surfaceWidth = n2;
            this.surfaceHeight = n3;
            for (oe oe2 : this.videoListeners) {
                oe2.a(n2, n3);
            }
        }
    }

    private final class a
    implements SurfaceHolder.Callback,
    TextureView.SurfaceTextureListener,
    al,
    fp,
    kg,
    of {
        private a() {
        }

        @Override
        public void a(bc bc2) {
            ac.this.videoDecoderCounters = bc2;
            for (of of2 : ac.this.videoDebugListeners) {
                of2.a(bc2);
            }
        }

        @Override
        public void a(String string, long l2, long l3) {
            for (of of2 : ac.this.videoDebugListeners) {
                of2.a(string, l2, l3);
            }
        }

        @Override
        public void a(k k2) {
            ac.this.videoFormat = k2;
            for (of of2 : ac.this.videoDebugListeners) {
                of2.a(k2);
            }
        }

        @Override
        public void a(int n2, long l2) {
            for (of of2 : ac.this.videoDebugListeners) {
                of2.a(n2, l2);
            }
        }

        @Override
        public void a(int n2, int n3, int n4, float f2) {
            for (Object object : ac.this.videoListeners) {
                if (ac.this.videoDebugListeners.contains(object)) continue;
                object.a(n2, n3, n4, f2);
            }
            for (Object object : ac.this.videoDebugListeners) {
                object.a(n2, n3, n4, f2);
            }
        }

        @Override
        public void a(Surface surface) {
            if (ac.this.surface == surface) {
                for (Object object : ac.this.videoListeners) {
                    object.c();
                }
            }
            for (Object object : ac.this.videoDebugListeners) {
                object.a(surface);
            }
        }

        @Override
        public void b(bc bc2) {
            for (of of2 : ac.this.videoDebugListeners) {
                of2.b(bc2);
            }
            ac.this.videoFormat = null;
            ac.this.videoDecoderCounters = null;
        }

        @Override
        public void c(bc bc2) {
            ac.this.audioDecoderCounters = bc2;
            for (al al2 : ac.this.audioDebugListeners) {
                al2.c(bc2);
            }
        }

        @Override
        public void a(int n2) {
            if (ac.this.audioSessionId == n2) {
                return;
            }
            ac.this.audioSessionId = n2;
            for (Object object : ac.this.audioListeners) {
                if (ac.this.audioDebugListeners.contains(object)) continue;
                object.a(n2);
            }
            for (Object object : ac.this.audioDebugListeners) {
                object.a(n2);
            }
        }

        @Override
        public void b(String string, long l2, long l3) {
            for (al al2 : ac.this.audioDebugListeners) {
                al2.b(string, l2, l3);
            }
        }

        @Override
        public void b(k k2) {
            ac.this.audioFormat = k2;
            for (al al2 : ac.this.audioDebugListeners) {
                al2.b(k2);
            }
        }

        @Override
        public void a(int n2, long l2, long l3) {
            for (al al2 : ac.this.audioDebugListeners) {
                al2.a(n2, l2, l3);
            }
        }

        @Override
        public void d(bc bc2) {
            for (al al2 : ac.this.audioDebugListeners) {
                al2.d(bc2);
            }
            ac.this.audioFormat = null;
            ac.this.audioDecoderCounters = null;
            ac.this.audioSessionId = 0;
        }

        @Override
        public void a(List<jx> list) {
            ac.this.currentCues = list;
            for (kg kg2 : ac.this.textOutputs) {
                kg2.a(list);
            }
        }

        @Override
        public void a(fk fk2) {
            for (fp fp2 : ac.this.metadataOutputs) {
                fp2.a(fk2);
            }
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            ac.this.setVideoSurfaceInternal(surfaceHolder.getSurface(), false);
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
            ac.this.maybeNotifySurfaceSizeChanged(n3, n4);
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            ac.this.setVideoSurfaceInternal(null, false);
            ac.this.maybeNotifySurfaceSizeChanged(0, 0);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
            ac.this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
            ac.this.maybeNotifySurfaceSizeChanged(n2, n3);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
            ac.this.maybeNotifySurfaceSizeChanged(n2, n3);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            ac.this.setVideoSurfaceInternal(null, true);
            ac.this.maybeNotifySurfaceSizeChanged(0, 0);
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }

    @Deprecated
    public static interface b
    extends oe {
    }
}

