/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import android.opengl.Matrix;
import com.google.vr.libraries.video.MotionCoordinateSystem;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.Vector;

public class FrameRotationBuffer {
    private static final String TAG = "FrameRotationBuffer";
    private final float[] deviceTransform = new float[16];
    private final float[] recenterTransform = new float[16];
    private final float[] outputTransform = new float[16];
    private final float[] tempTransform = new float[16];
    private final NavigableMap<Long, Vector<Float>> rotations = new TreeMap<Long, Vector<Float>>();
    private final MotionCoordinateSystem coordinateSystem;

    public FrameRotationBuffer(MotionCoordinateSystem motionCoordinateSystem) {
        this.coordinateSystem = motionCoordinateSystem;
        Matrix.setIdentityM((float[])this.outputTransform, (int)0);
        Matrix.setIdentityM((float[])this.recenterTransform, (int)0);
    }

    public synchronized void setRotation(long l2, float[] fArray) {
        Vector<Float> vector = new Vector<Float>();
        this.transformRotationForOutputCoordinateSystem(fArray, vector);
        if (this.rotations.size() == 0) {
            this.computeRecenterTransform(vector);
        }
        this.rotations.put(l2, vector);
    }

    public synchronized float[] getTransform(long l2) {
        Map.Entry<Long, Vector<Float>> entry = this.rotations.floorEntry(l2);
        if (entry == null) {
            return this.outputTransform;
        }
        this.rotations.headMap(entry.getKey()).clear();
        FrameRotationBuffer.angleAxisToMatrix(entry.getValue(), this.deviceTransform);
        Matrix.multiplyMM((float[])this.outputTransform, (int)0, (float[])this.recenterTransform, (int)0, (float[])this.deviceTransform, (int)0);
        return this.outputTransform;
    }

    private void transformRotationForOutputCoordinateSystem(float[] fArray, Vector<Float> vector) {
        switch (this.coordinateSystem) {
            case FLIP_XY: {
                vector.add(Float.valueOf(-fArray[0]));
                vector.add(Float.valueOf(-fArray[1]));
                vector.add(Float.valueOf(fArray[2]));
                break;
            }
            case FLIP_YZ: {
                vector.add(Float.valueOf(fArray[0]));
                vector.add(Float.valueOf(-fArray[1]));
                vector.add(Float.valueOf(-fArray[2]));
            }
        }
    }

    private void computeRecenterTransform(Vector<Float> vector) {
        FrameRotationBuffer.angleAxisToMatrix(vector, this.tempTransform);
        Matrix.setIdentityM((float[])this.recenterTransform, (int)0);
        float f2 = (float)Math.sqrt(this.tempTransform[10] * this.tempTransform[10] + this.tempTransform[8] * this.tempTransform[8]);
        this.recenterTransform[0] = this.tempTransform[10] / f2;
        this.recenterTransform[2] = this.tempTransform[8] / f2;
        this.recenterTransform[8] = -this.tempTransform[8] / f2;
        this.recenterTransform[10] = this.tempTransform[10] / f2;
    }

    private static void angleAxisToMatrix(Vector<Float> vector, float[] fArray) {
        float f2;
        float f3;
        float f4 = vector.get(0).floatValue();
        float f5 = Matrix.length((float)f4, (float)(f3 = vector.get(1).floatValue()), (float)(f2 = vector.get(2).floatValue()));
        if (f5 != 0.0f) {
            float f6 = (float)Math.toDegrees(f5);
            Matrix.setRotateM((float[])fArray, (int)0, (float)f6, (float)(f4 / f5), (float)(f3 / f5), (float)(f2 / f5));
        } else {
            Matrix.setIdentityM((float[])fArray, (int)0);
        }
    }
}

