/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import com.google.vr.libraries.video.FrameRotationBuffer;
import com.google.vr.libraries.video.MotionCoordinateSystem;
import com.google.vr.sdk.widgets.video.deps.a;
import com.google.vr.sdk.widgets.video.deps.bd;
import com.google.vr.sdk.widgets.video.deps.f;
import com.google.vr.sdk.widgets.video.deps.k;
import com.google.vr.sdk.widgets.video.deps.l;
import com.google.vr.sdk.widgets.video.deps.nm;
import java.io.IOException;

public class CameraMotionMetadataRendererV2
extends a {
    private static final int SAMPLE_WINDOW_DURATION_US = 100000;
    private final l formatHolder = new l();
    private final bd buffer = new bd(1);
    private final MotionCoordinateSystem coordinateSystem;
    private volatile FrameRotationBuffer frameRotationBuffer;

    public CameraMotionMetadataRendererV2(MotionCoordinateSystem motionCoordinateSystem) {
        super(4);
        this.coordinateSystem = motionCoordinateSystem;
    }

    public FrameRotationBuffer getFrameRotationBuffer() {
        return this.frameRotationBuffer;
    }

    @Override
    protected void onDisabled() {
        this.frameRotationBuffer = null;
    }

    @Override
    public int supportsFormat(k k2) {
        return k2.g.equals("application/x-camera-motion") ? 4 : 0;
    }

    @Override
    public void render(long l2, long l3) throws f {
        if (this.frameRotationBuffer == null) {
            this.frameRotationBuffer = new FrameRotationBuffer(this.coordinateSystem);
        }
        while (!this.hasReadStreamToEnd()) {
            this.buffer.a();
            int n2 = this.readSource(this.formatHolder, this.buffer, false);
            if (n2 != -4 || this.buffer.c()) {
                return;
            }
            try {
                this.buffer.h();
                float[] fArray = CameraMotionMetadataRendererV2.parseMetadata(this.buffer.b.array(), this.buffer.b.limit());
                if (fArray != null) {
                    this.frameRotationBuffer.setRotation(this.buffer.c, fArray);
                }
            }
            catch (IOException iOException) {
                throw f.a(iOException, this.getIndex());
            }
            if (this.buffer.c <= l2 + 100000L) continue;
            return;
        }
    }

    @Override
    public boolean isEnded() {
        return this.hasReadStreamToEnd();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    private static float[] parseMetadata(byte[] byArray, int n2) throws IOException {
        nm nm2 = new nm(byArray, n2);
        if (nm2.p() != 0) {
            return null;
        }
        float[] fArray = new float[]{Float.intBitsToFloat(nm2.p()), Float.intBitsToFloat(nm2.p()), Float.intBitsToFloat(nm2.p())};
        return fArray;
    }
}

