/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.vr.sdk.widgets.video.deps.ba;
import com.google.vr.sdk.widgets.video.deps.bb;
import com.google.vr.sdk.widgets.video.deps.bj;
import com.google.vr.sdk.widgets.video.deps.bk;
import com.google.vr.sdk.widgets.video.deps.bo;
import com.google.vr.sdk.widgets.video.deps.ew;
import com.google.vr.sdk.widgets.video.deps.ey;
import com.google.vr.sdk.widgets.video.deps.ez;
import com.google.vr.sdk.widgets.video.deps.f;
import com.google.vr.sdk.widgets.video.deps.k;
import com.google.vr.sdk.widgets.video.deps.l;
import com.google.vr.sdk.widgets.video.deps.lw;
import com.google.vr.sdk.widgets.video.deps.mh;
import com.google.vr.sdk.widgets.video.deps.mr;
import com.google.vr.sdk.widgets.video.deps.mt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=16)
public abstract class ex
extends com.google.vr.sdk.widgets.video.deps.a {
    private static final String TAG = "MediaCodecRenderer";
    private static final long MAX_CODEC_HOTSWAP_TIME_MS = 1000L;
    protected static final int KEEP_CODEC_RESULT_NO = 0;
    protected static final int KEEP_CODEC_RESULT_YES_WITHOUT_RECONFIGURATION = 1;
    protected static final int KEEP_CODEC_RESULT_YES_WITH_RECONFIGURATION = 3;
    private static final int RECONFIGURATION_STATE_NONE = 0;
    private static final int RECONFIGURATION_STATE_WRITE_PENDING = 1;
    private static final int RECONFIGURATION_STATE_QUEUE_PENDING = 2;
    private static final int REINITIALIZATION_STATE_NONE = 0;
    private static final int REINITIALIZATION_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int REINITIALIZATION_STATE_WAIT_END_OF_STREAM = 2;
    private static final int ADAPTATION_WORKAROUND_MODE_NEVER = 0;
    private static final int ADAPTATION_WORKAROUND_MODE_SAME_RESOLUTION = 1;
    private static final int ADAPTATION_WORKAROUND_MODE_ALWAYS = 2;
    private static final byte[] ADAPTATION_WORKAROUND_BUFFER = mt.i("0000016742C00BDA259000000168CE0F13200000016588840DCE7118A0002FBF1C31C3275D78");
    private static final int ADAPTATION_WORKAROUND_SLICE_WIDTH_HEIGHT = 32;
    private final ey mediaCodecSelector;
    @Nullable
    private final bk<bo> drmSessionManager;
    private final boolean playClearSamplesWithoutKeys;
    private final bb buffer;
    private final bb flagsOnlyBuffer;
    private final l formatHolder;
    private final List<Long> decodeOnlyPresentationTimestamps;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private k format;
    private bj<bo> drmSession;
    private bj<bo> pendingDrmSession;
    private MediaCodec codec;
    private ew codecInfo;
    private int codecAdaptationWorkaroundMode;
    private boolean codecNeedsDiscardToSpsWorkaround;
    private boolean codecNeedsFlushWorkaround;
    private boolean codecNeedsEosPropagationWorkaround;
    private boolean codecNeedsEosFlushWorkaround;
    private boolean codecNeedsEosOutputExceptionWorkaround;
    private boolean codecNeedsMonoChannelCountWorkaround;
    private boolean codecNeedsAdaptationWorkaroundBuffer;
    private boolean shouldSkipAdaptationWorkaroundOutputBuffer;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private long codecHotswapDeadlineMs;
    private int inputIndex;
    private int outputIndex;
    private ByteBuffer outputBuffer;
    private boolean shouldSkipOutputBuffer;
    private boolean codecReconfigured;
    private int codecReconfigurationState;
    private int codecReinitializationState;
    private boolean codecReceivedBuffers;
    private boolean codecReceivedEos;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private boolean waitingForKeys;
    private boolean waitingForFirstSyncFrame;
    protected ba decoderCounters;

    public ex(int n2, ey ey2, @Nullable bk<bo> bk2, boolean bl2) {
        super(n2);
        lw.b(mt.a >= 16);
        this.mediaCodecSelector = lw.a(ey2);
        this.drmSessionManager = bk2;
        this.playClearSamplesWithoutKeys = bl2;
        this.buffer = new bb(0);
        this.flagsOnlyBuffer = bb.e();
        this.formatHolder = new l();
        this.decodeOnlyPresentationTimestamps = new ArrayList<Long>();
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
    }

    @Override
    public final int supportsMixedMimeTypeAdaptation() {
        return 8;
    }

    @Override
    public final int supportsFormat(k k2) throws f {
        try {
            return this.supportsFormat(this.mediaCodecSelector, this.drmSessionManager, k2);
        }
        catch (ez.b b2) {
            throw f.a(b2, this.getIndex());
        }
    }

    protected abstract int supportsFormat(ey var1, bk<bo> var2, k var3) throws ez.b;

    protected ew getDecoderInfo(ey ey2, k k2, boolean bl2) throws ez.b {
        return ey2.a(k2.f, bl2);
    }

    protected abstract void configureCodec(ew var1, MediaCodec var2, k var3, MediaCrypto var4) throws ez.b;

    protected final void maybeInitCodec() throws f {
        Object object;
        if (this.codec != null || this.format == null) {
            return;
        }
        this.drmSession = this.pendingDrmSession;
        String string = this.format.f;
        MediaCrypto mediaCrypto = null;
        boolean bl2 = false;
        if (this.drmSession != null) {
            object = this.drmSession.g();
            if (object == null) {
                bj.a a2 = this.drmSession.f();
                if (a2 == null) {
                    return;
                }
            } else {
                mediaCrypto = ((bo)object).a();
                bl2 = ((bo)object).a(string);
            }
        }
        if (this.codecInfo == null) {
            try {
                this.codecInfo = this.getDecoderInfo(this.mediaCodecSelector, this.format, bl2);
                if (this.codecInfo == null && bl2) {
                    this.codecInfo = this.getDecoderInfo(this.mediaCodecSelector, this.format, false);
                    if (this.codecInfo != null) {
                        object = this.codecInfo.a;
                        Log.w((String)TAG, (String)new StringBuilder(99 + String.valueOf(string).length() + String.valueOf(object).length()).append("Drm session requires secure decoder for ").append(string).append(", but no secure decoder available. Trying to proceed with ").append((String)object).append(".").toString());
                    }
                }
            }
            catch (ez.b b2) {
                this.throwDecoderInitError(new a(this.format, (Throwable)b2, bl2, -49998));
            }
            if (this.codecInfo == null) {
                this.throwDecoderInitError(new a(this.format, null, bl2, -49999));
            }
        }
        if (!this.shouldInitCodec(this.codecInfo)) {
            return;
        }
        object = this.codecInfo.a;
        this.codecAdaptationWorkaroundMode = this.codecAdaptationWorkaroundMode((String)object);
        this.codecNeedsDiscardToSpsWorkaround = ex.codecNeedsDiscardToSpsWorkaround((String)object, this.format);
        this.codecNeedsFlushWorkaround = ex.codecNeedsFlushWorkaround((String)object);
        this.codecNeedsEosPropagationWorkaround = ex.codecNeedsEosPropagationWorkaround((String)object);
        this.codecNeedsEosFlushWorkaround = ex.codecNeedsEosFlushWorkaround((String)object);
        this.codecNeedsEosOutputExceptionWorkaround = ex.codecNeedsEosOutputExceptionWorkaround((String)object);
        this.codecNeedsMonoChannelCountWorkaround = ex.codecNeedsMonoChannelCountWorkaround((String)object, this.format);
        try {
            long l2 = SystemClock.elapsedRealtime();
            String string2 = String.valueOf(object);
            mr.a(string2.length() != 0 ? "createCodec:".concat(string2) : new String("createCodec:"));
            this.codec = MediaCodec.createByCodecName((String)object);
            mr.a();
            mr.a("configureCodec");
            this.configureCodec(this.codecInfo, this.codec, this.format, mediaCrypto);
            mr.a();
            mr.a("startCodec");
            this.codec.start();
            mr.a();
            long l3 = SystemClock.elapsedRealtime();
            this.onCodecInitialized((String)object, l3, l3 - l2);
            this.getCodecBuffers();
        }
        catch (Exception exception) {
            this.throwDecoderInitError(new a(this.format, (Throwable)exception, bl2, (String)object));
        }
        this.codecHotswapDeadlineMs = this.getState() == 2 ? SystemClock.elapsedRealtime() + 1000L : -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForFirstSyncFrame = true;
        ++this.decoderCounters.a;
    }

    private void throwDecoderInitError(a a2) throws f {
        throw f.a(a2, this.getIndex());
    }

    protected boolean shouldInitCodec(ew ew2) {
        return true;
    }

    protected final MediaCodec getCodec() {
        return this.codec;
    }

    protected final ew getCodecInfo() {
        return this.codecInfo;
    }

    @Override
    protected void onEnabled(boolean bl2) throws f {
        this.decoderCounters = new ba();
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) throws f {
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        if (this.codec != null) {
            this.flushCodec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDisabled() {
        this.format = null;
        try {
            this.releaseCodec();
        }
        finally {
            try {
                if (this.drmSession != null) {
                    this.drmSessionManager.a(this.drmSession);
                }
            }
            finally {
                try {
                    if (this.pendingDrmSession != null && this.pendingDrmSession != this.drmSession) {
                        this.drmSessionManager.a(this.pendingDrmSession);
                    }
                }
                finally {
                    this.drmSession = null;
                    this.pendingDrmSession = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseCodec() {
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForKeys = false;
        this.shouldSkipOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.resetCodecBuffers();
        this.codecInfo = null;
        this.codecReconfigured = false;
        this.codecReceivedBuffers = false;
        this.codecNeedsDiscardToSpsWorkaround = false;
        this.codecNeedsFlushWorkaround = false;
        this.codecAdaptationWorkaroundMode = 0;
        this.codecNeedsEosPropagationWorkaround = false;
        this.codecNeedsEosFlushWorkaround = false;
        this.codecNeedsMonoChannelCountWorkaround = false;
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        this.codecReceivedEos = false;
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
        if (this.codec != null) {
            ++this.decoderCounters.b;
            try {
                this.codec.stop();
            }
            finally {
                try {
                    this.codec.release();
                }
                finally {
                    this.codec = null;
                    if (this.drmSession != null && this.pendingDrmSession != this.drmSession) {
                        try {
                            this.drmSessionManager.a(this.drmSession);
                        }
                        finally {
                            this.drmSession = null;
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void onStarted() {
    }

    @Override
    protected void onStopped() {
    }

    @Override
    public void render(long l2, long l3) throws f {
        int n2;
        if (this.outputStreamEnded) {
            this.renderToEndOfStream();
            return;
        }
        if (this.format == null) {
            this.flagsOnlyBuffer.a();
            n2 = this.readSource(this.formatHolder, this.flagsOnlyBuffer, true);
            if (n2 == -5) {
                this.onInputFormatChanged(this.formatHolder.a);
            } else {
                if (n2 == -4) {
                    lw.b(this.flagsOnlyBuffer.c());
                    this.inputStreamEnded = true;
                    this.processEndOfStream();
                    return;
                }
                return;
            }
        }
        this.maybeInitCodec();
        if (this.codec != null) {
            mr.a("drainAndFeed");
            while (this.drainOutputBuffer(l2, l3)) {
            }
            while (this.feedInputBuffer()) {
            }
            mr.a();
        } else {
            this.decoderCounters.d += this.skipSource(l2);
            this.flagsOnlyBuffer.a();
            n2 = this.readSource(this.formatHolder, this.flagsOnlyBuffer, false);
            if (n2 == -5) {
                this.onInputFormatChanged(this.formatHolder.a);
            } else if (n2 == -4) {
                lw.b(this.flagsOnlyBuffer.c());
                this.inputStreamEnded = true;
                this.processEndOfStream();
            }
        }
        this.decoderCounters.a();
    }

    protected void flushCodec() throws f {
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForFirstSyncFrame = true;
        this.waitingForKeys = false;
        this.shouldSkipOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        if (this.codecNeedsFlushWorkaround || this.codecNeedsEosFlushWorkaround && this.codecReceivedEos) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else if (this.codecReinitializationState != 0) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.codec.flush();
            this.codecReceivedBuffers = false;
        }
        if (this.codecReconfigured && this.format != null) {
            this.codecReconfigurationState = 1;
        }
    }

    private boolean feedInputBuffer() throws f {
        int n2;
        int n3;
        if (this.codec == null || this.codecReinitializationState == 2 || this.inputStreamEnded) {
            return false;
        }
        if (this.inputIndex < 0) {
            this.inputIndex = this.codec.dequeueInputBuffer(0L);
            if (this.inputIndex < 0) {
                return false;
            }
            this.buffer.b = this.getInputBuffer(this.inputIndex);
            this.buffer.a();
        }
        if (this.codecReinitializationState == 1) {
            if (!this.codecNeedsEosPropagationWorkaround) {
                this.codecReceivedEos = true;
                this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                this.resetInputBuffer();
            }
            this.codecReinitializationState = 2;
            return false;
        }
        if (this.codecNeedsAdaptationWorkaroundBuffer) {
            this.codecNeedsAdaptationWorkaroundBuffer = false;
            this.buffer.b.put(ADAPTATION_WORKAROUND_BUFFER);
            this.codec.queueInputBuffer(this.inputIndex, 0, ADAPTATION_WORKAROUND_BUFFER.length, 0L, 0);
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            return true;
        }
        int n4 = 0;
        if (this.waitingForKeys) {
            n3 = -4;
        } else {
            if (this.codecReconfigurationState == 1) {
                for (n2 = 0; n2 < this.format.h.size(); n2 += 1) {
                    byte[] byArray = this.format.h.get(n2);
                    this.buffer.b.put(byArray);
                }
                this.codecReconfigurationState = 2;
            }
            n4 = this.buffer.b.position();
            n3 = this.readSource(this.formatHolder, this.buffer, false);
        }
        if (n3 == -3) {
            return false;
        }
        if (n3 == -5) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.a();
                this.codecReconfigurationState = 1;
            }
            this.onInputFormatChanged(this.formatHolder.a);
            return true;
        }
        if (this.buffer.c()) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.a();
                this.codecReconfigurationState = 1;
            }
            this.inputStreamEnded = true;
            if (!this.codecReceivedBuffers) {
                this.processEndOfStream();
                return false;
            }
            try {
                if (!this.codecNeedsEosPropagationWorkaround) {
                    this.codecReceivedEos = true;
                    this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                    this.resetInputBuffer();
                }
            }
            catch (MediaCodec.CryptoException cryptoException) {
                throw f.a((Exception)((Object)cryptoException), this.getIndex());
            }
            return false;
        }
        if (this.waitingForFirstSyncFrame && !this.buffer.d()) {
            this.buffer.a();
            if (this.codecReconfigurationState == 2) {
                this.codecReconfigurationState = 1;
            }
            return true;
        }
        this.waitingForFirstSyncFrame = false;
        n2 = this.buffer.g() ? 1 : 0;
        this.waitingForKeys = this.shouldWaitForKeys(n2 != 0);
        if (this.waitingForKeys) {
            return false;
        }
        if (this.codecNeedsDiscardToSpsWorkaround && !n2) {
            mh.a(this.buffer.b);
            if (this.buffer.b.position() == 0) {
                return true;
            }
            this.codecNeedsDiscardToSpsWorkaround = false;
        }
        try {
            long l2 = this.buffer.c;
            if (this.buffer.b_()) {
                this.decodeOnlyPresentationTimestamps.add(l2);
            }
            this.buffer.h();
            this.onQueueInputBuffer(this.buffer);
            if (n2) {
                MediaCodec.CryptoInfo cryptoInfo = ex.getFrameworkCryptoInfo(this.buffer, n4);
                this.codec.queueSecureInputBuffer(this.inputIndex, 0, cryptoInfo, l2, 0);
            } else {
                this.codec.queueInputBuffer(this.inputIndex, 0, this.buffer.b.limit(), l2, 0);
            }
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            this.codecReconfigurationState = 0;
            ++this.decoderCounters.c;
        }
        catch (MediaCodec.CryptoException cryptoException) {
            throw f.a((Exception)((Object)cryptoException), this.getIndex());
        }
        return true;
    }

    private void getCodecBuffers() {
        if (mt.a < 21) {
            this.inputBuffers = this.codec.getInputBuffers();
            this.outputBuffers = this.codec.getOutputBuffers();
        }
    }

    private void resetCodecBuffers() {
        if (mt.a < 21) {
            this.inputBuffers = null;
            this.outputBuffers = null;
        }
    }

    private ByteBuffer getInputBuffer(int n2) {
        if (mt.a >= 21) {
            return this.codec.getInputBuffer(n2);
        }
        return this.inputBuffers[n2];
    }

    private ByteBuffer getOutputBuffer(int n2) {
        if (mt.a >= 21) {
            return this.codec.getOutputBuffer(n2);
        }
        return this.outputBuffers[n2];
    }

    private boolean hasOutputBuffer() {
        return this.outputIndex >= 0;
    }

    private void resetInputBuffer() {
        this.inputIndex = -1;
        this.buffer.b = null;
    }

    private void resetOutputBuffer() {
        this.outputIndex = -1;
        this.outputBuffer = null;
    }

    private static MediaCodec.CryptoInfo getFrameworkCryptoInfo(bb bb2, int n2) {
        MediaCodec.CryptoInfo cryptoInfo = bb2.a.a();
        if (n2 == 0) {
            return cryptoInfo;
        }
        if (cryptoInfo.numBytesOfClearData == null) {
            cryptoInfo.numBytesOfClearData = new int[1];
        }
        cryptoInfo.numBytesOfClearData[0] = cryptoInfo.numBytesOfClearData[0] + n2;
        return cryptoInfo;
    }

    private boolean shouldWaitForKeys(boolean bl2) throws f {
        if (this.drmSession == null || !bl2 && this.playClearSamplesWithoutKeys) {
            return false;
        }
        int n2 = this.drmSession.e();
        if (n2 == 1) {
            throw f.a(this.drmSession.f(), this.getIndex());
        }
        return n2 != 4;
    }

    protected void onCodecInitialized(String string, long l2, long l3) {
    }

    protected void onInputFormatChanged(k k2) throws f {
        boolean bl2;
        k k3 = this.format;
        this.format = k2;
        boolean bl3 = bl2 = !mt.a(this.format.i, (Object)(k3 == null ? null : k3.i));
        if (bl2) {
            if (this.format.i != null) {
                if (this.drmSessionManager == null) {
                    throw f.a(new IllegalStateException("Media requires a DrmSessionManager"), this.getIndex());
                }
                this.pendingDrmSession = this.drmSessionManager.a(Looper.myLooper(), this.format.i);
                if (this.pendingDrmSession == this.drmSession) {
                    this.drmSessionManager.a(this.pendingDrmSession);
                }
            } else {
                this.pendingDrmSession = null;
            }
        }
        boolean bl4 = false;
        if (this.pendingDrmSession == this.drmSession && this.codec != null) {
            switch (this.canKeepCodec(this.codec, this.codecInfo, k3, this.format)) {
                case 0: {
                    break;
                }
                case 1: {
                    bl4 = true;
                    break;
                }
                case 3: {
                    bl4 = true;
                    this.codecReconfigured = true;
                    this.codecReconfigurationState = 1;
                    this.codecNeedsAdaptationWorkaroundBuffer = this.codecAdaptationWorkaroundMode == 2 || this.codecAdaptationWorkaroundMode == 1 && this.format.j == k3.j && this.format.k == k3.k;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (!bl4) {
            if (this.codecReceivedBuffers) {
                this.codecReinitializationState = 1;
            } else {
                this.releaseCodec();
                this.maybeInitCodec();
            }
        }
    }

    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) throws f {
    }

    protected void onQueueInputBuffer(bb bb2) {
    }

    protected void onProcessedOutputBuffer(long l2) {
    }

    protected int canKeepCodec(MediaCodec mediaCodec, ew ew2, k k2, k k3) {
        return 0;
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return this.format != null && !this.waitingForKeys && (this.isSourceReady() || this.hasOutputBuffer() || this.codecHotswapDeadlineMs != -9223372036854775807L && SystemClock.elapsedRealtime() < this.codecHotswapDeadlineMs);
    }

    protected long getDequeueOutputBufferTimeoutUs() {
        return 0L;
    }

    private boolean drainOutputBuffer(long l2, long l3) throws f {
        int n2;
        if (!this.hasOutputBuffer()) {
            if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
                try {
                    n2 = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
                }
                catch (IllegalStateException illegalStateException) {
                    this.processEndOfStream();
                    if (this.outputStreamEnded) {
                        this.releaseCodec();
                    }
                    return false;
                }
            } else {
                n2 = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
            }
            if (n2 >= 0) {
                if (this.shouldSkipAdaptationWorkaroundOutputBuffer) {
                    this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
                    this.codec.releaseOutputBuffer(n2, false);
                    return true;
                }
                if (this.outputBufferInfo.size == 0 && (this.outputBufferInfo.flags & 4) != 0) {
                    this.processEndOfStream();
                    return false;
                }
                this.outputIndex = n2;
                this.outputBuffer = this.getOutputBuffer(n2);
                if (this.outputBuffer != null) {
                    this.outputBuffer.position(this.outputBufferInfo.offset);
                    this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
                }
                this.shouldSkipOutputBuffer = this.shouldSkipOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            } else {
                if (n2 == -2) {
                    this.processOutputFormat();
                    return true;
                }
                if (n2 == -3) {
                    this.processOutputBuffersChanged();
                    return true;
                }
                if (this.codecNeedsEosPropagationWorkaround && (this.inputStreamEnded || this.codecReinitializationState == 2)) {
                    this.processEndOfStream();
                }
                return false;
            }
        }
        if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
            try {
                n2 = this.processOutputBuffer(l2, l3, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer) ? 1 : 0;
            }
            catch (IllegalStateException illegalStateException) {
                this.processEndOfStream();
                if (this.outputStreamEnded) {
                    this.releaseCodec();
                }
                return false;
            }
        } else {
            n2 = this.processOutputBuffer(l2, l3, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer) ? 1 : 0;
        }
        if (n2 != 0) {
            this.onProcessedOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            boolean bl2 = (this.outputBufferInfo.flags & 4) != 0;
            this.resetOutputBuffer();
            if (!bl2) {
                return true;
            }
            this.processEndOfStream();
        }
        return false;
    }

    private void processOutputFormat() throws f {
        MediaFormat mediaFormat = this.codec.getOutputFormat();
        if (this.codecAdaptationWorkaroundMode != 0 && mediaFormat.getInteger("width") == 32 && mediaFormat.getInteger("height") == 32) {
            this.shouldSkipAdaptationWorkaroundOutputBuffer = true;
            return;
        }
        if (this.codecNeedsMonoChannelCountWorkaround) {
            mediaFormat.setInteger("channel-count", 1);
        }
        this.onOutputFormatChanged(this.codec, mediaFormat);
    }

    private void processOutputBuffersChanged() {
        if (mt.a < 21) {
            this.outputBuffers = this.codec.getOutputBuffers();
        }
    }

    protected abstract boolean processOutputBuffer(long var1, long var3, MediaCodec var5, ByteBuffer var6, int var7, int var8, long var9, boolean var11) throws f;

    protected void renderToEndOfStream() throws f {
    }

    private void processEndOfStream() throws f {
        if (this.codecReinitializationState == 2) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.outputStreamEnded = true;
            this.renderToEndOfStream();
        }
    }

    private boolean shouldSkipOutputBuffer(long l2) {
        int n2 = this.decodeOnlyPresentationTimestamps.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.decodeOnlyPresentationTimestamps.get(i2) != l2) continue;
            this.decodeOnlyPresentationTimestamps.remove(i2);
            return true;
        }
        return false;
    }

    private static boolean codecNeedsFlushWorkaround(String string) {
        return mt.a < 18 || mt.a == 18 && ("OMX.SEC.avc.dec".equals(string) || "OMX.SEC.avc.dec.secure".equals(string)) || mt.a == 19 && mt.d.startsWith("SM-G800") && ("OMX.Exynos.avc.dec".equals(string) || "OMX.Exynos.avc.dec.secure".equals(string));
    }

    private int codecAdaptationWorkaroundMode(String string) {
        if (mt.a <= 25 && "OMX.Exynos.avc.dec.secure".equals(string) && (mt.d.startsWith("SM-T585") || mt.d.startsWith("SM-A510") || mt.d.startsWith("SM-A520") || mt.d.startsWith("SM-J700"))) {
            return 2;
        }
        if (mt.a < 24 && ("OMX.Nvidia.h264.decode".equals(string) || "OMX.Nvidia.h264.decode.secure".equals(string)) && ("flounder".equals(mt.b) || "flounder_lte".equals(mt.b) || "grouper".equals(mt.b) || "tilapia".equals(mt.b))) {
            return 1;
        }
        return 0;
    }

    private static boolean codecNeedsDiscardToSpsWorkaround(String string, k k2) {
        return mt.a < 21 && k2.h.isEmpty() && "OMX.MTK.VIDEO.DECODER.AVC".equals(string);
    }

    private static boolean codecNeedsEosPropagationWorkaround(String string) {
        return mt.a <= 17 && ("OMX.rk.video_decoder.avc".equals(string) || "OMX.allwinner.video.decoder.avc".equals(string));
    }

    private static boolean codecNeedsEosFlushWorkaround(String string) {
        return mt.a <= 23 && "OMX.google.vorbis.decoder".equals(string) || mt.a <= 19 && "hb2000".equals(mt.b) && ("OMX.amlogic.avc.decoder.awesome".equals(string) || "OMX.amlogic.avc.decoder.awesome.secure".equals(string));
    }

    private static boolean codecNeedsEosOutputExceptionWorkaround(String string) {
        return mt.a == 21 && "OMX.google.aac.decoder".equals(string);
    }

    private static boolean codecNeedsMonoChannelCountWorkaround(String string, k k2) {
        return mt.a <= 18 && k2.r == 1 && "OMX.MTK.AUDIO.DECODER.MP3".equals(string);
    }

    public static class a
    extends Exception {
        public final String a;
        public final boolean b;
        public final String c;
        public final String d;

        public a(k k2, Throwable throwable, boolean bl2, int n2) {
            String string = String.valueOf(k2);
            super(new StringBuilder(36 + String.valueOf(string).length()).append("Decoder init failed: [").append(n2).append("], ").append(string).toString(), throwable);
            this.a = k2.f;
            this.b = bl2;
            this.c = null;
            this.d = com.google.vr.sdk.widgets.video.deps.ex$a.a(n2);
        }

        public a(k k2, Throwable throwable, boolean bl2, String string) {
            String string2 = String.valueOf(k2);
            super(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Decoder init failed: ").append(string).append(", ").append(string2).toString(), throwable);
            this.a = k2.f;
            this.b = bl2;
            this.c = string;
            this.d = mt.a >= 21 ? com.google.vr.sdk.widgets.video.deps.ex$a.a(throwable) : null;
        }

        @TargetApi(value=21)
        private static String a(Throwable throwable) {
            if (throwable instanceof MediaCodec.CodecException) {
                return ((MediaCodec.CodecException)throwable).getDiagnosticInfo();
            }
            return null;
        }

        private static String a(int n2) {
            String string = n2 < 0 ? "neg_" : "";
            int n3 = Math.abs(n2);
            return new StringBuilder(64 + String.valueOf(string).length()).append("com.google.android.exoplayer.MediaCodecTrackRenderer_").append(string).append(n3).toString();
        }
    }
}

