/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.google.vr.libraries.video.CameraMotionMetadataRendererV2;
import com.google.vr.libraries.video.FrameRotationBuffer;
import com.google.vr.libraries.video.MotionCoordinateSystem;
import com.google.vr.libraries.video.SphericalV2MediaCodecVideoRenderer;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import com.google.vr.sdk.widgets.video.deps.ab;
import com.google.vr.sdk.widgets.video.deps.bk;
import com.google.vr.sdk.widgets.video.deps.bo;
import com.google.vr.sdk.widgets.video.deps.c;
import com.google.vr.sdk.widgets.video.deps.e;
import com.google.vr.sdk.widgets.video.deps.fg;
import com.google.vr.sdk.widgets.video.deps.k;
import com.google.vr.sdk.widgets.video.deps.ku;
import com.google.vr.sdk.widgets.video.deps.nc;
import com.google.vr.sdk.widgets.video.deps.w;
import java.util.ArrayList;

public class VrSimpleExoPlayer
extends ab {
    private final CameraMotionMetadataRendererV2 cameraMotionRenderer;
    private final SphericalV2MediaCodecVideoRenderer videoRenderer;

    public VrSimpleExoPlayer(Context context) {
        super(new VrRenderersFactory(context), new ku(), new c(), null);
        CameraMotionMetadataRendererV2 cameraMotionMetadataRendererV2 = null;
        SphericalV2MediaCodecVideoRenderer sphericalV2MediaCodecVideoRenderer = null;
        for (w w2 : this.renderers) {
            if (w2 instanceof CameraMotionMetadataRendererV2) {
                cameraMotionMetadataRendererV2 = (CameraMotionMetadataRendererV2)w2;
                continue;
            }
            if (!(w2 instanceof SphericalV2MediaCodecVideoRenderer)) continue;
            sphericalV2MediaCodecVideoRenderer = (SphericalV2MediaCodecVideoRenderer)w2;
        }
        this.cameraMotionRenderer = cameraMotionMetadataRendererV2;
        this.videoRenderer = sphericalV2MediaCodecVideoRenderer;
    }

    public FrameRotationBuffer getFrameRotationBuffer() {
        return this.cameraMotionRenderer.getFrameRotationBuffer();
    }

    public void setProjectionListener(SphericalV2ProjectionDataListener sphericalV2ProjectionDataListener) {
        this.videoRenderer.setProjectionListener(sphericalV2ProjectionDataListener);
    }

    public long getSampleTimestampUsForReleaseTimeUs(long l2) {
        return this.videoRenderer.getSampleTimestampBuffer().getSampleTimestampUsForReleaseTimeUs(l2);
    }

    public k getInputFormat() {
        return this.videoRenderer.getInputFormat();
    }

    private static class VrRenderersFactory
    extends e {
        public VrRenderersFactory(Context context) {
            super(context);
        }

        @Override
        protected void buildVideoRenderers(Context context, bk<bo> bk2, long l2, Handler handler, nc nc2, int n2, ArrayList<w> arrayList) {
            arrayList.add(new SphericalV2MediaCodecVideoRenderer(context, handler, bk2, nc2, l2));
        }

        @Override
        protected void buildMetadataRenderers(Context context, fg fg2, Looper looper, int n2, ArrayList<w> arrayList) {
            super.buildMetadataRenderers(context, fg2, looper, n2, arrayList);
            arrayList.add(new CameraMotionMetadataRendererV2(MotionCoordinateSystem.FLIP_XY));
        }
    }
}

