/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import com.google.vr.libraries.video.ProjectionScene;
import com.google.vr.sdk.widgets.video.deps.mi;
import com.google.vr.sdk.widgets.video.deps.mj;
import com.google.vr.sdk.widgets.video.deps.mt;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ProjectionMeshDecoderV2 {
    private static final int TYPE_YTMP = mt.h("ytmp");
    private static final int TYPE_MSHP = mt.h("mshp");
    private static final int TYPE_RAW = mt.h("raw ");
    private static final int TYPE_DFL8 = mt.h("dfl8");
    private static final int TYPE_MESH = mt.h("mesh");
    private static final int TYPE_PROJ = mt.h("proj");
    private static final int MAX_MESH_COUNT = 2;
    private static final int MAX_COORDINATE_COUNT = 10000;
    private static final int MAX_VERTEX_COUNT = 32000;
    private static final int MAX_TRIANGLE_INDICES = 128000;
    private static final int INITIAL_DECOMPRESS_SIZE = 100000;
    private List<ProjectionScene> sceneList = new ArrayList<ProjectionScene>();
    private boolean error;
    private ProjectionScene scene;
    private int meshCount;
    private boolean ytmpParsed;

    public ProjectionMeshDecoderV2() {
    }

    public ProjectionScene decode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        this.error = false;
        this.ytmpParsed = false;
        this.scene = null;
        mj mj2 = new mj(byArray);
        if (this.isProj(mj2)) {
            return this.parseProj(mj2);
        }
        return this.parseYtmp(mj2, mj2.e());
    }

    private boolean isProj(mj mj2) {
        int n2 = mj2.d();
        mj2.c(0);
        mj2.d(4);
        int n3 = mj2.o();
        mj2.c(n2);
        return n3 == TYPE_PROJ;
    }

    private ProjectionScene parseProj(mj mj2) {
        int n2;
        mj2.d(8);
        for (int i2 = mj2.d(); i2 < mj2.e() && !this.error; i2 += n2) {
            mj2.c(i2);
            n2 = mj2.o();
            if (n2 == 0) {
                return null;
            }
            int n3 = mj2.o();
            if (n3 != TYPE_YTMP && n3 != TYPE_MSHP) continue;
            if (this.ytmpParsed) {
                return null;
            }
            ProjectionScene projectionScene = this.parseYtmp(mj2, n2 + i2);
            if (this.error) {
                return null;
            }
            if (projectionScene == null) continue;
            return projectionScene;
        }
        return null;
    }

    private boolean readFromCache(int n2) {
        for (int i2 = 0; i2 < this.sceneList.size(); ++i2) {
            if (this.sceneList.get(i2).getCrc() != n2) continue;
            this.scene = this.sceneList.get(i2);
            return true;
        }
        return false;
    }

    private ProjectionScene parseYtmp(mj mj2, int n2) {
        int n3 = mj2.g();
        mj2.d(3);
        if (n3 == 0) {
            int n4 = mj2.o();
            if (this.readFromCache(n4)) {
                return this.scene;
            }
            int n5 = mj2.o();
            if (n5 == TYPE_RAW) {
                this.parseRawYtmpData(mj2, n2, n4);
                this.ytmpParsed = true;
            } else if (n5 == TYPE_DFL8) {
                int[] nArray = new int[1];
                byte[] byArray = ProjectionMeshDecoderV2.inflate(mj2.a, mj2.d(), n2 - mj2.d(), nArray);
                if (byArray == null) {
                    return null;
                }
                mj mj3 = new mj(byArray, nArray[0]);
                this.parseRawYtmpData(mj3, nArray[0], n4);
                this.ytmpParsed = true;
            } else {
                this.error = true;
            }
            if (this.error) {
                return null;
            }
            if (this.scene.getLeftMesh() != null) {
                this.sceneList.add(this.scene);
                return this.scene;
            }
        }
        return null;
    }

    private void parseRawYtmpData(mj mj2, int n2, int n3) {
        int n4;
        this.meshCount = 0;
        this.scene = new ProjectionScene(n3);
        for (int i2 = mj2.d(); i2 < n2 && !this.error; i2 += n4) {
            mj2.c(i2);
            n4 = mj2.o();
            if (n4 == 0) {
                this.error = true;
                return;
            }
            int n5 = mj2.o();
            if (n5 != TYPE_MESH) continue;
            if (this.meshCount >= 2) {
                this.error = true;
                return;
            }
            this.parseMesh(mj2);
            ++this.meshCount;
        }
    }

    private void parseMesh(mj mj2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = mj2.o();
        if (n7 > 10000) {
            this.error = true;
            return;
        }
        float[] fArray = new float[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            fArray[n6] = mj2.x();
        }
        n6 = mj2.o();
        if (n6 > 32000) {
            this.error = true;
            return;
        }
        double d2 = Math.log(2.0);
        int n8 = (int)Math.ceil(Math.log(2.0 * (double)n7) / d2);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        mi mi2 = new mi(mj2.a);
        mi2.a(mj2.d() * 8);
        float[] fArray2 = new float[n6 * 3];
        float[] fArray3 = new float[n6 * 2];
        for (n5 = 0; n5 < n6; ++n5) {
            if (ProjectionMeshDecoderV2.isVertexInvalid(n9 += ProjectionMeshDecoderV2.decodeZigZag(mi2.c(n8)), n10 += ProjectionMeshDecoderV2.decodeZigZag(mi2.c(n8)), n11 += ProjectionMeshDecoderV2.decodeZigZag(mi2.c(n8)), n12 += ProjectionMeshDecoderV2.decodeZigZag(mi2.c(n8)), n13 += ProjectionMeshDecoderV2.decodeZigZag(mi2.c(n8)), n7)) {
                this.error = true;
                return;
            }
            n4 = n5 * 3;
            fArray2[n4 + 0] = fArray[n9];
            fArray2[n4 + 1] = fArray[n10];
            fArray2[n4 + 2] = fArray[n11];
            n3 = n5 * 2;
            fArray3[n3 + 0] = fArray[n12];
            fArray3[n3 + 1] = fArray[n13];
        }
        mi2.a(mi2.b() + 7 & 0xFFFFFFF8);
        mi2.c(32);
        mi2.c(8);
        n5 = mi2.c(8);
        n4 = mi2.c(32);
        if (n4 > 128000) {
            this.error = true;
            return;
        }
        n3 = (int)Math.ceil(Math.log(2.0 * (double)n6) / d2);
        int[] nArray = new int[n4];
        int n14 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            if ((n14 += ProjectionMeshDecoderV2.decodeZigZag(mi2.c(n3))) >= n6) {
                this.error = true;
                return;
            }
            nArray[n2] = n14;
        }
        n2 = 4;
        switch (n5) {
            case 1: {
                n2 = 5;
                break;
            }
            case 2: {
                n2 = 6;
                break;
            }
        }
        ProjectionScene.Mesh mesh = new ProjectionScene.Mesh();
        ProjectionScene.SubMesh subMesh = new ProjectionScene.SubMesh(fArray2, fArray3, nArray, n2);
        mesh.addSubMesh(subMesh);
        if (this.meshCount == 0) {
            this.scene.setLeftMesh(mesh);
        } else if (this.meshCount == 1) {
            this.scene.setRightMesh(mesh);
        }
    }

    private static int decodeZigZag(int n2) {
        return n2 >> 1 ^ -(n2 & 1);
    }

    private static boolean isVertexInvalid(int n2, int n3, int n4, int n5, int n6, int n7) {
        return Math.max(Math.max(n2, n3), Math.max(n4, n5)) >= n7 || n6 >= n7;
    }

    static byte[] inflate(byte[] byArray, int n2, int n3, int[] nArray) {
        Inflater inflater = new Inflater(true);
        inflater.setInput(byArray, n2, n3);
        int n4 = 100000;
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        boolean bl2 = false;
        try {
            do {
                n5 += inflater.inflate(byArray2, n5, n4 - n5);
                boolean bl3 = bl2 = !inflater.needsInput();
                if (!bl2) continue;
                byArray2 = ProjectionMeshDecoderV2.resizeBuffer(byArray2);
                n4 = byArray2.length;
            } while (bl2);
        }
        catch (DataFormatException dataFormatException) {
            return null;
        }
        nArray[0] = n5;
        return byArray2;
    }

    private static byte[] resizeBuffer(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }
}

