/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import com.google.vr.sdk.widgets.video.deps.bn;
import com.google.vr.sdk.widgets.video.deps.bw;
import com.google.vr.sdk.widgets.video.deps.by;
import com.google.vr.sdk.widgets.video.deps.cc;
import com.google.vr.sdk.widgets.video.deps.fr;
import com.google.vr.sdk.widgets.video.deps.fs;
import com.google.vr.sdk.widgets.video.deps.ft;
import com.google.vr.sdk.widgets.video.deps.fu;
import com.google.vr.sdk.widgets.video.deps.fv;
import com.google.vr.sdk.widgets.video.deps.h;
import com.google.vr.sdk.widgets.video.deps.n;
import com.google.vr.sdk.widgets.video.deps.pp;
import com.google.vr.sdk.widgets.video.deps.qd;
import com.google.vr.sdk.widgets.video.deps.qs;
import com.google.vr.sdk.widgets.video.deps.qu;
import com.google.vr.sdk.widgets.video.deps.qy;
import com.google.vr.sdk.widgets.video.deps.rb;
import com.google.vr.sdk.widgets.video.deps.rd;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class ra
extends fs {
    private static final String TAG = "MediaCodecVideoRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private static final int[] STANDARD_LONG_EDGE_VIDEO_PX = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private static final int MAX_PENDING_OUTPUT_STREAM_OFFSET_COUNT = 10;
    private final Context context;
    private final rb frameReleaseTimeHelper;
    private final rd.a eventDispatcher;
    private final long allowedJoiningTimeMs;
    private final int maxDroppedFramesToNotify;
    private final boolean deviceNeedsAutoFrcWorkaround;
    private final long[] pendingOutputStreamOffsetsUs;
    private final long[] pendingOutputStreamSwitchTimesUs;
    private a codecMaxValues;
    private boolean codecNeedsSetOutputSurfaceWorkaround;
    private Surface surface;
    private Surface dummySurface;
    private int scalingMode;
    private boolean renderedFirstFrame;
    private long initialPositionUs;
    private long joiningDeadlineMs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int buffersInCodecCount;
    private long lastRenderTimeUs;
    private int pendingRotationDegrees;
    private float pendingPixelWidthHeightRatio;
    private int currentWidth;
    private int currentHeight;
    private int currentUnappliedRotationDegrees;
    private float currentPixelWidthHeightRatio;
    private int reportedWidth;
    private int reportedHeight;
    private int reportedUnappliedRotationDegrees;
    private float reportedPixelWidthHeightRatio;
    private boolean tunneling;
    private int tunnelingAudioSessionId;
    b tunnelingOnFrameRenderedListener;
    private long lastInputTimeUs;
    private long outputStreamOffsetUs;
    private int pendingOutputStreamOffsetCount;

    public ra(Context context, ft ft2) {
        this(context, ft2, 0L);
    }

    public ra(Context context, ft ft2, long l2) {
        this(context, ft2, l2, null, null, -1);
    }

    public ra(Context context, ft ft2, long l2, @Nullable Handler handler, @Nullable rd rd2, int n2) {
        this(context, ft2, l2, null, false, handler, rd2, n2);
    }

    public ra(Context context, ft ft2, long l2, @Nullable by<cc> by2, boolean bl2, @Nullable Handler handler, @Nullable rd rd2, int n2) {
        super(2, ft2, by2, bl2);
        this.allowedJoiningTimeMs = l2;
        this.maxDroppedFramesToNotify = n2;
        this.context = context.getApplicationContext();
        this.frameReleaseTimeHelper = new rb(context);
        this.eventDispatcher = new rd.a(handler, rd2);
        this.deviceNeedsAutoFrcWorkaround = ra.deviceNeedsAutoFrcWorkaround();
        this.pendingOutputStreamOffsetsUs = new long[10];
        this.pendingOutputStreamSwitchTimesUs = new long[10];
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.lastInputTimeUs = -9223372036854775807L;
        this.joiningDeadlineMs = -9223372036854775807L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.scalingMode = 1;
        this.clearReportedVideoSize();
    }

    @Override
    protected int supportsFormat(ft ft2, by<cc> by2, n n2) throws fu.b {
        int n3;
        int n4;
        fr fr2;
        String string = n2.h;
        if (!qd.b(string)) {
            return 0;
        }
        boolean bl2 = false;
        bw bw2 = n2.k;
        if (bw2 != null) {
            for (int i2 = 0; i2 < bw2.b; ++i2) {
                bl2 |= bw2.a((int)i2).c;
            }
        }
        if ((fr2 = ft2.a(string, bl2)) == null) {
            return bl2 && ft2.a(string, false) != null ? 2 : 1;
        }
        if (!ra.supportsFormatDrm(by2, bw2)) {
            return 2;
        }
        boolean bl3 = fr2.b(n2.e);
        if (bl3 && n2.l > 0 && n2.m > 0) {
            if (qu.a >= 21) {
                bl3 = fr2.a(n2.l, n2.m, n2.n);
            } else {
                boolean bl4 = bl3 = n2.l * n2.m <= fu.b();
                if (!bl3) {
                    n4 = n2.l;
                    n3 = n2.m;
                    String string2 = qu.e;
                    Log.d((String)TAG, (String)new StringBuilder(56 + String.valueOf(string2).length()).append("FalseCheck [legacyFrameSize, ").append(n4).append("x").append(n3).append("] [").append(string2).append("]").toString());
                }
            }
        }
        n4 = fr2.d ? 16 : 8;
        n3 = fr2.e ? 32 : 0;
        int n5 = bl3 ? 4 : 3;
        return n4 | n3 | n5;
    }

    @Override
    protected void onEnabled(boolean bl2) throws h {
        super.onEnabled(bl2);
        this.tunnelingAudioSessionId = this.getConfiguration().b;
        this.tunneling = this.tunnelingAudioSessionId != 0;
        this.eventDispatcher.a(this.decoderCounters);
        this.frameReleaseTimeHelper.a();
    }

    @Override
    protected void onStreamChanged(n[] nArray, long l2) throws h {
        if (this.outputStreamOffsetUs == -9223372036854775807L) {
            this.outputStreamOffsetUs = l2;
        } else {
            if (this.pendingOutputStreamOffsetCount == this.pendingOutputStreamOffsetsUs.length) {
                long l3 = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
                Log.w((String)TAG, (String)new StringBuilder(65).append("Too many stream changes, so dropping offset: ").append(l3).toString());
            } else {
                ++this.pendingOutputStreamOffsetCount;
            }
            this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1] = l2;
            this.pendingOutputStreamSwitchTimesUs[this.pendingOutputStreamOffsetCount - 1] = this.lastInputTimeUs;
        }
        super.onStreamChanged(nArray, l2);
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) throws h {
        super.onPositionReset(l2, bl2);
        this.clearRenderedFirstFrame();
        this.initialPositionUs = -9223372036854775807L;
        this.consecutiveDroppedFrameCount = 0;
        this.lastInputTimeUs = -9223372036854775807L;
        if (this.pendingOutputStreamOffsetCount != 0) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
            this.pendingOutputStreamOffsetCount = 0;
        }
        if (bl2) {
            this.setJoiningDeadlineMs();
        } else {
            this.joiningDeadlineMs = -9223372036854775807L;
        }
    }

    @Override
    public boolean isReady() {
        if (super.isReady() && (this.renderedFirstFrame || this.dummySurface != null && this.surface == this.dummySurface || this.getCodec() == null || this.tunneling)) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
        this.lastRenderTimeUs = SystemClock.elapsedRealtime() * 1000L;
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineMs = -9223372036854775807L;
        this.maybeNotifyDroppedFrames();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.lastInputTimeUs = -9223372036854775807L;
        this.pendingOutputStreamOffsetCount = 0;
        this.clearReportedVideoSize();
        this.clearRenderedFirstFrame();
        this.frameReleaseTimeHelper.b();
        this.tunnelingOnFrameRenderedListener = null;
        this.tunneling = false;
        try {
            super.onDisabled();
        }
        finally {
            this.decoderCounters.a();
            this.eventDispatcher.b(this.decoderCounters);
        }
    }

    @Override
    public void handleMessage(int n2, Object object) throws h {
        if (n2 == 1) {
            this.setSurface((Surface)object);
        } else if (n2 == 4) {
            this.scalingMode = (Integer)object;
            MediaCodec mediaCodec = this.getCodec();
            if (mediaCodec != null) {
                mediaCodec.setVideoScalingMode(this.scalingMode);
            }
        } else {
            super.handleMessage(n2, object);
        }
    }

    private void setSurface(Surface surface) throws h {
        if (surface == null) {
            if (this.dummySurface != null) {
                surface = this.dummySurface;
            } else {
                fr fr2 = this.getCodecInfo();
                if (fr2 != null && this.shouldUseDummySurface(fr2)) {
                    surface = this.dummySurface = qy.a(this.context, fr2.f);
                }
            }
        }
        if (this.surface != surface) {
            this.surface = surface;
            int n2 = this.getState();
            if (n2 == 1 || n2 == 2) {
                MediaCodec mediaCodec = this.getCodec();
                if (qu.a >= 23 && mediaCodec != null && surface != null && !this.codecNeedsSetOutputSurfaceWorkaround) {
                    ra.setOutputSurfaceV23(mediaCodec, surface);
                } else {
                    this.releaseCodec();
                    this.maybeInitCodec();
                }
            }
            if (surface != null && surface != this.dummySurface) {
                this.maybeRenotifyVideoSizeChanged();
                this.clearRenderedFirstFrame();
                if (n2 == 2) {
                    this.setJoiningDeadlineMs();
                }
            } else {
                this.clearReportedVideoSize();
                this.clearRenderedFirstFrame();
            }
        } else if (surface != null && surface != this.dummySurface) {
            this.maybeRenotifyVideoSizeChanged();
            this.maybeRenotifyRenderedFirstFrame();
        }
    }

    @Override
    protected boolean shouldInitCodec(fr fr2) {
        return this.surface != null || this.shouldUseDummySurface(fr2);
    }

    @Override
    protected void configureCodec(fr fr2, MediaCodec mediaCodec, n n2, MediaCrypto mediaCrypto) throws fu.b {
        this.codecMaxValues = this.getCodecMaxValues(fr2, n2, this.getStreamFormats());
        MediaFormat mediaFormat = this.getMediaFormat(n2, this.codecMaxValues, this.deviceNeedsAutoFrcWorkaround, this.tunnelingAudioSessionId);
        if (this.surface == null) {
            pp.b(this.shouldUseDummySurface(fr2));
            if (this.dummySurface == null) {
                this.dummySurface = qy.a(this.context, fr2.f);
            }
            this.surface = this.dummySurface;
        }
        mediaCodec.configure(mediaFormat, this.surface, mediaCrypto, 0);
        if (qu.a >= 23 && this.tunneling) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    @Override
    protected int canKeepCodec(MediaCodec mediaCodec, boolean bl2, n n2, n n3) {
        if (ra.areAdaptationCompatible(bl2, n2, n3) && n3.l <= this.codecMaxValues.a && n3.m <= this.codecMaxValues.b && ra.getMaxInputSize(n3) <= this.codecMaxValues.c) {
            return n2.b(n3) ? 1 : 3;
        }
        return 0;
    }

    @Override
    @CallSuper
    protected void releaseCodec() {
        try {
            super.releaseCodec();
        }
        finally {
            this.buffersInCodecCount = 0;
            if (this.dummySurface != null) {
                if (this.surface == this.dummySurface) {
                    this.surface = null;
                }
                this.dummySurface.release();
                this.dummySurface = null;
            }
        }
    }

    @Override
    @CallSuper
    protected void flushCodec() throws h {
        super.flushCodec();
        this.buffersInCodecCount = 0;
    }

    @Override
    protected void onCodecInitialized(String string, long l2, long l3) {
        this.eventDispatcher.a(string, l2, l3);
        this.codecNeedsSetOutputSurfaceWorkaround = ra.codecNeedsSetOutputSurfaceWorkaround(string);
    }

    @Override
    protected void onInputFormatChanged(n n2) throws h {
        super.onInputFormatChanged(n2);
        this.eventDispatcher.a(n2);
        this.pendingPixelWidthHeightRatio = n2.p;
        this.pendingRotationDegrees = n2.o;
    }

    @Override
    @CallSuper
    protected void onQueueInputBuffer(bn bn2) {
        ++this.buffersInCodecCount;
        this.lastInputTimeUs = Math.max(bn2.f, this.lastInputTimeUs);
        if (qu.a < 23 && this.tunneling) {
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    @Override
    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        boolean bl2 = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
        this.currentWidth = bl2 ? mediaFormat.getInteger(KEY_CROP_RIGHT) - mediaFormat.getInteger(KEY_CROP_LEFT) + 1 : mediaFormat.getInteger("width");
        this.currentHeight = bl2 ? mediaFormat.getInteger(KEY_CROP_BOTTOM) - mediaFormat.getInteger(KEY_CROP_TOP) + 1 : mediaFormat.getInteger("height");
        this.currentPixelWidthHeightRatio = this.pendingPixelWidthHeightRatio;
        if (qu.a >= 21) {
            if (this.pendingRotationDegrees == 90 || this.pendingRotationDegrees == 270) {
                int n2 = this.currentWidth;
                this.currentWidth = this.currentHeight;
                this.currentHeight = n2;
                this.currentPixelWidthHeightRatio = 1.0f / this.currentPixelWidthHeightRatio;
            }
        } else {
            this.currentUnappliedRotationDegrees = this.pendingRotationDegrees;
        }
        mediaCodec.setVideoScalingMode(this.scalingMode);
    }

    @Override
    protected boolean processOutputBuffer(long l2, long l3, MediaCodec mediaCodec, ByteBuffer byteBuffer, int n2, int n3, long l4, boolean bl2) throws h {
        boolean bl3;
        if (this.initialPositionUs == -9223372036854775807L) {
            this.initialPositionUs = l2;
        }
        long l5 = l4 - this.outputStreamOffsetUs;
        if (bl2) {
            this.skipOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        long l6 = l4 - l2;
        if (this.surface == this.dummySurface) {
            if (ra.isBufferLate(l6)) {
                this.skipOutputBuffer(mediaCodec, n2, l5);
                return true;
            }
            return false;
        }
        long l7 = SystemClock.elapsedRealtime() * 1000L;
        boolean bl4 = bl3 = this.getState() == 2;
        if (!this.renderedFirstFrame || bl3 && this.shouldForceRenderOutputBuffer(l6, l7 - this.lastRenderTimeUs)) {
            if (qu.a >= 21) {
                this.renderOutputBufferV21(mediaCodec, n2, l5, System.nanoTime());
            } else {
                this.renderOutputBuffer(mediaCodec, n2, l5);
            }
            return true;
        }
        if (!bl3 || l2 == this.initialPositionUs) {
            return false;
        }
        long l8 = l7 - l3;
        l6 -= l8;
        long l9 = System.nanoTime();
        long l10 = l9 + l6 * 1000L;
        long l11 = this.frameReleaseTimeHelper.a(l4, l10);
        l6 = (l11 - l9) / 1000L;
        if (this.shouldDropBuffersToKeyframe(l6, l3) && this.maybeDropBuffersToKeyframe(mediaCodec, n2, l5, l2)) {
            return false;
        }
        if (this.shouldDropOutputBuffer(l6, l3)) {
            this.dropOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        if (qu.a >= 21) {
            if (l6 < 50000L) {
                this.renderOutputBufferV21(mediaCodec, n2, l5, l11);
                return true;
            }
        } else if (l6 < 30000L) {
            if (l6 > 11000L) {
                try {
                    Thread.sleep((l6 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            this.renderOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        return false;
    }

    @Override
    @CallSuper
    protected void onProcessedOutputBuffer(long l2) {
        --this.buffersInCodecCount;
        while (this.pendingOutputStreamOffsetCount != 0 && l2 >= this.pendingOutputStreamSwitchTimesUs[0]) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[0];
            --this.pendingOutputStreamOffsetCount;
            System.arraycopy(this.pendingOutputStreamOffsetsUs, 1, this.pendingOutputStreamOffsetsUs, 0, this.pendingOutputStreamOffsetCount);
            System.arraycopy(this.pendingOutputStreamSwitchTimesUs, 1, this.pendingOutputStreamSwitchTimesUs, 0, this.pendingOutputStreamOffsetCount);
        }
    }

    protected boolean shouldDropOutputBuffer(long l2, long l3) {
        return ra.isBufferLate(l2);
    }

    protected boolean shouldDropBuffersToKeyframe(long l2, long l3) {
        return ra.isBufferVeryLate(l2);
    }

    protected boolean shouldForceRenderOutputBuffer(long l2, long l3) {
        return ra.isBufferLate(l2) && l3 > 100000L;
    }

    protected void skipOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        qs.a("skipVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        qs.a();
        ++this.decoderCounters.f;
    }

    protected void dropOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        qs.a("dropVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        qs.a();
        this.updateDroppedBufferCounters(1);
    }

    protected boolean maybeDropBuffersToKeyframe(MediaCodec mediaCodec, int n2, long l2, long l3) throws h {
        int n3 = this.skipSource(l3);
        if (n3 == 0) {
            return false;
        }
        ++this.decoderCounters.i;
        this.updateDroppedBufferCounters(this.buffersInCodecCount + n3);
        this.flushCodec();
        return true;
    }

    protected void updateDroppedBufferCounters(int n2) {
        this.decoderCounters.g += n2;
        this.droppedFrames += n2;
        this.consecutiveDroppedFrameCount += n2;
        this.decoderCounters.h = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.h);
        if (this.droppedFrames >= this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    protected void renderOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        this.maybeNotifyVideoSizeChanged();
        qs.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, true);
        qs.a();
        this.lastRenderTimeUs = SystemClock.elapsedRealtime() * 1000L;
        ++this.decoderCounters.e;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    @TargetApi(value=21)
    protected void renderOutputBufferV21(MediaCodec mediaCodec, int n2, long l2, long l3) {
        this.maybeNotifyVideoSizeChanged();
        qs.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, l3);
        qs.a();
        this.lastRenderTimeUs = SystemClock.elapsedRealtime() * 1000L;
        ++this.decoderCounters.e;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    private boolean shouldUseDummySurface(fr fr2) {
        return qu.a >= 23 && !this.tunneling && !ra.codecNeedsSetOutputSurfaceWorkaround(fr2.c) && (!fr2.f || qy.a(this.context));
    }

    private void setJoiningDeadlineMs() {
        this.joiningDeadlineMs = this.allowedJoiningTimeMs > 0L ? SystemClock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    private void clearRenderedFirstFrame() {
        MediaCodec mediaCodec;
        this.renderedFirstFrame = false;
        if (qu.a >= 23 && this.tunneling && (mediaCodec = this.getCodec()) != null) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    void maybeNotifyRenderedFirstFrame() {
        if (!this.renderedFirstFrame) {
            this.renderedFirstFrame = true;
            this.eventDispatcher.a(this.surface);
        }
    }

    private void maybeRenotifyRenderedFirstFrame() {
        if (this.renderedFirstFrame) {
            this.eventDispatcher.a(this.surface);
        }
    }

    private void clearReportedVideoSize() {
        this.reportedWidth = -1;
        this.reportedHeight = -1;
        this.reportedPixelWidthHeightRatio = -1.0f;
        this.reportedUnappliedRotationDegrees = -1;
    }

    private void maybeNotifyVideoSizeChanged() {
        if (!(this.currentWidth == -1 && this.currentHeight == -1 || this.reportedWidth == this.currentWidth && this.reportedHeight == this.currentHeight && this.reportedUnappliedRotationDegrees == this.currentUnappliedRotationDegrees && this.reportedPixelWidthHeightRatio == this.currentPixelWidthHeightRatio)) {
            this.eventDispatcher.a(this.currentWidth, this.currentHeight, this.currentUnappliedRotationDegrees, this.currentPixelWidthHeightRatio);
            this.reportedWidth = this.currentWidth;
            this.reportedHeight = this.currentHeight;
            this.reportedUnappliedRotationDegrees = this.currentUnappliedRotationDegrees;
            this.reportedPixelWidthHeightRatio = this.currentPixelWidthHeightRatio;
        }
    }

    private void maybeRenotifyVideoSizeChanged() {
        if (this.reportedWidth != -1 || this.reportedHeight != -1) {
            this.eventDispatcher.a(this.reportedWidth, this.reportedHeight, this.reportedUnappliedRotationDegrees, this.reportedPixelWidthHeightRatio);
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long l2 = SystemClock.elapsedRealtime();
            long l3 = l2 - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.a(this.droppedFrames, l3);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = l2;
        }
    }

    private static boolean isBufferLate(long l2) {
        return l2 < -30000L;
    }

    private static boolean isBufferVeryLate(long l2) {
        return l2 < -500000L;
    }

    @TargetApi(value=23)
    private static void setOutputSurfaceV23(MediaCodec mediaCodec, Surface surface) {
        mediaCodec.setOutputSurface(surface);
    }

    @TargetApi(value=21)
    private static void configureTunnelingV21(MediaFormat mediaFormat, int n2) {
        mediaFormat.setFeatureEnabled("tunneled-playback", true);
        mediaFormat.setInteger("audio-session-id", n2);
    }

    protected a getCodecMaxValues(fr fr2, n n2, n[] nArray) throws fu.b {
        int n3 = n2.l;
        int n4 = n2.m;
        int n5 = ra.getMaxInputSize(n2);
        if (nArray.length == 1) {
            return new a(n3, n4, n5);
        }
        boolean bl2 = false;
        for (n n6 : nArray) {
            if (!ra.areAdaptationCompatible(fr2.d, n2, n6)) continue;
            bl2 |= n6.l == -1 || n6.m == -1;
            n3 = Math.max(n3, n6.l);
            n4 = Math.max(n4, n6.m);
            n5 = Math.max(n5, ra.getMaxInputSize(n6));
        }
        if (bl2) {
            int n7 = n3;
            int n8 = n4;
            Log.w((String)TAG, (String)new StringBuilder(66).append("Resolutions unknown. Codec max resolution: ").append(n7).append("x").append(n8).toString());
            Point point = ra.getCodecMaxSize(fr2, n2);
            if (point != null) {
                n3 = Math.max(n3, point.x);
                n4 = Math.max(n4, point.y);
                n5 = Math.max(n5, ra.getMaxInputSize(n2.h, n3, n4));
                n8 = n3;
                int n9 = n4;
                Log.w((String)TAG, (String)new StringBuilder(57).append("Codec max resolution adjusted to: ").append(n8).append("x").append(n9).toString());
            }
        }
        return new a(n3, n4, n5);
    }

    @SuppressLint(value={"InlinedApi"})
    protected MediaFormat getMediaFormat(n n2, a a2, boolean bl2, int n3) {
        MediaFormat mediaFormat = new MediaFormat();
        mediaFormat.setString("mime", n2.h);
        mediaFormat.setInteger("width", n2.l);
        mediaFormat.setInteger("height", n2.m);
        fv.a(mediaFormat, n2.j);
        fv.a(mediaFormat, "frame-rate", n2.n);
        fv.a(mediaFormat, "rotation-degrees", n2.o);
        fv.a(mediaFormat, n2.s);
        mediaFormat.setInteger("max-width", a2.a);
        mediaFormat.setInteger("max-height", a2.b);
        fv.a(mediaFormat, "max-input-size", a2.c);
        if (qu.a >= 23) {
            mediaFormat.setInteger("priority", 0);
        }
        if (bl2) {
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (n3 != 0) {
            ra.configureTunnelingV21(mediaFormat, n3);
        }
        return mediaFormat;
    }

    private static Point getCodecMaxSize(fr fr2, n n2) throws fu.b {
        boolean bl2 = n2.m > n2.l;
        int n3 = bl2 ? n2.m : n2.l;
        int n4 = bl2 ? n2.l : n2.m;
        float f2 = (float)n4 / (float)n3;
        for (int n5 : STANDARD_LONG_EDGE_VIDEO_PX) {
            int n6 = (int)((float)n5 * f2);
            if (n5 <= n3 || n6 <= n4) {
                return null;
            }
            if (qu.a >= 21) {
                Point point = fr2.a(bl2 ? n6 : n5, bl2 ? n5 : n6);
                float f3 = n2.n;
                if (!fr2.a(point.x, point.y, f3)) continue;
                return point;
            }
            if ((n5 = qu.a(n5, 16) * 16) * (n6 = qu.a(n6, 16) * 16) > fu.b()) continue;
            return new Point(bl2 ? n6 : n5, bl2 ? n5 : n6);
        }
        return null;
    }

    private static int getMaxInputSize(n n2) {
        if (n2.i != -1) {
            int n3 = 0;
            int n4 = n2.j.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                n3 += n2.j.get(i2).length;
            }
            return n2.i + n3;
        }
        return ra.getMaxInputSize(n2.h, n2.l, n2.m);
    }

    private static int getMaxInputSize(String string, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == -1 || n3 == -1) {
            return -1;
        }
        switch (string) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(qu.d)) {
                    return -1;
                }
                n5 = qu.a(n2, 16) * qu.a(n3, 16) * 16 * 16;
                n4 = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                n5 = n2 * n3;
                n4 = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return n5 * 3 / (2 * n4);
    }

    private static boolean areAdaptationCompatible(boolean bl2, n n2, n n3) {
        return n2.h.equals(n3.h) && n2.o == n3.o && (bl2 || n2.l == n3.l && n2.m == n3.m) && qu.a(n2.s, (Object)n3.s);
    }

    private static boolean deviceNeedsAutoFrcWorkaround() {
        return qu.a <= 22 && "foster".equals(qu.b) && "NVIDIA".equals(qu.c);
    }

    private static boolean codecNeedsSetOutputSurfaceWorkaround(String string) {
        return ("deb".equals(qu.b) || "flo".equals(qu.b) || "mido".equals(qu.b) || "santoni".equals(qu.b)) && "OMX.qcom.video.decoder.avc".equals(string) || ("tcl_eu".equals(qu.b) || "SVP-DTV15".equals(qu.b) || "BRAVIA_ATV2".equals(qu.b) || qu.b.startsWith("panell_") || "F3311".equals(qu.b) || "M5c".equals(qu.b) || "QM16XE_U".equals(qu.b) || "A7010a48".equals(qu.b)) && "OMX.MTK.VIDEO.DECODER.AVC".equals(string) || ("ALE-L21".equals(qu.d) || "CAM-L21".equals(qu.d)) && "OMX.k3.video.decoder.avc".equals(string) || "HUAWEI VNS-L21".equals(qu.d) && "OMX.IMG.MSVDX.Decoder.AVC".equals(string);
    }

    @TargetApi(value=23)
    private final class b
    implements MediaCodec.OnFrameRenderedListener {
        private b(MediaCodec mediaCodec) {
            mediaCodec.setOnFrameRenderedListener((MediaCodec.OnFrameRenderedListener)this, new Handler());
        }

        public void onFrameRendered(@NonNull MediaCodec mediaCodec, long l2, long l3) {
            if (this != ra.this.tunnelingOnFrameRenderedListener) {
                return;
            }
            ra.this.maybeNotifyRenderedFirstFrame();
        }
    }

    protected static final class a {
        public final int a;
        public final int b;
        public final int c;

        public a(int n2, int n3, int n4) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
        }
    }
}

