/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.vr.sdk.widgets.video.deps.bm;
import com.google.vr.sdk.widgets.video.deps.bn;
import com.google.vr.sdk.widgets.video.deps.bx;
import com.google.vr.sdk.widgets.video.deps.by;
import com.google.vr.sdk.widgets.video.deps.cc;
import com.google.vr.sdk.widgets.video.deps.fr;
import com.google.vr.sdk.widgets.video.deps.ft;
import com.google.vr.sdk.widgets.video.deps.fu;
import com.google.vr.sdk.widgets.video.deps.h;
import com.google.vr.sdk.widgets.video.deps.n;
import com.google.vr.sdk.widgets.video.deps.o;
import com.google.vr.sdk.widgets.video.deps.pp;
import com.google.vr.sdk.widgets.video.deps.qe;
import com.google.vr.sdk.widgets.video.deps.qs;
import com.google.vr.sdk.widgets.video.deps.qu;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=16)
public abstract class fs
extends com.google.vr.sdk.widgets.video.deps.a {
    private static final String TAG = "MediaCodecRenderer";
    private static final long MAX_CODEC_HOTSWAP_TIME_MS = 1000L;
    protected static final int KEEP_CODEC_RESULT_NO = 0;
    protected static final int KEEP_CODEC_RESULT_YES_WITHOUT_RECONFIGURATION = 1;
    protected static final int KEEP_CODEC_RESULT_YES_WITH_RECONFIGURATION = 3;
    private static final int RECONFIGURATION_STATE_NONE = 0;
    private static final int RECONFIGURATION_STATE_WRITE_PENDING = 1;
    private static final int RECONFIGURATION_STATE_QUEUE_PENDING = 2;
    private static final int REINITIALIZATION_STATE_NONE = 0;
    private static final int REINITIALIZATION_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int REINITIALIZATION_STATE_WAIT_END_OF_STREAM = 2;
    private static final int ADAPTATION_WORKAROUND_MODE_NEVER = 0;
    private static final int ADAPTATION_WORKAROUND_MODE_SAME_RESOLUTION = 1;
    private static final int ADAPTATION_WORKAROUND_MODE_ALWAYS = 2;
    private static final byte[] ADAPTATION_WORKAROUND_BUFFER = qu.i("0000016742C00BDA259000000168CE0F13200000016588840DCE7118A0002FBF1C31C3275D78");
    private static final int ADAPTATION_WORKAROUND_SLICE_WIDTH_HEIGHT = 32;
    private final ft mediaCodecSelector;
    @Nullable
    private final by<cc> drmSessionManager;
    private final boolean playClearSamplesWithoutKeys;
    private final bn buffer;
    private final bn flagsOnlyBuffer;
    private final o formatHolder;
    private final List<Long> decodeOnlyPresentationTimestamps;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private n format;
    private bx<cc> drmSession;
    private bx<cc> pendingDrmSession;
    private MediaCodec codec;
    private fr codecInfo;
    private int codecAdaptationWorkaroundMode;
    private boolean codecNeedsDiscardToSpsWorkaround;
    private boolean codecNeedsFlushWorkaround;
    private boolean codecNeedsEosPropagationWorkaround;
    private boolean codecNeedsEosFlushWorkaround;
    private boolean codecNeedsEosOutputExceptionWorkaround;
    private boolean codecNeedsMonoChannelCountWorkaround;
    private boolean codecNeedsAdaptationWorkaroundBuffer;
    private boolean shouldSkipAdaptationWorkaroundOutputBuffer;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private long codecHotswapDeadlineMs;
    private int inputIndex;
    private int outputIndex;
    private ByteBuffer outputBuffer;
    private boolean shouldSkipOutputBuffer;
    private boolean codecReconfigured;
    private int codecReconfigurationState;
    private int codecReinitializationState;
    private boolean codecReceivedBuffers;
    private boolean codecReceivedEos;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private boolean waitingForKeys;
    private boolean waitingForFirstSyncFrame;
    protected bm decoderCounters;

    public fs(int n2, ft ft2, @Nullable by<cc> by2, boolean bl2) {
        super(n2);
        pp.b(qu.a >= 16);
        this.mediaCodecSelector = pp.a(ft2);
        this.drmSessionManager = by2;
        this.playClearSamplesWithoutKeys = bl2;
        this.buffer = new bn(0);
        this.flagsOnlyBuffer = bn.e();
        this.formatHolder = new o();
        this.decodeOnlyPresentationTimestamps = new ArrayList<Long>();
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
    }

    @Override
    public final int supportsMixedMimeTypeAdaptation() {
        return 8;
    }

    @Override
    public final int supportsFormat(n n2) throws h {
        try {
            return this.supportsFormat(this.mediaCodecSelector, this.drmSessionManager, n2);
        }
        catch (fu.b b2) {
            throw h.a(b2, this.getIndex());
        }
    }

    protected abstract int supportsFormat(ft var1, by<cc> var2, n var3) throws fu.b;

    protected fr getDecoderInfo(ft ft2, n n2, boolean bl2) throws fu.b {
        return ft2.a(n2.h, bl2);
    }

    protected abstract void configureCodec(fr var1, MediaCodec var2, n var3, MediaCrypto var4) throws fu.b;

    protected final void maybeInitCodec() throws h {
        Object object;
        if (this.codec != null || this.format == null) {
            return;
        }
        this.drmSession = this.pendingDrmSession;
        String string = this.format.h;
        MediaCrypto mediaCrypto = null;
        boolean bl2 = false;
        if (this.drmSession != null) {
            object = this.drmSession.g();
            if (object == null) {
                bx.a a2 = this.drmSession.f();
                if (a2 == null) {
                    return;
                }
            } else {
                mediaCrypto = ((cc)object).a();
                bl2 = ((cc)object).a(string);
            }
        }
        if (this.codecInfo == null) {
            try {
                this.codecInfo = this.getDecoderInfo(this.mediaCodecSelector, this.format, bl2);
                if (this.codecInfo == null && bl2) {
                    this.codecInfo = this.getDecoderInfo(this.mediaCodecSelector, this.format, false);
                    if (this.codecInfo != null) {
                        object = this.codecInfo.c;
                        Log.w((String)TAG, (String)new StringBuilder(99 + String.valueOf(string).length() + String.valueOf(object).length()).append("Drm session requires secure decoder for ").append(string).append(", but no secure decoder available. Trying to proceed with ").append((String)object).append(".").toString());
                    }
                }
            }
            catch (fu.b b2) {
                this.throwDecoderInitError(new b(this.format, (Throwable)b2, bl2, -49998));
            }
            if (this.codecInfo == null) {
                this.throwDecoderInitError(new b(this.format, null, bl2, -49999));
            }
        }
        if (!this.shouldInitCodec(this.codecInfo)) {
            return;
        }
        object = this.codecInfo.c;
        this.codecAdaptationWorkaroundMode = this.codecAdaptationWorkaroundMode((String)object);
        this.codecNeedsDiscardToSpsWorkaround = fs.codecNeedsDiscardToSpsWorkaround((String)object, this.format);
        this.codecNeedsFlushWorkaround = fs.codecNeedsFlushWorkaround((String)object);
        this.codecNeedsEosPropagationWorkaround = fs.codecNeedsEosPropagationWorkaround((String)object);
        this.codecNeedsEosFlushWorkaround = fs.codecNeedsEosFlushWorkaround((String)object);
        this.codecNeedsEosOutputExceptionWorkaround = fs.codecNeedsEosOutputExceptionWorkaround((String)object);
        this.codecNeedsMonoChannelCountWorkaround = fs.codecNeedsMonoChannelCountWorkaround((String)object, this.format);
        try {
            long l2 = SystemClock.elapsedRealtime();
            String string2 = String.valueOf(object);
            qs.a(string2.length() != 0 ? "createCodec:".concat(string2) : new String("createCodec:"));
            this.codec = MediaCodec.createByCodecName((String)object);
            qs.a();
            qs.a("configureCodec");
            this.configureCodec(this.codecInfo, this.codec, this.format, mediaCrypto);
            qs.a();
            qs.a("startCodec");
            this.codec.start();
            qs.a();
            long l3 = SystemClock.elapsedRealtime();
            this.onCodecInitialized((String)object, l3, l3 - l2);
            this.getCodecBuffers();
        }
        catch (Exception exception) {
            this.throwDecoderInitError(new b(this.format, (Throwable)exception, bl2, (String)object));
        }
        this.codecHotswapDeadlineMs = this.getState() == 2 ? SystemClock.elapsedRealtime() + 1000L : -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForFirstSyncFrame = true;
        ++this.decoderCounters.a;
    }

    private void throwDecoderInitError(b b2) throws h {
        throw h.a(b2, this.getIndex());
    }

    protected boolean shouldInitCodec(fr fr2) {
        return true;
    }

    protected final MediaCodec getCodec() {
        return this.codec;
    }

    protected final fr getCodecInfo() {
        return this.codecInfo;
    }

    @Override
    protected void onEnabled(boolean bl2) throws h {
        this.decoderCounters = new bm();
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) throws h {
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        if (this.codec != null) {
            this.flushCodec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDisabled() {
        this.format = null;
        try {
            this.releaseCodec();
        }
        finally {
            try {
                if (this.drmSession != null) {
                    this.drmSessionManager.a(this.drmSession);
                }
            }
            finally {
                try {
                    if (this.pendingDrmSession != null && this.pendingDrmSession != this.drmSession) {
                        this.drmSessionManager.a(this.pendingDrmSession);
                    }
                }
                finally {
                    this.drmSession = null;
                    this.pendingDrmSession = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseCodec() {
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForKeys = false;
        this.shouldSkipOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.resetCodecBuffers();
        this.codecInfo = null;
        this.codecReconfigured = false;
        this.codecReceivedBuffers = false;
        this.codecNeedsDiscardToSpsWorkaround = false;
        this.codecNeedsFlushWorkaround = false;
        this.codecAdaptationWorkaroundMode = 0;
        this.codecNeedsEosPropagationWorkaround = false;
        this.codecNeedsEosFlushWorkaround = false;
        this.codecNeedsMonoChannelCountWorkaround = false;
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        this.codecReceivedEos = false;
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
        if (this.codec != null) {
            ++this.decoderCounters.b;
            try {
                this.codec.stop();
            }
            finally {
                try {
                    this.codec.release();
                }
                finally {
                    this.codec = null;
                    if (this.drmSession != null && this.pendingDrmSession != this.drmSession) {
                        try {
                            this.drmSessionManager.a(this.drmSession);
                        }
                        finally {
                            this.drmSession = null;
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void onStarted() {
    }

    @Override
    protected void onStopped() {
    }

    @Override
    public void render(long l2, long l3) throws h {
        int n2;
        if (this.outputStreamEnded) {
            this.renderToEndOfStream();
            return;
        }
        if (this.format == null) {
            this.flagsOnlyBuffer.a();
            n2 = this.readSource(this.formatHolder, this.flagsOnlyBuffer, true);
            if (n2 == -5) {
                this.onInputFormatChanged(this.formatHolder.a);
            } else {
                if (n2 == -4) {
                    pp.b(this.flagsOnlyBuffer.c());
                    this.inputStreamEnded = true;
                    this.processEndOfStream();
                    return;
                }
                return;
            }
        }
        this.maybeInitCodec();
        if (this.codec != null) {
            qs.a("drainAndFeed");
            while (this.drainOutputBuffer(l2, l3)) {
            }
            while (this.feedInputBuffer()) {
            }
            qs.a();
        } else {
            this.decoderCounters.d += this.skipSource(l2);
            this.flagsOnlyBuffer.a();
            n2 = this.readSource(this.formatHolder, this.flagsOnlyBuffer, false);
            if (n2 == -5) {
                this.onInputFormatChanged(this.formatHolder.a);
            } else if (n2 == -4) {
                pp.b(this.flagsOnlyBuffer.c());
                this.inputStreamEnded = true;
                this.processEndOfStream();
            }
        }
        this.decoderCounters.a();
    }

    protected void flushCodec() throws h {
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.waitingForFirstSyncFrame = true;
        this.waitingForKeys = false;
        this.shouldSkipOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        if (this.codecNeedsFlushWorkaround || this.codecNeedsEosFlushWorkaround && this.codecReceivedEos) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else if (this.codecReinitializationState != 0) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.codec.flush();
            this.codecReceivedBuffers = false;
        }
        if (this.codecReconfigured && this.format != null) {
            this.codecReconfigurationState = 1;
        }
    }

    private boolean feedInputBuffer() throws h {
        int n2;
        int n3;
        if (this.codec == null || this.codecReinitializationState == 2 || this.inputStreamEnded) {
            return false;
        }
        if (this.inputIndex < 0) {
            this.inputIndex = this.codec.dequeueInputBuffer(0L);
            if (this.inputIndex < 0) {
                return false;
            }
            this.buffer.e = this.getInputBuffer(this.inputIndex);
            this.buffer.a();
        }
        if (this.codecReinitializationState == 1) {
            if (!this.codecNeedsEosPropagationWorkaround) {
                this.codecReceivedEos = true;
                this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                this.resetInputBuffer();
            }
            this.codecReinitializationState = 2;
            return false;
        }
        if (this.codecNeedsAdaptationWorkaroundBuffer) {
            this.codecNeedsAdaptationWorkaroundBuffer = false;
            this.buffer.e.put(ADAPTATION_WORKAROUND_BUFFER);
            this.codec.queueInputBuffer(this.inputIndex, 0, ADAPTATION_WORKAROUND_BUFFER.length, 0L, 0);
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            return true;
        }
        int n4 = 0;
        if (this.waitingForKeys) {
            n3 = -4;
        } else {
            if (this.codecReconfigurationState == 1) {
                for (n2 = 0; n2 < this.format.j.size(); n2 += 1) {
                    byte[] byArray = this.format.j.get(n2);
                    this.buffer.e.put(byArray);
                }
                this.codecReconfigurationState = 2;
            }
            n4 = this.buffer.e.position();
            n3 = this.readSource(this.formatHolder, this.buffer, false);
        }
        if (n3 == -3) {
            return false;
        }
        if (n3 == -5) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.a();
                this.codecReconfigurationState = 1;
            }
            this.onInputFormatChanged(this.formatHolder.a);
            return true;
        }
        if (this.buffer.c()) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.a();
                this.codecReconfigurationState = 1;
            }
            this.inputStreamEnded = true;
            if (!this.codecReceivedBuffers) {
                this.processEndOfStream();
                return false;
            }
            try {
                if (!this.codecNeedsEosPropagationWorkaround) {
                    this.codecReceivedEos = true;
                    this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                    this.resetInputBuffer();
                }
            }
            catch (MediaCodec.CryptoException cryptoException) {
                throw h.a((Exception)((Object)cryptoException), this.getIndex());
            }
            return false;
        }
        if (this.waitingForFirstSyncFrame && !this.buffer.d()) {
            this.buffer.a();
            if (this.codecReconfigurationState == 2) {
                this.codecReconfigurationState = 1;
            }
            return true;
        }
        this.waitingForFirstSyncFrame = false;
        n2 = this.buffer.g() ? 1 : 0;
        this.waitingForKeys = this.shouldWaitForKeys(n2 != 0);
        if (this.waitingForKeys) {
            return false;
        }
        if (this.codecNeedsDiscardToSpsWorkaround && !n2) {
            qe.a(this.buffer.e);
            if (this.buffer.e.position() == 0) {
                return true;
            }
            this.codecNeedsDiscardToSpsWorkaround = false;
        }
        try {
            long l2 = this.buffer.f;
            if (this.buffer.b_()) {
                this.decodeOnlyPresentationTimestamps.add(l2);
            }
            this.buffer.h();
            this.onQueueInputBuffer(this.buffer);
            if (n2) {
                MediaCodec.CryptoInfo cryptoInfo = fs.getFrameworkCryptoInfo(this.buffer, n4);
                this.codec.queueSecureInputBuffer(this.inputIndex, 0, cryptoInfo, l2, 0);
            } else {
                this.codec.queueInputBuffer(this.inputIndex, 0, this.buffer.e.limit(), l2, 0);
            }
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            this.codecReconfigurationState = 0;
            ++this.decoderCounters.c;
        }
        catch (MediaCodec.CryptoException cryptoException) {
            throw h.a((Exception)((Object)cryptoException), this.getIndex());
        }
        return true;
    }

    private void getCodecBuffers() {
        if (qu.a < 21) {
            this.inputBuffers = this.codec.getInputBuffers();
            this.outputBuffers = this.codec.getOutputBuffers();
        }
    }

    private void resetCodecBuffers() {
        if (qu.a < 21) {
            this.inputBuffers = null;
            this.outputBuffers = null;
        }
    }

    private ByteBuffer getInputBuffer(int n2) {
        if (qu.a >= 21) {
            return this.codec.getInputBuffer(n2);
        }
        return this.inputBuffers[n2];
    }

    private ByteBuffer getOutputBuffer(int n2) {
        if (qu.a >= 21) {
            return this.codec.getOutputBuffer(n2);
        }
        return this.outputBuffers[n2];
    }

    private boolean hasOutputBuffer() {
        return this.outputIndex >= 0;
    }

    private void resetInputBuffer() {
        this.inputIndex = -1;
        this.buffer.e = null;
    }

    private void resetOutputBuffer() {
        this.outputIndex = -1;
        this.outputBuffer = null;
    }

    private static MediaCodec.CryptoInfo getFrameworkCryptoInfo(bn bn2, int n2) {
        MediaCodec.CryptoInfo cryptoInfo = bn2.d.a();
        if (n2 == 0) {
            return cryptoInfo;
        }
        if (cryptoInfo.numBytesOfClearData == null) {
            cryptoInfo.numBytesOfClearData = new int[1];
        }
        cryptoInfo.numBytesOfClearData[0] = cryptoInfo.numBytesOfClearData[0] + n2;
        return cryptoInfo;
    }

    private boolean shouldWaitForKeys(boolean bl2) throws h {
        if (this.drmSession == null || !bl2 && this.playClearSamplesWithoutKeys) {
            return false;
        }
        int n2 = this.drmSession.e();
        if (n2 == 1) {
            throw h.a(this.drmSession.f(), this.getIndex());
        }
        return n2 != 4;
    }

    protected void onCodecInitialized(String string, long l2, long l3) {
    }

    protected void onInputFormatChanged(n n2) throws h {
        boolean bl2;
        n n3 = this.format;
        this.format = n2;
        boolean bl3 = bl2 = !qu.a(this.format.k, (Object)(n3 == null ? null : n3.k));
        if (bl2) {
            if (this.format.k != null) {
                if (this.drmSessionManager == null) {
                    throw h.a(new IllegalStateException("Media requires a DrmSessionManager"), this.getIndex());
                }
                this.pendingDrmSession = this.drmSessionManager.a(Looper.myLooper(), this.format.k);
                if (this.pendingDrmSession == this.drmSession) {
                    this.drmSessionManager.a(this.pendingDrmSession);
                }
            } else {
                this.pendingDrmSession = null;
            }
        }
        boolean bl4 = false;
        if (this.pendingDrmSession == this.drmSession && this.codec != null) {
            switch (this.canKeepCodec(this.codec, this.codecInfo.d, n3, this.format)) {
                case 0: {
                    break;
                }
                case 1: {
                    bl4 = true;
                    break;
                }
                case 3: {
                    bl4 = true;
                    this.codecReconfigured = true;
                    this.codecReconfigurationState = 1;
                    this.codecNeedsAdaptationWorkaroundBuffer = this.codecAdaptationWorkaroundMode == 2 || this.codecAdaptationWorkaroundMode == 1 && this.format.l == n3.l && this.format.m == n3.m;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (!bl4) {
            if (this.codecReceivedBuffers) {
                this.codecReinitializationState = 1;
            } else {
                this.releaseCodec();
                this.maybeInitCodec();
            }
        }
    }

    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) throws h {
    }

    protected void onQueueInputBuffer(bn bn2) {
    }

    protected void onProcessedOutputBuffer(long l2) {
    }

    protected int canKeepCodec(MediaCodec mediaCodec, boolean bl2, n n2, n n3) {
        return 0;
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return this.format != null && !this.waitingForKeys && (this.isSourceReady() || this.hasOutputBuffer() || this.codecHotswapDeadlineMs != -9223372036854775807L && SystemClock.elapsedRealtime() < this.codecHotswapDeadlineMs);
    }

    protected long getDequeueOutputBufferTimeoutUs() {
        return 0L;
    }

    private boolean drainOutputBuffer(long l2, long l3) throws h {
        int n2;
        if (!this.hasOutputBuffer()) {
            if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
                try {
                    n2 = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
                }
                catch (IllegalStateException illegalStateException) {
                    this.processEndOfStream();
                    if (this.outputStreamEnded) {
                        this.releaseCodec();
                    }
                    return false;
                }
            } else {
                n2 = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
            }
            if (n2 >= 0) {
                if (this.shouldSkipAdaptationWorkaroundOutputBuffer) {
                    this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
                    this.codec.releaseOutputBuffer(n2, false);
                    return true;
                }
                if (this.outputBufferInfo.size == 0 && (this.outputBufferInfo.flags & 4) != 0) {
                    this.processEndOfStream();
                    return false;
                }
                this.outputIndex = n2;
                this.outputBuffer = this.getOutputBuffer(n2);
                if (this.outputBuffer != null) {
                    this.outputBuffer.position(this.outputBufferInfo.offset);
                    this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
                }
                this.shouldSkipOutputBuffer = this.shouldSkipOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            } else {
                if (n2 == -2) {
                    this.processOutputFormat();
                    return true;
                }
                if (n2 == -3) {
                    this.processOutputBuffersChanged();
                    return true;
                }
                if (this.codecNeedsEosPropagationWorkaround && (this.inputStreamEnded || this.codecReinitializationState == 2)) {
                    this.processEndOfStream();
                }
                return false;
            }
        }
        if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
            try {
                n2 = this.processOutputBuffer(l2, l3, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer) ? 1 : 0;
            }
            catch (IllegalStateException illegalStateException) {
                this.processEndOfStream();
                if (this.outputStreamEnded) {
                    this.releaseCodec();
                }
                return false;
            }
        } else {
            n2 = this.processOutputBuffer(l2, l3, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer) ? 1 : 0;
        }
        if (n2 != 0) {
            this.onProcessedOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            boolean bl2 = (this.outputBufferInfo.flags & 4) != 0;
            this.resetOutputBuffer();
            if (!bl2) {
                return true;
            }
            this.processEndOfStream();
        }
        return false;
    }

    private void processOutputFormat() throws h {
        MediaFormat mediaFormat = this.codec.getOutputFormat();
        if (this.codecAdaptationWorkaroundMode != 0 && mediaFormat.getInteger("width") == 32 && mediaFormat.getInteger("height") == 32) {
            this.shouldSkipAdaptationWorkaroundOutputBuffer = true;
            return;
        }
        if (this.codecNeedsMonoChannelCountWorkaround) {
            mediaFormat.setInteger("channel-count", 1);
        }
        this.onOutputFormatChanged(this.codec, mediaFormat);
    }

    private void processOutputBuffersChanged() {
        if (qu.a < 21) {
            this.outputBuffers = this.codec.getOutputBuffers();
        }
    }

    protected abstract boolean processOutputBuffer(long var1, long var3, MediaCodec var5, ByteBuffer var6, int var7, int var8, long var9, boolean var11) throws h;

    protected void renderToEndOfStream() throws h {
    }

    private void processEndOfStream() throws h {
        if (this.codecReinitializationState == 2) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.outputStreamEnded = true;
            this.renderToEndOfStream();
        }
    }

    private boolean shouldSkipOutputBuffer(long l2) {
        int n2 = this.decodeOnlyPresentationTimestamps.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.decodeOnlyPresentationTimestamps.get(i2) != l2) continue;
            this.decodeOnlyPresentationTimestamps.remove(i2);
            return true;
        }
        return false;
    }

    private static boolean codecNeedsFlushWorkaround(String string) {
        return qu.a < 18 || qu.a == 18 && ("OMX.SEC.avc.dec".equals(string) || "OMX.SEC.avc.dec.secure".equals(string)) || qu.a == 19 && qu.d.startsWith("SM-G800") && ("OMX.Exynos.avc.dec".equals(string) || "OMX.Exynos.avc.dec.secure".equals(string));
    }

    private int codecAdaptationWorkaroundMode(String string) {
        if (qu.a <= 25 && "OMX.Exynos.avc.dec.secure".equals(string) && (qu.d.startsWith("SM-T585") || qu.d.startsWith("SM-A510") || qu.d.startsWith("SM-A520") || qu.d.startsWith("SM-J700"))) {
            return 2;
        }
        if (qu.a < 24 && ("OMX.Nvidia.h264.decode".equals(string) || "OMX.Nvidia.h264.decode.secure".equals(string)) && ("flounder".equals(qu.b) || "flounder_lte".equals(qu.b) || "grouper".equals(qu.b) || "tilapia".equals(qu.b))) {
            return 1;
        }
        return 0;
    }

    private static boolean codecNeedsDiscardToSpsWorkaround(String string, n n2) {
        return qu.a < 21 && n2.j.isEmpty() && "OMX.MTK.VIDEO.DECODER.AVC".equals(string);
    }

    private static boolean codecNeedsEosPropagationWorkaround(String string) {
        return qu.a <= 17 && ("OMX.rk.video_decoder.avc".equals(string) || "OMX.allwinner.video.decoder.avc".equals(string));
    }

    private static boolean codecNeedsEosFlushWorkaround(String string) {
        return qu.a <= 23 && "OMX.google.vorbis.decoder".equals(string) || qu.a <= 19 && "hb2000".equals(qu.b) && ("OMX.amlogic.avc.decoder.awesome".equals(string) || "OMX.amlogic.avc.decoder.awesome.secure".equals(string));
    }

    private static boolean codecNeedsEosOutputExceptionWorkaround(String string) {
        return qu.a == 21 && "OMX.google.aac.decoder".equals(string);
    }

    private static boolean codecNeedsMonoChannelCountWorkaround(String string, n n2) {
        return qu.a <= 18 && n2.t == 1 && "OMX.MTK.AUDIO.DECODER.MP3".equals(string);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface a {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface e {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface d {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    protected static @interface c {
    }

    public static class b
    extends Exception {
        private static final int e = -50000;
        private static final int f = -49999;
        private static final int g = -49998;
        public final String a;
        public final boolean b;
        public final String c;
        public final String d;

        public b(n n2, Throwable throwable, boolean bl2, int n3) {
            String string = String.valueOf(n2);
            super(new StringBuilder(36 + String.valueOf(string).length()).append("Decoder init failed: [").append(n3).append("], ").append(string).toString(), throwable);
            this.a = n2.h;
            this.b = bl2;
            this.c = null;
            this.d = com.google.vr.sdk.widgets.video.deps.fs$b.a(n3);
        }

        public b(n n2, Throwable throwable, boolean bl2, String string) {
            String string2 = String.valueOf(n2);
            super(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Decoder init failed: ").append(string).append(", ").append(string2).toString(), throwable);
            this.a = n2.h;
            this.b = bl2;
            this.c = string;
            this.d = qu.a >= 21 ? com.google.vr.sdk.widgets.video.deps.fs$b.a(throwable) : null;
        }

        @TargetApi(value=21)
        private static String a(Throwable throwable) {
            if (throwable instanceof MediaCodec.CodecException) {
                return ((MediaCodec.CodecException)throwable).getDiagnosticInfo();
            }
            return null;
        }

        private static String a(int n2) {
            String string = n2 < 0 ? "neg_" : "";
            int n3 = Math.abs(n2);
            return new StringBuilder(64 + String.valueOf(string).length()).append("com.google.android.exoplayer.MediaCodecTrackRenderer_").append(string).append(n3).toString();
        }
    }
}

