/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.google.vr.libraries.video.CameraMotionMetadataRendererV2;
import com.google.vr.libraries.video.FrameRotationBuffer;
import com.google.vr.libraries.video.MotionCoordinateSystem;
import com.google.vr.libraries.video.SphericalV2MediaCodecVideoRenderer;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import com.google.vr.sdk.widgets.video.deps.ae;
import com.google.vr.sdk.widgets.video.deps.aj;
import com.google.vr.sdk.widgets.video.deps.by;
import com.google.vr.sdk.widgets.video.deps.cc;
import com.google.vr.sdk.widgets.video.deps.e;
import com.google.vr.sdk.widgets.video.deps.g;
import com.google.vr.sdk.widgets.video.deps.gb;
import com.google.vr.sdk.widgets.video.deps.n;
import com.google.vr.sdk.widgets.video.deps.ne;
import com.google.vr.sdk.widgets.video.deps.rd;
import java.util.ArrayList;

public class VrSimpleExoPlayer
extends aj {
    private final CameraMotionMetadataRendererV2 cameraMotionRenderer;
    private final SphericalV2MediaCodecVideoRenderer videoRenderer;

    public VrSimpleExoPlayer(Context context) {
        super(new VrRenderersFactory(context), new ne(), new e(), null);
        CameraMotionMetadataRendererV2 cameraMotionMetadataRendererV2 = null;
        SphericalV2MediaCodecVideoRenderer sphericalV2MediaCodecVideoRenderer = null;
        for (ae ae2 : this.renderers) {
            if (ae2 instanceof CameraMotionMetadataRendererV2) {
                cameraMotionMetadataRendererV2 = (CameraMotionMetadataRendererV2)ae2;
                continue;
            }
            if (!(ae2 instanceof SphericalV2MediaCodecVideoRenderer)) continue;
            sphericalV2MediaCodecVideoRenderer = (SphericalV2MediaCodecVideoRenderer)ae2;
        }
        this.cameraMotionRenderer = cameraMotionMetadataRendererV2;
        this.videoRenderer = sphericalV2MediaCodecVideoRenderer;
    }

    public FrameRotationBuffer getFrameRotationBuffer() {
        return this.cameraMotionRenderer.getFrameRotationBuffer();
    }

    public void setProjectionListener(SphericalV2ProjectionDataListener sphericalV2ProjectionDataListener) {
        this.videoRenderer.setProjectionListener(sphericalV2ProjectionDataListener);
    }

    public long getSampleTimestampUsForReleaseTimeUs(long l2) {
        return this.videoRenderer.getSampleTimestampBuffer().getSampleTimestampUsForReleaseTimeUs(l2);
    }

    public n getInputFormat() {
        return this.videoRenderer.getInputFormat();
    }

    private static class VrRenderersFactory
    extends g {
        public VrRenderersFactory(Context context) {
            super(context);
        }

        @Override
        protected void buildVideoRenderers(Context context, by<cc> by2, long l2, Handler handler, rd rd2, int n2, ArrayList<ae> arrayList) {
            arrayList.add(new SphericalV2MediaCodecVideoRenderer(context, handler, by2, rd2, l2));
        }

        @Override
        protected void buildMetadataRenderers(Context context, gb gb2, Looper looper, int n2, ArrayList<ae> arrayList) {
            super.buildMetadataRenderers(context, gb2, looper, n2, arrayList);
            arrayList.add(new CameraMotionMetadataRendererV2(MotionCoordinateSystem.FLIP_XY));
        }
    }
}

