/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.google.vr.libraries.video.CameraMotionMetadataRendererV2;
import com.google.vr.libraries.video.FrameRotationBuffer;
import com.google.vr.libraries.video.MotionCoordinateSystem;
import com.google.vr.libraries.video.SphericalV2MediaCodecVideoRenderer;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import com.google.vr.sdk.widgets.video.deps.ab;
import com.google.vr.sdk.widgets.video.deps.ag;
import com.google.vr.sdk.widgets.video.deps.bo;
import com.google.vr.sdk.widgets.video.deps.bs;
import com.google.vr.sdk.widgets.video.deps.e;
import com.google.vr.sdk.widgets.video.deps.fq;
import com.google.vr.sdk.widgets.video.deps.g;
import com.google.vr.sdk.widgets.video.deps.mt;
import com.google.vr.sdk.widgets.video.deps.n;
import com.google.vr.sdk.widgets.video.deps.qq;
import java.util.ArrayList;

public class VrSimpleExoPlayer
extends ag {
    private final CameraMotionMetadataRendererV2 cameraMotionRenderer;
    private final SphericalV2MediaCodecVideoRenderer videoRenderer;

    public VrSimpleExoPlayer(Context context) {
        super(new VrRenderersFactory(context), new mt(), new e());
        CameraMotionMetadataRendererV2 cameraMotionMetadataRendererV2 = null;
        SphericalV2MediaCodecVideoRenderer sphericalV2MediaCodecVideoRenderer = null;
        for (ab ab2 : this.renderers) {
            if (ab2 instanceof CameraMotionMetadataRendererV2) {
                cameraMotionMetadataRendererV2 = (CameraMotionMetadataRendererV2)ab2;
                continue;
            }
            if (!(ab2 instanceof SphericalV2MediaCodecVideoRenderer)) continue;
            sphericalV2MediaCodecVideoRenderer = (SphericalV2MediaCodecVideoRenderer)ab2;
        }
        this.cameraMotionRenderer = cameraMotionMetadataRendererV2;
        this.videoRenderer = sphericalV2MediaCodecVideoRenderer;
    }

    public FrameRotationBuffer getFrameRotationBuffer() {
        return this.cameraMotionRenderer.getFrameRotationBuffer();
    }

    public void setProjectionListener(SphericalV2ProjectionDataListener sphericalV2ProjectionDataListener) {
        this.videoRenderer.setProjectionListener(sphericalV2ProjectionDataListener);
    }

    public long getSampleTimestampUsForReleaseTimeUs(long l2) {
        return this.videoRenderer.getSampleTimestampBuffer().getSampleTimestampUsForReleaseTimeUs(l2);
    }

    public n getInputFormat() {
        return this.videoRenderer.getInputFormat();
    }

    private static class VrRenderersFactory
    extends g {
        public VrRenderersFactory(Context context) {
            super(context);
        }

        @Override
        protected void buildVideoRenderers(Context context, bo<bs> bo2, long l2, Handler handler, qq qq2, int n2, ArrayList<ab> arrayList) {
            arrayList.add(new SphericalV2MediaCodecVideoRenderer(context, handler, bo2, qq2, l2));
        }

        @Override
        protected void buildMetadataRenderers(Context context, fq fq2, Looper looper, int n2, ArrayList<ab> arrayList) {
            super.buildMetadataRenderers(context, fq2, looper, n2, arrayList);
            arrayList.add(new CameraMotionMetadataRendererV2(MotionCoordinateSystem.FLIP_XY));
        }
    }
}

