/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import android.content.Context;
import android.media.MediaCodec;
import android.os.Handler;
import com.google.vr.libraries.video.SampleTimestampBuffer;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import com.google.vr.sdk.widgets.video.deps.bo;
import com.google.vr.sdk.widgets.video.deps.bs;
import com.google.vr.sdk.widgets.video.deps.fi;
import com.google.vr.sdk.widgets.video.deps.h;
import com.google.vr.sdk.widgets.video.deps.n;
import com.google.vr.sdk.widgets.video.deps.qn;
import com.google.vr.sdk.widgets.video.deps.qq;

public class SphericalV2MediaCodecVideoRenderer
extends qn {
    private static final int MAX_DROPPED_FRAME_COUNT_TO_NOTIFY = 1;
    private static final String TAG = SphericalV2MediaCodecVideoRenderer.class.getSimpleName();
    private final SampleTimestampBuffer sampleTimestampBuffer = new SampleTimestampBuffer();
    private SphericalV2ProjectionDataListener projectionListener;
    private n inputFormat;

    public SphericalV2MediaCodecVideoRenderer(Context context, Handler handler, bo<bs> bo2, qq qq2, long l2) {
        super(context, fi.a, l2, bo2, false, handler, qq2, 1);
    }

    public void setProjectionListener(SphericalV2ProjectionDataListener sphericalV2ProjectionDataListener) {
        this.projectionListener = sphericalV2ProjectionDataListener;
    }

    public SampleTimestampBuffer getSampleTimestampBuffer() {
        return this.sampleTimestampBuffer;
    }

    @Override
    protected void onInputFormatChanged(n n2) throws h {
        super.onInputFormatChanged(n2);
        this.inputFormat = n2;
        if (n2 != null) {
            this.projectionListener.onProjectionDataChanged(n2.q, n2.r);
        } else {
            this.projectionListener.onProjectionDataChanged(-1, null);
        }
    }

    public n getInputFormat() {
        return this.inputFormat;
    }

    @Override
    protected void onStreamChanged(n[] nArray, long l2) throws h {
        this.sampleTimestampBuffer.setPresentationTimeOffsetUs(l2);
        super.onStreamChanged(nArray, l2);
    }

    @Override
    protected void renderOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        this.sampleTimestampBuffer.addPresentationTimeUsForReleaseTimeUs(l2, System.nanoTime() / 1000L);
        super.renderOutputBuffer(mediaCodec, n2, l2);
    }

    @Override
    protected void renderOutputBufferV21(MediaCodec mediaCodec, int n2, long l2, long l3) {
        this.sampleTimestampBuffer.addPresentationTimeUsForReleaseTimeUs(l2, l3 / 1000L);
        super.renderOutputBufferV21(mediaCodec, n2, l2, l3);
    }
}

