/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import com.google.vr.libraries.video.FrameRotationBuffer;
import com.google.vr.libraries.video.MotionCoordinateSystem;
import com.google.vr.sdk.widgets.video.deps.a;
import com.google.vr.sdk.widgets.video.deps.be;
import com.google.vr.sdk.widgets.video.deps.h;
import com.google.vr.sdk.widgets.video.deps.n;
import com.google.vr.sdk.widgets.video.deps.o;
import com.google.vr.sdk.widgets.video.deps.pu;
import java.io.IOException;

public class CameraMotionMetadataRendererV2
extends a {
    private static final int SAMPLE_WINDOW_DURATION_US = 100000;
    private final o formatHolder = new o();
    private final be buffer = new be(1);
    private final MotionCoordinateSystem coordinateSystem;
    private volatile FrameRotationBuffer frameRotationBuffer;

    public CameraMotionMetadataRendererV2(MotionCoordinateSystem motionCoordinateSystem) {
        super(4);
        this.coordinateSystem = motionCoordinateSystem;
    }

    public FrameRotationBuffer getFrameRotationBuffer() {
        return this.frameRotationBuffer;
    }

    @Override
    protected void onDisabled() {
        this.frameRotationBuffer = null;
    }

    @Override
    public int supportsFormat(n n2) {
        return n2.h.equals("application/x-camera-motion") ? 4 : 0;
    }

    @Override
    public void render(long l2, long l3) throws h {
        if (this.frameRotationBuffer == null) {
            this.frameRotationBuffer = new FrameRotationBuffer(this.coordinateSystem);
        }
        while (!this.hasReadStreamToEnd()) {
            this.buffer.a();
            int n2 = this.readSource(this.formatHolder, this.buffer, false);
            if (n2 != -4 || this.buffer.c()) {
                return;
            }
            try {
                this.buffer.h();
                float[] fArray = CameraMotionMetadataRendererV2.parseMetadata(this.buffer.e.array(), this.buffer.e.limit());
                if (fArray != null) {
                    this.frameRotationBuffer.setRotation(this.buffer.f, fArray);
                }
            }
            catch (IOException iOException) {
                throw h.a(iOException, this.getIndex());
            }
            if (this.buffer.f <= l2 + 100000L) continue;
            return;
        }
    }

    @Override
    public boolean isEnded() {
        return this.hasReadStreamToEnd();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    private static float[] parseMetadata(byte[] byArray, int n2) throws IOException {
        pu pu2 = new pu(byArray, n2);
        if (pu2.t() != 0) {
            return null;
        }
        float[] fArray = new float[]{Float.intBitsToFloat(pu2.t()), Float.intBitsToFloat(pu2.t()), Float.intBitsToFloat(pu2.t())};
        return fArray;
    }
}

