/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import com.google.vr.sdk.widgets.video.deps.ae;
import com.google.vr.sdk.widgets.video.deps.am;
import com.google.vr.sdk.widgets.video.deps.ao;
import com.google.vr.sdk.widgets.video.deps.as;
import com.google.vr.sdk.widgets.video.deps.cg;
import com.google.vr.sdk.widgets.video.deps.ch;
import com.google.vr.sdk.widgets.video.deps.ci;
import com.google.vr.sdk.widgets.video.deps.cj;
import com.google.vr.sdk.widgets.video.deps.gU;
import com.google.vr.sdk.widgets.video.deps.h;
import com.google.vr.sdk.widgets.video.deps.hG;
import com.google.vr.sdk.widgets.video.deps.hJ;
import com.google.vr.sdk.widgets.video.deps.hL;
import com.google.vr.sdk.widgets.video.deps.hi;
import com.google.vr.sdk.widgets.video.deps.hw;
import com.google.vr.sdk.widgets.video.deps.hy;
import com.google.vr.sdk.widgets.video.deps.n;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class hI
extends ch {
    private static final String TAG = "MediaCodecVideoRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private static final int[] STANDARD_LONG_EDGE_VIDEO_PX = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private static final int MAX_PENDING_OUTPUT_STREAM_OFFSET_COUNT = 10;
    private final Context context;
    private final hJ frameReleaseTimeHelper;
    private final hL.a eventDispatcher;
    private final long allowedJoiningTimeMs;
    private final int maxDroppedFramesToNotify;
    private final boolean deviceNeedsAutoFrcWorkaround;
    private final long[] pendingOutputStreamOffsetsUs;
    private n[] streamFormats;
    private a codecMaxValues;
    private boolean codecNeedsSetOutputSurfaceWorkaround;
    private Surface surface;
    private Surface dummySurface;
    private int scalingMode;
    private boolean renderedFirstFrame;
    private boolean forceRenderFrame;
    private long joiningDeadlineMs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int buffersInCodecCount;
    private int pendingRotationDegrees;
    private float pendingPixelWidthHeightRatio;
    private int currentWidth;
    private int currentHeight;
    private int currentUnappliedRotationDegrees;
    private float currentPixelWidthHeightRatio;
    private int reportedWidth;
    private int reportedHeight;
    private int reportedUnappliedRotationDegrees;
    private float reportedPixelWidthHeightRatio;
    private boolean tunneling;
    private int tunnelingAudioSessionId;
    b tunnelingOnFrameRenderedListener;
    private long outputStreamOffsetUs;
    private int pendingOutputStreamOffsetCount;

    public hI(Context context, ci ci2) {
        this(context, ci2, 0L);
    }

    public hI(Context context, ci ci2, long l2) {
        this(context, ci2, l2, null, null, -1);
    }

    public hI(Context context, ci ci2, long l2, @Nullable Handler handler, @Nullable hL hL2, int n2) {
        this(context, ci2, l2, null, false, handler, hL2, n2);
    }

    public hI(Context context, ci ci2, long l2, @Nullable ao<as> ao2, boolean bl2, @Nullable Handler handler, @Nullable hL hL2, int n2) {
        super(2, ci2, ao2, bl2);
        this.allowedJoiningTimeMs = l2;
        this.maxDroppedFramesToNotify = n2;
        this.context = context.getApplicationContext();
        this.frameReleaseTimeHelper = new hJ(context);
        this.eventDispatcher = new hL.a(handler, hL2);
        this.deviceNeedsAutoFrcWorkaround = hI.deviceNeedsAutoFrcWorkaround();
        this.pendingOutputStreamOffsetsUs = new long[10];
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.joiningDeadlineMs = -9223372036854775807L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.scalingMode = 1;
        this.clearReportedVideoSize();
    }

    @Override
    protected int supportsFormat(ci ci2, ao<as> ao2, n n2) throws cj.b {
        int n3;
        int n4;
        cg cg2;
        String string = n2.h;
        if (!hi.b(string)) {
            return 0;
        }
        boolean bl2 = false;
        am am2 = n2.k;
        if (am2 != null) {
            for (int i2 = 0; i2 < am2.b; ++i2) {
                bl2 |= am2.a((int)i2).c;
            }
        }
        if ((cg2 = ci2.a(string, bl2)) == null) {
            return bl2 && ci2.a(string, false) != null ? 2 : 1;
        }
        if (!hI.supportsFormatDrm(ao2, am2)) {
            return 2;
        }
        boolean bl3 = cg2.b(n2.e);
        if (bl3 && n2.l > 0 && n2.m > 0) {
            if (hy.a >= 21) {
                bl3 = cg2.a(n2.l, n2.m, n2.n);
            } else {
                boolean bl4 = bl3 = n2.l * n2.m <= cj.b();
                if (!bl3) {
                    n4 = n2.l;
                    n3 = n2.m;
                    String string2 = hy.e;
                    Log.d((String)TAG, (String)new StringBuilder(56 + String.valueOf(string2).length()).append("FalseCheck [legacyFrameSize, ").append(n4).append("x").append(n3).append("] [").append(string2).append("]").toString());
                }
            }
        }
        n4 = cg2.c ? 16 : 8;
        n3 = cg2.d ? 32 : 0;
        int n5 = bl3 ? 4 : 3;
        return n4 | n3 | n5;
    }

    @Override
    protected void onEnabled(boolean bl2) throws h {
        super.onEnabled(bl2);
        this.tunnelingAudioSessionId = this.getConfiguration().b;
        this.tunneling = this.tunnelingAudioSessionId != 0;
        this.eventDispatcher.a(this.decoderCounters);
        this.frameReleaseTimeHelper.a();
    }

    @Override
    protected void onStreamChanged(n[] nArray, long l2) throws h {
        this.streamFormats = nArray;
        if (this.outputStreamOffsetUs == -9223372036854775807L) {
            this.outputStreamOffsetUs = l2;
        } else {
            if (this.pendingOutputStreamOffsetCount == this.pendingOutputStreamOffsetsUs.length) {
                long l3 = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
                Log.w((String)TAG, (String)new StringBuilder(65).append("Too many stream changes, so dropping offset: ").append(l3).toString());
            } else {
                ++this.pendingOutputStreamOffsetCount;
            }
            this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1] = l2;
        }
        super.onStreamChanged(nArray, l2);
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) throws h {
        super.onPositionReset(l2, bl2);
        this.clearRenderedFirstFrame();
        this.consecutiveDroppedFrameCount = 0;
        if (this.pendingOutputStreamOffsetCount != 0) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
            this.pendingOutputStreamOffsetCount = 0;
        }
        if (bl2) {
            this.setJoiningDeadlineMs();
        } else {
            this.joiningDeadlineMs = -9223372036854775807L;
        }
    }

    @Override
    public boolean isReady() {
        if (super.isReady() && (this.renderedFirstFrame || this.dummySurface != null && this.surface == this.dummySurface || this.getCodec() == null || this.tunneling)) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineMs = -9223372036854775807L;
        this.maybeNotifyDroppedFrames();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.pendingOutputStreamOffsetCount = 0;
        this.clearReportedVideoSize();
        this.clearRenderedFirstFrame();
        this.frameReleaseTimeHelper.b();
        this.tunnelingOnFrameRenderedListener = null;
        this.tunneling = false;
        try {
            super.onDisabled();
        }
        finally {
            this.decoderCounters.a();
            this.eventDispatcher.b(this.decoderCounters);
        }
    }

    @Override
    public void handleMessage(int n2, Object object) throws h {
        if (n2 == 1) {
            this.setSurface((Surface)object);
        } else if (n2 == 4) {
            this.scalingMode = (Integer)object;
            MediaCodec mediaCodec = this.getCodec();
            if (mediaCodec != null) {
                hI.setVideoScalingMode(mediaCodec, this.scalingMode);
            }
        } else {
            super.handleMessage(n2, object);
        }
    }

    private void setSurface(Surface surface) throws h {
        if (surface == null) {
            if (this.dummySurface != null) {
                surface = this.dummySurface;
            } else {
                cg cg2 = this.getCodecInfo();
                if (cg2 != null && this.shouldUseDummySurface(cg2)) {
                    surface = this.dummySurface = hG.a(this.context, cg2.e);
                }
            }
        }
        if (this.surface != surface) {
            this.surface = surface;
            int n2 = this.getState();
            if (n2 == 1 || n2 == 2) {
                MediaCodec mediaCodec = this.getCodec();
                if (hy.a >= 23 && mediaCodec != null && surface != null && !this.codecNeedsSetOutputSurfaceWorkaround) {
                    hI.setOutputSurfaceV23(mediaCodec, surface);
                } else {
                    this.releaseCodec();
                    this.maybeInitCodec();
                }
            }
            if (surface != null && surface != this.dummySurface) {
                this.maybeRenotifyVideoSizeChanged();
                this.clearRenderedFirstFrame();
                if (n2 == 2) {
                    this.setJoiningDeadlineMs();
                }
            } else {
                this.clearReportedVideoSize();
                this.clearRenderedFirstFrame();
            }
        } else if (surface != null && surface != this.dummySurface) {
            this.maybeRenotifyVideoSizeChanged();
            this.maybeRenotifyRenderedFirstFrame();
        }
    }

    @Override
    protected boolean shouldInitCodec(cg cg2) {
        return this.surface != null || this.shouldUseDummySurface(cg2);
    }

    @Override
    protected void configureCodec(cg cg2, MediaCodec mediaCodec, n n2, MediaCrypto mediaCrypto) throws cj.b {
        this.codecMaxValues = this.getCodecMaxValues(cg2, n2, this.streamFormats);
        MediaFormat mediaFormat = this.getMediaFormat(n2, this.codecMaxValues, this.deviceNeedsAutoFrcWorkaround, this.tunnelingAudioSessionId);
        if (this.surface == null) {
            gU.b(this.shouldUseDummySurface(cg2));
            if (this.dummySurface == null) {
                this.dummySurface = hG.a(this.context, cg2.e);
            }
            this.surface = this.dummySurface;
        }
        mediaCodec.configure(mediaFormat, this.surface, mediaCrypto, 0);
        if (hy.a >= 23 && this.tunneling) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    @Override
    @CallSuper
    protected void releaseCodec() {
        try {
            super.releaseCodec();
        }
        finally {
            this.buffersInCodecCount = 0;
            this.forceRenderFrame = false;
            if (this.dummySurface != null) {
                if (this.surface == this.dummySurface) {
                    this.surface = null;
                }
                this.dummySurface.release();
                this.dummySurface = null;
            }
        }
    }

    @Override
    @CallSuper
    protected void flushCodec() throws h {
        super.flushCodec();
        this.buffersInCodecCount = 0;
        this.forceRenderFrame = false;
    }

    @Override
    protected void onCodecInitialized(String string, long l2, long l3) {
        this.eventDispatcher.a(string, l2, l3);
        this.codecNeedsSetOutputSurfaceWorkaround = hI.codecNeedsSetOutputSurfaceWorkaround(string);
    }

    @Override
    protected void onInputFormatChanged(n n2) throws h {
        super.onInputFormatChanged(n2);
        this.eventDispatcher.a(n2);
        this.pendingPixelWidthHeightRatio = hI.getPixelWidthHeightRatio(n2);
        this.pendingRotationDegrees = hI.getRotationDegrees(n2);
    }

    @Override
    @CallSuper
    protected void onQueueInputBuffer(ae ae2) {
        ++this.buffersInCodecCount;
        if (hy.a < 23 && this.tunneling) {
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    @Override
    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        boolean bl2 = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
        this.currentWidth = bl2 ? mediaFormat.getInteger(KEY_CROP_RIGHT) - mediaFormat.getInteger(KEY_CROP_LEFT) + 1 : mediaFormat.getInteger("width");
        this.currentHeight = bl2 ? mediaFormat.getInteger(KEY_CROP_BOTTOM) - mediaFormat.getInteger(KEY_CROP_TOP) + 1 : mediaFormat.getInteger("height");
        this.currentPixelWidthHeightRatio = this.pendingPixelWidthHeightRatio;
        if (hy.a >= 21) {
            if (this.pendingRotationDegrees == 90 || this.pendingRotationDegrees == 270) {
                int n2 = this.currentWidth;
                this.currentWidth = this.currentHeight;
                this.currentHeight = n2;
                this.currentPixelWidthHeightRatio = 1.0f / this.currentPixelWidthHeightRatio;
            }
        } else {
            this.currentUnappliedRotationDegrees = this.pendingRotationDegrees;
        }
        hI.setVideoScalingMode(mediaCodec, this.scalingMode);
    }

    @Override
    protected boolean canReconfigureCodec(MediaCodec mediaCodec, boolean bl2, n n2, n n3) {
        return hI.areAdaptationCompatible(bl2, n2, n3) && n3.l <= this.codecMaxValues.a && n3.m <= this.codecMaxValues.b && hI.getMaxInputSize(n3) <= this.codecMaxValues.c;
    }

    @Override
    protected boolean processOutputBuffer(long l2, long l3, MediaCodec mediaCodec, ByteBuffer byteBuffer, int n2, int n3, long l4, boolean bl2) throws h {
        while (this.pendingOutputStreamOffsetCount != 0 && l4 >= this.pendingOutputStreamOffsetsUs[0]) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[0];
            --this.pendingOutputStreamOffsetCount;
            System.arraycopy(this.pendingOutputStreamOffsetsUs, 1, this.pendingOutputStreamOffsetsUs, 0, this.pendingOutputStreamOffsetCount);
        }
        long l5 = l4 - this.outputStreamOffsetUs;
        if (bl2) {
            this.skipOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        long l6 = l4 - l2;
        if (this.surface == this.dummySurface) {
            if (hI.isBufferLate(l6)) {
                this.forceRenderFrame = false;
                this.skipOutputBuffer(mediaCodec, n2, l5);
                return true;
            }
            return false;
        }
        if (!this.renderedFirstFrame || this.forceRenderFrame) {
            this.forceRenderFrame = false;
            if (hy.a >= 21) {
                this.renderOutputBufferV21(mediaCodec, n2, l5, System.nanoTime());
            } else {
                this.renderOutputBuffer(mediaCodec, n2, l5);
            }
            return true;
        }
        if (this.getState() != 2) {
            return false;
        }
        long l7 = SystemClock.elapsedRealtime() * 1000L - l3;
        l6 -= l7;
        long l8 = System.nanoTime();
        long l9 = l8 + l6 * 1000L;
        long l10 = this.frameReleaseTimeHelper.a(l4, l9);
        l6 = (l10 - l8) / 1000L;
        if (this.shouldDropBuffersToKeyframe(l6, l3) && this.maybeDropBuffersToKeyframe(mediaCodec, n2, l5, l2)) {
            this.forceRenderFrame = true;
            return false;
        }
        if (this.shouldDropOutputBuffer(l6, l3)) {
            this.dropOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        if (hy.a >= 21) {
            if (l6 < 50000L) {
                this.renderOutputBufferV21(mediaCodec, n2, l5, l10);
                return true;
            }
        } else if (l6 < 30000L) {
            if (l6 > 11000L) {
                try {
                    Thread.sleep((l6 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.renderOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        return false;
    }

    @Override
    @CallSuper
    protected void onProcessedOutputBuffer(long l2) {
        --this.buffersInCodecCount;
    }

    protected boolean shouldDropOutputBuffer(long l2, long l3) {
        return hI.isBufferLate(l2);
    }

    protected boolean shouldDropBuffersToKeyframe(long l2, long l3) {
        return hI.isBufferVeryLate(l2);
    }

    protected void skipOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        hw.a("skipVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        hw.a();
        ++this.decoderCounters.f;
    }

    protected void dropOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        hw.a("dropVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        hw.a();
        this.updateDroppedBufferCounters(1);
    }

    protected boolean maybeDropBuffersToKeyframe(MediaCodec mediaCodec, int n2, long l2, long l3) throws h {
        int n3 = this.skipSource(l3);
        if (n3 == 0) {
            return false;
        }
        ++this.decoderCounters.i;
        this.updateDroppedBufferCounters(this.buffersInCodecCount + n3);
        this.flushCodec();
        return true;
    }

    protected void updateDroppedBufferCounters(int n2) {
        this.decoderCounters.g += n2;
        this.droppedFrames += n2;
        this.consecutiveDroppedFrameCount += n2;
        this.decoderCounters.h = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.h);
        if (this.droppedFrames >= this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    protected void renderOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        this.maybeNotifyVideoSizeChanged();
        hw.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, true);
        hw.a();
        ++this.decoderCounters.e;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    @TargetApi(value=21)
    protected void renderOutputBufferV21(MediaCodec mediaCodec, int n2, long l2, long l3) {
        this.maybeNotifyVideoSizeChanged();
        hw.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, l3);
        hw.a();
        ++this.decoderCounters.e;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    private boolean shouldUseDummySurface(cg cg2) {
        return hy.a >= 23 && !this.tunneling && !hI.codecNeedsSetOutputSurfaceWorkaround(cg2.b) && (!cg2.e || hG.a(this.context));
    }

    private void setJoiningDeadlineMs() {
        this.joiningDeadlineMs = this.allowedJoiningTimeMs > 0L ? SystemClock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    private void clearRenderedFirstFrame() {
        MediaCodec mediaCodec;
        this.renderedFirstFrame = false;
        if (hy.a >= 23 && this.tunneling && (mediaCodec = this.getCodec()) != null) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    void maybeNotifyRenderedFirstFrame() {
        if (!this.renderedFirstFrame) {
            this.renderedFirstFrame = true;
            this.eventDispatcher.a(this.surface);
        }
    }

    private void maybeRenotifyRenderedFirstFrame() {
        if (this.renderedFirstFrame) {
            this.eventDispatcher.a(this.surface);
        }
    }

    private void clearReportedVideoSize() {
        this.reportedWidth = -1;
        this.reportedHeight = -1;
        this.reportedPixelWidthHeightRatio = -1.0f;
        this.reportedUnappliedRotationDegrees = -1;
    }

    private void maybeNotifyVideoSizeChanged() {
        if (!(this.currentWidth == -1 && this.currentHeight == -1 || this.reportedWidth == this.currentWidth && this.reportedHeight == this.currentHeight && this.reportedUnappliedRotationDegrees == this.currentUnappliedRotationDegrees && this.reportedPixelWidthHeightRatio == this.currentPixelWidthHeightRatio)) {
            this.eventDispatcher.a(this.currentWidth, this.currentHeight, this.currentUnappliedRotationDegrees, this.currentPixelWidthHeightRatio);
            this.reportedWidth = this.currentWidth;
            this.reportedHeight = this.currentHeight;
            this.reportedUnappliedRotationDegrees = this.currentUnappliedRotationDegrees;
            this.reportedPixelWidthHeightRatio = this.currentPixelWidthHeightRatio;
        }
    }

    private void maybeRenotifyVideoSizeChanged() {
        if (this.reportedWidth != -1 || this.reportedHeight != -1) {
            this.eventDispatcher.a(this.reportedWidth, this.reportedHeight, this.reportedUnappliedRotationDegrees, this.reportedPixelWidthHeightRatio);
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long l2 = SystemClock.elapsedRealtime();
            long l3 = l2 - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.a(this.droppedFrames, l3);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = l2;
        }
    }

    private static boolean isBufferLate(long l2) {
        return l2 < -30000L;
    }

    private static boolean isBufferVeryLate(long l2) {
        return l2 < -500000L;
    }

    @TargetApi(value=23)
    private static void setOutputSurfaceV23(MediaCodec mediaCodec, Surface surface) {
        mediaCodec.setOutputSurface(surface);
    }

    @TargetApi(value=21)
    private static void configureTunnelingV21(MediaFormat mediaFormat, int n2) {
        mediaFormat.setFeatureEnabled("tunneled-playback", true);
        mediaFormat.setInteger("audio-session-id", n2);
    }

    protected a getCodecMaxValues(cg cg2, n n2, n[] nArray) throws cj.b {
        int n3 = n2.l;
        int n4 = n2.m;
        int n5 = hI.getMaxInputSize(n2);
        if (nArray.length == 1) {
            return new a(n3, n4, n5);
        }
        boolean bl2 = false;
        for (n n6 : nArray) {
            if (!hI.areAdaptationCompatible(cg2.c, n2, n6)) continue;
            bl2 |= n6.l == -1 || n6.m == -1;
            n3 = Math.max(n3, n6.l);
            n4 = Math.max(n4, n6.m);
            n5 = Math.max(n5, hI.getMaxInputSize(n6));
        }
        if (bl2) {
            int n7 = n3;
            int n8 = n4;
            Log.w((String)TAG, (String)new StringBuilder(66).append("Resolutions unknown. Codec max resolution: ").append(n7).append("x").append(n8).toString());
            Point point = hI.getCodecMaxSize(cg2, n2);
            if (point != null) {
                n3 = Math.max(n3, point.x);
                n4 = Math.max(n4, point.y);
                n5 = Math.max(n5, hI.getMaxInputSize(n2.h, n3, n4));
                n8 = n3;
                int n9 = n4;
                Log.w((String)TAG, (String)new StringBuilder(57).append("Codec max resolution adjusted to: ").append(n8).append("x").append(n9).toString());
            }
        }
        return new a(n3, n4, n5);
    }

    @SuppressLint(value={"InlinedApi"})
    protected MediaFormat getMediaFormat(n n2, a a2, boolean bl2, int n3) {
        MediaFormat mediaFormat = this.getMediaFormatForPlayback(n2);
        mediaFormat.setInteger("max-width", a2.a);
        mediaFormat.setInteger("max-height", a2.b);
        if (a2.c != -1) {
            mediaFormat.setInteger("max-input-size", a2.c);
        }
        if (bl2) {
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (n3 != 0) {
            hI.configureTunnelingV21(mediaFormat, n3);
        }
        return mediaFormat;
    }

    private static Point getCodecMaxSize(cg cg2, n n2) throws cj.b {
        boolean bl2 = n2.m > n2.l;
        int n3 = bl2 ? n2.m : n2.l;
        int n4 = bl2 ? n2.l : n2.m;
        float f2 = (float)n4 / (float)n3;
        for (int n5 : STANDARD_LONG_EDGE_VIDEO_PX) {
            int n6 = (int)((float)n5 * f2);
            if (n5 <= n3 || n6 <= n4) {
                return null;
            }
            if (hy.a >= 21) {
                Point point = cg2.a(bl2 ? n6 : n5, bl2 ? n5 : n6);
                float f3 = n2.n;
                if (!cg2.a(point.x, point.y, f3)) continue;
                return point;
            }
            if ((n5 = hy.a(n5, 16) * 16) * (n6 = hy.a(n6, 16) * 16) > cj.b()) continue;
            return new Point(bl2 ? n6 : n5, bl2 ? n5 : n6);
        }
        return null;
    }

    private static int getMaxInputSize(n n2) {
        if (n2.i != -1) {
            int n3 = 0;
            int n4 = n2.j.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                n3 += n2.j.get(i2).length;
            }
            return n2.i + n3;
        }
        return hI.getMaxInputSize(n2.h, n2.l, n2.m);
    }

    private static int getMaxInputSize(String string, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == -1 || n3 == -1) {
            return -1;
        }
        switch (string) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(hy.d)) {
                    return -1;
                }
                n5 = hy.a(n2, 16) * hy.a(n3, 16) * 16 * 16;
                n4 = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                n5 = n2 * n3;
                n4 = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return n5 * 3 / (2 * n4);
    }

    private static void setVideoScalingMode(MediaCodec mediaCodec, int n2) {
        mediaCodec.setVideoScalingMode(n2);
    }

    private static boolean deviceNeedsAutoFrcWorkaround() {
        return hy.a <= 22 && "foster".equals(hy.b) && "NVIDIA".equals(hy.c);
    }

    private static boolean codecNeedsSetOutputSurfaceWorkaround(String string) {
        return ("deb".equals(hy.b) || "flo".equals(hy.b)) && "OMX.qcom.video.decoder.avc".equals(string) || ("tcl_eu".equals(hy.b) || "SVP-DTV15".equals(hy.b) || "BRAVIA_ATV2".equals(hy.b)) && "OMX.MTK.VIDEO.DECODER.AVC".equals(string) || "OMX.k3.video.decoder.avc".equals(string) && "ALE-L21".equals(hy.d);
    }

    private static boolean areAdaptationCompatible(boolean bl2, n n2, n n3) {
        return n2.h.equals(n3.h) && hI.getRotationDegrees(n2) == hI.getRotationDegrees(n3) && (bl2 || n2.l == n3.l && n2.m == n3.m);
    }

    private static float getPixelWidthHeightRatio(n n2) {
        return n2.p == -1.0f ? 1.0f : n2.p;
    }

    private static int getRotationDegrees(n n2) {
        return n2.o == -1 ? 0 : n2.o;
    }

    @TargetApi(value=23)
    private final class b
    implements MediaCodec.OnFrameRenderedListener {
        private b(MediaCodec mediaCodec) {
            mediaCodec.setOnFrameRenderedListener((MediaCodec.OnFrameRenderedListener)this, new Handler());
        }

        public void onFrameRendered(@NonNull MediaCodec mediaCodec, long l2, long l3) {
            if (this != hI.this.tunnelingOnFrameRenderedListener) {
                return;
            }
            hI.this.maybeNotifyRenderedFirstFrame();
        }
    }

    protected static final class a {
        public final int a;
        public final int b;
        public final int c;

        public a(int n2, int n3, int n4) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
        }
    }
}

