/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import com.google.vr.sdk.widgets.common.VrEventListener;
import com.google.vr.sdk.widgets.common.VrWidgetRenderer;
import com.google.vr.sdk.widgets.common.VrWidgetView;
import com.google.vr.sdk.widgets.video.VrVideoEventListener;
import com.google.vr.sdk.widgets.video.VrVideoPlayer;
import com.google.vr.sdk.widgets.video.VrVideoRenderer;
import com.google.vr.sdk.widgets.video.VrVideoView$$Lambda$0;
import com.google.vr.sdk.widgets.video.deps.ge;
import java.io.IOException;

public class VrVideoView
extends VrWidgetView {
    private static final String TAG = VrVideoView.class.getSimpleName();
    private static final boolean DEBUG = false;
    private VrVideoPlayer videoPlayer;
    private VrVideoRenderer renderer;

    public VrVideoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public VrVideoView(Context context) {
        super(context);
    }

    protected VrVideoRenderer createRenderer(Context context, VrWidgetRenderer.GLThreadScheduler gLThreadScheduler, float f2, float f3) {
        this.videoPlayer = new VrVideoPlayer(context, new VrVideoView$$Lambda$0(this));
        this.renderer = new VrVideoRenderer(this.videoPlayer, this.getContext(), gLThreadScheduler, f2, f3);
        return this.renderer;
    }

    public void pauseRendering() {
        super.pauseRendering();
        this.pauseVideo();
    }

    public void loadVideo(Uri uri, Options options) throws IOException {
        this.videoPlayer.openUri(uri, options);
    }

    public void loadVideoFromAsset(String string, Options options) throws IOException {
        this.videoPlayer.openAsset(string, options);
    }

    public void setMediaDataSourceFactory(ge.a a2) {
        this.videoPlayer.setMediaDataSourceFactory(a2);
    }

    public void setEventListener(VrVideoEventListener vrVideoEventListener) {
        super.setEventListener((VrEventListener)vrVideoEventListener);
        this.videoPlayer.setEventListener(vrVideoEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playVideo() {
        VrVideoPlayer vrVideoPlayer = this.videoPlayer;
        synchronized (vrVideoPlayer) {
            this.videoPlayer.getExoPlayer().setPlayWhenReady(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseVideo() {
        VrVideoPlayer vrVideoPlayer = this.videoPlayer;
        synchronized (vrVideoPlayer) {
            this.videoPlayer.getExoPlayer().setPlayWhenReady(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekTo(long l2) {
        VrVideoPlayer vrVideoPlayer = this.videoPlayer;
        synchronized (vrVideoPlayer) {
            this.videoPlayer.getExoPlayer().seekTo(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        long l2;
        VrVideoPlayer vrVideoPlayer = this.videoPlayer;
        synchronized (vrVideoPlayer) {
            l2 = this.videoPlayer.getExoPlayer().getDuration();
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentPosition() {
        long l2;
        VrVideoPlayer vrVideoPlayer = this.videoPlayer;
        synchronized (vrVideoPlayer) {
            l2 = this.videoPlayer.getExoPlayer().getCurrentPosition();
        }
        return l2;
    }

    public void setVolume(float f2) {
        this.videoPlayer.setVolume(f2);
    }

    final /* synthetic */ void lambda$createRenderer$0$VrVideoView() {
        this.renderer.setSphericalMetadata(this.videoPlayer.getMetadata());
    }

    public static class Options {
        private static final int FORMAT_START_MARKER = 0;
        public static final int FORMAT_DEFAULT = 1;
        public static final int FORMAT_HLS = 2;
        public static final int FORMAT_DASH = 3;
        private static final int FORMAT_END_MARKER = 4;
        public int inputFormat = 1;
        private static final int TYPE_START_MARKER = 0;
        public static final int TYPE_MONO = 1;
        public static final int TYPE_STEREO_OVER_UNDER = 2;
        private static final int TYPE_END_MARKER = 3;
        public int inputType = 1;

        public Options() {
        }

        public void validate() {
            int n2;
            if (this.inputFormat <= 0 || this.inputFormat >= 4) {
                n2 = this.inputFormat;
                Log.e((String)TAG, (String)new StringBuilder(40).append("Invalid Options.inputFormat: ").append(n2).toString());
                this.inputFormat = 1;
            }
            if (this.inputType <= 0 || this.inputType >= 3) {
                n2 = this.inputType;
                Log.e((String)TAG, (String)new StringBuilder(38).append("Invalid Options.inputType: ").append(n2).toString());
                this.inputType = 1;
            }
        }
    }
}

