/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.google.vr.libraries.video.CameraMotionMetadataRendererV2;
import com.google.vr.libraries.video.FrameRotationBuffer;
import com.google.vr.libraries.video.MotionCoordinateSystem;
import com.google.vr.libraries.video.SphericalV2MediaCodecVideoRenderer;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import com.google.vr.sdk.widgets.video.deps.B;
import com.google.vr.sdk.widgets.video.deps.G;
import com.google.vr.sdk.widgets.video.deps.ao;
import com.google.vr.sdk.widgets.video.deps.as;
import com.google.vr.sdk.widgets.video.deps.cp;
import com.google.vr.sdk.widgets.video.deps.e;
import com.google.vr.sdk.widgets.video.deps.fN;
import com.google.vr.sdk.widgets.video.deps.g;
import com.google.vr.sdk.widgets.video.deps.hL;
import com.google.vr.sdk.widgets.video.deps.n;
import java.util.ArrayList;

public class VrSimpleExoPlayer
extends G {
    private final CameraMotionMetadataRendererV2 cameraMotionRenderer;
    private final SphericalV2MediaCodecVideoRenderer videoRenderer;

    public VrSimpleExoPlayer(Context context) {
        super(new VrRenderersFactory(context), new fN(), new e());
        CameraMotionMetadataRendererV2 cameraMotionMetadataRendererV2 = null;
        SphericalV2MediaCodecVideoRenderer sphericalV2MediaCodecVideoRenderer = null;
        for (B b2 : this.renderers) {
            if (b2 instanceof CameraMotionMetadataRendererV2) {
                cameraMotionMetadataRendererV2 = (CameraMotionMetadataRendererV2)b2;
                continue;
            }
            if (!(b2 instanceof SphericalV2MediaCodecVideoRenderer)) continue;
            sphericalV2MediaCodecVideoRenderer = (SphericalV2MediaCodecVideoRenderer)b2;
        }
        this.cameraMotionRenderer = cameraMotionMetadataRendererV2;
        this.videoRenderer = sphericalV2MediaCodecVideoRenderer;
    }

    public FrameRotationBuffer getFrameRotationBuffer() {
        return this.cameraMotionRenderer.getFrameRotationBuffer();
    }

    public void setProjectionListener(SphericalV2ProjectionDataListener sphericalV2ProjectionDataListener) {
        this.videoRenderer.setProjectionListener(sphericalV2ProjectionDataListener);
    }

    public long getSampleTimestampUsForReleaseTimeUs(long l2) {
        return this.videoRenderer.getSampleTimestampBuffer().getSampleTimestampUsForReleaseTimeUs(l2);
    }

    public n getInputFormat() {
        return this.videoRenderer.getInputFormat();
    }

    private static class VrRenderersFactory
    extends g {
        public VrRenderersFactory(Context context) {
            super(context);
        }

        @Override
        protected void buildVideoRenderers(Context context, ao<as> ao2, long l2, Handler handler, hL hL2, int n2, ArrayList<B> arrayList) {
            arrayList.add(new SphericalV2MediaCodecVideoRenderer(context, handler, ao2, hL2, l2));
        }

        @Override
        protected void buildMetadataRenderers(Context context, cp cp2, Looper looper, int n2, ArrayList<B> arrayList) {
            super.buildMetadataRenderers(context, cp2, looper, n2, arrayList);
            arrayList.add(new CameraMotionMetadataRendererV2(MotionCoordinateSystem.FLIP_XY));
        }
    }
}

