/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import java.util.ArrayList;
import java.util.List;

public class ProjectionScene {
    private int crc;
    private Mesh[] meshes;
    private int stereoMode;

    public ProjectionScene(int n2) {
        this.crc = n2;
        this.meshes = new Mesh[2];
    }

    public Mesh getLeftMesh() {
        return this.meshes[0];
    }

    public void setLeftMesh(Mesh mesh) {
        this.meshes[0] = mesh;
    }

    public Mesh getRightMesh() {
        return this.meshes[1];
    }

    public void setRightMesh(Mesh mesh) {
        this.meshes[1] = mesh;
    }

    public int getCrc() {
        return this.crc;
    }

    public int getStereoMode() {
        return this.stereoMode;
    }

    public void setStereoMode(int n2) {
        this.stereoMode = n2;
    }

    public static class Mesh {
        private List<SubMesh> subMeshes = new ArrayList<SubMesh>();

        public Mesh() {
        }

        public void addSubMesh(SubMesh subMesh) {
            this.subMeshes.add(subMesh);
        }

        public int getSubMeshCount() {
            return this.subMeshes.size();
        }

        public SubMesh getSubMesh(int n2) {
            return this.subMeshes.get(n2);
        }
    }

    public static class SubMesh {
        private final int mode;
        private final float[] vertexBuffer;
        private final float[] textureCoordBuffer;
        private final int[] vertexIndices;

        public SubMesh(float[] fArray, float[] fArray2, int[] nArray, int n2) {
            this.vertexBuffer = fArray;
            this.textureCoordBuffer = fArray2;
            this.vertexIndices = nArray;
            this.mode = n2;
        }

        public int getMode() {
            return this.mode;
        }

        public float[] getVertexBuffer() {
            return this.vertexBuffer;
        }

        public float[] getTextureCoordBuffer() {
            return this.textureCoordBuffer;
        }

        public int[] getVertexIndices() {
            return this.vertexIndices;
        }

        public float[] getVertices() {
            return this.expandBuffer(this.vertexBuffer, 3);
        }

        public float[] getTextureCoords() {
            return this.expandBuffer(this.textureCoordBuffer, 2);
        }

        private float[] expandBuffer(float[] fArray, int n2) {
            int n3 = this.vertexIndices.length;
            float[] fArray2 = new float[n3 * n2];
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = i2 * n2;
                int n5 = this.vertexIndices[i2] * n2;
                for (int i3 = 0; i3 < n2; ++i3) {
                    fArray2[n4 + i3] = fArray[n5 + i3];
                }
            }
            return fArray2;
        }
    }
}

