/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import com.google.vr.sdk.widgets.video.deps.X;
import com.google.vr.sdk.widgets.video.deps.af;
import com.google.vr.sdk.widgets.video.deps.ah;
import com.google.vr.sdk.widgets.video.deps.al;
import com.google.vr.sdk.widgets.video.deps.bY;
import com.google.vr.sdk.widgets.video.deps.bZ;
import com.google.vr.sdk.widgets.video.deps.ca;
import com.google.vr.sdk.widgets.video.deps.cb;
import com.google.vr.sdk.widgets.video.deps.g;
import com.google.vr.sdk.widgets.video.deps.gA;
import com.google.vr.sdk.widgets.video.deps.gM;
import com.google.vr.sdk.widgets.video.deps.gZ;
import com.google.vr.sdk.widgets.video.deps.hb;
import com.google.vr.sdk.widgets.video.deps.hf;
import com.google.vr.sdk.widgets.video.deps.hi;
import com.google.vr.sdk.widgets.video.deps.hj;
import com.google.vr.sdk.widgets.video.deps.m;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class hh
extends bZ {
    private static final String TAG = "MediaCodecVideoRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private static final int[] STANDARD_LONG_EDGE_VIDEO_PX = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private static final int MAX_PENDING_OUTPUT_STREAM_OFFSET_COUNT = 10;
    private final Context context;
    private final hi frameReleaseTimeHelper;
    private final hj.a eventDispatcher;
    private final long allowedJoiningTimeMs;
    private final int maxDroppedFramesToNotify;
    private final boolean deviceNeedsAutoFrcWorkaround;
    private final long[] pendingOutputStreamOffsetsUs;
    private m[] streamFormats;
    private a codecMaxValues;
    private boolean codecNeedsSetOutputSurfaceWorkaround;
    private Surface surface;
    private Surface dummySurface;
    private int scalingMode;
    private boolean renderedFirstFrame;
    private boolean forceRenderFrame;
    private long joiningDeadlineMs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int buffersInCodecCount;
    private int pendingRotationDegrees;
    private float pendingPixelWidthHeightRatio;
    private int currentWidth;
    private int currentHeight;
    private int currentUnappliedRotationDegrees;
    private float currentPixelWidthHeightRatio;
    private int reportedWidth;
    private int reportedHeight;
    private int reportedUnappliedRotationDegrees;
    private float reportedPixelWidthHeightRatio;
    private boolean tunneling;
    private int tunnelingAudioSessionId;
    b tunnelingOnFrameRenderedListener;
    private long outputStreamOffsetUs;
    private int pendingOutputStreamOffsetCount;

    public hh(Context context, ca ca2) {
        this(context, ca2, 0L);
    }

    public hh(Context context, ca ca2, long l2) {
        this(context, ca2, l2, null, null, -1);
    }

    public hh(Context context, ca ca2, long l2, @Nullable Handler handler, @Nullable hj hj2, int n2) {
        this(context, ca2, l2, null, false, handler, hj2, n2);
    }

    public hh(Context context, ca ca2, long l2, @Nullable ah<al> ah2, boolean bl2, @Nullable Handler handler, @Nullable hj hj2, int n2) {
        super(2, ca2, ah2, bl2);
        this.allowedJoiningTimeMs = l2;
        this.maxDroppedFramesToNotify = n2;
        this.context = context.getApplicationContext();
        this.frameReleaseTimeHelper = new hi(context);
        this.eventDispatcher = new hj.a(handler, hj2);
        this.deviceNeedsAutoFrcWorkaround = hh.deviceNeedsAutoFrcWorkaround();
        this.pendingOutputStreamOffsetsUs = new long[10];
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.joiningDeadlineMs = -9223372036854775807L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.scalingMode = 1;
        this.clearReportedVideoSize();
    }

    @Override
    protected int supportsFormat(ca ca2, ah<al> ah2, m m2) throws cb.b {
        int n2;
        int n3;
        bY bY2;
        String string = m2.h;
        if (!gM.b(string)) {
            return 0;
        }
        boolean bl2 = false;
        af af2 = m2.k;
        if (af2 != null) {
            for (int i2 = 0; i2 < af2.b; ++i2) {
                bl2 |= af2.a((int)i2).c;
            }
        }
        if ((bY2 = ca2.a(string, bl2)) == null) {
            return bl2 && ca2.a(string, false) != null ? 2 : 1;
        }
        if (!hh.supportsFormatDrm(ah2, af2)) {
            return 2;
        }
        boolean bl3 = bY2.b(m2.e);
        if (bl3 && m2.l > 0 && m2.m > 0) {
            if (hb.a >= 21) {
                bl3 = bY2.a(m2.l, m2.m, m2.n);
            } else {
                boolean bl4 = bl3 = m2.l * m2.m <= cb.b();
                if (!bl3) {
                    n3 = m2.l;
                    n2 = m2.m;
                    String string2 = hb.e;
                    Log.d((String)TAG, (String)new StringBuilder(56 + String.valueOf(string2).length()).append("FalseCheck [legacyFrameSize, ").append(n3).append("x").append(n2).append("] [").append(string2).append("]").toString());
                }
            }
        }
        n3 = bY2.c ? 16 : 8;
        n2 = bY2.d ? 32 : 0;
        int n4 = bl3 ? 4 : 3;
        return n3 | n2 | n4;
    }

    @Override
    protected void onEnabled(boolean bl2) throws g {
        super.onEnabled(bl2);
        this.tunnelingAudioSessionId = this.getConfiguration().b;
        this.tunneling = this.tunnelingAudioSessionId != 0;
        this.eventDispatcher.a(this.decoderCounters);
        this.frameReleaseTimeHelper.a();
    }

    @Override
    protected void onStreamChanged(m[] mArray, long l2) throws g {
        this.streamFormats = mArray;
        if (this.outputStreamOffsetUs == -9223372036854775807L) {
            this.outputStreamOffsetUs = l2;
        } else {
            if (this.pendingOutputStreamOffsetCount == this.pendingOutputStreamOffsetsUs.length) {
                long l3 = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
                Log.w((String)TAG, (String)new StringBuilder(65).append("Too many stream changes, so dropping offset: ").append(l3).toString());
            } else {
                ++this.pendingOutputStreamOffsetCount;
            }
            this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1] = l2;
        }
        super.onStreamChanged(mArray, l2);
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) throws g {
        super.onPositionReset(l2, bl2);
        this.clearRenderedFirstFrame();
        this.consecutiveDroppedFrameCount = 0;
        if (this.pendingOutputStreamOffsetCount != 0) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
            this.pendingOutputStreamOffsetCount = 0;
        }
        if (bl2) {
            this.setJoiningDeadlineMs();
        } else {
            this.joiningDeadlineMs = -9223372036854775807L;
        }
    }

    @Override
    public boolean isReady() {
        if (super.isReady() && (this.renderedFirstFrame || this.dummySurface != null && this.surface == this.dummySurface || this.getCodec() == null || this.tunneling)) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineMs = -9223372036854775807L;
        this.maybeNotifyDroppedFrames();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.pendingPixelWidthHeightRatio = -1.0f;
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.pendingOutputStreamOffsetCount = 0;
        this.clearReportedVideoSize();
        this.clearRenderedFirstFrame();
        this.frameReleaseTimeHelper.b();
        this.tunnelingOnFrameRenderedListener = null;
        this.tunneling = false;
        try {
            super.onDisabled();
        }
        finally {
            this.decoderCounters.a();
            this.eventDispatcher.b(this.decoderCounters);
        }
    }

    @Override
    public void handleMessage(int n2, Object object) throws g {
        if (n2 == 1) {
            this.setSurface((Surface)object);
        } else if (n2 == 4) {
            this.scalingMode = (Integer)object;
            MediaCodec mediaCodec = this.getCodec();
            if (mediaCodec != null) {
                hh.setVideoScalingMode(mediaCodec, this.scalingMode);
            }
        } else {
            super.handleMessage(n2, object);
        }
    }

    private void setSurface(Surface surface) throws g {
        if (surface == null) {
            if (this.dummySurface != null) {
                surface = this.dummySurface;
            } else {
                bY bY2 = this.getCodecInfo();
                if (bY2 != null && this.shouldUseDummySurface(bY2.e)) {
                    surface = this.dummySurface = hf.a(this.context, bY2.e);
                }
            }
        }
        if (this.surface != surface) {
            this.surface = surface;
            int n2 = this.getState();
            if (n2 == 1 || n2 == 2) {
                MediaCodec mediaCodec = this.getCodec();
                if (hb.a >= 23 && mediaCodec != null && surface != null && !this.codecNeedsSetOutputSurfaceWorkaround) {
                    hh.setOutputSurfaceV23(mediaCodec, surface);
                } else {
                    this.releaseCodec();
                    this.maybeInitCodec();
                }
            }
            if (surface != null && surface != this.dummySurface) {
                this.maybeRenotifyVideoSizeChanged();
                this.clearRenderedFirstFrame();
                if (n2 == 2) {
                    this.setJoiningDeadlineMs();
                }
            } else {
                this.clearReportedVideoSize();
                this.clearRenderedFirstFrame();
            }
        } else if (surface != null && surface != this.dummySurface) {
            this.maybeRenotifyVideoSizeChanged();
            this.maybeRenotifyRenderedFirstFrame();
        }
    }

    @Override
    protected boolean shouldInitCodec(bY bY2) {
        return this.surface != null || this.shouldUseDummySurface(bY2.e);
    }

    @Override
    protected void configureCodec(bY bY2, MediaCodec mediaCodec, m m2, MediaCrypto mediaCrypto) throws cb.b {
        this.codecMaxValues = this.getCodecMaxValues(bY2, m2, this.streamFormats);
        MediaFormat mediaFormat = this.getMediaFormat(m2, this.codecMaxValues, this.deviceNeedsAutoFrcWorkaround, this.tunnelingAudioSessionId);
        if (this.surface == null) {
            gA.b(this.shouldUseDummySurface(bY2.e));
            if (this.dummySurface == null) {
                this.dummySurface = hf.a(this.context, bY2.e);
            }
            this.surface = this.dummySurface;
        }
        mediaCodec.configure(mediaFormat, this.surface, mediaCrypto, 0);
        if (hb.a >= 23 && this.tunneling) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    @Override
    @CallSuper
    protected void releaseCodec() {
        try {
            super.releaseCodec();
        }
        finally {
            this.buffersInCodecCount = 0;
            this.forceRenderFrame = false;
            if (this.dummySurface != null) {
                if (this.surface == this.dummySurface) {
                    this.surface = null;
                }
                this.dummySurface.release();
                this.dummySurface = null;
            }
        }
    }

    @Override
    @CallSuper
    protected void flushCodec() throws g {
        super.flushCodec();
        this.buffersInCodecCount = 0;
        this.forceRenderFrame = false;
    }

    @Override
    protected void onCodecInitialized(String string, long l2, long l3) {
        this.eventDispatcher.a(string, l2, l3);
        this.codecNeedsSetOutputSurfaceWorkaround = hh.codecNeedsSetOutputSurfaceWorkaround(string);
    }

    @Override
    protected void onInputFormatChanged(m m2) throws g {
        super.onInputFormatChanged(m2);
        this.eventDispatcher.a(m2);
        this.pendingPixelWidthHeightRatio = hh.getPixelWidthHeightRatio(m2);
        this.pendingRotationDegrees = hh.getRotationDegrees(m2);
    }

    @Override
    @CallSuper
    protected void onQueueInputBuffer(X x2) {
        ++this.buffersInCodecCount;
        if (hb.a < 23 && this.tunneling) {
            this.maybeNotifyRenderedFirstFrame();
        }
    }

    @Override
    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        boolean bl2 = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
        this.currentWidth = bl2 ? mediaFormat.getInteger(KEY_CROP_RIGHT) - mediaFormat.getInteger(KEY_CROP_LEFT) + 1 : mediaFormat.getInteger("width");
        this.currentHeight = bl2 ? mediaFormat.getInteger(KEY_CROP_BOTTOM) - mediaFormat.getInteger(KEY_CROP_TOP) + 1 : mediaFormat.getInteger("height");
        this.currentPixelWidthHeightRatio = this.pendingPixelWidthHeightRatio;
        if (hb.a >= 21) {
            if (this.pendingRotationDegrees == 90 || this.pendingRotationDegrees == 270) {
                int n2 = this.currentWidth;
                this.currentWidth = this.currentHeight;
                this.currentHeight = n2;
                this.currentPixelWidthHeightRatio = 1.0f / this.currentPixelWidthHeightRatio;
            }
        } else {
            this.currentUnappliedRotationDegrees = this.pendingRotationDegrees;
        }
        hh.setVideoScalingMode(mediaCodec, this.scalingMode);
    }

    @Override
    protected boolean canReconfigureCodec(MediaCodec mediaCodec, boolean bl2, m m2, m m3) {
        return hh.areAdaptationCompatible(bl2, m2, m3) && m3.l <= this.codecMaxValues.a && m3.m <= this.codecMaxValues.b && hh.getMaxInputSize(m3) <= this.codecMaxValues.c;
    }

    @Override
    protected boolean processOutputBuffer(long l2, long l3, MediaCodec mediaCodec, ByteBuffer byteBuffer, int n2, int n3, long l4, boolean bl2) throws g {
        while (this.pendingOutputStreamOffsetCount != 0 && l4 >= this.pendingOutputStreamOffsetsUs[0]) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[0];
            --this.pendingOutputStreamOffsetCount;
            System.arraycopy(this.pendingOutputStreamOffsetsUs, 1, this.pendingOutputStreamOffsetsUs, 0, this.pendingOutputStreamOffsetCount);
        }
        long l5 = l4 - this.outputStreamOffsetUs;
        if (bl2) {
            this.skipOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        long l6 = l4 - l2;
        if (this.surface == this.dummySurface) {
            if (hh.isBufferLate(l6)) {
                this.forceRenderFrame = false;
                this.skipOutputBuffer(mediaCodec, n2, l5);
                return true;
            }
            return false;
        }
        if (!this.renderedFirstFrame || this.forceRenderFrame) {
            this.forceRenderFrame = false;
            if (hb.a >= 21) {
                this.renderOutputBufferV21(mediaCodec, n2, l5, System.nanoTime());
            } else {
                this.renderOutputBuffer(mediaCodec, n2, l5);
            }
            return true;
        }
        if (this.getState() != 2) {
            return false;
        }
        long l7 = SystemClock.elapsedRealtime() * 1000L - l3;
        l6 -= l7;
        long l8 = System.nanoTime();
        long l9 = l8 + l6 * 1000L;
        long l10 = this.frameReleaseTimeHelper.a(l4, l9);
        l6 = (l10 - l8) / 1000L;
        if (this.shouldDropBuffersToKeyframe(l6, l3) && this.maybeDropBuffersToKeyframe(mediaCodec, n2, l5, l2)) {
            this.forceRenderFrame = true;
            return false;
        }
        if (this.shouldDropOutputBuffer(l6, l3)) {
            this.dropOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        if (hb.a >= 21) {
            if (l6 < 50000L) {
                this.renderOutputBufferV21(mediaCodec, n2, l5, l10);
                return true;
            }
        } else if (l6 < 30000L) {
            if (l6 > 11000L) {
                try {
                    Thread.sleep((l6 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.renderOutputBuffer(mediaCodec, n2, l5);
            return true;
        }
        return false;
    }

    @Override
    @CallSuper
    protected void onProcessedOutputBuffer(long l2) {
        --this.buffersInCodecCount;
    }

    protected boolean shouldDropOutputBuffer(long l2, long l3) {
        return hh.isBufferLate(l2);
    }

    protected boolean shouldDropBuffersToKeyframe(long l2, long l3) {
        return hh.isBufferVeryLate(l2);
    }

    protected void skipOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        gZ.a("skipVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        gZ.a();
        ++this.decoderCounters.f;
    }

    protected void dropOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        gZ.a("dropVideoBuffer");
        mediaCodec.releaseOutputBuffer(n2, false);
        gZ.a();
        this.updateDroppedBufferCounters(1);
    }

    protected boolean maybeDropBuffersToKeyframe(MediaCodec mediaCodec, int n2, long l2, long l3) throws g {
        int n3 = this.skipSource(l3);
        if (n3 == 0) {
            return false;
        }
        ++this.decoderCounters.i;
        this.updateDroppedBufferCounters(this.buffersInCodecCount + n3);
        this.flushCodec();
        return true;
    }

    protected void updateDroppedBufferCounters(int n2) {
        this.decoderCounters.g += n2;
        this.droppedFrames += n2;
        this.consecutiveDroppedFrameCount += n2;
        this.decoderCounters.h = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.h);
        if (this.droppedFrames >= this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    protected void renderOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        this.maybeNotifyVideoSizeChanged();
        gZ.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, true);
        gZ.a();
        ++this.decoderCounters.e;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    @TargetApi(value=21)
    protected void renderOutputBufferV21(MediaCodec mediaCodec, int n2, long l2, long l3) {
        this.maybeNotifyVideoSizeChanged();
        gZ.a("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n2, l3);
        gZ.a();
        ++this.decoderCounters.e;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    private boolean shouldUseDummySurface(boolean bl2) {
        return hb.a >= 23 && !this.tunneling && (!bl2 || hf.a(this.context));
    }

    private void setJoiningDeadlineMs() {
        this.joiningDeadlineMs = this.allowedJoiningTimeMs > 0L ? SystemClock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    private void clearRenderedFirstFrame() {
        MediaCodec mediaCodec;
        this.renderedFirstFrame = false;
        if (hb.a >= 23 && this.tunneling && (mediaCodec = this.getCodec()) != null) {
            this.tunnelingOnFrameRenderedListener = new b(mediaCodec);
        }
    }

    void maybeNotifyRenderedFirstFrame() {
        if (!this.renderedFirstFrame) {
            this.renderedFirstFrame = true;
            this.eventDispatcher.a(this.surface);
        }
    }

    private void maybeRenotifyRenderedFirstFrame() {
        if (this.renderedFirstFrame) {
            this.eventDispatcher.a(this.surface);
        }
    }

    private void clearReportedVideoSize() {
        this.reportedWidth = -1;
        this.reportedHeight = -1;
        this.reportedPixelWidthHeightRatio = -1.0f;
        this.reportedUnappliedRotationDegrees = -1;
    }

    private void maybeNotifyVideoSizeChanged() {
        if (!(this.currentWidth == -1 && this.currentHeight == -1 || this.reportedWidth == this.currentWidth && this.reportedHeight == this.currentHeight && this.reportedUnappliedRotationDegrees == this.currentUnappliedRotationDegrees && this.reportedPixelWidthHeightRatio == this.currentPixelWidthHeightRatio)) {
            this.eventDispatcher.a(this.currentWidth, this.currentHeight, this.currentUnappliedRotationDegrees, this.currentPixelWidthHeightRatio);
            this.reportedWidth = this.currentWidth;
            this.reportedHeight = this.currentHeight;
            this.reportedUnappliedRotationDegrees = this.currentUnappliedRotationDegrees;
            this.reportedPixelWidthHeightRatio = this.currentPixelWidthHeightRatio;
        }
    }

    private void maybeRenotifyVideoSizeChanged() {
        if (this.reportedWidth != -1 || this.reportedHeight != -1) {
            this.eventDispatcher.a(this.reportedWidth, this.reportedHeight, this.reportedUnappliedRotationDegrees, this.reportedPixelWidthHeightRatio);
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long l2 = SystemClock.elapsedRealtime();
            long l3 = l2 - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.a(this.droppedFrames, l3);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = l2;
        }
    }

    private static boolean isBufferLate(long l2) {
        return l2 < -30000L;
    }

    private static boolean isBufferVeryLate(long l2) {
        return l2 < -500000L;
    }

    @TargetApi(value=23)
    private static void setOutputSurfaceV23(MediaCodec mediaCodec, Surface surface) {
        mediaCodec.setOutputSurface(surface);
    }

    @TargetApi(value=21)
    private static void configureTunnelingV21(MediaFormat mediaFormat, int n2) {
        mediaFormat.setFeatureEnabled("tunneled-playback", true);
        mediaFormat.setInteger("audio-session-id", n2);
    }

    protected a getCodecMaxValues(bY bY2, m m2, m[] mArray) throws cb.b {
        int n2 = m2.l;
        int n3 = m2.m;
        int n4 = hh.getMaxInputSize(m2);
        if (mArray.length == 1) {
            return new a(n2, n3, n4);
        }
        boolean bl2 = false;
        for (m m3 : mArray) {
            if (!hh.areAdaptationCompatible(bY2.c, m2, m3)) continue;
            bl2 |= m3.l == -1 || m3.m == -1;
            n2 = Math.max(n2, m3.l);
            n3 = Math.max(n3, m3.m);
            n4 = Math.max(n4, hh.getMaxInputSize(m3));
        }
        if (bl2) {
            int n5 = n2;
            int n6 = n3;
            Log.w((String)TAG, (String)new StringBuilder(66).append("Resolutions unknown. Codec max resolution: ").append(n5).append("x").append(n6).toString());
            Point point = hh.getCodecMaxSize(bY2, m2);
            if (point != null) {
                n2 = Math.max(n2, point.x);
                n3 = Math.max(n3, point.y);
                n4 = Math.max(n4, hh.getMaxInputSize(m2.h, n2, n3));
                n6 = n2;
                int n7 = n3;
                Log.w((String)TAG, (String)new StringBuilder(57).append("Codec max resolution adjusted to: ").append(n6).append("x").append(n7).toString());
            }
        }
        return new a(n2, n3, n4);
    }

    @SuppressLint(value={"InlinedApi"})
    protected MediaFormat getMediaFormat(m m2, a a2, boolean bl2, int n2) {
        MediaFormat mediaFormat = m2.b();
        mediaFormat.setInteger("max-width", a2.a);
        mediaFormat.setInteger("max-height", a2.b);
        if (a2.c != -1) {
            mediaFormat.setInteger("max-input-size", a2.c);
        }
        if (bl2) {
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (n2 != 0) {
            hh.configureTunnelingV21(mediaFormat, n2);
        }
        return mediaFormat;
    }

    private static Point getCodecMaxSize(bY bY2, m m2) throws cb.b {
        boolean bl2 = m2.m > m2.l;
        int n2 = bl2 ? m2.m : m2.l;
        int n3 = bl2 ? m2.l : m2.m;
        float f2 = (float)n3 / (float)n2;
        for (int n4 : STANDARD_LONG_EDGE_VIDEO_PX) {
            int n5 = (int)((float)n4 * f2);
            if (n4 <= n2 || n5 <= n3) {
                return null;
            }
            if (hb.a >= 21) {
                Point point = bY2.a(bl2 ? n5 : n4, bl2 ? n4 : n5);
                float f3 = m2.n;
                if (!bY2.a(point.x, point.y, f3)) continue;
                return point;
            }
            if ((n4 = hb.a(n4, 16) * 16) * (n5 = hb.a(n5, 16) * 16) > cb.b()) continue;
            return new Point(bl2 ? n5 : n4, bl2 ? n4 : n5);
        }
        return null;
    }

    private static int getMaxInputSize(m m2) {
        if (m2.i != -1) {
            int n2 = 0;
            int n3 = m2.j.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 += m2.j.get(i2).length;
            }
            return m2.i + n2;
        }
        return hh.getMaxInputSize(m2.h, m2.l, m2.m);
    }

    private static int getMaxInputSize(String string, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == -1 || n3 == -1) {
            return -1;
        }
        switch (string) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(hb.d)) {
                    return -1;
                }
                n5 = hb.a(n2, 16) * hb.a(n3, 16) * 16 * 16;
                n4 = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                n5 = n2 * n3;
                n4 = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                n5 = n2 * n3;
                n4 = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return n5 * 3 / (2 * n4);
    }

    private static void setVideoScalingMode(MediaCodec mediaCodec, int n2) {
        mediaCodec.setVideoScalingMode(n2);
    }

    private static boolean deviceNeedsAutoFrcWorkaround() {
        return hb.a <= 22 && "foster".equals(hb.b) && "NVIDIA".equals(hb.c);
    }

    private static boolean codecNeedsSetOutputSurfaceWorkaround(String string) {
        return ("deb".equals(hb.b) || "flo".equals(hb.b)) && "OMX.qcom.video.decoder.avc".equals(string) || ("tcl_eu".equals(hb.b) || "SVP-DTV15".equals(hb.b) || "BRAVIA_ATV2".equals(hb.b)) && "OMX.MTK.VIDEO.DECODER.AVC".equals(string);
    }

    private static boolean areAdaptationCompatible(boolean bl2, m m2, m m3) {
        return m2.h.equals(m3.h) && hh.getRotationDegrees(m2) == hh.getRotationDegrees(m3) && (bl2 || m2.l == m3.l && m2.m == m3.m);
    }

    private static float getPixelWidthHeightRatio(m m2) {
        return m2.p == -1.0f ? 1.0f : m2.p;
    }

    private static int getRotationDegrees(m m2) {
        return m2.o == -1 ? 0 : m2.o;
    }

    @TargetApi(value=23)
    private final class b
    implements MediaCodec.OnFrameRenderedListener {
        private b(MediaCodec mediaCodec) {
            mediaCodec.setOnFrameRenderedListener((MediaCodec.OnFrameRenderedListener)this, new Handler());
        }

        public void onFrameRendered(@NonNull MediaCodec mediaCodec, long l2, long l3) {
            if (this != hh.this.tunnelingOnFrameRenderedListener) {
                return;
            }
            hh.this.maybeNotifyRenderedFirstFrame();
        }
    }

    protected static final class a {
        public final int a;
        public final int b;
        public final int c;

        public a(int n2, int n3, int n4) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
        }
    }
}

