/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.media.PlaybackParams;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import com.google.vr.sdk.widgets.video.deps.B;
import com.google.vr.sdk.widgets.video.deps.D;
import com.google.vr.sdk.widgets.video.deps.I;
import com.google.vr.sdk.widgets.video.deps.W;
import com.google.vr.sdk.widgets.video.deps.cc;
import com.google.vr.sdk.widgets.video.deps.ch;
import com.google.vr.sdk.widgets.video.deps.dd;
import com.google.vr.sdk.widgets.video.deps.dp;
import com.google.vr.sdk.widgets.video.deps.eB;
import com.google.vr.sdk.widgets.video.deps.eK;
import com.google.vr.sdk.widgets.video.deps.fy;
import com.google.vr.sdk.widgets.video.deps.fz;
import com.google.vr.sdk.widgets.video.deps.h;
import com.google.vr.sdk.widgets.video.deps.hb;
import com.google.vr.sdk.widgets.video.deps.hj;
import com.google.vr.sdk.widgets.video.deps.j;
import com.google.vr.sdk.widgets.video.deps.m;
import com.google.vr.sdk.widgets.video.deps.p;
import com.google.vr.sdk.widgets.video.deps.u;
import com.google.vr.sdk.widgets.video.deps.v;
import com.google.vr.sdk.widgets.video.deps.w;
import com.google.vr.sdk.widgets.video.deps.z;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;

@TargetApi(value=16)
public class A
implements h {
    private static final String TAG = "SimpleExoPlayer";
    protected final w[] renderers;
    private final h player;
    private final a componentListener = new a();
    private final CopyOnWriteArraySet<b> videoListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<eK> textOutputs = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<ch> metadataOutputs = new CopyOnWriteArraySet();
    private final int videoRendererCount;
    private final int audioRendererCount;
    private m videoFormat;
    private m audioFormat;
    private Surface surface;
    private boolean ownsSurface;
    private int videoScalingMode;
    private SurfaceHolder surfaceHolder;
    private TextureView textureView;
    private I audioDebugListener;
    private hj videoDebugListener;
    private W videoDecoderCounters;
    private W audioDecoderCounters;
    private int audioSessionId;
    private D audioAttributes;
    private float audioVolume;

    protected A(z z2, fz fz2, p p2) {
        Looper looper = Looper.myLooper() != null ? Looper.myLooper() : Looper.getMainLooper();
        Handler handler = new Handler(looper);
        this.renderers = z2.createRenderers(handler, this.componentListener, this.componentListener, this.componentListener, this.componentListener);
        int n2 = 0;
        int n3 = 0;
        block4: for (w w2 : this.renderers) {
            switch (w2.getTrackType()) {
                case 2: {
                    ++n2;
                    continue block4;
                }
                case 1: {
                    ++n3;
                }
            }
        }
        this.videoRendererCount = n2;
        this.audioRendererCount = n3;
        this.audioVolume = 1.0f;
        this.audioSessionId = 0;
        this.audioAttributes = D.a;
        this.videoScalingMode = 1;
        this.player = this.createExoPlayerImpl(this.renderers, fz2, p2);
    }

    public void setVideoScalingMode(int n2) {
        this.videoScalingMode = n2;
        h.c[] cArray = new h.c[this.videoRendererCount];
        int n3 = 0;
        for (w w2 : this.renderers) {
            if (w2.getTrackType() != 2) continue;
            cArray[n3++] = new h.c(w2, 4, n2);
        }
        this.player.sendMessages(cArray);
    }

    public int getVideoScalingMode() {
        return this.videoScalingMode;
    }

    public void clearVideoSurface() {
        this.setVideoSurface(null);
    }

    public void setVideoSurface(Surface surface) {
        this.removeSurfaceCallbacks();
        this.setVideoSurfaceInternal(surface, false);
    }

    public void clearVideoSurface(Surface surface) {
        if (surface != null && surface == this.surface) {
            this.setVideoSurface(null);
        }
    }

    public void setVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.removeSurfaceCallbacks();
        this.surfaceHolder = surfaceHolder;
        if (surfaceHolder == null) {
            this.setVideoSurfaceInternal(null, false);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
            Surface surface = surfaceHolder.getSurface();
            this.setVideoSurfaceInternal(surface != null && surface.isValid() ? surface : null, false);
        }
    }

    public void clearVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        if (surfaceHolder != null && surfaceHolder == this.surfaceHolder) {
            this.setVideoSurfaceHolder(null);
        }
    }

    public void setVideoSurfaceView(SurfaceView surfaceView) {
        this.setVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    public void clearVideoSurfaceView(SurfaceView surfaceView) {
        this.clearVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    public void setVideoTextureView(TextureView textureView) {
        this.removeSurfaceCallbacks();
        this.textureView = textureView;
        if (textureView == null) {
            this.setVideoSurfaceInternal(null, true);
        } else {
            if (textureView.getSurfaceTextureListener() != null) {
                Log.w((String)TAG, (String)"Replacing existing SurfaceTextureListener.");
            }
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.componentListener);
            SurfaceTexture surfaceTexture = textureView.isAvailable() ? textureView.getSurfaceTexture() : null;
            this.setVideoSurfaceInternal(surfaceTexture == null ? null : new Surface(surfaceTexture), true);
        }
    }

    public void clearVideoTextureView(TextureView textureView) {
        if (textureView != null && textureView == this.textureView) {
            this.setVideoTextureView(null);
        }
    }

    @Deprecated
    public void setAudioStreamType(int n2) {
        int n3 = hb.c(n2);
        int n4 = hb.d(n2);
        D d2 = new D.a().c(n3).a(n4).a();
        this.setAudioAttributes(d2);
    }

    @Deprecated
    public int getAudioStreamType() {
        return hb.e(this.audioAttributes.d);
    }

    public void setAudioAttributes(D d2) {
        this.audioAttributes = d2;
        h.c[] cArray = new h.c[this.audioRendererCount];
        int n2 = 0;
        for (w w2 : this.renderers) {
            if (w2.getTrackType() != 1) continue;
            cArray[n2++] = new h.c(w2, 3, d2);
        }
        this.player.sendMessages(cArray);
    }

    public D getAudioAttributes() {
        return this.audioAttributes;
    }

    public void setVolume(float f2) {
        this.audioVolume = f2;
        h.c[] cArray = new h.c[this.audioRendererCount];
        int n2 = 0;
        for (w w2 : this.renderers) {
            if (w2.getTrackType() != 1) continue;
            cArray[n2++] = new h.c(w2, 2, Float.valueOf(f2));
        }
        this.player.sendMessages(cArray);
    }

    public float getVolume() {
        return this.audioVolume;
    }

    @Deprecated
    @TargetApi(value=23)
    public void setPlaybackParams(@Nullable PlaybackParams playbackParams) {
        u u2;
        if (playbackParams != null) {
            playbackParams.allowDefaults();
            u2 = new u(playbackParams.getSpeed(), playbackParams.getPitch());
        } else {
            u2 = null;
        }
        this.setPlaybackParameters(u2);
    }

    public m getVideoFormat() {
        return this.videoFormat;
    }

    public m getAudioFormat() {
        return this.audioFormat;
    }

    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public W getVideoDecoderCounters() {
        return this.videoDecoderCounters;
    }

    public W getAudioDecoderCounters() {
        return this.audioDecoderCounters;
    }

    public void addVideoListener(b b2) {
        this.videoListeners.add(b2);
    }

    public void removeVideoListener(b b2) {
        this.videoListeners.remove(b2);
    }

    @Deprecated
    public void setVideoListener(b b2) {
        this.videoListeners.clear();
        if (b2 != null) {
            this.addVideoListener(b2);
        }
    }

    @Deprecated
    public void clearVideoListener(b b2) {
        this.removeVideoListener(b2);
    }

    public void addTextOutput(eK eK2) {
        this.textOutputs.add(eK2);
    }

    public void removeTextOutput(eK eK2) {
        this.textOutputs.remove(eK2);
    }

    @Deprecated
    public void setTextOutput(eK eK2) {
        this.textOutputs.clear();
        if (eK2 != null) {
            this.addTextOutput(eK2);
        }
    }

    @Deprecated
    public void clearTextOutput(eK eK2) {
        this.removeTextOutput(eK2);
    }

    public void addMetadataOutput(ch ch2) {
        this.metadataOutputs.add(ch2);
    }

    public void removeMetadataOutput(ch ch2) {
        this.metadataOutputs.remove(ch2);
    }

    @Deprecated
    public void setMetadataOutput(ch ch2) {
        this.metadataOutputs.clear();
        if (ch2 != null) {
            this.addMetadataOutput(ch2);
        }
    }

    @Deprecated
    public void clearMetadataOutput(ch ch2) {
        this.removeMetadataOutput(ch2);
    }

    public void setVideoDebugListener(hj hj2) {
        this.videoDebugListener = hj2;
    }

    public void setAudioDebugListener(I i2) {
        this.audioDebugListener = i2;
    }

    @Override
    public Looper getPlaybackLooper() {
        return this.player.getPlaybackLooper();
    }

    @Override
    public void addListener(v.c c2) {
        this.player.addListener(c2);
    }

    @Override
    public void removeListener(v.c c2) {
        this.player.removeListener(c2);
    }

    @Override
    public int getPlaybackState() {
        return this.player.getPlaybackState();
    }

    @Override
    public void prepare(dd dd2) {
        this.player.prepare(dd2);
    }

    @Override
    public void prepare(dd dd2, boolean bl2, boolean bl3) {
        this.player.prepare(dd2, bl2, bl3);
    }

    @Override
    public void setPlayWhenReady(boolean bl2) {
        this.player.setPlayWhenReady(bl2);
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.player.getPlayWhenReady();
    }

    @Override
    public int getRepeatMode() {
        return this.player.getRepeatMode();
    }

    @Override
    public void setRepeatMode(int n2) {
        this.player.setRepeatMode(n2);
    }

    @Override
    public void setShuffleModeEnabled(boolean bl2) {
        this.player.setShuffleModeEnabled(bl2);
    }

    @Override
    public boolean getShuffleModeEnabled() {
        return this.player.getShuffleModeEnabled();
    }

    @Override
    public boolean isLoading() {
        return this.player.isLoading();
    }

    @Override
    public void seekToDefaultPosition() {
        this.player.seekToDefaultPosition();
    }

    @Override
    public void seekToDefaultPosition(int n2) {
        this.player.seekToDefaultPosition(n2);
    }

    @Override
    public void seekTo(long l2) {
        this.player.seekTo(l2);
    }

    @Override
    public void seekTo(int n2, long l2) {
        this.player.seekTo(n2, l2);
    }

    @Override
    public void setPlaybackParameters(u u2) {
        this.player.setPlaybackParameters(u2);
    }

    @Override
    public u getPlaybackParameters() {
        return this.player.getPlaybackParameters();
    }

    @Override
    public void stop() {
        this.player.stop();
    }

    @Override
    public void release() {
        this.player.release();
        this.removeSurfaceCallbacks();
        if (this.surface != null) {
            if (this.ownsSurface) {
                this.surface.release();
            }
            this.surface = null;
        }
    }

    @Override
    public void sendMessages(h.c ... cArray) {
        this.player.sendMessages(cArray);
    }

    @Override
    public void blockingSendMessages(h.c ... cArray) {
        this.player.blockingSendMessages(cArray);
    }

    @Override
    public int getRendererCount() {
        return this.player.getRendererCount();
    }

    @Override
    public int getRendererType(int n2) {
        return this.player.getRendererType(n2);
    }

    @Override
    public dp getCurrentTrackGroups() {
        return this.player.getCurrentTrackGroups();
    }

    @Override
    public fy getCurrentTrackSelections() {
        return this.player.getCurrentTrackSelections();
    }

    @Override
    public B getCurrentTimeline() {
        return this.player.getCurrentTimeline();
    }

    @Override
    public Object getCurrentManifest() {
        return this.player.getCurrentManifest();
    }

    @Override
    public int getCurrentPeriodIndex() {
        return this.player.getCurrentPeriodIndex();
    }

    @Override
    public int getCurrentWindowIndex() {
        return this.player.getCurrentWindowIndex();
    }

    @Override
    public int getNextWindowIndex() {
        return this.player.getNextWindowIndex();
    }

    @Override
    public int getPreviousWindowIndex() {
        return this.player.getPreviousWindowIndex();
    }

    @Override
    public long getDuration() {
        return this.player.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.player.getCurrentPosition();
    }

    @Override
    public long getBufferedPosition() {
        return this.player.getBufferedPosition();
    }

    @Override
    public int getBufferedPercentage() {
        return this.player.getBufferedPercentage();
    }

    @Override
    public boolean isCurrentWindowDynamic() {
        return this.player.isCurrentWindowDynamic();
    }

    @Override
    public boolean isCurrentWindowSeekable() {
        return this.player.isCurrentWindowSeekable();
    }

    @Override
    public boolean isPlayingAd() {
        return this.player.isPlayingAd();
    }

    @Override
    public int getCurrentAdGroupIndex() {
        return this.player.getCurrentAdGroupIndex();
    }

    @Override
    public int getCurrentAdIndexInAdGroup() {
        return this.player.getCurrentAdIndexInAdGroup();
    }

    @Override
    public long getContentPosition() {
        return this.player.getContentPosition();
    }

    protected h createExoPlayerImpl(w[] wArray, fz fz2, p p2) {
        return new j(wArray, fz2, p2);
    }

    private void removeSurfaceCallbacks() {
        if (this.textureView != null) {
            if (this.textureView.getSurfaceTextureListener() != this.componentListener) {
                Log.w((String)TAG, (String)"SurfaceTextureListener already unset or replaced.");
            } else {
                this.textureView.setSurfaceTextureListener(null);
            }
            this.textureView = null;
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this.componentListener);
            this.surfaceHolder = null;
        }
    }

    private void setVideoSurfaceInternal(Surface surface, boolean bl2) {
        h.c[] cArray = new h.c[this.videoRendererCount];
        int n2 = 0;
        for (w w2 : this.renderers) {
            if (w2.getTrackType() != 2) continue;
            cArray[n2++] = new h.c(w2, 1, surface);
        }
        if (this.surface != null && this.surface != surface) {
            this.player.blockingSendMessages(cArray);
            if (this.ownsSurface) {
                this.surface.release();
            }
        } else {
            this.player.sendMessages(cArray);
        }
        this.surface = surface;
        this.ownsSurface = bl2;
    }

    private final class a
    implements SurfaceHolder.Callback,
    TextureView.SurfaceTextureListener,
    I,
    ch,
    eK,
    hj {
        private a() {
        }

        @Override
        public void a(W w2) {
            A.this.videoDecoderCounters = w2;
            if (A.this.videoDebugListener != null) {
                A.this.videoDebugListener.a(w2);
            }
        }

        @Override
        public void a(String string, long l2, long l3) {
            if (A.this.videoDebugListener != null) {
                A.this.videoDebugListener.a(string, l2, l3);
            }
        }

        @Override
        public void a(m m2) {
            A.this.videoFormat = m2;
            if (A.this.videoDebugListener != null) {
                A.this.videoDebugListener.a(m2);
            }
        }

        @Override
        public void a(int n2, long l2) {
            if (A.this.videoDebugListener != null) {
                A.this.videoDebugListener.a(n2, l2);
            }
        }

        @Override
        public void a(int n2, int n3, int n4, float f2) {
            for (b b2 : A.this.videoListeners) {
                b2.a(n2, n3, n4, f2);
            }
            if (A.this.videoDebugListener != null) {
                A.this.videoDebugListener.a(n2, n3, n4, f2);
            }
        }

        @Override
        public void a(Surface surface) {
            if (A.this.surface == surface) {
                for (b b2 : A.this.videoListeners) {
                    b2.a();
                }
            }
            if (A.this.videoDebugListener != null) {
                A.this.videoDebugListener.a(surface);
            }
        }

        @Override
        public void b(W w2) {
            if (A.this.videoDebugListener != null) {
                A.this.videoDebugListener.b(w2);
            }
            A.this.videoFormat = null;
            A.this.videoDecoderCounters = null;
        }

        @Override
        public void c(W w2) {
            A.this.audioDecoderCounters = w2;
            if (A.this.audioDebugListener != null) {
                A.this.audioDebugListener.c(w2);
            }
        }

        @Override
        public void a(int n2) {
            A.this.audioSessionId = n2;
            if (A.this.audioDebugListener != null) {
                A.this.audioDebugListener.a(n2);
            }
        }

        @Override
        public void b(String string, long l2, long l3) {
            if (A.this.audioDebugListener != null) {
                A.this.audioDebugListener.b(string, l2, l3);
            }
        }

        @Override
        public void b(m m2) {
            A.this.audioFormat = m2;
            if (A.this.audioDebugListener != null) {
                A.this.audioDebugListener.b(m2);
            }
        }

        @Override
        public void a(int n2, long l2, long l3) {
            if (A.this.audioDebugListener != null) {
                A.this.audioDebugListener.a(n2, l2, l3);
            }
        }

        @Override
        public void d(W w2) {
            if (A.this.audioDebugListener != null) {
                A.this.audioDebugListener.d(w2);
            }
            A.this.audioFormat = null;
            A.this.audioDecoderCounters = null;
            A.this.audioSessionId = 0;
        }

        @Override
        public void a(List<eB> list) {
            for (eK eK2 : A.this.textOutputs) {
                eK2.a(list);
            }
        }

        @Override
        public void a(cc cc2) {
            for (ch ch2 : A.this.metadataOutputs) {
                ch2.a(cc2);
            }
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            A.this.setVideoSurfaceInternal(surfaceHolder.getSurface(), false);
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            A.this.setVideoSurfaceInternal(null, false);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
            A.this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            A.this.setVideoSurfaceInternal(null, true);
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }

    public static interface b {
        public void a(int var1, int var2, int var3, float var4);

        public void a();
    }
}

