/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.google.vr.libraries.video.CameraMotionMetadataRendererV2;
import com.google.vr.libraries.video.FrameRotationBuffer;
import com.google.vr.libraries.video.MotionCoordinateSystem;
import com.google.vr.libraries.video.SphericalV2MediaCodecVideoRenderer;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import com.google.vr.sdk.widgets.video.deps.A;
import com.google.vr.sdk.widgets.video.deps.ah;
import com.google.vr.sdk.widgets.video.deps.al;
import com.google.vr.sdk.widgets.video.deps.ch;
import com.google.vr.sdk.widgets.video.deps.e;
import com.google.vr.sdk.widgets.video.deps.f;
import com.google.vr.sdk.widgets.video.deps.ft;
import com.google.vr.sdk.widgets.video.deps.hj;
import com.google.vr.sdk.widgets.video.deps.m;
import com.google.vr.sdk.widgets.video.deps.w;
import java.util.ArrayList;

public class VrSimpleExoPlayer
extends A {
    private final CameraMotionMetadataRendererV2 cameraMotionRenderer;
    private final SphericalV2MediaCodecVideoRenderer videoRenderer;

    public VrSimpleExoPlayer(Context context) {
        super(new VrRenderersFactory(context), new ft(), new e());
        CameraMotionMetadataRendererV2 cameraMotionMetadataRendererV2 = null;
        SphericalV2MediaCodecVideoRenderer sphericalV2MediaCodecVideoRenderer = null;
        for (w w2 : this.renderers) {
            if (w2 instanceof CameraMotionMetadataRendererV2) {
                cameraMotionMetadataRendererV2 = (CameraMotionMetadataRendererV2)w2;
                continue;
            }
            if (!(w2 instanceof SphericalV2MediaCodecVideoRenderer)) continue;
            sphericalV2MediaCodecVideoRenderer = (SphericalV2MediaCodecVideoRenderer)w2;
        }
        this.cameraMotionRenderer = cameraMotionMetadataRendererV2;
        this.videoRenderer = sphericalV2MediaCodecVideoRenderer;
    }

    public FrameRotationBuffer getFrameRotationBuffer() {
        return this.cameraMotionRenderer.getFrameRotationBuffer();
    }

    public void setProjectionListener(SphericalV2ProjectionDataListener sphericalV2ProjectionDataListener) {
        this.videoRenderer.setProjectionListener(sphericalV2ProjectionDataListener);
    }

    public long getSampleTimestampUsForReleaseTimeUs(long l2) {
        return this.videoRenderer.getSampleTimestampBuffer().getSampleTimestampUsForReleaseTimeUs(l2);
    }

    public m getInputFormat() {
        return this.videoRenderer.getInputFormat();
    }

    private static class VrRenderersFactory
    extends f {
        public VrRenderersFactory(Context context) {
            super(context);
        }

        @Override
        protected void buildVideoRenderers(Context context, ah<al> ah2, long l2, Handler handler, hj hj2, int n2, ArrayList<w> arrayList) {
            arrayList.add(new SphericalV2MediaCodecVideoRenderer(context, handler, ah2, hj2, l2));
        }

        @Override
        protected void buildMetadataRenderers(Context context, ch ch2, Looper looper, int n2, ArrayList<w> arrayList) {
            super.buildMetadataRenderers(context, ch2, looper, n2, arrayList);
            arrayList.add(new CameraMotionMetadataRendererV2(MotionCoordinateSystem.FLIP_XY));
        }
    }
}

