/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import com.google.vr.libraries.video.ProjectionMeshDecoderV2;
import com.google.vr.libraries.video.ProjectionScene;
import com.google.vr.sdk.widgets.video.nano.SphericalMetadataOuterClass;

public class SphericalV2MetadataParser {
    private static final String TAG = SphericalV2MetadataParser.class.getSimpleName();

    public SphericalV2MetadataParser() {
    }

    public static SphericalMetadataOuterClass.SphericalMetadata parse(int n2, byte[] byArray) {
        ProjectionMeshDecoderV2 projectionMeshDecoderV2 = new ProjectionMeshDecoderV2();
        ProjectionScene projectionScene = projectionMeshDecoderV2.decode(byArray);
        SphericalMetadataOuterClass.SphericalMetadata sphericalMetadata = new SphericalMetadataOuterClass.SphericalMetadata();
        switch (n2) {
            case 0: {
                sphericalMetadata.frameLayoutMode = 1;
                break;
            }
            case 1: {
                sphericalMetadata.frameLayoutMode = 2;
                break;
            }
            case 2: {
                sphericalMetadata.frameLayoutMode = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(33).append("Unexpected stereoMode ").append(n2).toString());
            }
        }
        if (projectionScene != null) {
            sphericalMetadata.mesh = new SphericalMetadataOuterClass.StereoMeshConfig();
            sphericalMetadata.mesh.leftEyeMesh = SphericalV2MetadataParser.createMesh(projectionScene.getLeftMesh());
            sphericalMetadata.mesh.rightEyeMesh = SphericalV2MetadataParser.createMesh(projectionScene.getRightMesh());
        }
        return sphericalMetadata;
    }

    private static SphericalMetadataOuterClass.StereoMeshConfig.Mesh createMesh(ProjectionScene.Mesh mesh) {
        if (mesh == null) {
            return null;
        }
        if (mesh.getSubMeshCount() != 1) {
            throw new IllegalArgumentException("There should be only a single submesh");
        }
        ProjectionScene.SubMesh subMesh = mesh.getSubMesh(0);
        SphericalMetadataOuterClass.StereoMeshConfig.Mesh mesh2 = new SphericalMetadataOuterClass.StereoMeshConfig.Mesh();
        switch (subMesh.getMode()) {
            case 5: {
                mesh2.geometryType = 1;
                break;
            }
            case 4: {
                mesh2.geometryType = 0;
                break;
            }
            default: {
                int n2 = subMesh.getMode();
                throw new IllegalArgumentException(new StringBuilder(32).append("Unexpected mesh mode ").append(n2).toString());
            }
        }
        float[] fArray = subMesh.getVertices();
        float[] fArray2 = subMesh.getTextureCoords();
        int n3 = fArray.length / 3;
        mesh2.vertices = new SphericalMetadataOuterClass.StereoMeshConfig.Mesh.Vertex[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            SphericalMetadataOuterClass.StereoMeshConfig.Mesh.Vertex vertex;
            mesh2.vertices[i2] = vertex = new SphericalMetadataOuterClass.StereoMeshConfig.Mesh.Vertex();
            vertex.x = fArray[3 * i2];
            vertex.y = fArray[3 * i2 + 1];
            vertex.z = fArray[3 * i2 + 2];
            vertex.u = fArray2[2 * i2];
            vertex.v = fArray2[2 * i2 + 1];
        }
        return mesh2;
    }
}

