/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.libraries.video;

import android.content.Context;
import android.media.MediaCodec;
import android.os.Handler;
import com.google.vr.libraries.video.SampleTimestampBuffer;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import com.google.vr.sdk.widgets.video.deps.ah;
import com.google.vr.sdk.widgets.video.deps.al;
import com.google.vr.sdk.widgets.video.deps.ca;
import com.google.vr.sdk.widgets.video.deps.g;
import com.google.vr.sdk.widgets.video.deps.hh;
import com.google.vr.sdk.widgets.video.deps.hj;
import com.google.vr.sdk.widgets.video.deps.m;

public class SphericalV2MediaCodecVideoRenderer
extends hh {
    private static final int MAX_DROPPED_FRAME_COUNT_TO_NOTIFY = 1;
    private static final String TAG = SphericalV2MediaCodecVideoRenderer.class.getSimpleName();
    private final SampleTimestampBuffer sampleTimestampBuffer = new SampleTimestampBuffer();
    private SphericalV2ProjectionDataListener projectionListener;
    private m inputFormat;

    public SphericalV2MediaCodecVideoRenderer(Context context, Handler handler, ah<al> ah2, hj hj2, long l2) {
        super(context, ca.a, l2, ah2, false, handler, hj2, 1);
    }

    public void setProjectionListener(SphericalV2ProjectionDataListener sphericalV2ProjectionDataListener) {
        this.projectionListener = sphericalV2ProjectionDataListener;
    }

    public SampleTimestampBuffer getSampleTimestampBuffer() {
        return this.sampleTimestampBuffer;
    }

    @Override
    protected void onInputFormatChanged(m m2) throws g {
        super.onInputFormatChanged(m2);
        this.inputFormat = m2;
        if (m2 != null && m2.q != -1 && m2.r != null && this.projectionListener != null) {
            this.projectionListener.onProjectionDataChanged(m2.q, m2.r);
        }
    }

    public m getInputFormat() {
        return this.inputFormat;
    }

    @Override
    protected void onStreamChanged(m[] mArray, long l2) throws g {
        this.sampleTimestampBuffer.setPresentationTimeOffsetUs(l2);
        super.onStreamChanged(mArray, l2);
    }

    @Override
    protected void renderOutputBuffer(MediaCodec mediaCodec, int n2, long l2) {
        this.sampleTimestampBuffer.addPresentationTimeUsForReleaseTimeUs(l2, System.nanoTime() / 1000L);
        super.renderOutputBuffer(mediaCodec, n2, l2);
    }

    @Override
    protected void renderOutputBufferV21(MediaCodec mediaCodec, int n2, long l2, long l3) {
        this.sampleTimestampBuffer.addPresentationTimeUsForReleaseTimeUs(l2, l3 / 1000L);
        super.renderOutputBufferV21(mediaCodec, n2, l2, l3);
    }
}

