/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video.deps;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.vr.sdk.widgets.video.deps.S;
import com.google.vr.sdk.widgets.video.deps.T;
import com.google.vr.sdk.widgets.video.deps.ab;
import com.google.vr.sdk.widgets.video.deps.ac;
import com.google.vr.sdk.widgets.video.deps.af;
import com.google.vr.sdk.widgets.video.deps.bS;
import com.google.vr.sdk.widgets.video.deps.bU;
import com.google.vr.sdk.widgets.video.deps.bV;
import com.google.vr.sdk.widgets.video.deps.g;
import com.google.vr.sdk.widgets.video.deps.gK;
import com.google.vr.sdk.widgets.video.deps.gM;
import com.google.vr.sdk.widgets.video.deps.gl;
import com.google.vr.sdk.widgets.video.deps.gy;
import com.google.vr.sdk.widgets.video.deps.m;
import com.google.vr.sdk.widgets.video.deps.n;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=16)
public abstract class bT
extends com.google.vr.sdk.widgets.video.deps.a {
    private static final String TAG = "MediaCodecRenderer";
    private static final long MAX_CODEC_HOTSWAP_TIME_MS = 1000L;
    private static final int RECONFIGURATION_STATE_NONE = 0;
    private static final int RECONFIGURATION_STATE_WRITE_PENDING = 1;
    private static final int RECONFIGURATION_STATE_QUEUE_PENDING = 2;
    private static final int REINITIALIZATION_STATE_NONE = 0;
    private static final int REINITIALIZATION_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int REINITIALIZATION_STATE_WAIT_END_OF_STREAM = 2;
    private static final byte[] ADAPTATION_WORKAROUND_BUFFER = gM.h("0000016742C00BDA259000000168CE0F13200000016588840DCE7118A0002FBF1C31C3275D78");
    private static final int ADAPTATION_WORKAROUND_SLICE_WIDTH_HEIGHT = 32;
    private final bU mediaCodecSelector;
    @Nullable
    private final ac<af> drmSessionManager;
    private final boolean playClearSamplesWithoutKeys;
    private final T buffer;
    private final T flagsOnlyBuffer;
    private final n formatHolder;
    private final List<Long> decodeOnlyPresentationTimestamps;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private m format;
    private ab<af> drmSession;
    private ab<af> pendingDrmSession;
    private MediaCodec codec;
    private bS codecInfo;
    private boolean codecNeedsDiscardToSpsWorkaround;
    private boolean codecNeedsFlushWorkaround;
    private boolean codecNeedsAdaptationWorkaround;
    private boolean codecNeedsEosPropagationWorkaround;
    private boolean codecNeedsEosFlushWorkaround;
    private boolean codecNeedsEosOutputExceptionWorkaround;
    private boolean codecNeedsMonoChannelCountWorkaround;
    private boolean codecNeedsAdaptationWorkaroundBuffer;
    private boolean shouldSkipAdaptationWorkaroundOutputBuffer;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private long codecHotswapDeadlineMs;
    private int inputIndex;
    private int outputIndex;
    private boolean shouldSkipOutputBuffer;
    private boolean codecReconfigured;
    private int codecReconfigurationState;
    private int codecReinitializationState;
    private boolean codecReceivedBuffers;
    private boolean codecReceivedEos;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private boolean waitingForKeys;
    private boolean waitingForFirstSyncFrame;
    protected S decoderCounters;

    public bT(int n2, bU bU2, @Nullable ac<af> ac2, boolean bl2) {
        super(n2);
        gl.b(gM.a >= 16);
        this.mediaCodecSelector = gl.a(bU2);
        this.drmSessionManager = ac2;
        this.playClearSamplesWithoutKeys = bl2;
        this.buffer = new T(0);
        this.flagsOnlyBuffer = T.e();
        this.formatHolder = new n();
        this.decodeOnlyPresentationTimestamps = new ArrayList<Long>();
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
    }

    @Override
    public final int supportsMixedMimeTypeAdaptation() {
        return 8;
    }

    @Override
    public final int supportsFormat(m m2) throws g {
        try {
            return this.supportsFormat(this.mediaCodecSelector, this.drmSessionManager, m2);
        }
        catch (bV.b b2) {
            throw g.a(b2, this.getIndex());
        }
    }

    protected abstract int supportsFormat(bU var1, ac<af> var2, m var3) throws bV.b;

    protected bS getDecoderInfo(bU bU2, m m2, boolean bl2) throws bV.b {
        return bU2.a(m2.h, bl2);
    }

    protected abstract void configureCodec(bS var1, MediaCodec var2, m var3, MediaCrypto var4) throws bV.b;

    protected final void maybeInitCodec() throws g {
        Object object;
        if (this.codec != null || this.format == null) {
            return;
        }
        this.drmSession = this.pendingDrmSession;
        String string = this.format.h;
        MediaCrypto mediaCrypto = null;
        boolean bl2 = false;
        if (this.drmSession != null) {
            object = this.drmSession.e();
            if (object == null) {
                ab.a a2 = this.drmSession.d();
                if (a2 != null) {
                    throw g.a(a2, this.getIndex());
                }
                return;
            }
            mediaCrypto = ((af)object).a();
            bl2 = ((af)object).a(string);
        }
        if (this.codecInfo == null) {
            try {
                this.codecInfo = this.getDecoderInfo(this.mediaCodecSelector, this.format, bl2);
                if (this.codecInfo == null && bl2) {
                    this.codecInfo = this.getDecoderInfo(this.mediaCodecSelector, this.format, false);
                    if (this.codecInfo != null) {
                        object = this.codecInfo.b;
                        Log.w((String)TAG, (String)new StringBuilder(99 + String.valueOf(string).length() + String.valueOf(object).length()).append("Drm session requires secure decoder for ").append(string).append(", but no secure decoder available. Trying to proceed with ").append((String)object).append(".").toString());
                    }
                }
            }
            catch (bV.b b2) {
                this.throwDecoderInitError(new a(this.format, (Throwable)b2, bl2, -49998));
            }
            if (this.codecInfo == null) {
                this.throwDecoderInitError(new a(this.format, null, bl2, -49999));
            }
        }
        if (!this.shouldInitCodec(this.codecInfo)) {
            return;
        }
        object = this.codecInfo.b;
        this.codecNeedsDiscardToSpsWorkaround = bT.codecNeedsDiscardToSpsWorkaround((String)object, this.format);
        this.codecNeedsFlushWorkaround = bT.codecNeedsFlushWorkaround((String)object);
        this.codecNeedsAdaptationWorkaround = bT.codecNeedsAdaptationWorkaround((String)object);
        this.codecNeedsEosPropagationWorkaround = bT.codecNeedsEosPropagationWorkaround((String)object);
        this.codecNeedsEosFlushWorkaround = bT.codecNeedsEosFlushWorkaround((String)object);
        this.codecNeedsEosOutputExceptionWorkaround = bT.codecNeedsEosOutputExceptionWorkaround((String)object);
        this.codecNeedsMonoChannelCountWorkaround = bT.codecNeedsMonoChannelCountWorkaround((String)object, this.format);
        try {
            long l2 = SystemClock.elapsedRealtime();
            String string2 = String.valueOf(object);
            gK.a(string2.length() != 0 ? "createCodec:".concat(string2) : new String("createCodec:"));
            this.codec = MediaCodec.createByCodecName((String)object);
            gK.a();
            gK.a("configureCodec");
            this.configureCodec(this.codecInfo, this.codec, this.format, mediaCrypto);
            gK.a();
            gK.a("startCodec");
            this.codec.start();
            gK.a();
            long l3 = SystemClock.elapsedRealtime();
            this.onCodecInitialized((String)object, l3, l3 - l2);
            this.inputBuffers = this.codec.getInputBuffers();
            this.outputBuffers = this.codec.getOutputBuffers();
        }
        catch (Exception exception) {
            this.throwDecoderInitError(new a(this.format, (Throwable)exception, bl2, (String)object));
        }
        this.codecHotswapDeadlineMs = this.getState() == 2 ? SystemClock.elapsedRealtime() + 1000L : -9223372036854775807L;
        this.inputIndex = -1;
        this.outputIndex = -1;
        this.waitingForFirstSyncFrame = true;
        ++this.decoderCounters.a;
    }

    private void throwDecoderInitError(a a2) throws g {
        throw g.a(a2, this.getIndex());
    }

    protected boolean shouldInitCodec(bS bS2) {
        return true;
    }

    protected final MediaCodec getCodec() {
        return this.codec;
    }

    protected final bS getCodecInfo() {
        return this.codecInfo;
    }

    @Override
    protected void onEnabled(boolean bl2) throws g {
        this.decoderCounters = new S();
    }

    @Override
    protected void onPositionReset(long l2, boolean bl2) throws g {
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        if (this.codec != null) {
            this.flushCodec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDisabled() {
        this.format = null;
        try {
            this.releaseCodec();
        }
        finally {
            try {
                if (this.drmSession != null) {
                    this.drmSessionManager.a(this.drmSession);
                }
            }
            finally {
                try {
                    if (this.pendingDrmSession != null && this.pendingDrmSession != this.drmSession) {
                        this.drmSessionManager.a(this.pendingDrmSession);
                    }
                }
                finally {
                    this.drmSession = null;
                    this.pendingDrmSession = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseCodec() {
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.inputIndex = -1;
        this.outputIndex = -1;
        this.waitingForKeys = false;
        this.shouldSkipOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.inputBuffers = null;
        this.outputBuffers = null;
        this.codecInfo = null;
        this.codecReconfigured = false;
        this.codecReceivedBuffers = false;
        this.codecNeedsDiscardToSpsWorkaround = false;
        this.codecNeedsFlushWorkaround = false;
        this.codecNeedsAdaptationWorkaround = false;
        this.codecNeedsEosPropagationWorkaround = false;
        this.codecNeedsEosFlushWorkaround = false;
        this.codecNeedsMonoChannelCountWorkaround = false;
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        this.codecReceivedEos = false;
        this.codecReconfigurationState = 0;
        this.codecReinitializationState = 0;
        this.buffer.e = null;
        if (this.codec != null) {
            ++this.decoderCounters.b;
            try {
                this.codec.stop();
            }
            finally {
                try {
                    this.codec.release();
                }
                finally {
                    this.codec = null;
                    if (this.drmSession != null && this.pendingDrmSession != this.drmSession) {
                        try {
                            this.drmSessionManager.a(this.drmSession);
                        }
                        finally {
                            this.drmSession = null;
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void onStarted() {
    }

    @Override
    protected void onStopped() {
    }

    @Override
    public void render(long l2, long l3) throws g {
        int n2;
        if (this.outputStreamEnded) {
            this.renderToEndOfStream();
            return;
        }
        if (this.format == null) {
            this.flagsOnlyBuffer.a();
            n2 = this.readSource(this.formatHolder, this.flagsOnlyBuffer, true);
            if (n2 == -5) {
                this.onInputFormatChanged(this.formatHolder.a);
            } else {
                if (n2 == -4) {
                    gl.b(this.flagsOnlyBuffer.c());
                    this.inputStreamEnded = true;
                    this.processEndOfStream();
                    return;
                }
                return;
            }
        }
        this.maybeInitCodec();
        if (this.codec != null) {
            gK.a("drainAndFeed");
            while (this.drainOutputBuffer(l2, l3)) {
            }
            while (this.feedInputBuffer()) {
            }
            gK.a();
        } else {
            this.decoderCounters.d += this.skipSource(l2);
            this.flagsOnlyBuffer.a();
            n2 = this.readSource(this.formatHolder, this.flagsOnlyBuffer, false);
            if (n2 == -5) {
                this.onInputFormatChanged(this.formatHolder.a);
            } else if (n2 == -4) {
                gl.b(this.flagsOnlyBuffer.c());
                this.inputStreamEnded = true;
                this.processEndOfStream();
            }
        }
        this.decoderCounters.a();
    }

    protected void flushCodec() throws g {
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.inputIndex = -1;
        this.outputIndex = -1;
        this.waitingForFirstSyncFrame = true;
        this.waitingForKeys = false;
        this.shouldSkipOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        if (this.codecNeedsFlushWorkaround || this.codecNeedsEosFlushWorkaround && this.codecReceivedEos) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else if (this.codecReinitializationState != 0) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.codec.flush();
            this.codecReceivedBuffers = false;
        }
        if (this.codecReconfigured && this.format != null) {
            this.codecReconfigurationState = 1;
        }
    }

    private boolean feedInputBuffer() throws g {
        int n2;
        int n3;
        if (this.codec == null || this.codecReinitializationState == 2 || this.inputStreamEnded) {
            return false;
        }
        if (this.inputIndex < 0) {
            this.inputIndex = this.codec.dequeueInputBuffer(0L);
            if (this.inputIndex < 0) {
                return false;
            }
            this.buffer.e = this.inputBuffers[this.inputIndex];
            this.buffer.a();
        }
        if (this.codecReinitializationState == 1) {
            if (!this.codecNeedsEosPropagationWorkaround) {
                this.codecReceivedEos = true;
                this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                this.inputIndex = -1;
            }
            this.codecReinitializationState = 2;
            return false;
        }
        if (this.codecNeedsAdaptationWorkaroundBuffer) {
            this.codecNeedsAdaptationWorkaroundBuffer = false;
            this.buffer.e.put(ADAPTATION_WORKAROUND_BUFFER);
            this.codec.queueInputBuffer(this.inputIndex, 0, ADAPTATION_WORKAROUND_BUFFER.length, 0L, 0);
            this.inputIndex = -1;
            this.codecReceivedBuffers = true;
            return true;
        }
        int n4 = 0;
        if (this.waitingForKeys) {
            n3 = -4;
        } else {
            if (this.codecReconfigurationState == 1) {
                for (n2 = 0; n2 < this.format.j.size(); n2 += 1) {
                    byte[] byArray = this.format.j.get(n2);
                    this.buffer.e.put(byArray);
                }
                this.codecReconfigurationState = 2;
            }
            n4 = this.buffer.e.position();
            n3 = this.readSource(this.formatHolder, this.buffer, false);
        }
        if (n3 == -3) {
            return false;
        }
        if (n3 == -5) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.a();
                this.codecReconfigurationState = 1;
            }
            this.onInputFormatChanged(this.formatHolder.a);
            return true;
        }
        if (this.buffer.c()) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.a();
                this.codecReconfigurationState = 1;
            }
            this.inputStreamEnded = true;
            if (!this.codecReceivedBuffers) {
                this.processEndOfStream();
                return false;
            }
            try {
                if (!this.codecNeedsEosPropagationWorkaround) {
                    this.codecReceivedEos = true;
                    this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                    this.inputIndex = -1;
                }
            }
            catch (MediaCodec.CryptoException cryptoException) {
                throw g.a((Exception)((Object)cryptoException), this.getIndex());
            }
            return false;
        }
        if (this.waitingForFirstSyncFrame && !this.buffer.d()) {
            this.buffer.a();
            if (this.codecReconfigurationState == 2) {
                this.codecReconfigurationState = 1;
            }
            return true;
        }
        this.waitingForFirstSyncFrame = false;
        n2 = this.buffer.g() ? 1 : 0;
        this.waitingForKeys = this.shouldWaitForKeys(n2 != 0);
        if (this.waitingForKeys) {
            return false;
        }
        if (this.codecNeedsDiscardToSpsWorkaround && !n2) {
            gy.a(this.buffer.e);
            if (this.buffer.e.position() == 0) {
                return true;
            }
            this.codecNeedsDiscardToSpsWorkaround = false;
        }
        try {
            long l2 = this.buffer.f;
            if (this.buffer.c_()) {
                this.decodeOnlyPresentationTimestamps.add(l2);
            }
            this.buffer.h();
            this.onQueueInputBuffer(this.buffer);
            if (n2) {
                MediaCodec.CryptoInfo cryptoInfo = bT.getFrameworkCryptoInfo(this.buffer, n4);
                this.codec.queueSecureInputBuffer(this.inputIndex, 0, cryptoInfo, l2, 0);
            } else {
                this.codec.queueInputBuffer(this.inputIndex, 0, this.buffer.e.limit(), l2, 0);
            }
            this.inputIndex = -1;
            this.codecReceivedBuffers = true;
            this.codecReconfigurationState = 0;
            ++this.decoderCounters.c;
        }
        catch (MediaCodec.CryptoException cryptoException) {
            throw g.a((Exception)((Object)cryptoException), this.getIndex());
        }
        return true;
    }

    private static MediaCodec.CryptoInfo getFrameworkCryptoInfo(T t2, int n2) {
        MediaCodec.CryptoInfo cryptoInfo = t2.d.a();
        if (n2 == 0) {
            return cryptoInfo;
        }
        if (cryptoInfo.numBytesOfClearData == null) {
            cryptoInfo.numBytesOfClearData = new int[1];
        }
        cryptoInfo.numBytesOfClearData[0] = cryptoInfo.numBytesOfClearData[0] + n2;
        return cryptoInfo;
    }

    private boolean shouldWaitForKeys(boolean bl2) throws g {
        if (this.drmSession == null || !bl2 && this.playClearSamplesWithoutKeys) {
            return false;
        }
        int n2 = this.drmSession.c();
        if (n2 == 1) {
            throw g.a(this.drmSession.d(), this.getIndex());
        }
        return n2 != 4;
    }

    protected void onCodecInitialized(String string, long l2, long l3) {
    }

    protected void onInputFormatChanged(m m2) throws g {
        boolean bl2;
        m m3 = this.format;
        this.format = m2;
        boolean bl3 = bl2 = !gM.a(this.format.k, (Object)(m3 == null ? null : m3.k));
        if (bl2) {
            if (this.format.k != null) {
                if (this.drmSessionManager == null) {
                    throw g.a(new IllegalStateException("Media requires a DrmSessionManager"), this.getIndex());
                }
                this.pendingDrmSession = this.drmSessionManager.a(Looper.myLooper(), this.format.k);
                if (this.pendingDrmSession == this.drmSession) {
                    this.drmSessionManager.a(this.pendingDrmSession);
                }
            } else {
                this.pendingDrmSession = null;
            }
        }
        if (this.pendingDrmSession == this.drmSession && this.codec != null && this.canReconfigureCodec(this.codec, this.codecInfo.c, m3, this.format)) {
            this.codecReconfigured = true;
            this.codecReconfigurationState = 1;
            this.codecNeedsAdaptationWorkaroundBuffer = this.codecNeedsAdaptationWorkaround && this.format.l == m3.l && this.format.m == m3.m;
        } else if (this.codecReceivedBuffers) {
            this.codecReinitializationState = 1;
        } else {
            this.releaseCodec();
            this.maybeInitCodec();
        }
    }

    protected void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) throws g {
    }

    protected void onQueueInputBuffer(T t2) {
    }

    protected void onProcessedOutputBuffer(long l2) {
    }

    protected boolean canReconfigureCodec(MediaCodec mediaCodec, boolean bl2, m m2, m m3) {
        return false;
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return this.format != null && !this.waitingForKeys && (this.isSourceReady() || this.outputIndex >= 0 || this.codecHotswapDeadlineMs != -9223372036854775807L && SystemClock.elapsedRealtime() < this.codecHotswapDeadlineMs);
    }

    protected long getDequeueOutputBufferTimeoutUs() {
        return 0L;
    }

    private boolean drainOutputBuffer(long l2, long l3) throws g {
        boolean bl2;
        if (this.outputIndex < 0) {
            if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
                try {
                    this.outputIndex = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
                }
                catch (IllegalStateException illegalStateException) {
                    this.processEndOfStream();
                    if (this.outputStreamEnded) {
                        this.releaseCodec();
                    }
                    return false;
                }
            } else {
                this.outputIndex = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
            }
            if (this.outputIndex >= 0) {
                if (this.shouldSkipAdaptationWorkaroundOutputBuffer) {
                    this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
                    this.codec.releaseOutputBuffer(this.outputIndex, false);
                    this.outputIndex = -1;
                    return true;
                }
                if ((this.outputBufferInfo.flags & 4) != 0) {
                    this.processEndOfStream();
                    this.outputIndex = -1;
                    return false;
                }
                ByteBuffer byteBuffer = this.outputBuffers[this.outputIndex];
                if (byteBuffer != null) {
                    byteBuffer.position(this.outputBufferInfo.offset);
                    byteBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
                }
                this.shouldSkipOutputBuffer = this.shouldSkipOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            } else {
                if (this.outputIndex == -2) {
                    this.processOutputFormat();
                    return true;
                }
                if (this.outputIndex == -3) {
                    this.processOutputBuffersChanged();
                    return true;
                }
                if (this.codecNeedsEosPropagationWorkaround && (this.inputStreamEnded || this.codecReinitializationState == 2)) {
                    this.processEndOfStream();
                }
                return false;
            }
        }
        if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
            try {
                bl2 = this.processOutputBuffer(l2, l3, this.codec, this.outputBuffers[this.outputIndex], this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer);
            }
            catch (IllegalStateException illegalStateException) {
                this.processEndOfStream();
                if (this.outputStreamEnded) {
                    this.releaseCodec();
                }
                return false;
            }
        } else {
            bl2 = this.processOutputBuffer(l2, l3, this.codec, this.outputBuffers[this.outputIndex], this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer);
        }
        if (bl2) {
            this.onProcessedOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            this.outputIndex = -1;
            return true;
        }
        return false;
    }

    private void processOutputFormat() throws g {
        MediaFormat mediaFormat = this.codec.getOutputFormat();
        if (this.codecNeedsAdaptationWorkaround && mediaFormat.getInteger("width") == 32 && mediaFormat.getInteger("height") == 32) {
            this.shouldSkipAdaptationWorkaroundOutputBuffer = true;
            return;
        }
        if (this.codecNeedsMonoChannelCountWorkaround) {
            mediaFormat.setInteger("channel-count", 1);
        }
        this.onOutputFormatChanged(this.codec, mediaFormat);
    }

    private void processOutputBuffersChanged() {
        this.outputBuffers = this.codec.getOutputBuffers();
    }

    protected abstract boolean processOutputBuffer(long var1, long var3, MediaCodec var5, ByteBuffer var6, int var7, int var8, long var9, boolean var11) throws g;

    protected void renderToEndOfStream() throws g {
    }

    private void processEndOfStream() throws g {
        if (this.codecReinitializationState == 2) {
            this.releaseCodec();
            this.maybeInitCodec();
        } else {
            this.outputStreamEnded = true;
            this.renderToEndOfStream();
        }
    }

    private boolean shouldSkipOutputBuffer(long l2) {
        int n2 = this.decodeOnlyPresentationTimestamps.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.decodeOnlyPresentationTimestamps.get(i2) != l2) continue;
            this.decodeOnlyPresentationTimestamps.remove(i2);
            return true;
        }
        return false;
    }

    private static boolean codecNeedsFlushWorkaround(String string) {
        return gM.a < 18 || gM.a == 18 && ("OMX.SEC.avc.dec".equals(string) || "OMX.SEC.avc.dec.secure".equals(string)) || gM.a == 19 && gM.d.startsWith("SM-G800") && ("OMX.Exynos.avc.dec".equals(string) || "OMX.Exynos.avc.dec.secure".equals(string));
    }

    private static boolean codecNeedsAdaptationWorkaround(String string) {
        return !(gM.a >= 24 || !"OMX.Nvidia.h264.decode".equals(string) && !"OMX.Nvidia.h264.decode.secure".equals(string) || !"flounder".equals(gM.b) && !"flounder_lte".equals(gM.b) && !"grouper".equals(gM.b) && !"tilapia".equals(gM.b));
    }

    private static boolean codecNeedsDiscardToSpsWorkaround(String string, m m2) {
        return gM.a < 21 && m2.j.isEmpty() && "OMX.MTK.VIDEO.DECODER.AVC".equals(string);
    }

    private static boolean codecNeedsEosPropagationWorkaround(String string) {
        return gM.a <= 17 && ("OMX.rk.video_decoder.avc".equals(string) || "OMX.allwinner.video.decoder.avc".equals(string));
    }

    private static boolean codecNeedsEosFlushWorkaround(String string) {
        return gM.a <= 23 && "OMX.google.vorbis.decoder".equals(string) || gM.a <= 19 && "hb2000".equals(gM.b) && ("OMX.amlogic.avc.decoder.awesome".equals(string) || "OMX.amlogic.avc.decoder.awesome.secure".equals(string));
    }

    private static boolean codecNeedsEosOutputExceptionWorkaround(String string) {
        return gM.a == 21 && "OMX.google.aac.decoder".equals(string);
    }

    private static boolean codecNeedsMonoChannelCountWorkaround(String string, m m2) {
        return gM.a <= 18 && m2.t == 1 && "OMX.MTK.AUDIO.DECODER.MP3".equals(string);
    }

    public static class a
    extends Exception {
        private static final int e = -50000;
        private static final int f = -49999;
        private static final int g = -49998;
        public final String a;
        public final boolean b;
        public final String c;
        public final String d;

        public a(m m2, Throwable throwable, boolean bl2, int n2) {
            String string = String.valueOf(m2);
            super(new StringBuilder(36 + String.valueOf(string).length()).append("Decoder init failed: [").append(n2).append("], ").append(string).toString(), throwable);
            this.a = m2.h;
            this.b = bl2;
            this.c = null;
            this.d = com.google.vr.sdk.widgets.video.deps.bT$a.a(n2);
        }

        public a(m m2, Throwable throwable, boolean bl2, String string) {
            String string2 = String.valueOf(m2);
            super(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Decoder init failed: ").append(string).append(", ").append(string2).toString(), throwable);
            this.a = m2.h;
            this.b = bl2;
            this.c = string;
            this.d = gM.a >= 21 ? com.google.vr.sdk.widgets.video.deps.bT$a.a(throwable) : null;
        }

        @TargetApi(value=21)
        private static String a(Throwable throwable) {
            if (throwable instanceof MediaCodec.CodecException) {
                return ((MediaCodec.CodecException)throwable).getDiagnosticInfo();
            }
            return null;
        }

        private static String a(int n2) {
            String string = n2 < 0 ? "neg_" : "";
            int n3 = Math.abs(n2);
            return new StringBuilder(64 + String.valueOf(string).length()).append("com.google.android.exoplayer.MediaCodecTrackRenderer_").append(string).append(n3).toString();
        }
    }
}

