/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.content.Context;
import android.net.Uri;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.libraries.video.SphericalV2ProjectionDataListener;
import com.google.vr.sdk.widgets.video.SphericalMetadataMP4;
import com.google.vr.sdk.widgets.video.SphericalMetadataParser;
import com.google.vr.sdk.widgets.video.SphericalV2MetadataParser;
import com.google.vr.sdk.widgets.video.VideoTexture;
import com.google.vr.sdk.widgets.video.VrSimpleExoPlayer;
import com.google.vr.sdk.widgets.video.VrVideoEventListener;
import com.google.vr.sdk.widgets.video.VrVideoView;
import com.google.vr.sdk.widgets.video.deps.aq;
import com.google.vr.sdk.widgets.video.deps.cJ;
import com.google.vr.sdk.widgets.video.deps.cS;
import com.google.vr.sdk.widgets.video.deps.cW;
import com.google.vr.sdk.widgets.video.deps.dD;
import com.google.vr.sdk.widgets.video.deps.dZ;
import com.google.vr.sdk.widgets.video.deps.di;
import com.google.vr.sdk.widgets.video.deps.dz;
import com.google.vr.sdk.widgets.video.deps.fC;
import com.google.vr.sdk.widgets.video.deps.fj;
import com.google.vr.sdk.widgets.video.deps.fv;
import com.google.vr.sdk.widgets.video.deps.fy;
import com.google.vr.sdk.widgets.video.deps.g;
import com.google.vr.sdk.widgets.video.deps.h;
import com.google.vr.sdk.widgets.video.deps.m;
import com.google.vr.sdk.widgets.video.deps.s;
import com.google.vr.sdk.widgets.video.deps.z;
import com.google.vr.sdk.widgets.video.nano.SphericalMetadataOuterClass;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class VrVideoPlayer
implements cJ,
cS.a {
    private static final String TAG = VrVideoPlayer.class.getSimpleName();
    private static final String EXO_USER_AGENT = "Video Player Widget";
    private static final boolean DEBUG = false;
    private final VideoTexturesListener videoTexturesListener;
    private final VideoTexture videoTexture = new VideoTexture();
    private final VrSimpleExoPlayer simpleExoPlayer;
    private final int[] textureIds = new int[1];
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private boolean isBuffering = false;
    private boolean isLooping;
    private Context context;
    private VrVideoEventListener eventListener;
    private fv.a mediaDataSourceFactory;
    private float volume = 1.0f;
    private float[] cameraRotationMatrix;
    private SphericalMetadataOuterClass.SphericalMetadata metadata;

    public VrVideoPlayer(Context context, VideoTexturesListener videoTexturesListener) {
        this.context = context;
        this.simpleExoPlayer = new VrSimpleExoPlayer(context);
        this.videoTexturesListener = videoTexturesListener;
        this.simpleExoPlayer.setProjectionListener(new ProjectionDataListener());
        this.getExoPlayer().addListener(new VideoLooperListener());
        this.getExoPlayer().setPlayWhenReady(true);
    }

    private synchronized void loadVideoIntoPlayer(Uri uri, VrVideoView.Options options) {
        if (options == null) {
            options = new VrVideoView.Options();
        } else {
            options.validate();
        }
        if (this.mediaDataSourceFactory == null) {
            this.mediaDataSourceFactory = new fC(this.context, EXO_USER_AGENT);
        }
        cW cW2 = this.buildMediaSource(uri, options);
        this.simpleExoPlayer.prepare(cW2);
        this.videoTexture.setOnNewFrameListener(new NewFrameNotifier());
        if (this.videoTexturesListener != null) {
            this.videoTexturesListener.onVideoTexturesReady();
        }
        this.applyVolumeToPlayer();
    }

    private cW buildMediaSource(Uri uri, VrVideoView.Options options) {
        switch (options.inputFormat) {
            case 2: {
                return new dZ(uri, this.mediaDataSourceFactory, this.mainHandler, this);
            }
            case 3: {
                return new dz(uri, this.mediaDataSourceFactory, new dD.a(this.mediaDataSourceFactory), this.mainHandler, (cJ)this);
            }
        }
        return new cS(uri, this.mediaDataSourceFactory, new aq(), this.mainHandler, this);
    }

    public void setEventListener(VrVideoEventListener vrVideoEventListener) {
        this.eventListener = vrVideoEventListener;
    }

    public void openAsset(String string, VrVideoView.Options options) throws IOException {
        this.metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        this.metadata = options != null ? VrVideoPlayer.createMetadataFromOptions(options) : VrVideoPlayer.parseMetadataFromVideoInputStream(this.context.getAssets().open(string));
        String string2 = String.valueOf(string);
        Uri uri = Uri.parse((String)(string2.length() != 0 ? "file:///android_asset/".concat(string2) : new String("file:///android_asset/")));
        this.loadVideoIntoPlayer(uri, options);
    }

    public void openUri(Uri uri, VrVideoView.Options options) throws IOException {
        this.metadata = new SphericalMetadataOuterClass.SphericalMetadata();
        if (options != null) {
            this.metadata = VrVideoPlayer.createMetadataFromOptions(options);
        } else {
            String string = uri.getScheme();
            if (string == null || !string.startsWith("http")) {
                this.metadata = VrVideoPlayer.parseMetadataFromVideoInputStream(new FileInputStream(uri.getPath()));
            }
        }
        this.loadVideoIntoPlayer(uri, options);
    }

    public SphericalMetadataOuterClass.SphericalMetadata getMetadata() {
        return this.metadata;
    }

    public byte[] getMetadataBytes() {
        return SphericalMetadataOuterClass.SphericalMetadata.toByteArray((MessageNano)this.metadata);
    }

    public float[] getCameraRotationMatrix() {
        return this.cameraRotationMatrix;
    }

    public synchronized int[] bindTexture() {
        if (!this.videoTexture.getIsTextureSet()) {
            this.videoTexture.init();
        }
        Surface surface = new Surface(this.videoTexture.getSurfaceTexture());
        this.simpleExoPlayer.setVideoSurface(surface);
        this.simpleExoPlayer.seekTo(this.getExoPlayer().getCurrentPosition() + 1L);
        this.textureIds[0] = this.videoTexture.getTextureId();
        return this.textureIds;
    }

    public synchronized boolean prepareFrame() {
        boolean bl2 = true;
        if (this.videoTexture.getIsTextureSet()) {
            this.videoTexture.updateTexture();
            if (this.simpleExoPlayer.getFrameRotationBuffer() != null) {
                long l2 = this.videoTexture.getTimestamp() / 1000L;
                long l3 = this.simpleExoPlayer.getSampleTimestampUsForReleaseTimeUs(l2);
                this.cameraRotationMatrix = this.simpleExoPlayer.getFrameRotationBuffer().getTransform(l3);
            } else if (this.simpleExoPlayer.getInputFormat() != null && this.simpleExoPlayer.getInputFormat().o != -1) {
                if (this.cameraRotationMatrix == null) {
                    this.cameraRotationMatrix = new float[16];
                }
                Matrix.setIdentityM((float[])this.cameraRotationMatrix, (int)0);
                Matrix.rotateM((float[])this.cameraRotationMatrix, (int)0, (float)this.simpleExoPlayer.getInputFormat().o, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public synchronized void onViewDetach() {
        this.simpleExoPlayer.setVideoSurface(null);
        this.videoTexture.release();
    }

    public synchronized void shutdown() {
        this.getExoPlayer().stop();
        this.getExoPlayer().release();
        this.videoTexture.release();
    }

    public synchronized long getCurrentPositionMs() {
        return this.getExoPlayer().getCurrentPosition();
    }

    public h getExoPlayer() {
        return this.simpleExoPlayer;
    }

    public synchronized void setVolume(float f2) {
        this.volume = f2;
        this.applyVolumeToPlayer();
    }

    void setMediaDataSourceFactory(fv.a a2) {
        this.mediaDataSourceFactory = a2;
    }

    private synchronized void applyVolumeToPlayer() {
        this.simpleExoPlayer.setVolume(this.volume);
    }

    private static SphericalMetadataOuterClass.SphericalMetadata createMetadataFromOptions(VrVideoView.Options options) {
        SphericalMetadataOuterClass.SphericalMetadata sphericalMetadata = new SphericalMetadataOuterClass.SphericalMetadata();
        switch (options.inputType) {
            case 1: {
                sphericalMetadata.frameLayoutMode = 1;
                break;
            }
            case 2: {
                sphericalMetadata.frameLayoutMode = 2;
                break;
            }
            default: {
                int n2 = options.inputType;
                throw new IllegalArgumentException(new StringBuilder(40).append("Unexpected options.inputType ").append(n2).toString());
            }
        }
        return sphericalMetadata;
    }

    private static SphericalMetadataOuterClass.SphericalMetadata parseMetadataFromVideoInputStream(InputStream inputStream) throws IOException {
        SphericalMetadataOuterClass.SphericalMetadata sphericalMetadata = new SphericalMetadataOuterClass.SphericalMetadata();
        String string = SphericalMetadataMP4.extract(inputStream);
        sphericalMetadata = SphericalMetadataParser.parse(string);
        inputStream.close();
        return sphericalMetadata;
    }

    @Override
    public void onLoadError(IOException iOException) {
        int n2 = this.hashCode();
        String string = String.valueOf(iOException);
        Log.e((String)TAG, (String)new StringBuilder(58 + String.valueOf(string).length()).append(n2).append("ExtractorMediaSource.EventListener.onLoadError ").append(string).toString());
        if (this.eventListener != null) {
            this.eventListener.onLoadError(iOException.toString());
        }
    }

    @Override
    public void onLoadStarted(fy fy2, int n2, int n3, m m2, int n4, Object object, long l2, long l3, long l4) {
    }

    @Override
    public void onLoadError(fy fy2, int n2, int n3, m m2, int n4, Object object, long l2, long l3, long l4, long l5, long l6, IOException iOException, boolean bl2) {
        int n5 = this.hashCode();
        String string = String.valueOf(iOException);
        Log.e((String)TAG, (String)new StringBuilder(56 + String.valueOf(string).length()).append(n5).append("AdaptiveMediaSourceEventListener.onLoadError ").append(string).toString());
        if (this.eventListener != null) {
            this.eventListener.onLoadError(iOException.toString());
        }
    }

    @Override
    public void onLoadCanceled(fy fy2, int n2, int n3, m m2, int n4, Object object, long l2, long l3, long l4, long l5, long l6) {
    }

    @Override
    public void onLoadCompleted(fy fy2, int n2, int n3, m m2, int n4, Object object, long l2, long l3, long l4, long l5, long l6) {
    }

    @Override
    public void onUpstreamDiscarded(int n2, long l2, long l3) {
    }

    @Override
    public void onDownstreamFormatChanged(int n2, m m2, int n3, Object object, long l2) {
    }

    private class NewFrameNotifier
    implements VideoTexture.OnNewFrameListener,
    Runnable {
        private final Handler mainHandler = new Handler(Looper.getMainLooper());

        private NewFrameNotifier() {
        }

        @Override
        public void onNewFrame() {
            this.mainHandler.post((Runnable)this);
        }

        @Override
        public void run() {
            if (VrVideoPlayer.this.eventListener != null) {
                VrVideoPlayer.this.eventListener.onNewFrame();
            }
        }
    }

    private class ProjectionDataListener
    implements SphericalV2ProjectionDataListener {
        private ProjectionDataListener() {
        }

        @Override
        public void onProjectionDataChanged(int n2, byte[] byArray) {
            VrVideoPlayer.this.metadata = SphericalV2MetadataParser.parse(n2, byArray);
            if (VrVideoPlayer.this.videoTexturesListener != null) {
                VrVideoPlayer.this.videoTexturesListener.onVideoTexturesReady();
            }
        }
    }

    private class VideoLooperListener
    implements h.a {
        private VideoLooperListener() {
        }

        @Override
        public void onTracksChanged(di di2, fj fj2) {
        }

        @Override
        public void onPositionDiscontinuity() {
        }

        @Override
        public void onPlaybackParametersChanged(s s2) {
        }

        @Override
        public void onRepeatModeChanged(int n2) {
        }

        @Override
        public void onShuffleModeEnabledChanged(boolean bl2) {
        }

        @Override
        public void onTimelineChanged(z z2, Object object) {
        }

        @Override
        public void onLoadingChanged(boolean bl2) {
        }

        @Override
        public void onPlayerError(g g2) {
            int n2 = this.hashCode();
            Log.e((String)TAG, (String)new StringBuilder(25).append(n2).append(".onPlayerError").toString(), (Throwable)g2);
            if (VrVideoPlayer.this.eventListener != null) {
                VrVideoPlayer.this.eventListener.onLoadError(g2.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlayerStateChanged(boolean bl2, int n2) {
            if (n2 == 2) {
                VrVideoPlayer.this.isBuffering = true;
            } else if (n2 == 3) {
                if (VrVideoPlayer.this.isBuffering && VrVideoPlayer.this.eventListener != null) {
                    VrVideoPlayer.this.isBuffering = false;
                    VrVideoPlayer.this.eventListener.onLoadSuccess();
                }
            } else if (bl2 && n2 == 4) {
                if (VrVideoPlayer.this.eventListener != null) {
                    VrVideoPlayer.this.eventListener.onCompletion();
                }
                if (VrVideoPlayer.this.isLooping) {
                    VrVideoPlayer vrVideoPlayer = VrVideoPlayer.this;
                    synchronized (vrVideoPlayer) {
                        VrVideoPlayer.this.getExoPlayer().seekTo(0L);
                    }
                }
            }
        }
    }

    static interface VideoTexturesListener {
        public void onVideoTexturesReady();
    }
}

