/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.video;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.util.Log;
import com.google.vr.sdk.widgets.video.VrVideoPlayerInternal;

class VideoTexture {
    private static final String TAG = VideoTexture.class.getSimpleName();
    private static final boolean DEBUG = false;
    private SurfaceTexture surfaceTexture;
    private final int[] textureHandle = new int[1];
    private boolean needUpdateTexture = false;
    private VrVideoPlayerInternal.NewFrameNotifier frameNotifier;

    public void init() {
        if (this.surfaceTexture != null) {
            Log.w((String)TAG, (String)"Texture is already initialized");
            return;
        }
        GLES20.glGenTextures((int)1, (int[])this.textureHandle, (int)0);
        this.surfaceTexture = new SurfaceTexture(this.textureHandle[0]);
        this.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)new UpdateSurfaceListener());
        GLES20.glBindTexture((int)36197, (int)this.textureHandle[0]);
    }

    public void setFrameNotifier(VrVideoPlayerInternal.NewFrameNotifier frameNotifier) {
        this.frameNotifier = frameNotifier;
    }

    public synchronized void updateTexture() {
        if (this.needUpdateTexture) {
            if (this.surfaceTexture != null) {
                this.surfaceTexture.updateTexImage();
            }
            this.needUpdateTexture = false;
        }
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public boolean getIsTextureSet() {
        return this.surfaceTexture != null;
    }

    public int getTextureId() {
        return this.textureHandle[0];
    }

    public synchronized void release() {
        if (this.surfaceTexture != null) {
            this.surfaceTexture.release();
            GLES20.glDeleteTextures((int)1, (int[])this.textureHandle, (int)0);
            this.surfaceTexture = null;
        }
    }

    private class UpdateSurfaceListener
    implements SurfaceTexture.OnFrameAvailableListener {
        private UpdateSurfaceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            VideoTexture videoTexture = VideoTexture.this;
            synchronized (videoTexture) {
                VideoTexture.this.needUpdateTexture = true;
            }
            if (VideoTexture.this.frameNotifier != null) {
                VideoTexture.this.frameNotifier.onNewFrame();
            }
        }
    }
}

