/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.pano;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.util.Log;
import com.google.vr.cardboard.annotations.UsedByNative;
import com.google.vr.sdk.widgets.common.VrEventListener;
import com.google.vr.sdk.widgets.common.VrWidgetRenderer;
import com.google.vr.sdk.widgets.common.VrWidgetView;
import com.google.vr.sdk.widgets.pano.VrPanoramaEventListener;
import com.google.vr.sdk.widgets.pano.VrPanoramaRenderer;

public class VrPanoramaView
extends VrWidgetView {
    private static final String TAG = VrPanoramaView.class.getSimpleName();
    private static final boolean DEBUG = false;
    private VrPanoramaRenderer renderer;
    private VrPanoramaEventListener eventListener = new VrPanoramaEventListener();

    public VrPanoramaView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VrPanoramaView(Context context) {
        super(context);
    }

    protected VrPanoramaRenderer createRenderer(Context context, VrWidgetRenderer.GLThreadScheduler glThreadScheduler, float xMetersPerPixel, float yMetersPerPixel) {
        this.renderer = new VrPanoramaRenderer(this.getContext(), glThreadScheduler, xMetersPerPixel, yMetersPerPixel);
        return this.renderer;
    }

    public void loadImageFromBitmap(Bitmap bitmap, Options options) {
        if (options == null) {
            options = new Options();
        } else {
            options.validate();
        }
        this.renderer.loadImageFromBitmap(bitmap, options, this.eventListener);
    }

    public void loadImageFromByteArray(byte[] jpegImageData, Options options) {
        if (options == null) {
            options = new Options();
        } else {
            options.validate();
        }
        this.renderer.loadImageFromByteArray(jpegImageData, options, this.eventListener);
    }

    public void setEventListener(VrPanoramaEventListener eventListener) {
        super.setEventListener((VrEventListener)eventListener);
        this.eventListener = eventListener;
    }

    @UsedByNative
    public static class Options {
        private static final int TYPE_START_MARKER = 0;
        public static final int TYPE_MONO = 1;
        public static final int TYPE_STEREO_OVER_UNDER = 2;
        private static final int TYPE_END_MARKER = 3;
        @UsedByNative
        public int inputType = 1;

        void validate() {
            if (this.inputType <= 0 || this.inputType >= 3) {
                int n = this.inputType;
                Log.e((String)TAG, (String)new StringBuilder(38).append("Invalid Options.inputType: ").append(n).toString());
                this.inputType = 1;
            }
        }
    }
}

