/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.widgets.pano;

import android.content.Context;
import android.graphics.Bitmap;
import com.google.vr.sdk.widgets.common.VrEventListener;
import com.google.vr.sdk.widgets.common.VrWidgetRenderer;
import com.google.vr.sdk.widgets.pano.VrPanoramaView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

class VrPanoramaRenderer
extends VrWidgetRenderer {
    private static final String TAG = VrPanoramaRenderer.class.getSimpleName();
    private static final boolean DEBUG = false;
    private volatile VrWidgetRenderer.ApiRequest lastLoadImageRequest;

    public VrPanoramaRenderer(Context context, VrWidgetRenderer.GLThreadScheduler glThreadScheduler, float xMetersPerPixel, float yMetersPerPixel, int screenRotation) {
        super(context, glThreadScheduler, xMetersPerPixel, yMetersPerPixel, screenRotation);
        System.loadLibrary("panorenderer");
    }

    public void loadImageFromBitmap(Bitmap bitmap, VrPanoramaView.Options options, VrEventListener eventListener) {
        this.lastLoadImageRequest = new LoadBitmapRequest(bitmap, options, eventListener);
        this.postApiRequestToGlThread(this.lastLoadImageRequest);
    }

    public void loadImageFromByteArray(byte[] jpegImageData, VrPanoramaView.Options options, VrEventListener eventListener) {
        this.lastLoadImageRequest = new LoadImageFromByteArrayRequest(jpegImageData, options, eventListener);
        this.postApiRequestToGlThread(this.lastLoadImageRequest);
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        super.onSurfaceCreated(gl, config);
        if (this.lastLoadImageRequest != null) {
            this.executeApiRequestOnGlThread(this.lastLoadImageRequest);
        }
    }

    protected native long nativeCreate(ClassLoader var1, Context var2, float var3);

    protected native void nativeResize(long var1, int var3, int var4, float var5, float var6, int var7);

    protected native void nativeDestroy(long var1);

    protected native void nativeRenderFrame(long var1);

    protected native void nativeSetStereoMode(long var1, boolean var3);

    protected native void nativeOnPause(long var1);

    protected native void nativeOnResume(long var1);

    protected native void nativeOnPanningEvent(long var1, float var3, float var4);

    protected native void nativeGetHeadRotation(long var1, float[] var3);

    private native void nativeLoadImageFromBitmap(long var1, Bitmap var3, VrPanoramaView.Options var4, VrEventListener var5);

    private native void nativeLoadImageFromByteArray(long var1, byte[] var3, VrPanoramaView.Options var4, VrEventListener var5);

    private class LoadImageFromByteArrayRequest
    implements VrWidgetRenderer.ApiRequest {
        public final byte[] jpegImageData;
        public final VrPanoramaView.Options options;
        public final VrEventListener eventListener;

        public LoadImageFromByteArrayRequest(byte[] jpegImageData, VrPanoramaView.Options options, VrEventListener eventListener) {
            this.jpegImageData = jpegImageData;
            this.options = options;
            this.eventListener = eventListener;
        }

        public void execute() {
            VrPanoramaRenderer.this.nativeLoadImageFromByteArray(VrPanoramaRenderer.this.getNativeRenderer(), this.jpegImageData, this.options, this.eventListener);
        }
    }

    private class LoadBitmapRequest
    implements VrWidgetRenderer.ApiRequest {
        public final Bitmap bitmap;
        public final VrPanoramaView.Options options;
        public final VrEventListener eventListener;

        public LoadBitmapRequest(Bitmap bitmap, VrPanoramaView.Options options, VrEventListener eventListener) {
            this.bitmap = bitmap;
            this.options = options;
            this.eventListener = eventListener;
        }

        public void execute() {
            VrPanoramaRenderer.this.nativeLoadImageFromBitmap(VrPanoramaRenderer.this.getNativeRenderer(), this.bitmap, this.options, this.eventListener);
        }
    }
}

