/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.controller;

import java.util.Locale;

public class Orientation {
    public float x;
    public float y;
    public float z;
    public float w;

    Orientation() {
        this.set(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Orientation(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    static Orientation fromAxisAngleDegrees(float x, float y, float z, float degrees) {
        return new Orientation((float)Math.sin((double)x * Math.toRadians(degrees / 2.0f)), (float)Math.sin((double)y * Math.toRadians(degrees / 2.0f)), (float)Math.sin((double)z * Math.toRadians(degrees / 2.0f)), (float)Math.cos(Math.toRadians(degrees / 2.0f)));
    }

    void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    void set(Orientation o) {
        this.set(o.x, o.y, o.z, o.w);
    }

    public String toString() {
        return String.format(Locale.US, "%5.2fi %5.2fj %5.2fk %5.2f", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.w));
    }

    public String toAxisAngleString() {
        float ang = (float)Math.toDegrees(2.0 * Math.acos(this.w));
        float sqrt = (float)Math.sqrt(1.0f - this.w * this.w);
        float vecX = sqrt > 0.0f ? this.x / sqrt : 0.0f;
        float vecY = sqrt > 0.0f ? this.y / sqrt : 0.0f;
        float vecZ = sqrt > 0.0f ? this.z / sqrt : 0.0f;
        return String.format(Locale.US, "(%5.2f, %5.2f, %5.2f), %3.0f\u00b0", Float.valueOf(vecX), Float.valueOf(vecY), Float.valueOf(vecZ), Float.valueOf(ang));
    }

    void multiply(Orientation o) {
        float x0 = this.x;
        float y0 = this.y;
        float z0 = this.z;
        float w0 = this.w;
        this.x = o.w * x0 + o.x * w0 + o.z * y0 - o.y * z0;
        this.y = o.w * y0 + o.y * w0 + o.x * z0 - o.z * x0;
        this.z = o.w * z0 + o.z * w0 + o.y * x0 - o.x * y0;
        this.w = o.w * w0 - o.x * x0 - o.y * y0 - o.z * z0;
    }

    public float[] toYawPitchRollRadians(float[] angles) {
        if (angles == null) {
            angles = new float[3];
        }
        float vx = -2.0f * (this.x * this.z + this.w * this.y);
        float vy = 2.0f * (this.w * this.x - this.y * this.z);
        float vz = -this.w * this.w + this.x * this.x + this.y * this.y - this.z * this.z;
        if (Math.abs(vy) < 0.9999f) {
            angles[0] = (float)Math.atan2(-vx, -vz);
            angles[1] = (float)Math.asin(vy);
            angles[2] = (float)Math.atan2(2.0f * this.w * this.z + 2.0f * this.x * this.y, 1.0f - 2.0f * this.x * this.x - 2.0f * this.z * this.z);
        } else {
            angles[0] = (float)((double)Math.copySign(2.0f, vy) * Math.atan2(this.z, this.w));
            angles[1] = (float)Math.copySign(1.5707963267948966, (double)vy);
            angles[2] = 0.0f;
        }
        return angles;
    }

    public float[] toYawPitchRollDegrees(float[] angles) {
        float[] anglesDeg = this.toYawPitchRollRadians(angles);
        for (int i = 0; i < 3; ++i) {
            anglesDeg[i] = (float)Math.toDegrees(anglesDeg[i]);
        }
        return anglesDeg;
    }

    public float[] toRotationMatrix(float[] output) {
        output[0] = 1.0f - 2.0f * this.y * this.y - 2.0f * this.z * this.z;
        output[1] = 2.0f * this.x * this.y + 2.0f * this.z * this.w;
        output[2] = 2.0f * this.x * this.z - 2.0f * this.y * this.w;
        output[3] = 0.0f;
        output[4] = 2.0f * this.x * this.y - 2.0f * this.z * this.w;
        output[5] = 1.0f - 2.0f * this.x * this.x - 2.0f * this.z * this.z;
        output[6] = 2.0f * this.y * this.z + 2.0f * this.x * this.w;
        output[7] = 0.0f;
        output[8] = 2.0f * this.x * this.z + 2.0f * this.y * this.w;
        output[9] = 2.0f * this.y * this.z - 2.0f * this.x * this.w;
        output[10] = 1.0f - 2.0f * this.x * this.x - 2.0f * this.y * this.y;
        output[11] = 0.0f;
        output[12] = 0.0f;
        output[13] = 0.0f;
        output[14] = 0.0f;
        output[15] = 1.0f;
        return output;
    }
}

