/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.common.api;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.aidl.BaseProxy;
import com.google.android.aidl.BaseStub;
import com.google.android.aidl.Codecs;
import com.google.vr.vrcore.common.api.HeadTrackingState;
import com.google.vr.vrcore.common.api.IDaydreamListener;
import com.google.vr.vrcore.common.api.ITransitionCallbacks;

public interface IDaydreamManager
extends IInterface {
    public boolean registerListener(ComponentName var1, IDaydreamListener var2) throws RemoteException;

    public boolean unregisterListener(ComponentName var1) throws RemoteException;

    public int prepareVr(ComponentName var1, HeadTrackingState var2) throws RemoteException;

    public boolean deprecatedLaunchInVr(PendingIntent var1) throws RemoteException;

    public void registerDaydreamIntent(PendingIntent var1) throws RemoteException;

    public void unregisterDaydreamIntent() throws RemoteException;

    public boolean launchInVr(PendingIntent var1, ComponentName var2) throws RemoteException;

    public boolean launchVrHome() throws RemoteException;

    public boolean launchVrTransition(ITransitionCallbacks var1) throws RemoteException;

    public boolean exitFromVr(PendingIntent var1) throws RemoteException;

    public void handleInsertionIntoHeadset(byte[] var1) throws RemoteException;

    public void handleRemovalFromHeadset() throws RemoteException;

    public int prepareVr2(ComponentName var1, int var2, PendingIntent var3, HeadTrackingState var4) throws RemoteException;

    public void onExitingFromVr() throws RemoteException;

    public static abstract class Stub
    extends BaseStub
    implements IDaydreamManager {
        private static final String DESCRIPTOR = "com.google.vr.vrcore.common.api.IDaydreamManager";
        static final int TRANSACTION_registerListener = 1;
        static final int TRANSACTION_unregisterListener = 2;
        static final int TRANSACTION_prepareVr = 3;
        static final int TRANSACTION_deprecatedLaunchInVr = 4;
        static final int TRANSACTION_registerDaydreamIntent = 5;
        static final int TRANSACTION_unregisterDaydreamIntent = 6;
        static final int TRANSACTION_launchInVr = 7;
        static final int TRANSACTION_launchVrHome = 8;
        static final int TRANSACTION_launchVrTransition = 9;
        static final int TRANSACTION_exitFromVr = 10;
        static final int TRANSACTION_handleInsertionIntoHeadset = 11;
        static final int TRANSACTION_handleRemovalFromHeadset = 12;
        static final int TRANSACTION_prepareVr2 = 13;
        static final int TRANSACTION_onExitingFromVr = 14;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDaydreamManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface instanceof IDaydreamManager) {
                return (IDaydreamManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            if (this.routeToSuperOrEnforceInterface(n, parcel, parcel2, n2)) {
                return true;
            }
            switch (n) {
                case 1: {
                    ComponentName componentName = (ComponentName)Codecs.createParcelable(parcel, ComponentName.CREATOR);
                    IDaydreamListener iDaydreamListener = IDaydreamListener.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = this.registerListener(componentName, iDaydreamListener);
                    parcel2.writeNoException();
                    Codecs.writeBoolean(parcel2, bl);
                    break;
                }
                case 2: {
                    ComponentName componentName = (ComponentName)Codecs.createParcelable(parcel, ComponentName.CREATOR);
                    boolean bl = this.unregisterListener(componentName);
                    parcel2.writeNoException();
                    Codecs.writeBoolean(parcel2, bl);
                    break;
                }
                case 3: {
                    ComponentName componentName = (ComponentName)Codecs.createParcelable(parcel, ComponentName.CREATOR);
                    HeadTrackingState headTrackingState = new HeadTrackingState();
                    int n3 = this.prepareVr(componentName, headTrackingState);
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    Codecs.writeParcelableAsReturnValue(parcel2, headTrackingState);
                    break;
                }
                case 4: {
                    PendingIntent pendingIntent = (PendingIntent)Codecs.createParcelable(parcel, PendingIntent.CREATOR);
                    boolean bl = this.deprecatedLaunchInVr(pendingIntent);
                    parcel2.writeNoException();
                    Codecs.writeBoolean(parcel2, bl);
                    break;
                }
                case 5: {
                    PendingIntent pendingIntent = (PendingIntent)Codecs.createParcelable(parcel, PendingIntent.CREATOR);
                    this.registerDaydreamIntent(pendingIntent);
                    break;
                }
                case 6: {
                    this.unregisterDaydreamIntent();
                    break;
                }
                case 7: {
                    PendingIntent pendingIntent = (PendingIntent)Codecs.createParcelable(parcel, PendingIntent.CREATOR);
                    ComponentName componentName = (ComponentName)Codecs.createParcelable(parcel, ComponentName.CREATOR);
                    boolean bl = this.launchInVr(pendingIntent, componentName);
                    parcel2.writeNoException();
                    Codecs.writeBoolean(parcel2, bl);
                    break;
                }
                case 8: {
                    boolean bl = this.launchVrHome();
                    parcel2.writeNoException();
                    Codecs.writeBoolean(parcel2, bl);
                    break;
                }
                case 9: {
                    ITransitionCallbacks iTransitionCallbacks = ITransitionCallbacks.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = this.launchVrTransition(iTransitionCallbacks);
                    parcel2.writeNoException();
                    Codecs.writeBoolean(parcel2, bl);
                    break;
                }
                case 10: {
                    PendingIntent pendingIntent = (PendingIntent)Codecs.createParcelable(parcel, PendingIntent.CREATOR);
                    boolean bl = this.exitFromVr(pendingIntent);
                    parcel2.writeNoException();
                    Codecs.writeBoolean(parcel2, bl);
                    break;
                }
                case 11: {
                    byte[] byArray = parcel.createByteArray();
                    this.handleInsertionIntoHeadset(byArray);
                    break;
                }
                case 12: {
                    this.handleRemovalFromHeadset();
                    break;
                }
                case 13: {
                    ComponentName componentName = (ComponentName)Codecs.createParcelable(parcel, ComponentName.CREATOR);
                    int n4 = parcel.readInt();
                    PendingIntent pendingIntent = (PendingIntent)Codecs.createParcelable(parcel, PendingIntent.CREATOR);
                    HeadTrackingState headTrackingState = new HeadTrackingState();
                    int n5 = this.prepareVr2(componentName, n4, pendingIntent, headTrackingState);
                    parcel2.writeNoException();
                    parcel2.writeInt(n5);
                    Codecs.writeParcelableAsReturnValue(parcel2, headTrackingState);
                    break;
                }
                case 14: {
                    this.onExitingFromVr();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public static class Proxy
        extends BaseProxy
        implements IDaydreamManager {
            Proxy(IBinder iBinder) {
                super(iBinder, Stub.DESCRIPTOR);
            }

            @Override
            public boolean registerListener(ComponentName componentName, IDaydreamListener iDaydreamListener) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeParcelable(parcel, (Parcelable)componentName);
                Codecs.writeStrongBinder(parcel, iDaydreamListener);
                Parcel parcel2 = this.transactAndReadException(1, parcel);
                boolean bl = Codecs.createBoolean(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean unregisterListener(ComponentName componentName) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeParcelable(parcel, (Parcelable)componentName);
                Parcel parcel2 = this.transactAndReadException(2, parcel);
                boolean bl = Codecs.createBoolean(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public int prepareVr(ComponentName componentName, HeadTrackingState headTrackingState) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeParcelable(parcel, (Parcelable)componentName);
                Parcel parcel2 = this.transactAndReadException(3, parcel);
                int n = parcel2.readInt();
                if (parcel2.readInt() != 0) {
                    headTrackingState.readFromParcel(parcel2);
                }
                parcel2.recycle();
                return n;
            }

            @Override
            public boolean deprecatedLaunchInVr(PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeParcelable(parcel, (Parcelable)pendingIntent);
                Parcel parcel2 = this.transactAndReadException(4, parcel);
                boolean bl = Codecs.createBoolean(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public void registerDaydreamIntent(PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeParcelable(parcel, (Parcelable)pendingIntent);
                this.transactOneway(5, parcel);
            }

            @Override
            public void unregisterDaydreamIntent() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                this.transactOneway(6, parcel);
            }

            @Override
            public boolean launchInVr(PendingIntent pendingIntent, ComponentName componentName) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeParcelable(parcel, (Parcelable)pendingIntent);
                Codecs.writeParcelable(parcel, (Parcelable)componentName);
                Parcel parcel2 = this.transactAndReadException(7, parcel);
                boolean bl = Codecs.createBoolean(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean launchVrHome() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Parcel parcel2 = this.transactAndReadException(8, parcel);
                boolean bl = Codecs.createBoolean(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean launchVrTransition(ITransitionCallbacks iTransitionCallbacks) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeStrongBinder(parcel, iTransitionCallbacks);
                Parcel parcel2 = this.transactAndReadException(9, parcel);
                boolean bl = Codecs.createBoolean(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean exitFromVr(PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeParcelable(parcel, (Parcelable)pendingIntent);
                Parcel parcel2 = this.transactAndReadException(10, parcel);
                boolean bl = Codecs.createBoolean(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public void handleInsertionIntoHeadset(byte[] byArray) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeByteArray(byArray);
                this.transactOneway(11, parcel);
            }

            @Override
            public void handleRemovalFromHeadset() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                this.transactOneway(12, parcel);
            }

            @Override
            public int prepareVr2(ComponentName componentName, int n, PendingIntent pendingIntent, HeadTrackingState headTrackingState) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeParcelable(parcel, (Parcelable)componentName);
                parcel.writeInt(n);
                Codecs.writeParcelable(parcel, (Parcelable)pendingIntent);
                Parcel parcel2 = this.transactAndReadException(13, parcel);
                int n2 = parcel2.readInt();
                if (parcel2.readInt() != 0) {
                    headTrackingState.readFromParcel(parcel2);
                }
                parcel2.recycle();
                return n2;
            }

            @Override
            public void onExitingFromVr() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                this.transactOneway(14, parcel);
            }
        }
    }
}

