/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.vr.cardboard.R;
import com.google.vr.cardboard.ThreadUtils;
import com.google.vr.cardboard.UiUtils;
import com.google.vr.ndk.base.DaydreamApi;
import com.google.vr.ndk.base.DaydreamUtils;
import com.google.vr.ndk.base.DaydreamUtilsWrapper;
import com.google.vr.ndk.base.FadeOverlayView;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.common.api.HeadTrackingState;
import com.google.vr.vrcore.common.api.IDaydreamListener;
import com.google.vr.vrcore.common.api.IDaydreamManager;
import com.google.vr.vrcore.common.api.IVrCoreSdkService;
import com.google.vr.vrcore.logging.api.IVrCoreLoggingService;
import java.lang.ref.WeakReference;

class VrCoreSdkClient {
    private static final String TAG = "VrCoreSdkClient";
    private static final boolean DEBUG = false;
    static final int MIN_VRCORE_API_VERSION = 5;
    static final int TARGET_VRCORE_API_VERSION = 19;
    static final int MIN_PREPARE_VR_2_API_VERSION = 13;
    static final int MIN_ON_EXITING_FROM_VR_API_VERSION = 16;
    private final Context context;
    private final GvrApi gvrApi;
    private final ComponentName componentName;
    private final DaydreamUtilsWrapper daydreamUtils;
    private final Runnable closeVrRunnable;
    private final FadeOverlayView fadeOverlayView;
    private final DaydreamListenerImpl daydreamListener;
    private final boolean shouldBind;
    private boolean isBound;
    private boolean isResumed;
    private boolean isEnabled = true;
    private IVrCoreSdkService vrCoreSdkService;
    private IDaydreamManager daydreamManager;
    private IVrCoreLoggingService loggingService;
    private AlertDialog helpCenterDialog;
    private int vrCoreClientApiVersion;
    private PendingIntent optionalReentryIntent;
    private final ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            block19: {
                HeadTrackingState headTrackingState;
                block18: {
                    IVrCoreSdkService iVrCoreSdkService = IVrCoreSdkService.Stub.asInterface(iBinder);
                    try {
                        if (!iVrCoreSdkService.initialize(19)) {
                            Log.e((String)VrCoreSdkClient.TAG, (String)"Failed to initialize VrCore SDK Service.");
                            VrCoreSdkClient.this.handleBindFailed();
                            return;
                        }
                    }
                    catch (RemoteException remoteException) {
                        String string2 = String.valueOf((Object)remoteException);
                        Log.w((String)VrCoreSdkClient.TAG, (String)new StringBuilder(41 + String.valueOf(string2).length()).append("Failed to initialize VrCore SDK Service: ").append(string2).toString());
                        VrCoreSdkClient.this.handleBindFailed();
                        return;
                    }
                    VrCoreSdkClient.this.vrCoreSdkService = iVrCoreSdkService;
                    try {
                        VrCoreSdkClient.this.daydreamManager = VrCoreSdkClient.this.vrCoreSdkService.getDaydreamManager();
                        if (VrCoreSdkClient.this.daydreamManager == null) {
                            Log.w((String)VrCoreSdkClient.TAG, (String)"Failed to obtain DaydreamManager from VrCore SDK Service.");
                            VrCoreSdkClient.this.handleNoDaydreamManager();
                            return;
                        }
                        VrCoreSdkClient.this.daydreamManager.registerListener(VrCoreSdkClient.this.componentName, VrCoreSdkClient.this.daydreamListener);
                    }
                    catch (RemoteException remoteException) {
                        String string3 = String.valueOf((Object)remoteException);
                        Log.w((String)VrCoreSdkClient.TAG, (String)new StringBuilder(57 + String.valueOf(string3).length()).append("Failed to obtain DaydreamManager from VrCore SDK Service:").append(string3).toString());
                        VrCoreSdkClient.this.handleNoDaydreamManager();
                        return;
                    }
                    headTrackingState = null;
                    try {
                        int n;
                        HeadTrackingState headTrackingState2 = VrCoreSdkClient.this.getHeadTrackingState();
                        if (VrCoreSdkClient.this.vrCoreClientApiVersion >= 13) {
                            int n2 = DaydreamUtils.getComponentDaydreamCompatibility(VrCoreSdkClient.this.context, VrCoreSdkClient.this.componentName);
                            PendingIntent pendingIntent = VrCoreSdkClient.this.optionalReentryIntent;
                            if (pendingIntent == null) {
                                Intent intent = DaydreamApi.createVrIntent(VrCoreSdkClient.this.componentName);
                                intent.addFlags(0x20000000);
                                pendingIntent = PendingIntent.getActivity((Context)VrCoreSdkClient.this.context, (int)0, (Intent)intent, (int)0x40000000);
                            }
                            n = VrCoreSdkClient.this.daydreamManager.prepareVr2(VrCoreSdkClient.this.componentName, n2, pendingIntent, headTrackingState2);
                        } else {
                            if (VrCoreSdkClient.this.optionalReentryIntent != null) {
                                Log.i((String)VrCoreSdkClient.TAG, (String)"Ignoring client re-entry intent; unsupported by current VrCore.");
                            }
                            n = VrCoreSdkClient.this.daydreamManager.prepareVr(VrCoreSdkClient.this.componentName, headTrackingState2);
                        }
                        if (n == 2) {
                            Log.e((String)VrCoreSdkClient.TAG, (String)"Daydream VR preparation failed, closing VR session.");
                            VrCoreSdkClient.this.handlePrepareVrFailed();
                            return;
                        }
                        if (n != 0) break block18;
                        headTrackingState = headTrackingState2;
                    }
                    catch (RemoteException remoteException) {
                        String string4 = String.valueOf((Object)remoteException);
                        Log.w((String)VrCoreSdkClient.TAG, (String)new StringBuilder(61 + String.valueOf(string4).length()).append("Error while registering listener with the VrCore SDK Service:").append(string4).toString());
                        break block19;
                    }
                    finally {
                        VrCoreSdkClient.this.resumeTracking(null);
                    }
                }
                VrCoreSdkClient.this.resumeTracking(headTrackingState);
            }
            try {
                VrCoreSdkClient.this.loggingService = VrCoreSdkClient.this.vrCoreSdkService.getLoggingService();
                return;
            }
            catch (RemoteException remoteException) {
                String string5 = String.valueOf((Object)remoteException);
                Log.w((String)VrCoreSdkClient.TAG, (String)new StringBuilder(42 + String.valueOf(string5).length()).append("Error getting logging service from VrCore:").append(string5).toString());
                return;
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            VrCoreSdkClient.this.vrCoreSdkService = null;
            VrCoreSdkClient.this.daydreamManager = null;
            VrCoreSdkClient.this.loggingService = null;
        }
    };

    public VrCoreSdkClient(Context context, GvrApi gvrApi, ComponentName componentName, DaydreamUtilsWrapper daydreamUtilsWrapper, Runnable runnable, FadeOverlayView fadeOverlayView) {
        this.context = context;
        this.gvrApi = gvrApi;
        this.componentName = componentName;
        this.daydreamUtils = daydreamUtilsWrapper;
        this.closeVrRunnable = runnable;
        this.fadeOverlayView = fadeOverlayView;
        this.daydreamListener = new DaydreamListenerImpl(gvrApi, fadeOverlayView, runnable);
        this.shouldBind = this.hasCompatibleSdkService(context);
        gvrApi.setIgnoreManualTrackerPauseResume(true);
    }

    IDaydreamManager getDaydreamManager() {
        return this.daydreamManager;
    }

    IVrCoreLoggingService getLoggingService() {
        return this.loggingService;
    }

    HeadTrackingState getHeadTrackingState() {
        return new HeadTrackingState();
    }

    public boolean onResume() {
        this.isResumed = true;
        if (!this.isEnabled) {
            return false;
        }
        return this.doBind();
    }

    public void onPause() {
        this.isResumed = false;
        this.daydreamListener.resetSafeguards();
        if (this.isEnabled) {
            this.doUnbind();
        }
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled == bl) {
            return;
        }
        this.isEnabled = bl;
        this.gvrApi.setIgnoreManualTrackerPauseResume(bl);
        if (this.isResumed) {
            if (this.isEnabled) {
                this.doBind();
                return;
            }
            this.doUnbind();
        }
    }

    public void setReentryIntent(PendingIntent pendingIntent) {
        this.optionalReentryIntent = pendingIntent;
    }

    public void onExitingFromVr() {
        if (this.daydreamManager == null) {
            return;
        }
        if (this.vrCoreClientApiVersion < 16) {
            return;
        }
        try {
            this.daydreamManager.onExitingFromVr();
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf((Object)remoteException);
            Log.e((String)TAG, (String)new StringBuilder(41 + String.valueOf(string2).length()).append("Failed to signal exit from VR to VrCore: ").append(string2).toString());
            return;
        }
    }

    private boolean doBind() {
        if (this.isBound) {
            return true;
        }
        if (this.shouldBind) {
            Intent intent = new Intent("com.google.vr.vrcore.BIND_SDK_SERVICE");
            intent.setPackage("com.google.vr.vrcore");
            this.isBound = this.context.bindService(intent, this.serviceConnection, 1);
        }
        if (!this.isBound) {
            this.handleBindFailed();
        }
        return this.isBound;
    }

    private void doUnbind() {
        if (this.isResumed) {
            this.resumeTracking(null);
        } else {
            this.gvrApi.pauseTrackingGetState();
        }
        if (!this.isBound) {
            return;
        }
        if (this.daydreamManager != null) {
            try {
                this.daydreamManager.unregisterListener(this.componentName);
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf((Object)remoteException);
                Log.w((String)TAG, (String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to unregister Daydream listener: ").append(string2).toString());
            }
            this.daydreamManager = null;
        }
        this.vrCoreSdkService = null;
        this.loggingService = null;
        this.context.unbindService(this.serviceConnection);
        this.isBound = false;
    }

    private void handleBindFailed() {
        this.doUnbind();
        this.warnIfIncompatibleClient();
    }

    private void handleNoDaydreamManager() {
        this.doUnbind();
        this.warnIfIncompatibleClient();
    }

    private void handlePrepareVrFailed() {
        this.doUnbind();
        this.closeVrRunnable.run();
    }

    private void warnIfIncompatibleClient() {
        if (!this.daydreamUtils.isDaydreamPhone(this.context) && this.daydreamUtils.isDaydreamRequiredComponent(this.context) && !ActivityManager.isRunningInTestHarness()) {
            if (this.helpCenterDialog != null) {
                this.helpCenterDialog.show();
                return;
            }
            this.helpCenterDialog = UiUtils.showDaydreamHelpCenterDialog(this.context, R.string.dialog_title_incompatible_phone, R.string.dialog_message_incompatible_phone, this.closeVrRunnable);
        }
    }

    private void resumeTracking(HeadTrackingState headTrackingState) {
        VrCoreSdkClient.resumeTracking(this.gvrApi, headTrackingState);
        if (this.fadeOverlayView != null) {
            this.fadeOverlayView.flushAutoFade();
        }
    }

    private static void resumeTracking(GvrApi gvrApi, HeadTrackingState headTrackingState) {
        gvrApi.resumeTrackingSetState(headTrackingState != null && !headTrackingState.isEmpty() ? headTrackingState.getData() : null);
    }

    private boolean hasCompatibleSdkService(Context context) {
        try {
            this.vrCoreClientApiVersion = VrCoreUtils.getVrCoreClientApiVersion(context);
            if (this.vrCoreClientApiVersion >= 5) {
                return true;
            }
            Log.w((String)TAG, (String)String.format("VrCore service obsolete, GVR SDK requires API %d but found API %d.", 5, this.vrCoreClientApiVersion));
        }
        catch (VrCoreNotAvailableException vrCoreNotAvailableException) {}
        return false;
    }

    static final class DaydreamListenerImpl
    extends IDaydreamListener.Stub {
        private static final long TRACKING_SAFEGUARD_DELAY_MILLIS = 5000L;
        private static final long FADE_SAFEGUARD_DELAY_MILLIS = 5500L;
        private static final int MSG_TRACKING_RESUME_SAFEGUARD = 1;
        private static final int MSG_FADE_IN_SAFEGUARD = 2;
        private final WeakReference<GvrApi> gvrApiWeak;
        private final WeakReference<FadeOverlayView> fadeOverlayViewWeak;
        private final WeakReference<Runnable> closeVrRunnableWeak;
        private final Handler safeguardHandler = new Handler(){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 2: {
                        Log.w((String)VrCoreSdkClient.TAG, (String)"Forcing fade in: VrCore unresponsive");
                        DaydreamListenerImpl.this.applyFadeImpl(1, 350L);
                        return;
                    }
                    case 1: {
                        Log.w((String)VrCoreSdkClient.TAG, (String)"Forcing tracking resume: VrCore unresponsive");
                        DaydreamListenerImpl.this.resumeHeadTrackingImpl(null);
                        return;
                    }
                }
                super.handleMessage(message);
            }
        };

        DaydreamListenerImpl(GvrApi gvrApi, FadeOverlayView fadeOverlayView, Runnable runnable) {
            this.gvrApiWeak = new WeakReference<GvrApi>(gvrApi);
            this.fadeOverlayViewWeak = new WeakReference<FadeOverlayView>(fadeOverlayView);
            this.closeVrRunnableWeak = new WeakReference<Runnable>(runnable);
        }

        final void resetSafeguards() {
            this.safeguardHandler.removeCallbacksAndMessages(null);
        }

        @Override
        public final int getTargetApiVersion() throws RemoteException {
            return 19;
        }

        @Override
        public final HeadTrackingState requestStopTracking() throws RemoteException {
            GvrApi gvrApi = (GvrApi)this.gvrApiWeak.get();
            if (gvrApi == null) {
                Log.w((String)VrCoreSdkClient.TAG, (String)"Invalid requestStopTracking() call: GvrApi no longer valid");
                return null;
            }
            byte[] byArray = gvrApi.pauseTrackingGetState();
            this.rescheduleSafeguard(1, 5000L);
            if (byArray != null) {
                return new HeadTrackingState(byArray);
            }
            return null;
        }

        @Override
        public final void applyFade(int n, long l) {
            this.applyFadeImpl(n, l);
        }

        @Override
        public final void recenterHeadTracking() throws RemoteException {
            GvrApi gvrApi = (GvrApi)this.gvrApiWeak.get();
            if (gvrApi == null) {
                Log.w((String)VrCoreSdkClient.TAG, (String)"Invalid recenterHeadTracking() call: GvrApi no longer valid");
                return;
            }
            gvrApi.recenterTracking();
        }

        @Override
        public final void dumpDebugData() throws RemoteException {
            GvrApi gvrApi = (GvrApi)this.gvrApiWeak.get();
            if (gvrApi == null) {
                Log.w((String)VrCoreSdkClient.TAG, (String)"Invalid dumpDebugData() call: GvrApi no longer valid");
                return;
            }
            gvrApi.dumpDebugData();
        }

        @Override
        public final void resumeHeadTracking(HeadTrackingState headTrackingState) {
            this.resumeHeadTrackingImpl(headTrackingState);
        }

        @Override
        public final void invokeCloseAction() {
            Runnable runnable = (Runnable)this.closeVrRunnableWeak.get();
            if (runnable == null) {
                Log.w((String)VrCoreSdkClient.TAG, (String)"Invalid invokeCloseAction() call: Runnable no longer valid");
                return;
            }
            ThreadUtils.runOnUiThread(runnable);
        }

        @Override
        public final void deprecated_setLensOffsets(float f, float f2, float f3, float f4) {
            GvrApi gvrApi = (GvrApi)this.gvrApiWeak.get();
            if (gvrApi == null) {
                Log.w((String)VrCoreSdkClient.TAG, (String)"Invalid setLensOffsets() call: GvrApi no longer valid");
                return;
            }
            gvrApi.setLensOffset(f, f2, 0.0f);
        }

        @Override
        public final void setLensOffset(float f, float f2, float f3) {
            GvrApi gvrApi = (GvrApi)this.gvrApiWeak.get();
            if (gvrApi == null) {
                Log.w((String)VrCoreSdkClient.TAG, (String)"Invalid setLensOffset() call: GvrApi no longer valid");
                return;
            }
            gvrApi.setLensOffset(f, f2, f3);
        }

        private final void resumeHeadTrackingImpl(HeadTrackingState headTrackingState) {
            GvrApi gvrApi = (GvrApi)this.gvrApiWeak.get();
            if (gvrApi == null) {
                Log.w((String)VrCoreSdkClient.TAG, (String)"Invalid resumeHeadTracking() call: GvrApi no longer valid");
                return;
            }
            this.cancelSafeguard(1);
            VrCoreSdkClient.resumeTracking(gvrApi, headTrackingState);
        }

        private final void applyFadeImpl(final int n, final long l) {
            final FadeOverlayView fadeOverlayView = (FadeOverlayView)((Object)this.fadeOverlayViewWeak.get());
            if (fadeOverlayView == null) {
                return;
            }
            this.cancelSafeguard(2);
            fadeOverlayView.post(new Runnable(this){

                @Override
                public void run() {
                    fadeOverlayView.startFade(n, l);
                }
            });
            if (n == 2) {
                this.rescheduleSafeguard(2, l + 5500L);
            }
        }

        private final void cancelSafeguard(int n) {
            this.safeguardHandler.removeMessages(n);
        }

        private final void rescheduleSafeguard(int n, long l) {
            this.cancelSafeguard(n);
            this.safeguardHandler.sendEmptyMessageDelayed(n, l);
        }
    }
}

