/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.internal.controller;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import com.google.devtools.build.android.desugar.runtime.ThrowableExtension;
import com.google.vr.cardboard.annotations.UsedByNative;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerEventPacket2;
import com.google.vr.vrcore.controller.api.ControllerInitResults;
import com.google.vr.vrcore.controller.api.ControllerListenerOptions;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.IControllerListener;
import com.google.vr.vrcore.controller.api.IControllerService;
import java.lang.ref.WeakReference;

@UsedByNative
public class ControllerServiceBridge
implements ServiceConnection {
    static final String TAG = ControllerServiceBridge.class.getSimpleName();
    private static final boolean DEBUG = false;
    public static final int TARGET_SERVICE_API_VERSION = 13;
    static final String LISTENER_KEY = "com.google.vr.internal.controller.LISTENER_KEY";
    public static final int FLAG_SUPPORTS_RECENTER = 1;
    private final Context context;
    private final Handler mainThreadHandler;
    private IControllerService service;
    private LocalControllerListener defaultListener;
    private final SparseArray<LocalControllerListener> controllerListenerMap = new SparseArray();
    private boolean isBound;
    private final Runnable bindRunnable = new Runnable(){

        @Override
        public void run() {
            ControllerServiceBridge.this.doBind();
        }
    };
    private final Runnable unbindRunnable = new Runnable(){

        @Override
        public void run() {
            ControllerServiceBridge.this.doUnbind();
        }
    };

    @UsedByNative
    public ControllerServiceBridge(Context context, Callbacks callbacks) {
        this.context = context.getApplicationContext();
        this.defaultListener = new LocalControllerListener(callbacks, new ControllerListenerOptions());
        this.controllerListenerMap.put(0, (Object)this.defaultListener);
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
    }

    @UsedByNative
    public void setOrientationEnabled(boolean bl) {
        this.defaultListener.options.enableOrientation = bl;
    }

    @UsedByNative
    public void setTouchEnabled(boolean bl) {
        this.defaultListener.options.enableTouch = bl;
    }

    @UsedByNative
    public void setGyroEnabled(boolean bl) {
        this.defaultListener.options.enableGyro = bl;
    }

    @UsedByNative
    public void setAccelEnabled(boolean bl) {
        this.defaultListener.options.enableAccel = bl;
    }

    @UsedByNative
    public void setGesturesEnabled(boolean bl) {
        this.defaultListener.options.enableGestures = bl;
    }

    @UsedByNative
    public void setPositionEnabled(boolean bl) {
    }

    @UsedByNative
    public void setBatteryEnabled(boolean bl) {
    }

    @UsedByNative
    public void requestBind() {
        this.mainThreadHandler.post(this.bindRunnable);
    }

    @UsedByNative
    public void requestUnbind() {
        this.mainThreadHandler.post(this.unbindRunnable);
    }

    public void doBind() {
        this.ensureOnMainThread();
        if (this.isBound) {
            Log.w((String)TAG, (String)"Service is already bound.");
            return;
        }
        Intent intent = new Intent("com.google.vr.vrcore.controller.BIND");
        intent.setPackage("com.google.vr.vrcore");
        if (!this.context.bindService(intent, (ServiceConnection)this, 1)) {
            Log.w((String)TAG, (String)"Bind failed. Service is not available.");
            this.defaultListener.callbacks.onServiceUnavailable();
            return;
        }
        this.isBound = true;
    }

    public void doUnbind() {
        this.ensureOnMainThread();
        if (!this.isBound) {
            Log.w((String)TAG, (String)"Service is already unbound.");
            return;
        }
        this.unregisterListener();
        this.context.unbindService((ServiceConnection)this);
        this.isBound = false;
    }

    public Callbacks getControllerCallbacks(int n) {
        this.ensureOnMainThread();
        LocalControllerListener localControllerListener = (LocalControllerListener)this.controllerListenerMap.get(n);
        if (localControllerListener == null) {
            return null;
        }
        return localControllerListener.callbacks;
    }

    public void clearControllers() {
        this.ensureOnMainThread();
        this.controllerListenerMap.clear();
    }

    public boolean createAndConnectController(int n, Callbacks callbacks) throws RemoteException {
        this.ensureOnMainThread();
        if (this.service == null) {
            return false;
        }
        LocalControllerListener localControllerListener = new LocalControllerListener(callbacks, new ControllerListenerOptions());
        if (this.service.registerListener(n, LISTENER_KEY, new ControllerListener(localControllerListener))) {
            if (n == 0) {
                this.defaultListener = localControllerListener;
            }
            this.controllerListenerMap.put(n, (Object)localControllerListener);
            return true;
        }
        Log.e((String)TAG, (String)new StringBuilder(41).append("Failed to connect controller ").append(n).append(".").toString());
        this.controllerListenerMap.remove(n);
        return false;
    }

    public void unregisterListener() {
        this.ensureOnMainThread();
        if (this.service == null) {
            return;
        }
        try {
            this.service.unregisterListener(LISTENER_KEY);
            return;
        }
        catch (RemoteException remoteException) {
            RemoteException remoteException2 = remoteException;
            ThrowableExtension.printStackTrace(remoteException);
            Log.w((String)TAG, (String)"RemoteException while unregistering listener.");
            return;
        }
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        int n;
        this.ensureOnMainThread();
        this.service = IControllerService.Stub.asInterface(iBinder);
        try {
            n = this.service.initialize(13);
        }
        catch (RemoteException remoteException) {
            RemoteException remoteException2 = remoteException;
            ThrowableExtension.printStackTrace(remoteException);
            Log.e((String)TAG, (String)"Failed to call initialize() on controller service (RemoteException).");
            this.defaultListener.callbacks.onServiceFailed();
            this.doUnbind();
            return;
        }
        if (n != 0) {
            String string2 = String.valueOf(ControllerInitResults.toString(n));
            Log.e((String)TAG, (String)(string2.length() != 0 ? "initialize() returned error: ".concat(string2) : new String("initialize() returned error: ")));
            this.defaultListener.callbacks.onServiceInitFailed(n);
            this.doUnbind();
            return;
        }
        this.defaultListener.callbacks.onServiceConnected(1);
        try {
            if (!this.service.registerListener(0, LISTENER_KEY, new ControllerListener(this.defaultListener))) {
                Log.w((String)TAG, (String)"Failed to register listener.");
                this.defaultListener.callbacks.onServiceFailed();
                this.doUnbind();
                return;
            }
        }
        catch (RemoteException remoteException) {
            RemoteException remoteException3 = remoteException;
            ThrowableExtension.printStackTrace(remoteException);
            Log.w((String)TAG, (String)"RemoteException while registering listener.");
            this.defaultListener.callbacks.onServiceFailed();
            this.doUnbind();
            return;
        }
        this.controllerListenerMap.put(0, (Object)this.defaultListener);
    }

    public void onServiceDisconnected(ComponentName componentName) {
        this.ensureOnMainThread();
        this.service = null;
        this.defaultListener.callbacks.onServiceDisconnected();
    }

    private static void logIfControllerPacketLags(ControllerEventPacket2 controllerEventPacket2) {
        if (controllerEventPacket2.getTimestampMillis() == 0L) {
            return;
        }
        long l = SystemClock.elapsedRealtime() - controllerEventPacket2.getTimestampMillis();
        if (l > 300L) {
            Log.w((String)TAG, (String)new StringBuilder(122).append("Experiencing large controller packet delivery time between service and  client: timestamp diff in ms: ").append(l).toString());
        }
    }

    private void ensureOnMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("This should be running on the main thread.");
        }
    }

    static class ControllerListener
    extends IControllerListener.Stub {
        private final WeakReference<LocalControllerListener> listener;

        public ControllerListener(LocalControllerListener localControllerListener) {
            this.listener = new WeakReference<LocalControllerListener>(localControllerListener);
        }

        @Override
        public int getApiVersion() throws RemoteException {
            return 13;
        }

        @Override
        public ControllerListenerOptions getOptions() throws RemoteException {
            LocalControllerListener localControllerListener = (LocalControllerListener)this.listener.get();
            if (localControllerListener == null) {
                return null;
            }
            return localControllerListener.options;
        }

        @Override
        public void onControllerStateChanged(int n, int n2) throws RemoteException {
            LocalControllerListener localControllerListener = (LocalControllerListener)this.listener.get();
            if (localControllerListener == null) {
                return;
            }
            localControllerListener.callbacks.onControllerStateChanged(n, n2);
        }

        @Override
        public void onControllerEventPacket(ControllerEventPacket controllerEventPacket) throws RemoteException {
            LocalControllerListener localControllerListener = (LocalControllerListener)this.listener.get();
            if (localControllerListener == null) {
                return;
            }
            localControllerListener.callbacks.onControllerEventPacket(controllerEventPacket);
            controllerEventPacket.recycle();
        }

        @Override
        public void onControllerEventPacket2(ControllerEventPacket2 controllerEventPacket2) throws RemoteException {
            LocalControllerListener localControllerListener = (LocalControllerListener)this.listener.get();
            if (localControllerListener == null) {
                return;
            }
            ControllerServiceBridge.logIfControllerPacketLags(controllerEventPacket2);
            localControllerListener.callbacks.onControllerEventPacket2(controllerEventPacket2);
            controllerEventPacket2.recycle();
        }

        @Override
        public void onControllerRecentered(ControllerOrientationEvent controllerOrientationEvent) {
            LocalControllerListener localControllerListener = (LocalControllerListener)this.listener.get();
            if (localControllerListener == null) {
                return;
            }
            localControllerListener.callbacks.onControllerRecentered(controllerOrientationEvent);
        }
    }

    static class LocalControllerListener {
        public final Callbacks callbacks;
        public final ControllerListenerOptions options;

        public LocalControllerListener(Callbacks callbacks, ControllerListenerOptions controllerListenerOptions) {
            this.callbacks = callbacks;
            this.options = controllerListenerOptions;
        }
    }

    @UsedByNative
    public static interface Callbacks {
        public void onServiceConnected(int var1);

        public void onServiceDisconnected();

        public void onServiceUnavailable();

        public void onServiceFailed();

        public void onServiceInitFailed(int var1);

        public void onControllerStateChanged(int var1, int var2);

        public void onControllerEventPacket(ControllerEventPacket var1);

        public void onControllerRecentered(ControllerOrientationEvent var1);

        public void onControllerEventPacket2(ControllerEventPacket2 var1);
    }
}

