/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.os.Build;
import android.os.RemoteException;
import android.util.Log;
import com.google.vr.cardboard.UsedByNative;
import com.google.vr.ndk.base.Version;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.library.api.IVrCreator;
import com.google.vr.vrcore.library.api.IVrNativeLibraryLoader;
import com.google.vr.vrcore.library.api.ObjectWrapper;
import com.google.vr.vrcore.library.api.VrCoreLoader;

@UsedByNative
public class VrCoreLibraryLoader {
    private static final String TAG = "VrCoreLibraryLoader";
    private static final int MAX_ANDROID_SDK_VERSION_FOR_DLSYM = 22;
    private static final int MIN_TARGET_API_VERSION_FOR_DLSYM = 14;
    private static final int MIN_TARGET_API_VERSION_FOR_MIN_SDK_VERSION = 19;

    public VrCoreLibraryLoader() {
    }

    public static void checkVrCoreGvrLibraryAvailable(Context context) throws VrCoreNotAvailableException {
        VrCoreLibraryLoader.checkVrCoreGvrLibraryAvailable(context, Version.MIN);
    }

    @UsedByNative
    public static long loadNativeGvrLibrary(Context context) {
        return VrCoreLibraryLoader.loadNativeGvrLibrary(context, Version.MIN, Version.CURRENT);
    }

    @UsedByNative
    public static long loadNativeGvrLibrary(Context context, Version version, Version version2) {
        try {
            VrCoreLibraryLoader.checkVrCoreGvrLibraryAvailable(context, version);
            Context context2 = VrCoreLoader.getRemoteContext(context);
            int n = VrCoreLoader.getRemoteContextClientApiVersion(context);
            IVrCreator iVrCreator = VrCoreLoader.getRemoteCreator(context);
            IVrNativeLibraryLoader iVrNativeLibraryLoader = iVrCreator.newNativeLibraryLoader(ObjectWrapper.wrap(context2), ObjectWrapper.wrap(context));
            if (iVrNativeLibraryLoader == null) {
                Log.e((String)TAG, (String)"Failed to load native GVR library from VrCore: no library loader available.");
                return 0L;
            }
            if (n < 19) {
                return iVrNativeLibraryLoader.loadNativeGvrLibrary(version2.majorVersion, version2.minorVersion, version2.patchVersion);
            }
            return iVrNativeLibraryLoader.loadNativeGvrLibraryWithMinVersion(version.toString(), version2.toString());
        }
        catch (RemoteException | VrCoreNotAvailableException | IllegalArgumentException | IllegalStateException | SecurityException | UnsatisfiedLinkError throwable) {
            String string2 = String.valueOf(throwable);
            Log.e((String)TAG, (String)new StringBuilder(49 + String.valueOf(string2).length()).append("Failed to load native GVR library from VrCore:\n  ").append(string2).toString());
            return 0L;
        }
    }

    @UsedByNative
    public static long loadNativeDlsymMethod(Context context) {
        if (Build.VERSION.SDK_INT > 22) {
            return 0L;
        }
        try {
            if (VrCoreUtils.getVrCoreClientApiVersion(context) < 14) {
                return 0L;
            }
            Context context2 = VrCoreLoader.getRemoteContext(context);
            IVrCreator iVrCreator = VrCoreLoader.getRemoteCreator(context);
            IVrNativeLibraryLoader iVrNativeLibraryLoader = iVrCreator.newNativeLibraryLoader(ObjectWrapper.wrap(context2), ObjectWrapper.wrap(context));
            if (iVrNativeLibraryLoader == null) {
                Log.e((String)TAG, (String)"Failed to load native dlsym handle from VrCore: no library loader available.");
                return 0L;
            }
            return iVrNativeLibraryLoader.loadNativeDlsymMethod();
        }
        catch (RemoteException | VrCoreNotAvailableException | IllegalArgumentException | IllegalStateException | SecurityException | UnsatisfiedLinkError throwable) {
            String string2 = String.valueOf(throwable);
            Log.e((String)TAG, (String)new StringBuilder(50 + String.valueOf(string2).length()).append("Failed to load native dlsym handle from VrCore:\n  ").append(string2).toString());
            return 0L;
        }
    }

    private static void checkVrCoreGvrLibraryAvailable(Context context, Version version) throws VrCoreNotAvailableException {
        String string2 = VrCoreUtils.getVrCoreSdkLibraryVersion(context);
        Version version2 = Version.parse(string2);
        if (version2 == null) {
            Log.i((String)TAG, (String)"VrCore version does not support library loading.");
            throw new VrCoreNotAvailableException(4);
        }
        if (!version2.isAtLeast(version)) {
            Log.w((String)TAG, (String)String.format("VrCore GVR library version obsolete; VrCore supports %s but client min is %s", string2, version.toString()));
            throw new VrCoreNotAvailableException(4);
        }
    }
}

