/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.common.api;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.vr.vrcore.common.api.HeadTrackingState;

public interface IDaydreamListener
extends IInterface {
    public int getTargetApiVersion() throws RemoteException;

    public HeadTrackingState requestStopTracking() throws RemoteException;

    public void applyFade(int var1, long var2) throws RemoteException;

    public void recenterHeadTracking() throws RemoteException;

    public void dumpDebugData() throws RemoteException;

    public void resumeHeadTracking(HeadTrackingState var1) throws RemoteException;

    public void invokeCloseAction() throws RemoteException;

    public void setLensOffsets(float var1, float var2, float var3, float var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDaydreamListener {
        private static final String DESCRIPTOR = "com.google.vr.vrcore.common.api.IDaydreamListener";
        static final int TRANSACTION_getTargetApiVersion = 1;
        static final int TRANSACTION_requestStopTracking = 2;
        static final int TRANSACTION_applyFade = 3;
        static final int TRANSACTION_recenterHeadTracking = 4;
        static final int TRANSACTION_dumpDebugData = 5;
        static final int TRANSACTION_resumeHeadTracking = 6;
        static final int TRANSACTION_invokeCloseAction = 7;
        static final int TRANSACTION_setLensOffsets = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDaydreamListener asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IDaydreamListener) {
                return (IDaydreamListener)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = this.getTargetApiVersion();
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    HeadTrackingState headTrackingState = this.requestStopTracking();
                    parcel2.writeNoException();
                    if (headTrackingState != null) {
                        parcel2.writeInt(1);
                        headTrackingState.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    long l = parcel.readLong();
                    this.applyFade(n4, l);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.recenterHeadTracking();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.dumpDebugData();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    HeadTrackingState headTrackingState = 0 != parcel.readInt() ? (HeadTrackingState)HeadTrackingState.CREATOR.createFromParcel(parcel) : null;
                    this.resumeHeadTracking(headTrackingState);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.invokeCloseAction();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    float f = parcel.readFloat();
                    float f2 = parcel.readFloat();
                    float f3 = parcel.readFloat();
                    float f4 = parcel.readFloat();
                    this.setLensOffsets(f, f2, f3, f4);
                    return true;
                }
            }
            return super.onTransact(n, parcel, parcel2, n2);
        }

        static class Proxy
        implements IDaydreamListener {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public int getTargetApiVersion() throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            @Override
            public HeadTrackingState requestStopTracking() throws RemoteException {
                HeadTrackingState headTrackingState;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    headTrackingState = 0 != parcel2.readInt() ? (HeadTrackingState)HeadTrackingState.CREATOR.createFromParcel(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return headTrackingState;
            }

            @Override
            public void applyFade(int n, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeLong(l);
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void recenterHeadTracking() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void dumpDebugData() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void resumeHeadTracking(HeadTrackingState headTrackingState) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (headTrackingState != null) {
                        parcel.writeInt(1);
                        headTrackingState.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void invokeCloseAction() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setLensOffsets(float f, float f2, float f3, float f4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeFloat(f);
                    parcel.writeFloat(f2);
                    parcel.writeFloat(f3);
                    parcel.writeFloat(f4);
                    this.mRemote.transact(8, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

