/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.util.Log;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.sdk.proto.nano.Analytics;

public class GvrAnalytics {
    private static final String TAG = "GvrAnalytics";
    private final long nativeAnalytics;
    private Analytics.AnalyticsRequest request;
    private long lastSampleTimestampNanos;

    GvrAnalytics(long l) {
        this.nativeAnalytics = l;
        this.request = new Analytics.AnalyticsRequest();
    }

    public Analytics.AnalyticsSample querySample(long l) {
        this.request.setPrevSampleTimestampNanoseconds(l);
        byte[] byArray = GvrApi.nativeAnalyticsCreateSample(this.nativeAnalytics, MessageNano.toByteArray((MessageNano)this.request));
        if (byArray == null) {
            return null;
        }
        try {
            return Analytics.AnalyticsSample.parseFrom(byArray);
        }
        catch (InvalidProtocolBufferNanoException invalidProtocolBufferNanoException) {
            String string2 = String.valueOf((Object)invalidProtocolBufferNanoException);
            Log.e((String)TAG, (String)new StringBuilder(31 + String.valueOf(string2).length()).append("error parsing AnalyticsSample: ").append(string2).toString());
            return null;
        }
    }

    public Analytics.AnalyticsSample queryNextSample() {
        Analytics.AnalyticsSample analyticsSample = this.querySample(this.lastSampleTimestampNanos);
        if (analyticsSample != null) {
            this.lastSampleTimestampNanos = analyticsSample.getTimestampNanoseconds();
        }
        return analyticsSample;
    }

    public long getNativeGvrAnalyticsPointer() {
        return this.nativeAnalytics;
    }
}

