/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import com.google.common.logging.nano.Vr$VREvent;
import com.google.common.logging.nano.Vr$VREvent$PhoneAlignment;
import com.google.common.logging.nano.Vr$VREvent$Vector2;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import com.google.vr.sdk.proto.nano.Phone;

public abstract class AbstractDaydreamTouchListener {
    static final double MAX_TOUCH_DISTANCE_METERS = 0.015;
    static final int ANGLE_SAMPLE_TO_LOG = 200;
    private final String logTag = this.getClass().getSimpleName();
    private int angleSamplesReceived = 0;
    private DisplayMetrics displayMetrics;
    private float xMetersPerPixel;
    private float yMetersPerPixel;
    private float borderSizeMeters;
    private float[][] markersInPixels;
    private int mostTouchesSeen;
    private int[] touchBestMarker;
    private int[] markerBestTouch;
    private double[] currentMarkerBestDists;
    private float[] pixelTranslation = new float[2];
    private boolean lastMotionEventInHeadset;
    private boolean enabled = true;
    private float[] lastTranslation = new float[2];
    private float[] translation = new float[2];

    public AbstractDaydreamTouchListener() {
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.resetTrackingState();
        }
    }

    public void getTranslationInScreenSpace(float[] fArray) {
        if (fArray.length < 2) {
            throw new IllegalArgumentException("Translation array too small");
        }
        if (this.displayMetrics == null) {
            Log.e((String)this.logTag, (String)"displayMetrics must be set before calling getTranslationInScreenSpace.");
            return;
        }
        fArray[0] = this.pixelTranslation[0] / (float)this.displayMetrics.widthPixels;
        fArray[1] = this.pixelTranslation[1] / (float)this.displayMetrics.heightPixels;
        fArray[0] = fArray[0] * 2.0f;
        fArray[1] = fArray[1] * -2.0f;
    }

    public Rect getBoundingRect(DisplayMetrics displayMetrics) {
        if (this.markersInPixels == null || this.markersInPixels.length == 0) {
            Log.e((String)this.logTag, (String)"No touch markers, so there's no bounding rect.");
            return null;
        }
        double d = 0.015 / (double)this.xMetersPerPixel;
        double d2 = 0.015 / (double)this.yMetersPerPixel;
        int n = displayMetrics.widthPixels;
        int n2 = 0;
        int n3 = displayMetrics.heightPixels;
        int n4 = 0;
        for (int i = 0; i < this.markersInPixels.length; ++i) {
            float[] fArray = this.markersInPixels[i];
            n = (int)Math.min((double)n, (double)fArray[0] - d);
            n2 = (int)Math.max((double)n2, (double)fArray[0] + d + 1.0);
            n3 = (int)Math.min((double)n3, (double)fArray[1] - d2);
            n4 = (int)Math.max((double)n4, (double)fArray[1] + d2 + 1.0);
        }
        n = Math.max(n, 0);
        n2 = Math.min(n2, displayMetrics.widthPixels);
        n3 = Math.max(n3, 0);
        n4 = Math.min(n4, displayMetrics.heightPixels);
        return new Rect(n, n3, n2, n4);
    }

    protected final boolean handleTouch(MotionEvent motionEvent, float f, float f2) {
        if (!this.processMotionEvent(motionEvent, f, f2)) {
            return false;
        }
        this.getTranslationInScreenSpace(this.translation);
        if (this.translation[0] != this.lastTranslation[0] || this.translation[1] != this.lastTranslation[1]) {
            this.lastTranslation[0] = this.translation[0];
            this.lastTranslation[1] = this.translation[1];
            this.setLensOffset(this.translation[0], this.translation[1]);
        }
        return true;
    }

    protected final void initWithPhoneParams(DisplayMetrics displayMetrics, Phone.PhoneParams phoneParams) {
        this.displayMetrics = displayMetrics;
        this.borderSizeMeters = DisplayUtils.getBorderSizeMeters(phoneParams);
        this.xMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch(this.displayMetrics.xdpi);
        this.yMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch(this.displayMetrics.ydpi);
        this.resetTrackingState();
    }

    protected final void setDeviceParams(CardboardDevice.DeviceParams deviceParams) {
        if (deviceParams == null || deviceParams.daydreamInternal == null || deviceParams.daydreamInternal.alignmentMarkers == null) {
            Log.e((String)this.logTag, (String)"Null deviceParams or no alignment markers found.");
            this.markersInPixels = null;
            return;
        }
        if (this.displayMetrics == null) {
            Log.e((String)this.logTag, (String)"displayMetrics must be set before calling setDeviceParams.");
            return;
        }
        CardboardDevice.ScreenAlignmentMarker[] screenAlignmentMarkerArray = deviceParams.daydreamInternal.alignmentMarkers;
        this.markersInPixels = new float[screenAlignmentMarkerArray.length][];
        this.currentMarkerBestDists = new double[screenAlignmentMarkerArray.length];
        this.markerBestTouch = new int[screenAlignmentMarkerArray.length];
        for (int i = 0; i < screenAlignmentMarkerArray.length; ++i) {
            CardboardDevice.ScreenAlignmentMarker screenAlignmentMarker = screenAlignmentMarkerArray[i];
            this.markersInPixels[i] = new float[2];
            this.markersInPixels[i][0] = (float)(this.displayMetrics.widthPixels / 2) + screenAlignmentMarker.getHorizontal() / this.xMetersPerPixel;
            this.markersInPixels[i][1] = (float)this.displayMetrics.heightPixels - (screenAlignmentMarker.getVertical() + deviceParams.getTrayToLensDistance() - this.borderSizeMeters) / this.yMetersPerPixel;
        }
    }

    protected abstract void logEvent(int var1, Vr$VREvent var2);

    protected abstract void setLensOffset(float var1, float var2);

    protected abstract boolean isDaydreamImageAlignmentEnabled();

    void getTranslationInPixels(float[] fArray) {
        if (fArray.length < 2) {
            throw new IllegalArgumentException("Translation array too small");
        }
        fArray[0] = this.pixelTranslation[0];
        fArray[1] = this.pixelTranslation[1];
    }

    boolean viewerNeedsTouchProcessing() {
        return this.enabled && this.markersInPixels != null && this.markersInPixels.length > 0;
    }

    boolean wasLastMotionEventInViewer() {
        return this.lastMotionEventInHeadset;
    }

    boolean processMotionEvent(MotionEvent motionEvent, float f, float f2) {
        int n;
        int n2;
        if (!this.viewerNeedsTouchProcessing()) {
            this.lastMotionEventInHeadset = false;
            return false;
        }
        if (!this.isDaydreamImageAlignmentEnabled()) {
            return true;
        }
        int n3 = motionEvent.getPointerCount();
        if (n3 > this.mostTouchesSeen) {
            this.touchBestMarker = new int[n3];
            this.mostTouchesSeen = n3;
        }
        for (n2 = 0; n2 < this.markersInPixels.length; ++n2) {
            this.markerBestTouch[n2] = -1;
            this.currentMarkerBestDists[n2] = 2.25E-4;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            double d = 2.25E-4;
            this.touchBestMarker[n2] = -1;
            for (n = 0; n < this.markersInPixels.length; ++n) {
                double d2;
                float f3 = (this.markersInPixels[n][0] - (motionEvent.getX(n2) + f)) * this.xMetersPerPixel;
                float f4 = (this.markersInPixels[n][1] - (motionEvent.getY(n2) + f2)) * this.yMetersPerPixel;
                double d3 = f3 * f3 + f4 * f4;
                if (d2 < d) {
                    d = d3;
                    this.touchBestMarker[n2] = n;
                }
                if (!(d3 < this.currentMarkerBestDists[n])) continue;
                this.currentMarkerBestDists[n] = d3;
                this.markerBestTouch[n] = n2;
            }
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n4 = 0;
        for (n = 0; n < this.markerBestTouch.length; ++n) {
            if (this.markerBestTouch[n] == -1) continue;
            if (this.touchBestMarker[this.markerBestTouch[n]] != n) {
                this.markerBestTouch[n] = -1;
                continue;
            }
            ++n4;
            f5 += motionEvent.getX(this.markerBestTouch[n]) + f - this.markersInPixels[n][0];
            f6 += motionEvent.getY(this.markerBestTouch[n]) + f2 - this.markersInPixels[n][1];
        }
        if (n4 > 0) {
            this.lastMotionEventInHeadset = true;
            this.pixelTranslation[0] = f5 / (float)n4;
            this.pixelTranslation[1] = f6 / (float)n4;
        } else {
            this.lastMotionEventInHeadset = false;
            this.pixelTranslation[0] = 0.0f;
            this.pixelTranslation[1] = 0.0f;
        }
        if (n3 > 0) {
            ++this.angleSamplesReceived;
            if (this.angleSamplesReceived == 200) {
                this.logPhoneAlignment(motionEvent, f, f2);
            }
        }
        return true;
    }

    private void resetTrackingState() {
        this.lastMotionEventInHeadset = false;
        this.pixelTranslation[0] = 0.0f;
        this.pixelTranslation[1] = 0.0f;
        this.mostTouchesSeen = 0;
    }

    private void logPhoneAlignment(MotionEvent motionEvent, float f, float f2) {
        int n = motionEvent.getPointerCount();
        Vr$VREvent vr$VREvent = new Vr$VREvent();
        new Vr$VREvent().phoneAlignment = new Vr$VREvent$PhoneAlignment();
        vr$VREvent.phoneAlignment.touchLocations = new Vr$VREvent$Vector2[n];
        for (int i = 0; i < n; ++i) {
            vr$VREvent.phoneAlignment.touchLocations[i] = new Vr$VREvent$Vector2();
            vr$VREvent.phoneAlignment.touchLocations[i].x = Float.valueOf(motionEvent.getX(i) + f);
            vr$VREvent.phoneAlignment.touchLocations[i].y = Float.valueOf(motionEvent.getY(i) + f2);
        }
        vr$VREvent.phoneAlignment.lensOffset = new Vr$VREvent$Vector2();
        vr$VREvent.phoneAlignment.lensOffset.x = Float.valueOf(this.pixelTranslation[0]);
        vr$VREvent.phoneAlignment.lensOffset.y = Float.valueOf(this.pixelTranslation[1]);
        if (n == 2 && this.markersInPixels.length == 2) {
            double d;
            float f3 = motionEvent.getX(0) - motionEvent.getX(1);
            float f4 = motionEvent.getY(0) - motionEvent.getY(1);
            double d2 = Math.atan2(f4, f3);
            float f5 = this.markersInPixels[0][0] - this.markersInPixels[1][0];
            float f6 = this.markersInPixels[0][1] - this.markersInPixels[1][1];
            double d3 = Math.atan2(f6, f5);
            double d4 = Math.toDegrees(d2 - d3);
            if (d > 90.0) {
                d4 -= 180.0;
            }
            if (d4 < -90.0) {
                d4 += 180.0;
            }
            vr$VREvent.phoneAlignment.angleDegrees = Float.valueOf((float)d4);
            double d5 = d4;
            Log.i((String)this.logTag, (String)new StringBuilder(58).append("Phone angle in headset (degrees): ").append(d5).toString());
            float f7 = motionEvent.getX(0) + f;
            float f8 = motionEvent.getY(0) + f2;
            Log.i((String)this.logTag, (String)new StringBuilder(49).append("  Touch point 1: ").append(f7).append(", ").append(f8).toString());
            f7 = motionEvent.getX(1) + f;
            f8 = motionEvent.getY(1) + f2;
            Log.i((String)this.logTag, (String)new StringBuilder(49).append("  Touch point 2: ").append(f7).append(", ").append(f8).toString());
        }
        this.logEvent(2012, vr$VREvent);
    }
}

