/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.os.Build;
import com.google.vr.cardboard.ContentProviderVrParamsProvider;
import com.google.vr.cardboard.LegacyVrParamsProvider;
import com.google.vr.cardboard.PackageUtils;
import com.google.vr.cardboard.VrParamsProvider;
import java.util.ArrayList;
import java.util.List;

public final class VrParamsProviderFactory {
    private static final String TAG = VrParamsProviderFactory.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static VrParamsProvider providerForTesting;

    public VrParamsProviderFactory() {
    }

    public static VrParamsProvider create(Context context) {
        if (providerForTesting != null) {
            return providerForTesting;
        }
        ContentProviderClientHandle contentProviderClientHandle = VrParamsProviderFactory.tryToGetContentProviderClientHandle(context);
        if (contentProviderClientHandle != null) {
            return new ContentProviderVrParamsProvider(contentProviderClientHandle.client, contentProviderClientHandle.authority);
        }
        return new LegacyVrParamsProvider();
    }

    public static ContentProviderClientHandle tryToGetContentProviderClientHandle(Context context) {
        List<String> list = VrParamsProviderFactory.getValidContentProviderAuthorities(context);
        if (list != null) {
            for (String string2 : list) {
                ContentProviderClient contentProviderClient = context.getContentResolver().acquireContentProviderClient(string2);
                if (contentProviderClient == null) continue;
                return new ContentProviderClientHandle(contentProviderClient, string2);
            }
        }
        return null;
    }

    public static boolean isContentProviderAvailable(Context context) {
        if (providerForTesting != null && providerForTesting instanceof ContentProviderVrParamsProvider) {
            return true;
        }
        List<String> list = VrParamsProviderFactory.getValidContentProviderAuthorities(context);
        return list != null && !list.isEmpty();
    }

    private static List<String> getValidContentProviderAuthorities(Context context) {
        Intent intent;
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentContentProviders(intent = new Intent("android.content.action.VR_SETTINGS_PROVIDER"), 0);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ResolveInfo resolveInfo : list) {
            ProviderInfo providerInfo = resolveInfo.providerInfo;
            if (!PackageUtils.isGooglePackage(providerInfo.packageName)) continue;
            arrayList.add(providerInfo.authority);
        }
        return arrayList;
    }

    public static void setProviderForTesting(VrParamsProvider vrParamsProvider) {
        providerForTesting = vrParamsProvider;
    }

    public static class ContentProviderClientHandle {
        public final ContentProviderClient client;
        public final String authority;

        ContentProviderClientHandle(ContentProviderClient contentProviderClient, String string2) {
            this.client = contentProviderClient;
            this.authority = string2;
        }
    }
}

