/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.library.api;

import android.os.IBinder;
import com.google.vr.cardboard.annotations.UsedByReflection;
import com.google.vr.vrcore.library.api.IObjectWrapper;
import java.lang.reflect.Field;

@UsedByReflection(value="ObjectWrapper.java")
public final class ObjectWrapper<T>
extends IObjectWrapper.Stub {
    @UsedByReflection(value="ObjectWrapper.java")
    private final T wrappedObject;

    private ObjectWrapper(T t) {
        this.wrappedObject = t;
    }

    public static <T> IObjectWrapper wrap(T t) {
        return new ObjectWrapper<T>(t);
    }

    public static <T> T unwrap(IObjectWrapper iObjectWrapper, Class<T> clazz) {
        if (iObjectWrapper == null) {
            return null;
        }
        if (iObjectWrapper instanceof ObjectWrapper) {
            return ((ObjectWrapper)iObjectWrapper).wrappedObject;
        }
        IBinder iBinder = iObjectWrapper.asBinder();
        Class<?> clazz2 = iBinder.getClass();
        Field[] fieldArray = clazz2.getDeclaredFields();
        if (fieldArray.length == 1) {
            Field field = fieldArray[0];
            if (!field.isAccessible()) {
                field.setAccessible(true);
                try {
                    Object object = field.get(iBinder);
                    if (object == null) {
                        return null;
                    }
                    if (!clazz.isInstance(object)) {
                        throw new IllegalArgumentException("remoteBinder is the wrong class.");
                    }
                    return clazz.cast(object);
                }
                catch (NullPointerException nullPointerException) {
                    throw new IllegalArgumentException("Binder object is null.", nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("remoteBinder is the wrong class.", illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("Could not access the field in remoteBinder.", illegalAccessException);
                }
            }
            throw new IllegalArgumentException("The concrete class implementing IObjectWrapper must have exactly one declared *private* field for the wrapped object. Preferably, this is an instance of the ObjectWrapper<T> class.");
        }
        throw new IllegalArgumentException("The concrete class implementing IObjectWrapper must have exactly *one* declared private field for the wrapped object.  Preferably, this is an instance of the ObjectWrapper<T> class.");
    }
}

