/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.controller.api;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.vr.vrcore.controller.api.ControllerEvent;

public final class ControllerBatteryEvent
extends ControllerEvent {
    public static final int BATTERY_LEVEL_UNKNOWN = 0;
    public static final int BATTERY_LEVEL_CRITICAL_LOW = 1;
    public static final int BATTERY_LEVEL_LOW = 2;
    public static final int BATTERY_LEVEL_MEDIUM = 3;
    public static final int BATTERY_LEVEL_ALMOST_FULL = 4;
    public static final int BATTERY_LEVEL_FULL = 5;
    public static final int BATTERY_LEVEL_COUNT = 6;
    public int batteryLevelBucket;
    public boolean charging;
    public static final Parcelable.Creator<ControllerBatteryEvent> CREATOR = new Parcelable.Creator<ControllerBatteryEvent>(){

        public ControllerBatteryEvent createFromParcel(Parcel parcel) {
            return new ControllerBatteryEvent(parcel);
        }

        public ControllerBatteryEvent[] newArray(int n) {
            return new ControllerBatteryEvent[n];
        }
    };

    public ControllerBatteryEvent() {
    }

    public ControllerBatteryEvent(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    public final int describeContents() {
        return 0;
    }

    @Override
    public final void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeInt(this.batteryLevelBucket);
        parcel.writeInt(this.charging ? 1 : 0);
    }

    @Override
    public final void readFromParcel(Parcel parcel) {
        super.readFromParcel(parcel);
        this.batteryLevelBucket = parcel.readInt();
        this.charging = 0 != parcel.readInt();
    }

    public static String toString(int n) {
        switch (n) {
            case 0: {
                return "BATTERY_LEVEL_UNKNOWN";
            }
            case 1: {
                return "BATTERY_LEVEL_CRITICAL_LOW";
            }
            case 2: {
                return "BATTERY_LEVEL_LOW";
            }
            case 3: {
                return "BATTERY_LEVEL_MEDIUM";
            }
            case 4: {
                return "BATTERY_LEVEL_ALMOST_FULL";
            }
            case 5: {
                return "BATTERY_LEVEL_FULL";
            }
        }
        return new StringBuilder(28).append("[Unknown level: ").append(n).append("]").toString();
    }

    public static int getBatteryLevelBucket(int n) {
        if (n < 20) {
            return 1;
        }
        if (n < 40) {
            return 2;
        }
        if (n < 60) {
            return 3;
        }
        if (n < 80) {
            return 4;
        }
        return 5;
    }

    @Override
    public final int getByteSize() {
        return super.getByteSize() + 8;
    }

    @Override
    public final void copyFrom(ControllerEvent controllerEvent) {
        if (!(controllerEvent instanceof ControllerBatteryEvent)) {
            throw new IllegalStateException("Cannot copy ControllerBatteryEvent from non-ControllerBatteryEvent instance.");
        }
        super.copyFrom(controllerEvent);
        ControllerBatteryEvent controllerBatteryEvent = (ControllerBatteryEvent)controllerEvent;
        this.batteryLevelBucket = controllerBatteryEvent.batteryLevelBucket;
        this.charging = controllerBatteryEvent.charging;
    }
}

