/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.Context;
import android.os.AsyncTask;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import com.google.common.logging.nano.Vr$VREvent;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrParamsProviderFactory;
import com.google.vr.ndk.base.AbstractDaydreamTouchListener;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrLayoutImpl;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import com.google.vr.sdk.proto.nano.Phone;
import com.google.vr.vrcore.logging.api.VREventParcelable;

class SdkDaydreamTouchListener
extends AbstractDaydreamTouchListener
implements View.OnTouchListener {
    static final String TAG = "SdkDaydreamTouchListener";
    private final VrParamsProvider vrParamsProvider;
    private final GvrLayoutImpl gvrLayout;
    private final GvrApi gvrApi;
    private final boolean isDaydreamImageAlignmentEnabled;

    public SdkDaydreamTouchListener(GvrLayoutImpl gvrLayoutImpl) {
        this.gvrLayout = gvrLayoutImpl;
        this.gvrApi = gvrLayoutImpl.getGvrApi();
        this.isDaydreamImageAlignmentEnabled = this.gvrApi.getSdkConfigurationParams().daydreamImageAlignment != 1;
        Context context = gvrLayoutImpl.getContext();
        this.vrParamsProvider = VrParamsProviderFactory.create(context);
        FinishInitilizationTask finishInitilizationTask = new FinishInitilizationTask();
        new FinishInitilizationTask().display = DisplayUtils.getDefaultDisplay(context);
        finishInitilizationTask.execute(new Void[0]);
    }

    SdkDaydreamTouchListener(VrParamsProvider vrParamsProvider, DisplayMetrics displayMetrics, Phone.PhoneParams phoneParams, GvrApi gvrApi, GvrLayoutImpl gvrLayoutImpl, boolean bl) {
        this.isDaydreamImageAlignmentEnabled = bl;
        this.vrParamsProvider = vrParamsProvider;
        this.gvrApi = gvrApi;
        this.gvrLayout = gvrLayoutImpl;
        this.init(displayMetrics, phoneParams);
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        return this.handleTouch(motionEvent, 0.0f, 0.0f);
    }

    public void refreshViewerProfile() {
        new RefreshViewerProfileTask().execute(new Void[0]);
    }

    public void shutdown() {
        this.vrParamsProvider.close();
    }

    private void init(DisplayMetrics displayMetrics, Phone.PhoneParams phoneParams) {
        this.initWithPhoneParams(displayMetrics, phoneParams);
        this.refreshViewerProfile();
    }

    @Override
    protected boolean isDaydreamImageAlignmentEnabled() {
        return this.isDaydreamImageAlignmentEnabled;
    }

    @Override
    protected void setLensOffset(float f, float f2) {
        this.gvrApi.setLensOffset(f, f2);
    }

    @Override
    protected void logEvent(int n, Vr$VREvent vr$VREvent) {
        if (this.gvrLayout.getVrCoreSdkClient() != null && this.gvrLayout.getVrCoreSdkClient().getLoggingService() != null) {
            VREventParcelable vREventParcelable = new VREventParcelable(2012, vr$VREvent);
            try {
                this.gvrLayout.getVrCoreSdkClient().getLoggingService().log(vREventParcelable);
            }
            catch (RemoteException remoteException) {
                Log.w((String)TAG, (String)"Unable to log alignment event");
                return;
            }
        } else {
            Log.w((String)TAG, (String)"Unable to log alignment event; logging service not available.");
        }
    }

    class FinishInitilizationTask
    extends AsyncTask<Void, Void, Phone.PhoneParams> {
        public Display display;

        private FinishInitilizationTask() {
        }

        protected Phone.PhoneParams doInBackground(Void ... voidArray) {
            return SdkDaydreamTouchListener.this.vrParamsProvider.readPhoneParams();
        }

        protected void onProgressUpdate(Void ... voidArray) {
        }

        protected void onPostExecute(Phone.PhoneParams phoneParams) {
            DisplayMetrics displayMetrics = DisplayUtils.getDisplayMetricsLandscapeWithOverride(this.display, phoneParams);
            SdkDaydreamTouchListener.this.init(displayMetrics, phoneParams);
        }
    }

    class RefreshViewerProfileTask
    extends AsyncTask<Void, Void, CardboardDevice.DeviceParams> {
        private RefreshViewerProfileTask() {
        }

        protected CardboardDevice.DeviceParams doInBackground(Void ... voidArray) {
            return SdkDaydreamTouchListener.this.vrParamsProvider.readDeviceParams();
        }

        protected void onProgressUpdate(Void ... voidArray) {
        }

        protected void onPostExecute(CardboardDevice.DeviceParams deviceParams) {
            SdkDaydreamTouchListener.this.setDeviceParams(deviceParams);
        }
    }
}

