/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.app.Activity;
import android.app.PendingIntent;
import android.app.Presentation;
import android.content.ComponentName;
import android.content.Context;
import android.content.res.Configuration;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.view.Choreographer;
import android.view.Display;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.common.logging.nano.Vr$VREvent$SdkConfigurationParams$AsyncReprojectionConfig;
import com.google.vr.cardboard.ContextUtils;
import com.google.vr.cardboard.DisplaySynchronizer;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.cardboard.EglFactory;
import com.google.vr.cardboard.EglReadyListener;
import com.google.vr.cardboard.MutableEglConfigChooser;
import com.google.vr.cardboard.ScanlineRacingRenderer;
import com.google.vr.cardboard.ThreadUtils;
import com.google.vr.cardboard.VrContextWrapper;
import com.google.vr.ndk.base.CardboardEmulator;
import com.google.vr.ndk.base.DaydreamUtilsWrapper;
import com.google.vr.ndk.base.ExternalSurface;
import com.google.vr.ndk.base.FadeOverlayView;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrSurfaceView;
import com.google.vr.ndk.base.GvrUiLayoutImpl;
import com.google.vr.ndk.base.PerformanceOverlay;
import com.google.vr.ndk.base.SdkDaydreamTouchListener;
import com.google.vr.ndk.base.VrCoreSdkClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class GvrLayoutImpl
extends FrameLayout {
    private static final String TAG = "GvrLayoutImpl";
    private static final boolean DEBUG = false;
    private static final int EXTERNAL_PRESENTATION_MIN_API = 16;
    private static final int SHOW_RENDERING_VIEWS_DELAY_FOR_FADE = 50;
    private static final int ASYNC_REPROJECTION_FLAGS_UNKNOWN = -1;
    private static PresentationFactory sOptionalPresentationFactory = null;
    private DaydreamUtilsWrapper daydreamUtils;
    private FrameLayout presentationLayout;
    private GvrUiLayoutImpl uiLayout;
    private DisplaySynchronizer displaySynchronizer;
    private View presentationView;
    private int asyncReprojectionFlags = -1;
    private AsyncReprojectionSurfaceView scanlineRacingView;
    private ScanlineRacingRenderer scanlineRacingRenderer;
    private EglReadyListener eglReadyListener;
    private EglFactory eglFactory;
    private FadeOverlayView fadeOverlayView;
    private boolean autoFadeEnabled = true;
    private PresentationHelper presentationHelper;
    private VrCoreSdkClient vrCoreSdkClient;
    private SdkDaydreamTouchListener daydreamTouchListener;
    private CardboardEmulator cardboardEmulator;
    private PerformanceOverlay performanceOverlay;
    private GvrApi gvrApi;
    private boolean isResumed = false;
    private ExternalSurface videoSurface;
    private boolean stereoModeEnabled = true;
    private final Runnable showRenderingViewsRunnable = new Runnable(){

        @Override
        public void run() {
            GvrLayoutImpl.this.updateRenderingViewsVisibility(0);
        }
    };
    private ScreenOnManager screenOnManager;
    private FrameFlushWorkaround frameFlushWorkaround;

    public GvrLayoutImpl(Context context) {
        super(context);
        Activity activity;
        if (!(context instanceof VrContextWrapper) && (activity = ContextUtils.getActivity(context)) == null) {
            throw new IllegalArgumentException("An Activity Context is required for VR functionality.");
        }
        this.init();
    }

    GvrLayoutImpl(Context context, GvrApi gvrApi, DisplaySynchronizer displaySynchronizer, EglReadyListener eglReadyListener, FadeOverlayView fadeOverlayView, DaydreamUtilsWrapper daydreamUtilsWrapper) {
        super(context);
        this.initWithInjectedObjects(gvrApi, displaySynchronizer, eglReadyListener, fadeOverlayView, daydreamUtilsWrapper);
    }

    private void init() {
        DisplaySynchronizer displaySynchronizer = GvrApi.createDefaultDisplaySynchronizer(this.getContext());
        this.initWithInjectedObjects(new GvrApi(this.getContext(), displaySynchronizer), displaySynchronizer, new EglReadyListener(), null, new DaydreamUtilsWrapper());
    }

    private void initWithInjectedObjects(GvrApi gvrApi, DisplaySynchronizer displaySynchronizer, EglReadyListener eglReadyListener, FadeOverlayView fadeOverlayView, DaydreamUtilsWrapper daydreamUtilsWrapper) {
        int n;
        this.gvrApi = gvrApi;
        if (this.isContextSharingEnabled()) {
            gvrApi.requestContextSharing(eglReadyListener);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (GvrLayoutImpl.this.vrCoreSdkClient != null) {
                    GvrLayoutImpl.this.vrCoreSdkClient.onExitingFromVr();
                }
            }
        };
        this.daydreamUtils = daydreamUtilsWrapper;
        this.presentationLayout = new FrameLayout(this.getContext());
        this.uiLayout = new GvrUiLayoutImpl(this.getContext(), runnable);
        this.displaySynchronizer = displaySynchronizer;
        this.eglReadyListener = eglReadyListener;
        this.presentationHelper = this.tryCreatePresentationHelper();
        this.frameFlushWorkaround = new FrameFlushWorkaround();
        this.addView((View)this.presentationLayout, 0);
        this.addView((View)this.uiLayout.getRoot(), 1);
        this.updateUiLayout();
        boolean bl = daydreamUtilsWrapper.isDaydreamPhone(this.getContext());
        if (bl) {
            this.daydreamTouchListener = this.createDaydreamTouchListener();
            this.uiLayout.getRoot().setOnTouchListener((View.OnTouchListener)this.daydreamTouchListener);
        }
        boolean bl2 = (n = daydreamUtilsWrapper.getComponentDaydreamCompatibility(this.getContext())) != 1;
        boolean bl3 = n == 3;
        boolean bl4 = bl || bl3;
        if (bl4) {
            if (bl2) {
                if (this.getContext() instanceof VrContextWrapper) {
                    this.autoFadeEnabled = ((VrContextWrapper)this.getContext()).autoFadeEnabled();
                }
                this.fadeOverlayView = fadeOverlayView != null ? fadeOverlayView : new FadeOverlayView(this.getContext(), this.autoFadeEnabled);
                this.addView(this.fadeOverlayView, 2);
            }
            this.vrCoreSdkClient = this.createVrCoreSdkClient(this.getContext(), gvrApi, daydreamUtilsWrapper, this.fadeOverlayView);
        }
        this.screenOnManager = new ScreenOnManager((View)this);
        if (this.isDeviceDetectionEnabled()) {
            gvrApi.setIdleListener(this.screenOnManager);
        }
    }

    public GvrUiLayoutImpl getUiLayoutImpl() {
        return this.uiLayout;
    }

    public void onWindowVisibilityChanged(int n) {
        super.onWindowVisibilityChanged(n);
        this.updateFadeVisibility();
    }

    public void onPause() {
        this.gvrApi.pause();
        if (this.scanlineRacingView != null) {
            this.scanlineRacingView.queueEvent(new Runnable(){

                @Override
                public void run() {
                    GvrLayoutImpl.this.scanlineRacingRenderer.onPause();
                }
            });
            this.scanlineRacingView.onPause();
        }
        if (this.presentationHelper != null) {
            this.presentationHelper.onPause();
        }
        this.displaySynchronizer.onPause();
        if (this.vrCoreSdkClient != null) {
            this.vrCoreSdkClient.onPause();
        }
        if (this.cardboardEmulator != null) {
            this.cardboardEmulator.onPause();
        }
        if (this.performanceOverlay != null) {
            this.performanceOverlay.stop();
        }
        this.screenOnManager.onPause();
        this.isResumed = false;
        this.updateFadeVisibility();
    }

    public void onResume() {
        this.gvrApi.resume();
        if (this.daydreamTouchListener != null) {
            this.daydreamTouchListener.refreshViewerProfile();
        }
        this.displaySynchronizer.onResume();
        if (this.presentationHelper != null) {
            this.presentationHelper.onResume();
        }
        if (this.scanlineRacingView != null) {
            this.scanlineRacingView.onResume();
        }
        if (this.vrCoreSdkClient != null) {
            this.vrCoreSdkClient.onResume();
        }
        if (this.cardboardEmulator != null && this.gvrApi.getViewerType() == 1) {
            this.cardboardEmulator.onResume();
        }
        this.screenOnManager.onResume();
        this.frameFlushWorkaround.onResume();
        if (this.performanceOverlay != null) {
            this.performanceOverlay.stop();
        }
        this.isResumed = true;
        this.updateFadeVisibility();
        this.updateUiLayout();
    }

    public void onBackPressed() {
        this.uiLayout.invokeCloseButtonListener();
    }

    public void shutdown() {
        this.displaySynchronizer.shutdown();
        if (this.daydreamTouchListener != null) {
            this.daydreamTouchListener.shutdown();
        }
        this.removeView((View)this.presentationLayout);
        this.removeView((View)this.uiLayout.getRoot());
        this.scanlineRacingRenderer = null;
        if (this.videoSurface != null) {
            this.videoSurface.shutdown();
            this.videoSurface = null;
        }
        this.scanlineRacingView = null;
        this.presentationView = null;
        if (this.presentationHelper != null) {
            this.presentationHelper.shutdown();
            this.presentationHelper = null;
        }
        if (this.vrCoreSdkClient != null) {
            this.vrCoreSdkClient.onPause();
            this.vrCoreSdkClient = null;
        }
        if (this.cardboardEmulator != null) {
            this.cardboardEmulator.onPause();
            this.cardboardEmulator = null;
        }
        if (this.performanceOverlay != null) {
            this.performanceOverlay.shutdown();
            this.performanceOverlay = null;
        }
        if (this.gvrApi != null) {
            this.gvrApi.shutdown();
            this.gvrApi = null;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.presentationHelper != null) {
            this.presentationHelper.onDetachedFromWindow();
        }
    }

    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.displaySynchronizer.onConfigurationChanged();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.presentationView != null && this.isPresenting() && this.presentationView.dispatchTouchEvent(motionEvent)) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void setPresentationView(View view) {
        if (this.presentationView != null) {
            this.presentationLayout.removeView(this.presentationView);
        }
        this.presentationLayout.addView(view, 0);
        this.presentationView = view;
    }

    public boolean enableAsyncReprojection(int n) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new IllegalStateException("Async reprojection may only be enabled from the UI thread");
        }
        if (this.asyncReprojectionFlags != -1) {
            if ((this.asyncReprojectionFlags & n) != n) {
                throw new UnsupportedOperationException("Async reprojection flags cannot be added once initialized.");
            }
            int n2 = this.asyncReprojectionFlags;
            Log.d((String)TAG, (String)new StringBuilder(58).append("Async reprojection already enabled with flags: ").append(n2).toString());
            return true;
        }
        if (this.scanlineRacingView != null) {
            return true;
        }
        if (!this.daydreamUtils.isDaydreamPhone(this.getContext())) {
            return false;
        }
        if (!this.gvrApi.setAsyncReprojectionEnabled(true)) {
            Log.e((String)TAG, (String)"Failed to initialize async reprojection, unsupported device.");
            return false;
        }
        this.asyncReprojectionFlags = n;
        if (!this.gvrApi.usingVrDisplayService()) {
            this.addScanlineRacingView();
        }
        return true;
    }

    public boolean enableCardboardTriggerEmulation(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("The Cardboard trigger listener must not be null.");
        }
        if (this.cardboardEmulator != null) {
            return true;
        }
        if (!this.daydreamUtils.isDaydreamPhone(this.getContext())) {
            return false;
        }
        this.cardboardEmulator = new CardboardEmulator(this.getContext(), runnable);
        return true;
    }

    public GvrApi getGvrApi() {
        return this.gvrApi;
    }

    protected VrCoreSdkClient createVrCoreSdkClient(Context context, GvrApi gvrApi, DaydreamUtilsWrapper daydreamUtilsWrapper, FadeOverlayView fadeOverlayView) {
        ComponentName componentName = ContextUtils.getComponentName(context);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GvrLayoutImpl.this.uiLayout.invokeCloseButtonListener();
            }
        };
        return new VrCoreSdkClient(context, gvrApi, componentName, daydreamUtilsWrapper, runnable, fadeOverlayView);
    }

    public void setStereoModeEnabled(boolean bl) {
        if (this.stereoModeEnabled == bl) {
            return;
        }
        this.stereoModeEnabled = bl;
        this.uiLayout.setEnabled(bl);
        if (this.vrCoreSdkClient != null) {
            this.vrCoreSdkClient.setEnabled(bl);
        }
        if (this.fadeOverlayView != null) {
            this.fadeOverlayView.setEnabled(bl);
        }
        if (this.daydreamTouchListener != null) {
            this.daydreamTouchListener.setEnabled(bl);
        }
        this.screenOnManager.setEnabled(bl);
        this.updateRenderingViewsVisibility(0);
    }

    public void setReentryIntent(PendingIntent pendingIntent) {
        if (this.vrCoreSdkClient != null) {
            this.vrCoreSdkClient.setReentryIntent(pendingIntent);
        }
    }

    boolean isPresenting() {
        return this.presentationView != null && this.presentationHelper != null && this.presentationHelper.isPresenting();
    }

    static void setPresentationFactory(PresentationFactory presentationFactory) {
        sOptionalPresentationFactory = presentationFactory;
    }

    VrCoreSdkClient getVrCoreSdkClient() {
        return this.vrCoreSdkClient;
    }

    FadeOverlayView getFadeOverlayView() {
        return this.fadeOverlayView;
    }

    void addPresentationListener(PresentationListener presentationListener) {
        if (this.presentationHelper != null) {
            this.presentationHelper.addListener(presentationListener);
        }
    }

    SdkDaydreamTouchListener createDaydreamTouchListener() {
        return new SdkDaydreamTouchListener(this);
    }

    private boolean isDeviceDetectionEnabled() {
        if (this.gvrApi.getSdkConfigurationParams().useDeviceIdleDetection == null) {
            return false;
        }
        return this.gvrApi.getSdkConfigurationParams().useDeviceIdleDetection;
    }

    private boolean isContextSharingEnabled() {
        if (this.gvrApi == null) {
            throw new IllegalStateException("GvrApi must be ready before isContextSharingEnabled is called");
        }
        Vr$VREvent$SdkConfigurationParams$AsyncReprojectionConfig vr$VREvent$SdkConfigurationParams$AsyncReprojectionConfig = this.gvrApi.getSdkConfigurationParams().asyncReprojectionConfig;
        if (vr$VREvent$SdkConfigurationParams$AsyncReprojectionConfig == null || vr$VREvent$SdkConfigurationParams$AsyncReprojectionConfig.flags == null) {
            return false;
        }
        return (vr$VREvent$SdkConfigurationParams$AsyncReprojectionConfig.flags & 0x10L) != 0L;
    }

    private void addScanlineRacingView() {
        if (this.scanlineRacingView != null) {
            return;
        }
        this.eglFactory = new EglFactory();
        this.eglFactory.setUsePriorityContext(true);
        this.eglFactory.setUseProtectedBuffers((this.asyncReprojectionFlags & 1) != 0);
        this.eglFactory.setEGLContextClientVersion(2);
        this.scanlineRacingView = new AsyncReprojectionSurfaceView(this.getContext());
        this.scanlineRacingView.setEGLConfigChooser(new MutableEglConfigChooser());
        this.scanlineRacingView.setZOrderMediaOverlay(true);
        this.scanlineRacingView.setEGLContextFactory(this.eglFactory);
        this.scanlineRacingView.setEGLWindowSurfaceFactory(this.eglFactory);
        if (this.isContextSharingEnabled()) {
            this.scanlineRacingView.setEglReadyListener(this.eglReadyListener);
        }
        if (!this.stereoModeEnabled) {
            Log.w((String)TAG, (String)"Disabling stereo mode with async reprojection enabled may not work properly.");
            this.scanlineRacingView.setVisibility(8);
        }
        if (this.scanlineRacingRenderer == null) {
            this.scanlineRacingRenderer = new ScanlineRacingRenderer(this.gvrApi);
        }
        this.scanlineRacingRenderer.setSurfaceView(this.scanlineRacingView);
        this.scanlineRacingView.setRenderer(this.scanlineRacingRenderer);
        this.scanlineRacingView.setSwapMode(1);
        if (!this.isResumed) {
            this.scanlineRacingView.onPause();
        }
        this.presentationLayout.addView((View)this.scanlineRacingView, 0);
    }

    private PresentationHelper tryCreatePresentationHelper() {
        if (Build.VERSION.SDK_INT <= 16) {
            return null;
        }
        String string2 = DisplayUtils.getExternalDisplayName(this.getContext());
        if (string2 == null) {
            Log.e((String)TAG, (String)"HDMI display name could not be found, disabling external presentation support");
            return null;
        }
        return new PresentationHelper(this.getContext(), this, (View)this.presentationLayout, this.displaySynchronizer, string2);
    }

    private void updateRenderingViewsVisibility(int n) {
        if (this.presentationView != null) {
            this.presentationView.setVisibility(this.stereoModeEnabled ? n : 0);
        }
        if (this.scanlineRacingView != null) {
            this.scanlineRacingView.setVisibility(this.stereoModeEnabled ? n : 8);
        }
    }

    private void updateFadeVisibility() {
        if (this.fadeOverlayView == null) {
            return;
        }
        if (!this.autoFadeEnabled) {
            if (this.isResumed) {
                this.fadeOverlayView.onVisible();
                return;
            }
            this.fadeOverlayView.onInvisible();
            return;
        }
        boolean bl = this.getWindowVisibility() == 0;
        if (bl && this.isResumed) {
            this.fadeOverlayView.onVisible();
            this.removeCallbacks(this.showRenderingViewsRunnable);
            this.postDelayed(this.showRenderingViewsRunnable, 50L);
            return;
        }
        if (!bl && !this.isResumed) {
            this.fadeOverlayView.onInvisible();
            this.updateRenderingViewsVisibility(4);
            this.removeCallbacks(this.showRenderingViewsRunnable);
        }
    }

    private void updateUiLayout() {
        boolean bl = this.gvrApi.getViewerType() == 1;
        this.uiLayout.setDaydreamModeEnabled(bl);
    }

    private PerformanceOverlay experimentalCreatePerformanceOverlay() {
        return null;
    }

    static class ScreenOnManager
    implements GvrApi.IdleListener {
        private static final long QUIET_PERIOD_AFTER_RESUME_MILLIS = TimeUnit.SECONDS.toMillis(5L);
        private boolean isEnabled = true;
        private boolean isResumed;
        private boolean isIdle;
        private long lastResumeTimeMillis;
        private final View parentView;

        public ScreenOnManager(View view) {
            this.parentView = view;
        }

        public void onResume() {
            this.isResumed = true;
            this.isIdle = false;
            this.lastResumeTimeMillis = SystemClock.elapsedRealtime();
            this.updateSetScreenOn();
        }

        public void onPause() {
            this.isResumed = false;
            this.updateSetScreenOn();
        }

        public void setEnabled(final boolean bl) {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (ScreenOnManager.this.isEnabled == bl) {
                        return;
                    }
                    ScreenOnManager.this.isEnabled = bl;
                    ScreenOnManager.this.updateSetScreenOn();
                }
            });
        }

        @Override
        public void onIdleChanged(final boolean bl) {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    long l = SystemClock.elapsedRealtime() - ScreenOnManager.this.lastResumeTimeMillis;
                    if (l < QUIET_PERIOD_AFTER_RESUME_MILLIS) {
                        boolean bl2 = bl;
                        Log.d((String)GvrLayoutImpl.TAG, (String)new StringBuilder(80).append("Quiet period after onResume() -- ignoring idle status change with isIdle = ").append(bl2).toString());
                        return;
                    }
                    if (ScreenOnManager.this.isIdle != bl) {
                        boolean bl3 = bl;
                        Log.d((String)GvrLayoutImpl.TAG, (String)new StringBuilder(36).append("Idle status change to isIdle = ").append(bl3).toString());
                    }
                    ScreenOnManager.this.isIdle = bl;
                    ScreenOnManager.this.updateSetScreenOn();
                }
            });
        }

        private void updateSetScreenOn() {
            this.parentView.setKeepScreenOn(this.isEnabled && this.isResumed && !this.isIdle);
        }
    }

    static class PresentationHelper
    implements DisplayManager.DisplayListener {
        private final RelativeLayout.LayoutParams layout = new RelativeLayout.LayoutParams(-1, -1);
        private final Context context;
        private final DisplayManager displayManager;
        private final DisplaySynchronizer displaySynchronizer;
        private final FrameLayout originalParent;
        private final View view;
        private final List<PresentationListener> listeners;
        private String externalDisplayName;
        private Presentation presentation;

        PresentationHelper(Context context, FrameLayout frameLayout, View view, DisplaySynchronizer displaySynchronizer, String string2) {
            this.context = context;
            this.originalParent = frameLayout;
            this.view = view;
            this.displaySynchronizer = displaySynchronizer;
            this.externalDisplayName = string2;
            this.displayManager = (DisplayManager)context.getSystemService("display");
            this.listeners = new ArrayList<PresentationListener>();
        }

        public boolean isPresenting() {
            return this.presentation != null && this.presentation.isShowing();
        }

        public void onPause() {
            this.displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
        }

        public void onResume() {
            this.externalDisplayName = DisplayUtils.getExternalDisplayName(this.context);
            if (this.externalDisplayName == null) {
                this.setDisplay(null);
                return;
            }
            this.displayManager.registerDisplayListener((DisplayManager.DisplayListener)this, null);
            Display display = null;
            for (Display display2 : this.displayManager.getDisplays()) {
                if (!this.isValidExternalDisplay(display2)) continue;
                display = display2;
                break;
            }
            this.setDisplay(display);
        }

        public void shutdown() {
            this.displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
            if (this.presentation != null) {
                this.presentation.cancel();
                this.presentation = null;
                for (PresentationListener presentationListener : this.listeners) {
                    presentationListener.onPresentationStopped();
                }
            }
        }

        public void onDetachedFromWindow() {
            this.displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
            this.setDisplay(null);
        }

        public void addListener(PresentationListener presentationListener) {
            if (this.listeners.contains(presentationListener)) {
                return;
            }
            this.listeners.add(presentationListener);
            if (this.presentation != null) {
                presentationListener.onPresentationStarted(this.presentation.getDisplay());
            }
        }

        public void onDisplayAdded(int n) {
            Display display = this.displayManager.getDisplay(n);
            if (this.isValidExternalDisplay(display)) {
                this.setDisplay(display);
            }
        }

        public void onDisplayRemoved(int n) {
            if (this.presentation != null && this.presentation.getDisplay().getDisplayId() == n) {
                this.setDisplay(null);
            }
        }

        public void onDisplayChanged(int n) {
        }

        private void setDisplay(Display display) {
            Presentation presentation;
            block9: {
                Display display2;
                Display display3 = display2 = this.presentation != null ? this.presentation.getDisplay() : null;
                if (!this.hasCurrentPresentationExpired() && DisplayUtils.isSameDisplay(display, display2)) {
                    return;
                }
                presentation = this.presentation;
                if (this.presentation != null) {
                    this.presentation.dismiss();
                    this.presentation = null;
                }
                PresentationHelper.detachViewFromParent(this.view);
                if (display != null) {
                    this.presentation = sOptionalPresentationFactory != null ? sOptionalPresentationFactory.create(this.context, display) : new Presentation(this.context, display);
                    this.presentation.addContentView(this.view, (ViewGroup.LayoutParams)this.layout);
                    try {
                        this.presentation.show();
                        break block9;
                    }
                    catch (WindowManager.InvalidDisplayException invalidDisplayException) {
                        String object = String.valueOf((Object)invalidDisplayException);
                        Log.e((String)GvrLayoutImpl.TAG, (String)new StringBuilder(57 + String.valueOf(object).length()).append("Attaching Cardboard View to the external display failed: ").append(object).toString());
                        this.presentation.cancel();
                        this.presentation = null;
                        PresentationHelper.detachViewFromParent(this.view);
                    }
                }
                this.originalParent.addView(this.view, 0);
            }
            this.displaySynchronizer.setDisplay(this.presentation != null ? this.presentation.getDisplay() : DisplayUtils.getDefaultDisplay(this.context));
            if (presentation != null) {
                for (PresentationListener presentationListener : this.listeners) {
                    presentationListener.onPresentationStopped();
                }
            }
            if (this.presentation != null) {
                for (PresentationListener presentationListener : this.listeners) {
                    presentationListener.onPresentationStarted(this.presentation.getDisplay());
                }
            }
        }

        private static void detachViewFromParent(View view) {
            ViewGroup viewGroup = (ViewGroup)view.getParent();
            if (viewGroup != null) {
                viewGroup.removeView(view);
            }
        }

        private boolean isValidExternalDisplay(Display display) {
            return display != null && display.isValid() && display.getName().equals(this.externalDisplayName);
        }

        private boolean hasCurrentPresentationExpired() {
            if (this.presentation == null) {
                return false;
            }
            return !this.presentation.isShowing() || !this.presentation.getDisplay().isValid();
        }
    }

    static class AsyncReprojectionSurfaceView
    extends GvrSurfaceView {
        private ScanlineRacingRenderer scanlineRacingRenderer;

        AsyncReprojectionSurfaceView(Context context) {
            super(context);
        }

        public void setRenderer(ScanlineRacingRenderer scanlineRacingRenderer) {
            this.scanlineRacingRenderer = scanlineRacingRenderer;
            super.setRenderer(scanlineRacingRenderer);
        }

        @Override
        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            if (!this.isDetachedFromWindow() && this.scanlineRacingRenderer != null) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                this.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        AsyncReprojectionSurfaceView.this.scanlineRacingRenderer.onDestroySurface();
                        countDownLatch.countDown();
                    }
                });
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    Log.e((String)GvrLayoutImpl.TAG, (String)"Interrupted during surface destroyed: ", (Throwable)interruptedException);
                }
            }
            super.surfaceDestroyed(surfaceHolder);
        }
    }

    static class FrameFlushWorkaround
    implements Choreographer.FrameCallback {
        private static final int DEFAULT_FRAME_FLUSH_COUNT = 5;
        private final Choreographer choreographer = Choreographer.getInstance();
        private int framesRemaining;

        public FrameFlushWorkaround() {
        }

        public void onResume() {
            if (this.framesRemaining > 0) {
                this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
            }
            this.framesRemaining = 5;
            this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
        }

        public void doFrame(long l) {
            if (--this.framesRemaining > 0) {
                this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
            }
        }
    }

    static interface PresentationListener {
        public void onPresentationStarted(Display var1);

        public void onPresentationStopped();
    }

    static interface PresentationFactory {
        public Presentation create(Context var1, Display var2);
    }
}

