/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.util.Log;
import com.google.vr.ndk.base.BuildConstants;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version {
    public static final String TAG = BuildConstants.class.getSimpleName();
    public static final Version CURRENT = Version.parse("1.60.0");
    public final int majorVersion;
    public final int minorVersion;
    public final int patchVersion;

    public Version(int n, int n2, int n3) {
        this.majorVersion = n;
        this.minorVersion = n2;
        this.patchVersion = n3;
    }

    public static Version parse(String string2) {
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        Matcher matcher = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)").matcher(string2);
        if (!matcher.matches()) {
            String string3 = String.valueOf(string2);
            Log.w((String)TAG, (String)(string3.length() != 0 ? "Failed to parse version from: ".concat(string3) : new String("Failed to parse version from: ")));
            return null;
        }
        return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
    }

    public final boolean isAtLeast(Version version) {
        if (this.majorVersion > version.majorVersion) {
            return true;
        }
        if (this.majorVersion < version.majorVersion) {
            return false;
        }
        if (this.minorVersion > version.minorVersion) {
            return true;
        }
        if (this.minorVersion < version.minorVersion) {
            return false;
        }
        if (this.patchVersion > version.patchVersion) {
            return true;
        }
        return this.patchVersion >= version.patchVersion;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        return this.majorVersion == version.majorVersion && this.minorVersion == version.minorVersion && this.patchVersion == version.patchVersion;
    }

    public final int hashCode() {
        return Objects.hash(this.majorVersion, this.minorVersion, this.patchVersion);
    }

    public final String toString() {
        return String.format("%d.%d.%d", this.majorVersion, this.minorVersion, this.patchVersion);
    }
}

