/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.ViewGroup;
import com.google.vr.cardboard.ContextUtils;
import com.google.vr.cardboard.UiLayer;
import com.google.vr.ndk.base.DaydreamUtilsWrapper;
import com.google.vr.vrcore.library.api.IGvrUiLayout;
import com.google.vr.vrcore.library.api.IObjectWrapper;
import com.google.vr.vrcore.library.api.ObjectWrapper;

class GvrUiLayoutImpl
extends IGvrUiLayout.Stub {
    private static final String TAG = "GvrUiLayoutImpl";
    private static final float DAYDREAM_ALIGNMENT_MARKER_SCALE = 0.35f;
    private final UiLayer uiLayer;
    private final CloseButtonListenerWrapper closeButtonListener;
    private boolean daydreamModeEnabled = false;

    GvrUiLayoutImpl(Context context, Runnable runnable) {
        this(context, runnable, new DaydreamUtilsWrapper());
    }

    GvrUiLayoutImpl(Context context, Runnable runnable, DaydreamUtilsWrapper daydreamUtilsWrapper) {
        this.closeButtonListener = new CloseButtonListenerWrapper(context, runnable, daydreamUtilsWrapper);
        this.uiLayer = new UiLayer(context);
        this.uiLayer.setBackButtonListener(this.closeButtonListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.uiLayer.setEnabled(bl);
    }

    @Override
    public IObjectWrapper getRootView() {
        return ObjectWrapper.wrap(this.uiLayer.getView());
    }

    @Override
    public boolean isEnabled() {
        return this.uiLayer.isEnabled();
    }

    @Override
    public void setCloseButtonListener(IObjectWrapper iObjectWrapper) {
        Runnable runnable = iObjectWrapper != null ? ObjectWrapper.unwrap(iObjectWrapper, Runnable.class) : null;
        this.closeButtonListener.setClientCloseButtonListener(runnable);
    }

    @Override
    public void setTransitionViewEnabled(boolean bl) {
        this.uiLayer.setTransitionViewEnabled(bl && !this.daydreamModeEnabled);
    }

    @Override
    public void setTransitionViewListener(IObjectWrapper iObjectWrapper) {
        this.uiLayer.setTransitionViewListener(iObjectWrapper != null ? ObjectWrapper.unwrap(iObjectWrapper, Runnable.class) : null);
    }

    @Override
    public void setSettingsButtonEnabled(boolean bl) {
        this.uiLayer.setSettingsButtonEnabled(bl);
    }

    @Override
    public void setSettingsButtonListener(IObjectWrapper iObjectWrapper) {
        this.uiLayer.setSettingsButtonListener(iObjectWrapper != null ? ObjectWrapper.unwrap(iObjectWrapper, Runnable.class) : null);
    }

    @Override
    public void setViewerName(String string2) {
        this.uiLayer.setViewerName(string2);
    }

    UiLayer getUiLayer() {
        return this.uiLayer;
    }

    ViewGroup getRoot() {
        return this.uiLayer.getView();
    }

    void invokeCloseButtonListener() {
        this.closeButtonListener.run();
    }

    void setDaydreamModeEnabled(boolean bl) {
        if (this.daydreamModeEnabled == bl) {
            return;
        }
        this.daydreamModeEnabled = bl;
        if (bl) {
            this.uiLayer.setAlignmentMarkerScale(0.35f);
            this.uiLayer.setTransitionViewEnabled(false);
            return;
        }
        this.uiLayer.setAlignmentMarkerScale(1.0f);
    }

    boolean isDaydreamModeEnabled() {
        return this.daydreamModeEnabled;
    }

    private static Runnable createDefaultCloseButtonListener(final Context context, DaydreamUtilsWrapper daydreamUtilsWrapper) {
        final Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        intent.setFlags(0x10000000);
        final Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return new Runnable(){

                @Override
                public void run() {
                    context.startActivity(intent);
                }
            };
        }
        if (daydreamUtilsWrapper.isDaydreamActivity(activity)) {
            return new Runnable(){

                @Override
                public void run() {
                    activity.startActivity(intent);
                    activity.finish();
                }
            };
        }
        return new Runnable(){

            @Override
            public void run() {
                activity.onBackPressed();
            }
        };
    }

    static class CloseButtonListenerWrapper
    implements Runnable {
        private final Context context;
        private final Runnable defaultCloseButtonListener;
        private final Runnable passiveCloseButtonListener;
        private Runnable activeCloseButtonListener;
        private boolean invokingCloseButton = false;

        CloseButtonListenerWrapper(Context context, Runnable runnable, DaydreamUtilsWrapper daydreamUtilsWrapper) {
            this.context = context;
            this.passiveCloseButtonListener = runnable;
            this.activeCloseButtonListener = this.defaultCloseButtonListener = GvrUiLayoutImpl.createDefaultCloseButtonListener(context, daydreamUtilsWrapper);
        }

        @Override
        public void run() {
            if (this.invokingCloseButton) {
                Log.w((String)GvrUiLayoutImpl.TAG, (String)"GVR close behavior invoked recursively.");
                Activity activity = ContextUtils.getActivity(this.context);
                if (activity != null) {
                    activity.finish();
                }
                return;
            }
            Log.d((String)GvrUiLayoutImpl.TAG, (String)"GVR close behavior invoked.");
            this.invokingCloseButton = true;
            try {
                if (this.passiveCloseButtonListener != null) {
                    this.passiveCloseButtonListener.run();
                }
                if (this.activeCloseButtonListener != null) {
                    this.activeCloseButtonListener.run();
                }
                return;
            }
            finally {
                this.invokingCloseButton = false;
            }
        }

        public void setClientCloseButtonListener(Runnable runnable) {
            this.activeCloseButtonListener = runnable != null ? runnable : this.defaultCloseButtonListener;
        }
    }
}

