/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.graphics.Point;
import android.util.Log;
import com.google.vr.ndk.base.GvrApi;

public class BufferSpec {
    private static final String TAG = BufferSpec.class.getSimpleName();
    long nativeBufferSpec;

    BufferSpec(long l) {
        this.nativeBufferSpec = l;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nativeBufferSpec != 0L) {
                Log.w((String)TAG, (String)"BufferSpec.shutdown() should be called to ensure resource cleanup");
                this.shutdown();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void shutdown() {
        if (this.nativeBufferSpec != 0L) {
            GvrApi.nativeBufferSpecDestroy(this.nativeBufferSpec);
            this.nativeBufferSpec = 0L;
        }
    }

    public void getSize(Point point) {
        GvrApi.nativeBufferSpecGetSize(this.nativeBufferSpec, point);
    }

    public void setSize(Point point) {
        GvrApi.nativeBufferSpecSetSize(this.nativeBufferSpec, point.x, point.y);
    }

    public int getSamples() {
        return GvrApi.nativeBufferSpecGetSamples(this.nativeBufferSpec);
    }

    public void setSamples(int n) {
        GvrApi.nativeBufferSpecSetSamples(this.nativeBufferSpec, n);
    }

    public void setColorFormat(int n) {
        if (!BufferSpec.isValidColorFormat(n)) {
            throw new IllegalArgumentException("Invalid color format.");
        }
        GvrApi.nativeBufferSpecSetColorFormat(this.nativeBufferSpec, n);
    }

    public void setDepthStencilFormat(int n) {
        if (!BufferSpec.isValidDepthStencilFormat(n)) {
            throw new IllegalArgumentException("Invalid depth-stencil format.");
        }
        GvrApi.nativeBufferSpecSetDepthStencilFormat(this.nativeBufferSpec, n);
    }

    public void setMultiviewLayers(int n) {
        GvrApi.nativeBufferSpecSetMultiviewLayers(this.nativeBufferSpec, n);
    }

    public static boolean isValidColorFormat(int n) {
        return n >= 0 && n < 2;
    }

    public static boolean isValidDepthStencilFormat(int n) {
        return n == 255 || n >= 0 && n < 6;
    }

    public static abstract class DepthStencilFormat {
        public static final int NONE = 255;
        public static final int DEPTH_16 = 0;
        public static final int DEPTH_24 = 1;
        public static final int DEPTH_24_STENCIL_8 = 2;
        public static final int DEPTH_32_F = 3;
        public static final int DEPTH_32_F_STENCIL_8 = 4;
        public static final int STENCIL_8 = 5;
        public static final int NUM_FORMATS = 6;

        public DepthStencilFormat() {
        }
    }

    public static abstract class ColorFormat {
        public static final int RGBA_8888 = 0;
        public static final int RGB_565 = 1;
        public static final int NUM_FORMATS = 2;

        public ColorFormat() {
        }
    }
}

