/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.cardboard.UsedByNative;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrParamsProviderFactory;
import com.google.vr.ndk.base.SdkConfigurationReader;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import com.google.vr.sdk.proto.nano.Phone;
import com.google.vr.sdk.proto.nano.Preferences;

@UsedByNative
public class VrParamsProviderJni {
    private static final String TAG = "VrParamsProviderJni";
    private static volatile DisplayMetrics displayMetricsOverride = null;

    public VrParamsProviderJni() {
    }

    public static void setDisplayOverride(Display display) {
        displayMetricsOverride = display != null ? DisplayUtils.getDisplayMetricsLandscape(display) : null;
    }

    @UsedByNative
    private static byte[] readDeviceParams(Context context) {
        VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(context);
        CardboardDevice.DeviceParams deviceParams = vrParamsProvider.readDeviceParams();
        vrParamsProvider.close();
        if (deviceParams == null) {
            return null;
        }
        return MessageNano.toByteArray((MessageNano)deviceParams);
    }

    @UsedByNative
    private static byte[] readSdkConfigurationParams(Context context) {
        return MessageNano.toByteArray((MessageNano)SdkConfigurationReader.getParams(context));
    }

    @UsedByNative
    private static boolean writeDeviceParams(Context context, byte[] byArray) {
        try (VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(context);){
            CardboardDevice.DeviceParams deviceParams = byArray != null ? (CardboardDevice.DeviceParams)MessageNano.mergeFrom((MessageNano)new CardboardDevice.DeviceParams(), (byte[])byArray) : null;
            boolean bl = vrParamsProvider.writeDeviceParams(deviceParams);
            return bl;
        }
    }

    @UsedByNative
    private static void readPhoneParams(Context context, long l) {
        if (context == null) {
            Log.w((String)TAG, (String)"Missing context for phone params lookup. Results may be invalid.");
            VrParamsProviderJni.updateNativePhoneParamsPointer(l, Resources.getSystem().getDisplayMetrics());
            return;
        }
        DisplayMetrics displayMetrics = VrParamsProviderJni.getDisplayMetrics(context);
        VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(context);
        Phone.PhoneParams phoneParams = vrParamsProvider.readPhoneParams();
        vrParamsProvider.close();
        if (phoneParams != null) {
            if (phoneParams.hasXPpi()) {
                displayMetrics.xdpi = phoneParams.getXPpi();
            }
            if (phoneParams.hasYPpi()) {
                displayMetrics.ydpi = phoneParams.getYPpi();
            }
        }
        VrParamsProviderJni.updateNativePhoneParamsPointer(l, displayMetrics);
    }

    @UsedByNative
    private static byte[] readUserPrefs(Context context) {
        VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(context);
        Preferences.UserPrefs userPrefs = vrParamsProvider.readUserPrefs();
        vrParamsProvider.close();
        if (userPrefs == null) {
            return null;
        }
        return MessageNano.toByteArray((MessageNano)userPrefs);
    }

    private static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics = displayMetricsOverride;
        if (displayMetrics != null) {
            return displayMetrics;
        }
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        return DisplayUtils.getDisplayMetricsLandscape(display);
    }

    private static void updateNativePhoneParamsPointer(long l, DisplayMetrics displayMetrics) {
        VrParamsProviderJni.nativeUpdateNativePhoneParamsPointer(l, displayMetrics.widthPixels, displayMetrics.heightPixels, displayMetrics.xdpi, displayMetrics.ydpi);
    }

    private static native void nativeUpdateNativePhoneParamsPointer(long var0, int var2, int var3, float var4, float var5);
}

