/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Choreographer;

public class FrameMonitor
implements Handler.Callback,
Choreographer.FrameCallback {
    private static final String TAG = FrameMonitor.class.getSimpleName();
    private static final int CREATE_CHOREOGRAPHER = 0;
    private static final int MSG_POST_FRAME_CALLBACK = 1;
    private static final int MSG_REMOVE_FRAME_CALLBACK = 2;
    private final Choreographer.FrameCallback callback;
    private final HandlerThread choreographerOwnerThread;
    private Handler handler;
    private Choreographer choreographer;
    private boolean isPaused;

    public FrameMonitor(Choreographer.FrameCallback frameCallback) {
        this(null, frameCallback);
    }

    public FrameMonitor(Choreographer choreographer, Choreographer.FrameCallback frameCallback) {
        this.callback = frameCallback;
        this.choreographer = choreographer;
        this.choreographerOwnerThread = new HandlerThread("FrameMonitor");
    }

    public void init() {
        this.choreographerOwnerThread.start();
        this.handler = new Handler(this.choreographerOwnerThread.getLooper(), (Handler.Callback)this);
        this.handler.sendEmptyMessage(0);
    }

    public Looper getLooper() {
        return this.handler.getLooper();
    }

    public void onPause() {
        if (this.isPaused) {
            return;
        }
        this.isPaused = true;
        this.handler.sendEmptyMessage(2);
    }

    public void onResume() {
        if (!this.isPaused) {
            return;
        }
        this.isPaused = false;
        this.handler.sendEmptyMessage(1);
    }

    public void shutdown() {
        this.onPause();
        this.choreographerOwnerThread.quitSafely();
        try {
            this.choreographerOwnerThread.join();
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)TAG, (String)"Interrupted when shutting down FrameMonitor.");
            interruptedException.printStackTrace();
            return;
        }
    }

    public void doFrame(long l) {
        this.callback.doFrame(l);
        this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
    }

    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                if (this.choreographer == null) {
                    this.choreographer = Choreographer.getInstance();
                }
                this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
                return true;
            }
            case 1: {
                this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
                return true;
            }
            case 2: {
                this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
                return true;
            }
        }
        return false;
    }
}

