/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.opengl.GLES20;
import android.util.Log;
import com.google.vr.cardboard.UsedByNative;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

@UsedByNative
public class EglReadyListener {
    private static final String TAG = "EglReadyListener";
    private static final int GL_CONTEXT_FLAGS = 33310;
    private static final int DEFAULT_GL_MAJOR_VERSION = 2;
    private volatile EGLContext eglContext;
    private volatile int eglContextFlags;
    private volatile int glVersion = 2;
    private volatile Object monitor;

    public EglReadyListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedByNative
    public void onEglReady() {
        this.eglContext = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
        if (this.eglContext == null || this.eglContext == EGL10.EGL_NO_CONTEXT) {
            Log.e((String)TAG, (String)"Unable to obtain the application's OpenGL context.");
        }
        String string2 = GLES20.glGetString((int)7938);
        this.glVersion = EglReadyListener.parseVersionString(string2);
        int[] nArray = new int[1];
        GLES20.glGetIntegerv((int)33310, (int[])nArray, (int)0);
        GLES20.glGetError();
        this.eglContextFlags = nArray[0];
        if (this.monitor != null) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
                return;
            }
        }
    }

    public EGLContext getEGLContext() {
        return this.eglContext;
    }

    public int getEGLContextFlags() {
        return this.eglContextFlags;
    }

    public int getGLVersion() {
        return this.glVersion;
    }

    public void setMonitor(Object object) {
        if (this.monitor != null) {
            throw new RuntimeException("EglReadyListener must be configured only once.");
        }
        this.monitor = object;
    }

    public void resetMonitor() {
        this.monitor = null;
    }

    public static int parseVersionString(String string2) {
        if (string2 == null) {
            Log.e((String)TAG, (String)"Unable to determine the OpenGL major version.");
            return 2;
        }
        int n = string2.indexOf(46);
        if (n <= 0) {
            Log.e((String)TAG, (String)"Unable to determine the OpenGL major version.");
            return 2;
        }
        int n2 = Character.getNumericValue(string2.charAt(n - 1));
        if (n2 < 0) {
            Log.e((String)TAG, (String)"Unable to determine the OpenGL major version.");
            return 2;
        }
        return n2;
    }
}

