/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.net.Uri;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import com.google.vr.sdk.proto.nano.Phone;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ConfigUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = ConfigUtils.class.getSimpleName();
    private static final int CARDBOARD_PHONE_PARAMS_STREAM_SENTINEL = 779508118;
    public static final String URI_KEY_PARAMS = "p";
    public static final String CARDBOARD_CONFIG_FOLDER = "Cardboard";
    private static final String CARDBOARD_DEVICE_PARAMS_FILE = "current_device_params";
    private static final String CARDBOARD_PHONE_PARAMS_FILE = "phone_params";
    private static final int CARDBOARD_DEVICE_PARAMS_STREAM_SENTINEL = 894990891;

    public ConfigUtils() {
    }

    public static CardboardDevice.DeviceParams readDeviceParamsFromExternalStorage() {
        CardboardDevice.DeviceParams deviceParams = ConfigUtils.readFromExternalStorage(CardboardDevice.DeviceParams.class, CARDBOARD_DEVICE_PARAMS_FILE, 894990891, true);
        return deviceParams;
    }

    public static CardboardDevice.DeviceParams readDeviceParamsFromUri(Uri uri) {
        String string2 = uri.getQueryParameter(URI_KEY_PARAMS);
        if (string2 == null) {
            Log.w((String)TAG, (String)"No Cardboard parameters in URI.");
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string2, (int)11);
            CardboardDevice.DeviceParams deviceParams = (CardboardDevice.DeviceParams)MessageNano.mergeFrom((MessageNano)new CardboardDevice.DeviceParams(), (byte[])byArray);
            return deviceParams;
        }
        catch (Exception exception) {
            String string3 = String.valueOf(exception);
            Log.w((String)TAG, (String)new StringBuilder(46 + String.valueOf(string3).length()).append("Parsing cardboard parameters from URI failed: ").append(string3).toString());
            return null;
        }
    }

    public static Phone.PhoneParams readPhoneParamsFromExternalStorage() {
        Phone.PhoneParams phoneParams = ConfigUtils.readFromExternalStorage(Phone.PhoneParams.class, CARDBOARD_PHONE_PARAMS_FILE, 779508118, false);
        return phoneParams;
    }

    public static boolean writeDeviceParamsToExternalStorage(CardboardDevice.DeviceParams deviceParams) {
        boolean bl = ConfigUtils.writeToExternalStorage((MessageNano)deviceParams, CARDBOARD_DEVICE_PARAMS_FILE, 894990891);
        if (!bl) {
            Log.e((String)TAG, (String)"Could not write Cardboard parameters to external storage.");
        }
        return bl;
    }

    public static boolean writePhoneParamsToExternalStorage(Phone.PhoneParams phoneParams) {
        boolean bl;
        if (phoneParams.dEPRECATEDGyroBias != null && phoneParams.dEPRECATEDGyroBias.length == 0) {
            phoneParams = phoneParams.clone();
            v0.dEPRECATEDGyroBias = new float[]{0.0f, 0.0f, 0.0f};
        }
        if (!(bl = ConfigUtils.writeToExternalStorage((MessageNano)phoneParams, CARDBOARD_PHONE_PARAMS_FILE, 779508118))) {
            Log.e((String)TAG, (String)"Could not write Phone parameters to external storage.");
        }
        return bl;
    }

    public static boolean removeDeviceParamsFromExternalStorage() {
        boolean bl = false;
        try {
            File file = ConfigUtils.getConfigFile(CARDBOARD_DEVICE_PARAMS_FILE);
            bl = file.exists() ? file.delete() : true;
        }
        catch (IllegalStateException illegalStateException) {
            String string2 = String.valueOf(illegalStateException);
            Log.w((String)TAG, (String)new StringBuilder(34 + String.valueOf(string2).length()).append("Error clearing device parameters: ").append(string2).toString());
        }
        if (!bl) {
            Log.e((String)TAG, (String)"Could not clear Cardboard parameters from external storage.");
        }
        return bl;
    }

    private static File getConfigFile(String string2) throws IllegalStateException {
        File file = new File(Environment.getExternalStorageDirectory(), CARDBOARD_CONFIG_FOLDER);
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            String string3 = String.valueOf(file);
            throw new IllegalStateException(new StringBuilder(61 + String.valueOf(string3).length()).append(string3).append(" already exists as a file, but is expected to be a directory.").toString());
        }
        return new File(file, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T extends MessageNano> T readFromExternalStorage(Class<T> clazz, String string2, int n, boolean bl) {
        try {
            T t;
            InputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(ConfigUtils.getConfigFile(string2)));
                t = ConfigUtils.readFromInputStream(clazz, inputStream, n);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return t;
            }
            catch (IOException iOException) {}
            return t;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!bl) return null;
            String string3 = String.valueOf(fileNotFoundException);
            Log.d((String)TAG, (String)new StringBuilder(39 + String.valueOf(string3).length()).append("Parameters file not found for reading: ").append(string3).toString());
            return null;
        }
        catch (IllegalStateException illegalStateException) {
            String string4 = String.valueOf(illegalStateException);
            Log.w((String)TAG, (String)new StringBuilder(26 + String.valueOf(string4).length()).append("Error reading parameters: ").append(string4).toString());
        }
        return null;
    }

    private static <T extends MessageNano> T readFromInputStream(Class<T> clazz, InputStream inputStream, int n) {
        if (inputStream == null) {
            return null;
        }
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            if (inputStream.read(byteBuffer.array(), 0, byteBuffer.array().length) == -1) {
                Log.e((String)TAG, (String)"Error parsing param record: end of stream.");
                return null;
            }
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            if (n2 != n) {
                Log.e((String)TAG, (String)"Error parsing param record: incorrect sentinel.");
                return null;
            }
            byte[] byArray = new byte[n3];
            if (inputStream.read(byArray, 0, n3) == -1) {
                Log.e((String)TAG, (String)"Error parsing param record: end of stream.");
                return null;
            }
            return (T)MessageNano.mergeFrom((MessageNano)((MessageNano)clazz.newInstance()), (byte[])byArray);
        }
        catch (InvalidProtocolBufferNanoException invalidProtocolBufferNanoException) {
            String string2 = String.valueOf(invalidProtocolBufferNanoException.toString());
            Log.w((String)TAG, (String)(string2.length() != 0 ? "Error parsing protocol buffer: ".concat(string2) : new String("Error parsing protocol buffer: ")));
        }
        catch (IOException iOException) {
            String string3 = String.valueOf(iOException.toString());
            Log.w((String)TAG, (String)(string3.length() != 0 ? "Error reading parameters: ".concat(string3) : new String("Error reading parameters: ")));
        }
        catch (InstantiationException instantiationException) {
            String string4 = String.valueOf(instantiationException.toString());
            Log.w((String)TAG, (String)(string4.length() != 0 ? "Error creating parameters: ".concat(string4) : new String("Error creating parameters: ")));
        }
        catch (IllegalAccessException illegalAccessException) {
            String string5 = String.valueOf(illegalAccessException.toString());
            Log.w((String)TAG, (String)(string5.length() != 0 ? "Error accessing parameter type: ".concat(string5) : new String("Error accessing parameter type: ")));
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean writeToExternalStorage(MessageNano messageNano, String string2, int n) {
        boolean bl = false;
        OutputStream outputStream = null;
        outputStream = new BufferedOutputStream(new FileOutputStream(ConfigUtils.getConfigFile(string2)));
        bl = ConfigUtils.writeToOutputStream(messageNano, outputStream, n);
        try {
            outputStream.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = String.valueOf(fileNotFoundException);
            Log.e((String)TAG, (String)new StringBuilder(39 + String.valueOf(string3).length()).append("Parameters file not found for writing: ").append(string3).toString());
            if (outputStream == null) return bl;
            try {
                outputStream.close();
                return bl;
            }
            catch (IOException iOException) {}
            return bl;
        }
        catch (IllegalStateException illegalStateException) {
            String string4 = String.valueOf(illegalStateException);
            Log.w((String)TAG, (String)new StringBuilder(26 + String.valueOf(string4).length()).append("Error writing parameters: ").append(string4).toString());
            if (outputStream == null) return bl;
            {
                catch (Throwable throwable) {
                    if (outputStream == null) throw throwable;
                    try {
                        outputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                outputStream.close();
                return bl;
            }
            catch (IOException iOException) {}
            return bl;
        }
    }

    private static boolean writeToOutputStream(MessageNano messageNano, OutputStream outputStream, int n) {
        try {
            byte[] byArray = MessageNano.toByteArray((MessageNano)messageNano);
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.putInt(n);
            byteBuffer.putInt(byArray.length);
            outputStream.write(byteBuffer.array());
            outputStream.write(byArray);
            return true;
        }
        catch (IOException iOException) {
            String string2 = String.valueOf(iOException.toString());
            Log.w((String)TAG, (String)(string2.length() != 0 ? "Error writing parameters: ".concat(string2) : new String("Error writing parameters: ")));
            return false;
        }
    }
}

