/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.controller.api;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.vr.vrcore.controller.api.ControllerAccelEvent;
import com.google.vr.vrcore.controller.api.ControllerButtonEvent;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerEventPacket2;
import com.google.vr.vrcore.controller.api.ControllerGyroEvent;
import com.google.vr.vrcore.controller.api.ControllerListenerOptions;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.ControllerTouchEvent;

public interface IControllerListener
extends IInterface {
    public int getApiVersion() throws RemoteException;

    public void onControllerStateChanged(int var1, int var2) throws RemoteException;

    public void deprecatedOnControllerTouchEvent(ControllerTouchEvent var1) throws RemoteException;

    public void deprecatedOnControllerOrientationEvent(ControllerOrientationEvent var1) throws RemoteException;

    public boolean deprecatedOnControllerButtonEventV1(ControllerButtonEvent var1) throws RemoteException;

    public void deprecatedOnControllerButtonEvent(ControllerButtonEvent var1) throws RemoteException;

    public void deprecatedOnControllerAccelEvent(ControllerAccelEvent var1) throws RemoteException;

    public void deprecatedOnControllerGyroEvent(ControllerGyroEvent var1) throws RemoteException;

    public ControllerListenerOptions getOptions() throws RemoteException;

    public void onControllerEventPacket(ControllerEventPacket var1) throws RemoteException;

    public void onControllerRecentered(ControllerOrientationEvent var1) throws RemoteException;

    public void onControllerEventPacket2(ControllerEventPacket2 var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IControllerListener {
        private static final String DESCRIPTOR = "com.google.vr.vrcore.controller.api.IControllerListener";
        static final int TRANSACTION_getApiVersion = 1;
        static final int TRANSACTION_onControllerStateChanged = 2;
        static final int TRANSACTION_deprecatedOnControllerTouchEvent = 3;
        static final int TRANSACTION_deprecatedOnControllerOrientationEvent = 4;
        static final int TRANSACTION_deprecatedOnControllerButtonEventV1 = 5;
        static final int TRANSACTION_deprecatedOnControllerButtonEvent = 6;
        static final int TRANSACTION_deprecatedOnControllerAccelEvent = 7;
        static final int TRANSACTION_deprecatedOnControllerGyroEvent = 8;
        static final int TRANSACTION_getOptions = 9;
        static final int TRANSACTION_onControllerEventPacket = 10;
        static final int TRANSACTION_onControllerRecentered = 11;
        static final int TRANSACTION_onControllerEventPacket2 = 12;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IControllerListener asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IControllerListener) {
                return (IControllerListener)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = this.getApiVersion();
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    int n5 = parcel.readInt();
                    this.onControllerStateChanged(n4, n5);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ControllerTouchEvent controllerTouchEvent = 0 != parcel.readInt() ? (ControllerTouchEvent)ControllerTouchEvent.CREATOR.createFromParcel(parcel) : null;
                    this.deprecatedOnControllerTouchEvent(controllerTouchEvent);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ControllerOrientationEvent controllerOrientationEvent = 0 != parcel.readInt() ? (ControllerOrientationEvent)ControllerOrientationEvent.CREATOR.createFromParcel(parcel) : null;
                    this.deprecatedOnControllerOrientationEvent(controllerOrientationEvent);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ControllerButtonEvent controllerButtonEvent = 0 != parcel.readInt() ? (ControllerButtonEvent)ControllerButtonEvent.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.deprecatedOnControllerButtonEventV1(controllerButtonEvent);
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ControllerButtonEvent controllerButtonEvent = 0 != parcel.readInt() ? (ControllerButtonEvent)ControllerButtonEvent.CREATOR.createFromParcel(parcel) : null;
                    this.deprecatedOnControllerButtonEvent(controllerButtonEvent);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ControllerAccelEvent controllerAccelEvent = 0 != parcel.readInt() ? (ControllerAccelEvent)ControllerAccelEvent.CREATOR.createFromParcel(parcel) : null;
                    this.deprecatedOnControllerAccelEvent(controllerAccelEvent);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ControllerGyroEvent controllerGyroEvent = 0 != parcel.readInt() ? (ControllerGyroEvent)ControllerGyroEvent.CREATOR.createFromParcel(parcel) : null;
                    this.deprecatedOnControllerGyroEvent(controllerGyroEvent);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ControllerListenerOptions controllerListenerOptions = this.getOptions();
                    parcel2.writeNoException();
                    if (controllerListenerOptions != null) {
                        parcel2.writeInt(1);
                        controllerListenerOptions.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ControllerEventPacket controllerEventPacket = 0 != parcel.readInt() ? (ControllerEventPacket)ControllerEventPacket.CREATOR.createFromParcel(parcel) : null;
                    this.onControllerEventPacket(controllerEventPacket);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ControllerOrientationEvent controllerOrientationEvent = 0 != parcel.readInt() ? (ControllerOrientationEvent)ControllerOrientationEvent.CREATOR.createFromParcel(parcel) : null;
                    this.onControllerRecentered(controllerOrientationEvent);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ControllerEventPacket2 controllerEventPacket2 = 0 != parcel.readInt() ? (ControllerEventPacket2)ControllerEventPacket2.CREATOR.createFromParcel(parcel) : null;
                    this.onControllerEventPacket2(controllerEventPacket2);
                    return true;
                }
            }
            return super.onTransact(n, parcel, parcel2, n2);
        }

        private static class Proxy
        implements IControllerListener {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public int getApiVersion() throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            @Override
            public void onControllerStateChanged(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void deprecatedOnControllerTouchEvent(ControllerTouchEvent controllerTouchEvent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (controllerTouchEvent != null) {
                        parcel.writeInt(1);
                        controllerTouchEvent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void deprecatedOnControllerOrientationEvent(ControllerOrientationEvent controllerOrientationEvent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (controllerOrientationEvent != null) {
                        parcel.writeInt(1);
                        controllerOrientationEvent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public boolean deprecatedOnControllerButtonEventV1(ControllerButtonEvent controllerButtonEvent) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (controllerButtonEvent != null) {
                        parcel.writeInt(1);
                        controllerButtonEvent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            @Override
            public void deprecatedOnControllerButtonEvent(ControllerButtonEvent controllerButtonEvent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (controllerButtonEvent != null) {
                        parcel.writeInt(1);
                        controllerButtonEvent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void deprecatedOnControllerAccelEvent(ControllerAccelEvent controllerAccelEvent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (controllerAccelEvent != null) {
                        parcel.writeInt(1);
                        controllerAccelEvent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(7, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void deprecatedOnControllerGyroEvent(ControllerGyroEvent controllerGyroEvent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (controllerGyroEvent != null) {
                        parcel.writeInt(1);
                        controllerGyroEvent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(8, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public ControllerListenerOptions getOptions() throws RemoteException {
                ControllerListenerOptions controllerListenerOptions;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    controllerListenerOptions = 0 != parcel2.readInt() ? (ControllerListenerOptions)ControllerListenerOptions.CREATOR.createFromParcel(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return controllerListenerOptions;
            }

            @Override
            public void onControllerEventPacket(ControllerEventPacket controllerEventPacket) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (controllerEventPacket != null) {
                        parcel.writeInt(1);
                        controllerEventPacket.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(10, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onControllerRecentered(ControllerOrientationEvent controllerOrientationEvent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (controllerOrientationEvent != null) {
                        parcel.writeInt(1);
                        controllerOrientationEvent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(11, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onControllerEventPacket2(ControllerEventPacket2 controllerEventPacket2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (controllerEventPacket2 != null) {
                        parcel.writeInt(1);
                        controllerEventPacket2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(12, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

